/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocApplyBiddingFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyBiddingFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyBiddingFuncRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocApplyBiddingFunctionImpl
implements DycUocApplyBiddingFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocApplyBiddingFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;

    @Override
    public DycUocApplyBiddingFuncRspBO applyBatchBidding(DycUocApplyBiddingFuncReqBO reqBO) {
        String callUrl = null;
        callUrl = DycPropertiesUtil.getProperty((String)"ESB_APPLY_BIDDING_URL");
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u8bf7\u6c42hsn:{}", (Object)hsn);
        Date callTime = new Date();
        String result = DycEsbUtil.doPostReuest((String)callUrl, (String)JSON.toJSONString((Object)reqBO), (String)hsn);
        Date retTime = new Date();
        this.intsertInterLog(reqBO.getBargainingId(), Long.valueOf(reqBO.getThirdApplyId()), callTime, retTime, hsn, callUrl, JSON.toJSONString((Object)reqBO), result);
        log.info("\u63d0\u4ea4\u7ade\u4ef7\u51fa\u53c2: " + result);
        return this.resolveRsp(result);
    }

    private DycUocApplyBiddingFuncRspBO resolveRsp(String returnString) {
        DycUocApplyBiddingFuncRspBO submitOrderRsp = new DycUocApplyBiddingFuncRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            submitOrderRsp = (DycUocApplyBiddingFuncRspBO)((Object)JSON.parseObject((String)jsonObject.toJSONString(), DycUocApplyBiddingFuncRspBO.class));
            submitOrderRsp.setRespCode("0000");
            submitOrderRsp.setRespDesc("\u6210\u529f");
            return submitOrderRsp;
        }
        submitOrderRsp.setRespCode(rspJsonObject.getString("resultCode"));
        submitOrderRsp.setRespDesc(rspJsonObject.getString("resultMessage"));
        return submitOrderRsp;
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.BARGAIN);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(1));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

