/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.atom.busicommon.api.DycAgrDicDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycFscDicDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycUccDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycUmcDictionaryFunction;
import com.tydic.dyc.atom.busicommon.api.DycUmcPesDicQryListByConfigKeysFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocProDictionaryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycAgrOperateDicDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycAgrOperateDicDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycAgrQryDicDictionaryByListFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycAgrQryDicDictionaryByListFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscDicDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscDictionaryFuncPageRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycFscQueryDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryAddFuncBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryAddFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryDeleteFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryDeleteFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryUpdateFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUccDictionaryUpdateFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcDicDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcPesDicConfigFuncBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcPesDicQryListByConfigKeysFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcPesDicQryListByConfigKeysFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcQueryDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUmcRspListFuncBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryCreateFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryCreateFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryDeleteFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryDeleteFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryUpdateFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocProDictionaryUpdateFuncRspBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.busicommon.order.api.DycComUocDictionaryOperateService;
import com.tydic.dyc.busicommon.order.bo.ComPesDictionaryCodeBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataOperateReqBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataOperateRspBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataQueryReqBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDicDataQueryRspBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocDictionaryRspDataBO;
import com.tydic.dyc.busicommon.order.bo.DycComUocRefreshCodeListRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycComUocDictionaryOperateServiceImpl
implements DycComUocDictionaryOperateService {
    private static final Logger log = LoggerFactory.getLogger(DycComUocDictionaryOperateServiceImpl.class);
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "9999";
    public static final String UOC_PRO_CODE = "UOC_PRO";
    public static final String UMC_CODE = "UMC";
    public static final String UCC_CODE = "UCC";
    public static final String FSC_CODE = "FSC";
    public static final String AGR_CODE = "AGR";
    public static final Integer QUERY = 0;
    public static final Integer INSERT = 1;
    public static final Integer UPDATE = 2;
    public static final Integer DELETE = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(DycComUocDictionaryOperateServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private DycUmcPesDicQryListByConfigKeysFunction dycUmcPesDicQryListByConfigKeysFunction;
    @Autowired
    private DycUmcDictionaryFunction dycUmcDictionaryFunction;
    @Autowired
    private DycUccDictionaryFunction dycUccDictionaryFunction;
    @Autowired
    private DycFscDicDictionaryFunction dycFscDictionaryFunction;
    @Autowired
    private DycAgrDicDictionaryFunction dycAgrDicDictionaryFunction;
    @Autowired
    private DycUocProDictionaryFunction dycUocProDictionaryFunction;
    private static Map<String, BiFunction<Integer, ComPesDictionaryCodeBO, List<ComPesDictionaryCodeBO>>> dicActionMap = Maps.newHashMapWithExpectedSize((int)4);

    public DycComUocDictionaryOperateServiceImpl() {
        dicActionMap.put(UMC_CODE, this::callUmcDicService);
        dicActionMap.put(UCC_CODE, this::callUccDicService);
        dicActionMap.put(FSC_CODE, this::callFscDicService);
        dicActionMap.put(AGR_CODE, this::callAgrDicService);
        dicActionMap.put(UOC_PRO_CODE, this::callUocProDicService);
    }

    @Override
    public DycComUocDicDataQueryRspBO queryCodeList(DycComUocDicDataQueryReqBO reqBO) {
        DycComUocDicDataQueryRspBO rspBO = new DycComUocDicDataQueryRspBO();
        if (CollectionUtils.isEmpty(reqBO.getConfigKeys())) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return rspBO;
        }
        HashMap rspData = Maps.newHashMapWithExpectedSize((int)reqBO.getConfigKeys().size());
        List<String> callConfigKeys = this.cacheDataProcess(reqBO.getConfigKeys(), rspData);
        if (!CollectionUtils.isEmpty(callConfigKeys)) {
            DycUmcPesDicQryListByConfigKeysFuncReqBO umcPesDicQryListByConfigKeysAbilityReqBO = new DycUmcPesDicQryListByConfigKeysFuncReqBO();
            umcPesDicQryListByConfigKeysAbilityReqBO.setCallConfigKeys(callConfigKeys);
            log.info("umcPesDicQryListByConfigKeysAbilityReqBO ===================================" + umcPesDicQryListByConfigKeysAbilityReqBO.toString());
            DycUmcPesDicQryListByConfigKeysFuncRspBO umcPesDicQryListByConfigKeysAbilityRspBO = this.dycUmcPesDicQryListByConfigKeysFunction.qryPesDicListByConfigKeys(umcPesDicQryListByConfigKeysAbilityReqBO);
            log.info("umcPesDicQryListByConfigKeysAbilityRspBO ===================================" + umcPesDicQryListByConfigKeysAbilityRspBO.toString());
            List configList = umcPesDicQryListByConfigKeysAbilityRspBO.getConfigList();
            if (CollectionUtils.isEmpty((Collection)configList)) {
                rspBO.setRespCode(RSP_CODE_FAILURE);
                rspBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u914d\u7f6e\u4e3a\u7a7a\uff0ccallConfigKeys=" + callConfigKeys.toString());
                return rspBO;
            }
            Map<String, DycUmcPesDicConfigFuncBO> dicMap = configList.stream().collect(Collectors.toMap(DycUmcPesDicConfigFuncBO::getConfigKey, Function.identity()));
            HashMap<String, DycUmcPesDicConfigFuncBO> pCodeMap = new HashMap<String, DycUmcPesDicConfigFuncBO>();
            for (DycUmcPesDicConfigFuncBO comPesDicConfigPO : configList) {
                pCodeMap.put(comPesDicConfigPO.getPCode(), comPesDicConfigPO);
            }
            pCodeMap.keySet().forEach(pCodeKey -> this.cacheClient.delete(pCodeKey));
            log.info("dicMap =======================================" + dicMap.toString());
            log.info("callConfigKeys ======================================" + callConfigKeys.toString());
            log.info("\u7f13\u5b58rspData ======================================" + ((Object)rspData).toString());
            this.dicDataProcess(callConfigKeys, dicMap, rspData);
            log.info("\u4e2d\u5fc3\u5b57\u5178rspData ======================================" + ((Object)rspData).toString());
        }
        ArrayList<DycComUocDictionaryRspDataBO> data = new ArrayList<DycComUocDictionaryRspDataBO>();
        rspData.keySet().forEach(key -> {
            DycComUocDictionaryRspDataBO rspDataBO = new DycComUocDictionaryRspDataBO();
            rspDataBO.setConfigKey((String)key);
            rspDataBO.setCodeList((List)rspData.get(key));
            data.add(rspDataBO);
        });
        rspBO.setData(data);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u83b7\u53d6\u6570\u636e\u6210\u529f");
        return rspBO;
    }

    @Override
    public DycComUocDicDataOperateRspBO dealCodeOperate(DycComUocDicDataOperateReqBO reqBO) {
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u4f20\u5165[operateType]\u4e3a\u7a7a");
        }
        if (!(INSERT.equals(reqBO.getOperateType()) || UPDATE.equals(reqBO.getOperateType()) || DELETE.equals(reqBO.getOperateType()))) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[operateType]");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConfigKey())) {
            throw new ZTBusinessException("\u4f20\u5165[configKey]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        ComPesDictionaryCodeBO dictionaryCode = reqBO.getDictionaryCode();
        if (StringUtils.isEmpty((Object)dictionaryCode.getCode()) || dictionaryCode.getCode().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u7f16\u7801\u4e3a\u7a7a" + reqBO.getCenter());
        }
        if (StringUtils.isEmpty((Object)dictionaryCode.getTitle()) || dictionaryCode.getTitle().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u5b57\u5178\u4e3a\u7a7a" + reqBO.getCenter());
        }
        List<ComPesDictionaryCodeBO> rspInfo = dicActionMap.get(reqBO.getCenter()).apply(reqBO.getOperateType(), dictionaryCode);
        DycComUocDicDataOperateRspBO rspBO = new DycComUocDicDataOperateRspBO();
        rspBO.setRespCode(rspInfo.get(0).getRespCode());
        rspBO.setRespDesc(rspInfo.get(0).getRespDesc());
        if (RSP_CODE_SUCCESS.equals(rspBO.getRespCode())) {
            DycComUocDicDataQueryReqBO refreshReqBO = new DycComUocDicDataQueryReqBO();
            refreshReqBO.setConfigKeys(Collections.singletonList(reqBO.getConfigKey()));
            this.refreshCodeList(refreshReqBO);
        }
        return rspBO;
    }

    @Override
    public DycComUocRefreshCodeListRspBO refreshCodeList(DycComUocDicDataQueryReqBO reqBO) {
        DycComUocRefreshCodeListRspBO rspBO = new DycComUocRefreshCodeListRspBO();
        if (CollectionUtils.isEmpty(reqBO.getConfigKeys())) {
            LOGGER.error("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            rspBO.setRespCode(RSP_CODE_SUCCESS);
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        reqBO.getConfigKeys().forEach(config -> this.cacheClient.delete(DICTIONARY_KEY_PREFIX + config));
        this.queryCodeList(reqBO);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<String> cacheDataProcess(List<String> configKeys, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        ArrayList notExistsKeys = Lists.newArrayListWithExpectedSize((int)configKeys.size());
        for (String configKey : configKeys) {
            notExistsKeys.add(configKey);
        }
        return notExistsKeys;
    }

    private void dicDataProcess(List<String> configKeys, Map<String, DycUmcPesDicConfigFuncBO> dicMap, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        for (String configKey : configKeys) {
            if (dicMap.get(configKey) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u672a\u83b7\u53d6\u5230\u5b57\u5178\u914d\u7f6e\uff0cconfigKey=" + configKey);
                continue;
            }
            DycUmcPesDicConfigFuncBO dicInfo = dicMap.get(configKey);
            if (dicActionMap.get(dicInfo.getCenter()) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + dicInfo.getCenter());
                continue;
            }
            ComPesDictionaryCodeBO param = new ComPesDictionaryCodeBO();
            param.setPCode(dicInfo.getPCode());
            List<ComPesDictionaryCodeBO> dicList = dicActionMap.get(dicInfo.getCenter()).apply(QUERY, param);
            log.info("dicList--------------------->:{}", (Object)JSON.toJSONString(dicList));
            rspData.put(configKey, dicList);
            if (!CollectionUtils.isEmpty(dicList)) continue;
            LOGGER.info("{}\u5b57\u5178\u670d\u52a1\u672a\u8fd4\u56de\u5b57\u5178\u6570\u636e\uff0cpCode={}", (Object)dicInfo.getCenter(), (Object)dicInfo.getPCode());
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }

    private List<ComPesDictionaryCodeBO> callAgrDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        log.info("dictionaryCode ================================" + dictionaryCode.toString());
        if (QUERY.equals(operateType)) {
            DycAgrQryDicDictionaryByListFuncReqBO dycAgrQryDicDictionaryByListFuncReqBO = new DycAgrQryDicDictionaryByListFuncReqBO();
            dycAgrQryDicDictionaryByListFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            log.info("dycAgrQryDicDictionaryByListFuncReqBO =================================" + dycAgrQryDicDictionaryByListFuncReqBO.toString());
            DycAgrQryDicDictionaryByListFuncRspBO dycAgrQryDicDictionaryByListFuncRspBO = this.dycAgrDicDictionaryFunction.queryDicDictionaryByList(dycAgrQryDicDictionaryByListFuncReqBO);
            List rows = dycAgrQryDicDictionaryByListFuncRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rows) ? Lists.newArrayList() : JUtil.jsl((List)rows, ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycAgrOperateDicDictionaryFuncReqBO dycAgrOperateDicDictionaryFuncReqBO = new DycAgrOperateDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)dycAgrOperateDicDictionaryFuncReqBO);
            dycAgrOperateDicDictionaryFuncReqBO.setOperType(Integer.valueOf(1));
            dycAgrOperateDicDictionaryFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            DycAgrOperateDicDictionaryFuncRspBO dycAgrOperateDicDictionaryFuncRspBO = this.dycAgrDicDictionaryFunction.operateDicDictionary(dycAgrOperateDicDictionaryFuncReqBO);
            rspBO.setRespCode(dycAgrOperateDicDictionaryFuncRspBO.getRespCode());
            rspBO.setRespDesc(dycAgrOperateDicDictionaryFuncRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycAgrOperateDicDictionaryFuncReqBO dycAgrOperateDicDictionaryFuncReqBO = new DycAgrOperateDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)dycAgrOperateDicDictionaryFuncReqBO);
            dycAgrOperateDicDictionaryFuncReqBO.setOperType(Integer.valueOf(3));
            dycAgrOperateDicDictionaryFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            DycAgrOperateDicDictionaryFuncRspBO dycAgrOperateDicDictionaryFuncRspBO = this.dycAgrDicDictionaryFunction.operateDicDictionary(dycAgrOperateDicDictionaryFuncReqBO);
            rspBO.setRespCode(dycAgrOperateDicDictionaryFuncRspBO.getRespCode());
            rspBO.setRespDesc(dycAgrOperateDicDictionaryFuncRspBO.getRespDesc());
        } else {
            DycAgrOperateDicDictionaryFuncReqBO dycAgrOperateDicDictionaryFuncReqBO = new DycAgrOperateDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)dycAgrOperateDicDictionaryFuncReqBO);
            dycAgrOperateDicDictionaryFuncReqBO.setOperType(Integer.valueOf(2));
            dycAgrOperateDicDictionaryFuncReqBO.setPcodenew(dictionaryCode.getPCode());
            DycAgrOperateDicDictionaryFuncRspBO dycAgrOperateDicDictionaryFuncRspBO = this.dycAgrDicDictionaryFunction.operateDicDictionary(dycAgrOperateDicDictionaryFuncReqBO);
            rspBO.setRespCode(dycAgrOperateDicDictionaryFuncRspBO.getRespCode());
            rspBO.setRespDesc(dycAgrOperateDicDictionaryFuncRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUocProDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycUocProDictionaryFuncReqBO reqBO = new DycUocProDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            DycUocProDictionaryFuncRspBO qryRspBO = this.dycUocProDictionaryFunction.qryDic(reqBO);
            List rspList = qryRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rspList) ? Lists.newArrayList() : JUtil.jsl((List)rspList, ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycUocProDictionaryCreateFuncReqBO reqBO = new DycUocProDictionaryCreateFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            DycUocProDictionaryCreateFuncRspBO addRspBO = this.dycUocProDictionaryFunction.createDic(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycUocProDictionaryUpdateFuncReqBO reqBO = new DycUocProDictionaryUpdateFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            DycUocProDictionaryUpdateFuncRspBO updateRspBO = this.dycUocProDictionaryFunction.updateDic(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycUocProDictionaryDeleteFuncReqBO reqBO = new DycUocProDictionaryDeleteFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycUocProDictionaryDeleteFuncRspBO delRspBO = this.dycUocProDictionaryFunction.deleteDic(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUmcDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycUmcQueryDictionaryFuncReqBO reqBO = new DycUmcQueryDictionaryFuncReqBO();
            reqBO.setPcode(dictionaryCode.getPCode());
            DycUmcRspListFuncBO qryRspBO = this.dycUmcDictionaryFunction.queryBypCodeBackPo(reqBO);
            log.info("umc:{}", (Object)JUtil.jsl((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class));
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycUmcDicDictionaryFuncReqBO reqBO = new DycUmcDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycUmcDictionaryFuncRspBO addRspBO = this.dycUmcDictionaryFunction.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycUmcDicDictionaryFuncReqBO reqBO = new DycUmcDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycUmcDictionaryFuncRspBO updateRspBO = this.dycUmcDictionaryFunction.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycUmcDicDictionaryFuncReqBO reqBO = new DycUmcDicDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycUmcDictionaryFuncRspBO delRspBO = this.dycUmcDictionaryFunction.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUccDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycUccDictionaryFuncReqBO reqBO = new DycUccDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            DycUccDictionaryFuncRspBO qryRspBO = this.dycUccDictionaryFunction.queryDictionary(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycUccDictionaryAddFuncBO reqBO = new DycUccDictionaryAddFuncBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            DycUccDictionaryAddFuncRspBO addRspBO = this.dycUccDictionaryFunction.insertDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycUccDictionaryUpdateFuncReqBO reqBO = new DycUccDictionaryUpdateFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            DycUccDictionaryUpdateFuncRspBO updateRspBO = this.dycUccDictionaryFunction.updateDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycUccDictionaryDeleteFuncReqBO reqBO = new DycUccDictionaryDeleteFuncReqBO();
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycUccDictionaryDeleteFuncRspBO delRspBO = this.dycUccDictionaryFunction.deleteDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callFscDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            DycFscQueryDictionaryFuncReqBO reqBO = new DycFscQueryDictionaryFuncReqBO();
            reqBO.setPcode(dictionaryCode.getPCode());
            DycFscDictionaryFuncPageRspBO qryRspBO = this.dycFscDictionaryFunction.queryBypCodeBackPo(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : JUtil.jsl((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            DycFscDicDictionaryFuncReqBO reqBO = new DycFscDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycFscDictionaryFuncRspBO addRspBO = this.dycFscDictionaryFunction.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            DycFscDicDictionaryFuncReqBO reqBO = new DycFscDicDictionaryFuncReqBO();
            BeanUtils.copyProperties((Object)((Object)dictionaryCode), (Object)reqBO);
            DycFscDictionaryFuncRspBO updateRspBO = this.dycFscDictionaryFunction.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            DycFscDicDictionaryFuncReqBO reqBO = new DycFscDicDictionaryFuncReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DycFscDictionaryFuncRspBO delRspBO = this.dycFscDictionaryFunction.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }
}

