/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreAfterOrderCancelFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreAfterOrderCancelFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreAfterOrderCancelFuncRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterOrderCancelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreAfterOrderCancelFunctionImpl
implements DycUocEstoreAfterOrderCancelFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreAfterOrderCancelFunctionImpl.class);

    @Override
    public DycUocEstoreAfterOrderCancelFuncRspBO applyCancel(DycUocEstoreAfterOrderCancelFuncReqBO reqBO) {
        DycUocEstoreAfterOrderCancelFuncRspBO rsp = new DycUocEstoreAfterOrderCancelFuncRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        this.validateArg(reqBO);
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupId()));
        if (reqBO.getSupId().equals(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"))) {
            try {
                JSONObject jdParm = new JSONObject();
                JSONObject jdInParm = new JSONObject();
                jdInParm.put("orderId", (Object)reqBO.getServiceId());
                jdInParm.put("orgId", (Object)reqBO.getOrgId());
                jdInParm.put("thirdApplyId", (Object)reqBO.getThirdApplyId());
                jdInParm.put("remark", (Object)"\u53d6\u6d88");
                jdParm.put("param", (Object)jdInParm);
                log.info("\u4eac\u4e1c\u53d6\u6d88\u552e\u540e\u7533\u8bf7httpReqStr: {}", (Object)JSONObject.toJSONString((Object)jdParm));
                String httpRspStr = DycEsbUtil.doPostReuest((String)reqBO.getRequestUrl(), (String)JSONObject.toJSONString((Object)jdParm), (String)hsn);
                log.info("\u4eac\u4e1c\u53d6\u6d88\u552e\u540e\u7533\u8bf7httpRspStr: {}", (Object)httpRspStr);
                this.resolveRsp(httpRspStr);
            }
            catch (ZTBusinessException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        try {
            AfterOrderCancelEntity afterOrderCancelEntity = new AfterOrderCancelEntity();
            afterOrderCancelEntity.setOrgId(reqBO.getOrgId());
            afterOrderCancelEntity.setServiceId(reqBO.getServiceId());
            log.info("httpReqStr: {}", (Object)JSONObject.toJSONString((Object)afterOrderCancelEntity));
            String httpRspStr = DycEsbUtil.doPostReuest((String)reqBO.getRequestUrl(), (String)JSONObject.toJSONString((Object)afterOrderCancelEntity), (String)hsn);
            log.info("httpRspStr: {}", (Object)httpRspStr);
            this.resolveRsp(httpRspStr);
        }
        catch (ZTBusinessException e) {
            throw new ZTBusinessException(e.getMessage());
        }
        return rsp;
    }

    private void resolveRsp(String httpRspStr) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)httpRspStr);
        if (!rspJsonObject.getBoolean("success").booleanValue()) {
            throw new ZTBusinessException("\u8c03\u7528\u4e09\u65b9\u7535\u5546\u53d6\u6d88\u552e\u540e\u5355\u5931\u8d25");
        }
    }

    private void validateArg(DycUocEstoreAfterOrderCancelFuncReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getServiceId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5916\u90e8\u552e\u540e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupId())) {
            throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

