/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.constants.DycFuncRspConstants;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreQryAfterOrderTypeFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreQryAfterOrderTypeFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreQryAfterOrderTypeFuncRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterOrderTypeEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterTypeAndTakeValueEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.JDAfterTypeAndTakeValueEntity;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspAfsBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreQryAfterOrderTypeFunctionImpl
implements DycUocEstoreQryAfterOrderTypeFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreQryAfterOrderTypeFunctionImpl.class);
    @Value(value="${ESB_QRY_AFTER_TYPE_URL}")
    private String esbQryArterTypeUrl;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;

    @Override
    public DycUocEstoreQryAfterOrderTypeFuncRspBO qryAfterOrderType(DycUocEstoreQryAfterOrderTypeFuncReqBO reqBo) {
        DycUocEstoreQryAfterOrderTypeFuncRspBO funcRspBO = new DycUocEstoreQryAfterOrderTypeFuncRspBO();
        funcRspBO.setRespCode("0000");
        funcRspBO.setRespDesc("\u6210\u529f");
        this.validateArg(reqBo);
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setOrderId(reqBo.getOrderId());
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        for (Long itemId : reqBo.getOrdItemList()) {
            AfterOrderTypeEntity afterOrderType = this.buildThirdEntity(saleOrderDetail, itemId);
            String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + saleOrderDetail.getSupId()));
            if (saleOrderDetail.getSupId().equals(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"))) {
                JSONObject jdInParam = new JSONObject();
                jdInParam.put("orderId", (Object)afterOrderType.getOrderId());
                jdInParam.put("orgId", (Object)reqBo.getOrgId());
                jdInParam.put("wareIds", Arrays.asList(afterOrderType.getSkuId()));
                JSONObject jdParam = new JSONObject();
                jdParam.put("param", (Object)jdInParam);
                try {
                    log.info("\u4eac\u4e1c\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u5165\u53c2: {}", (Object)JSONObject.toJSONString((Object)jdParam));
                    String httpRspStr = DycEsbUtil.doPostReuest((String)this.esbQryArterTypeUrl, (String)JSONObject.toJSONString((Object)jdParam), (String)hsn);
                    log.info("\u4eac\u4e1c\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u51fa\u53c2: {}", (Object)httpRspStr);
                    this.resolveJDRsp(httpRspStr, funcRspBO);
                    continue;
                }
                catch (ZTBusinessException e) {
                    throw new ZTBusinessException(e.getMessage());
                }
            }
            try {
                log.info("httpReqStr: {}", (Object)JSONObject.toJSONString((Object)((Object)reqBo)));
                log.info("httpReqStr: {}", (Object)JSONObject.toJSONString((Object)afterOrderType));
                String httpRspStr = DycEsbUtil.doPostReuest((String)reqBo.getRequestUrl(), (String)JSONObject.toJSONString((Object)afterOrderType), (String)hsn);
                log.info("httpRspStr: {}", (Object)httpRspStr);
                this.resolveRsp(httpRspStr, funcRspBO);
            }
            catch (ZTBusinessException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        if ("XS_YS_YS".equals(saleOrderDetail.getSaleOrderState()) && ObjectUtil.isNotEmpty(funcRspBO.getServerTypes())) {
            Iterator<UocAfterServiceTypeQryServiceRspAfsBo> iterator = funcRspBO.getServerTypes().iterator();
            while (iterator.hasNext()) {
                UocAfterServiceTypeQryServiceRspAfsBo item = iterator.next();
                int type = item.getServerType();
                if (type != 10) continue;
                log.info("\u9a8c\u6536\u4e0d\u9700\u8981\u9000\u8d27");
                iterator.remove();
            }
        }
        return funcRspBO;
    }

    private AfterOrderTypeEntity buildThirdEntity(UocGetSaleOrderDetailServiceRspBo saleOrderDetail, Long itemId) {
        List saleOrderDetailServiceRspItemBoList = saleOrderDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<Long, UocGetSaleOrderDetailServiceRspItemBo> itemBoMap = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSaleOrderItemId, o -> o));
        UocGetSaleOrderDetailServiceRspItemBo uocGetSaleOrderDetailServiceRspItemBo = itemBoMap.get(itemId);
        String skuExtSkuId = uocGetSaleOrderDetailServiceRspItemBo.getSkuExtSkuId();
        AfterOrderTypeEntity afterOrderTypeEntity = new AfterOrderTypeEntity();
        String saleOrderNoExt = saleOrderDetail.getSaleOrderNoExt();
        afterOrderTypeEntity.setOrderId(saleOrderNoExt);
        afterOrderTypeEntity.setSkuId(skuExtSkuId);
        afterOrderTypeEntity.setOrgId(saleOrderDetail.getPurOrgId());
        return afterOrderTypeEntity;
    }

    private void resolveRsp(String returnString, DycUocEstoreQryAfterOrderTypeFuncRspBO funcRspBO) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        ArrayList<UocAfterServiceTypeQryServiceRspAfsBo> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<UocAfterServiceTypeQryServiceRspAfsBo>();
        if (rspJsonObject.getBoolean("success").booleanValue() && rspJsonObject.get((Object)"result") != null) {
            Object object = rspJsonObject.get((Object)"result");
            try {
                List parseArray = JSON.parseArray((String)object.toString(), AfterTypeAndTakeValueEntity.class);
                List resultByOrder = parseArray.stream().sorted(new Comparator<AfterTypeAndTakeValueEntity>(){

                    @Override
                    public int compare(AfterTypeAndTakeValueEntity o1, AfterTypeAndTakeValueEntity o2) {
                        return o1.getType().compareTo(o1.getType());
                    }
                }).collect(Collectors.toList());
                for (AfterTypeAndTakeValueEntity afterTypeAndTakeValueEntity : resultByOrder) {
                    UocAfterServiceTypeQryServiceRspAfsBo uocAfterServiceTypeQryServiceRspAfsBo;
                    Integer type = afterTypeAndTakeValueEntity.getType();
                    if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.RETURN.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerType(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_RETURN);
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerName("\u9000\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.CHANGE.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerType(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_CHANGE);
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerName("\u6362\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (!DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.FIX.equals(type)) continue;
                    uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
                    uocAfterServiceTypeQryServiceRspAfsBo.setServerType(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_FIX);
                    uocAfterServiceTypeQryServiceRspAfsBo.setServerName("\u7ef4\u4fee");
                    uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
                    uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                }
                if (CollectionUtil.isEmpty(funcRspBO.getServerTypes())) {
                    funcRspBO.setServerTypes(uocAfterServiceTypeQryServiceRspAfsBos);
                } else {
                    List intersection = (List)CollectionUtil.intersection(funcRspBO.getServerTypes(), uocAfterServiceTypeQryServiceRspAfsBos);
                    funcRspBO.setServerTypes(intersection);
                }
            }
            catch (Exception e) {
                funcRspBO.setServerTypes(uocAfterServiceTypeQryServiceRspAfsBos);
            }
        }
    }

    private void resolveJDRsp(String returnString, DycUocEstoreQryAfterOrderTypeFuncRspBO funcRspBO) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        ArrayList<UocAfterServiceTypeQryServiceRspAfsBo> uocAfterServiceTypeQryServiceRspAfsBos = new ArrayList<UocAfterServiceTypeQryServiceRspAfsBo>();
        if (rspJsonObject.getBoolean("success").booleanValue() && rspJsonObject.get((Object)"result") != null) {
            Object object = rspJsonObject.get((Object)"result");
            try {
                List parseArray = JSON.parseArray((String)object.toString(), JDAfterTypeAndTakeValueEntity.class);
                ArrayList<Integer> customerExpect = new ArrayList<Integer>();
                for (Object afterTypeAndTakeValueEntity : parseArray) {
                    customerExpect.addAll(((JDAfterTypeAndTakeValueEntity)afterTypeAndTakeValueEntity).getCustomerExpect());
                }
                List resultByOrder = customerExpect.stream().sorted(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o1.compareTo(o2);
                    }
                }).collect(Collectors.toList());
                for (Integer type : resultByOrder) {
                    UocAfterServiceTypeQryServiceRspAfsBo uocAfterServiceTypeQryServiceRspAfsBo;
                    if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerType(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_RETURN);
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerName("\u9000\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_CHANGE.equals(type)) {
                        uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerType(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_CHANGE);
                        uocAfterServiceTypeQryServiceRspAfsBo.setServerName("\u6362\u8d27");
                        uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
                        uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                        continue;
                    }
                    if (!DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_FIX.equals(type)) continue;
                    uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
                    uocAfterServiceTypeQryServiceRspAfsBo.setServerType(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.LOCAL_FIX);
                    uocAfterServiceTypeQryServiceRspAfsBo.setServerName("\u7ef4\u4fee");
                    uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
                    uocAfterServiceTypeQryServiceRspAfsBos.add(uocAfterServiceTypeQryServiceRspAfsBo);
                }
                if (CollectionUtil.isEmpty(funcRspBO.getServerTypes())) {
                    funcRspBO.setServerTypes(uocAfterServiceTypeQryServiceRspAfsBos);
                } else {
                    List intersection = (List)CollectionUtil.intersection(funcRspBO.getServerTypes(), uocAfterServiceTypeQryServiceRspAfsBos);
                    funcRspBO.setServerTypes(intersection);
                }
            }
            catch (Exception e) {
                funcRspBO.setServerTypes(uocAfterServiceTypeQryServiceRspAfsBos);
            }
        }
    }

    private void validateArg(DycUocEstoreQryAfterOrderTypeFuncReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

