/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.fsc.pay.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.user.api.DycAuthUserDataPowerQryFunction;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionReqBo;
import com.tydic.dyc.atom.busicommon.user.bo.DycAuthUserDataPowerQryFunctionRspBo;
import com.tydic.dyc.fsc.pay.api.DycFscQueryServiceListAbilityService;
import com.tydic.dyc.fsc.pay.bo.DycFscOrderInfoBO;
import com.tydic.dyc.fsc.pay.bo.DycFscQueryServiceListAbilityReqBO;
import com.tydic.dyc.fsc.pay.bo.DycFscQueryServiceListAbilityRspBO;
import com.tydic.dyc.fsc.pay.bo.DycUocProTransactionListQueryReqBO;
import com.tydic.dyc.fsc.pay.bo.DycUocProTransactionListQueryRspBO;
import com.tydic.dyc.fsc.pay.bo.DycUocServiceFeeQryListBO;
import com.tydic.dyc.fsc.pay.bo.FscServiceListBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.fsc.pay.api.DycFscQueryServiceListAbilityService"})
public class DycFscQueryServiceListAbilityServiceImpl
implements DycFscQueryServiceListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DycFscQueryServiceListAbilityServiceImpl.class);
    private static final Integer TAB_ID = 80013;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Value(value="${fsc.qry.url:}")
    private String generalQueryUrl;
    @Autowired
    private DycAuthUserDataPowerQryFunction dycAuthUserDataPowerQryFunction;

    @Override
    @PostMapping(value={"qryServiceList"})
    public DycFscQueryServiceListAbilityRspBO qryServiceList(@RequestBody DycFscQueryServiceListAbilityReqBO reqBO) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = (FscComOrderListQueryAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), FscComOrderListQueryAbilityReqBO.class);
        this.setDataAuth(fscComOrderListQueryAbilityReqBO, reqBO);
        FscComOrderListQueryAbilityRspBO abilityRspBO = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        String rspString = JSON.toJSONString((Object)abilityRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        DycFscQueryServiceListAbilityRspBO dycFscQueryServiceListAbilityRspBO = (DycFscQueryServiceListAbilityRspBO)((Object)JSON.parseObject((String)rspString, DycFscQueryServiceListAbilityRspBO.class));
        if (!CollectionUtils.isEmpty((Collection)dycFscQueryServiceListAbilityRspBO.getRows())) {
            List<Long> relIdList = dycFscQueryServiceListAbilityRspBO.getRows().stream().map(FscServiceListBO::getFscOrderId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            HashMap orderInfo = new HashMap();
            DycUocProTransactionListQueryReqBO uocProTransactionServiceListQueryReqBo = new DycUocProTransactionListQueryReqBO();
            uocProTransactionServiceListQueryReqBo.setRelIdList(relIdList);
            uocProTransactionServiceListQueryReqBo.setPageNo(1);
            uocProTransactionServiceListQueryReqBo.setPageSize(10000);
            log.info("\u901a\u7528\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)uocProTransactionServiceListQueryReqBo)));
            DycUocProTransactionListQueryRspBO monthFee = this.getMonthFee(uocProTransactionServiceListQueryReqBo);
            log.info("\u901a\u7528\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)monthFee)));
            Map<Long, List<DycUocServiceFeeQryListBO>> dycUocServiceFeeQryListMap = monthFee.getRows().stream().collect(Collectors.groupingBy(DycUocServiceFeeQryListBO::getRelId));
            for (Map.Entry<Long, List<DycUocServiceFeeQryListBO>> dycUocServiceFeeQryListEntry : dycUocServiceFeeQryListMap.entrySet()) {
                ArrayList<DycFscOrderInfoBO> dycFscOrderInfoBOS = new ArrayList<DycFscOrderInfoBO>();
                for (DycUocServiceFeeQryListBO bo : dycUocServiceFeeQryListEntry.getValue()) {
                    DycFscOrderInfoBO dycFscOrderInfoBO = new DycFscOrderInfoBO();
                    dycFscOrderInfoBO.setOrderId(Convert.toStr((Object)bo.getOrderItem().get(0).getOrderId()));
                    dycFscOrderInfoBO.setInspectionVoucherCode(Convert.toStr((Object)bo.getInspOrderNo()));
                    dycFscOrderInfoBO.setInspTotalPurchaseMoney(bo.getPurFee());
                    dycFscOrderInfoBO.setOrderCreateTime(DateUtil.format((Date)bo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    dycFscOrderInfoBO.setPurAccountName(bo.getPurAccountName());
                    dycFscOrderInfoBO.setPurchaseVoucherNo(bo.getSaleOrderNo());
                    dycFscOrderInfoBO.setPurName(bo.getPurCompanyName());
                    dycFscOrderInfoBO.setPurPlaceOrderName(bo.getPurName());
                    dycFscOrderInfoBO.setSerPriceMoney(bo.getSerPriceMoney());
                    dycFscOrderInfoBO.setSaleVoucherId(bo.getSaleOrderId());
                    dycFscOrderInfoBO.setOrderSource(bo.getOrderSource());
                    dycFscOrderInfoBO.setPurLogName(bo.getPurUserName());
                    dycFscOrderInfoBO.setPurLogName(bo.getPurUserName());
                    dycFscOrderInfoBOS.add(dycFscOrderInfoBO);
                }
                orderInfo.put(dycUocServiceFeeQryListEntry.getKey(), dycFscOrderInfoBOS);
            }
            Iterator<Map.Entry<Long, List<DycUocServiceFeeQryListBO>>> iterator = dycFscQueryServiceListAbilityRspBO.getRows().iterator();
            while (iterator.hasNext()) {
                FscServiceListBO fscServiceListBO;
                fscServiceListBO.setAuditProcInstId(CollectionUtil.isEmpty((fscServiceListBO = (FscServiceListBO)((Object)iterator.next())).getFscEsAuditTaskInfoBO()) ? "" : fscServiceListBO.getFscEsAuditTaskInfoBO().get(0).getProcInstId());
                if (!CollectionUtils.isEmpty(fscServiceListBO.getAttachmentList())) {
                    String join = String.join((CharSequence)",", fscServiceListBO.getAttachmentList());
                    fscServiceListBO.setAttachmentListStr(join);
                }
                fscServiceListBO.setOrderInfo((List)orderInfo.get(fscServiceListBO.getFscOrderId()));
                fscServiceListBO.setCreditAmount(Optional.ofNullable(fscServiceListBO.getCreditAmount()).orElse(new BigDecimal("0.00")));
            }
        }
        return dycFscQueryServiceListAbilityRspBO;
    }

    private DycUocProTransactionListQueryRspBO getMonthFee(DycUocProTransactionListQueryReqBO reqBO) {
        String rspJsonStr = this.commonQry(JSON.toJSONString((Object)((Object)reqBO)));
        return (DycUocProTransactionListQueryRspBO)((Object)JSON.parseObject((String)rspJsonStr, DycUocProTransactionListQueryRspBO.class));
    }

    private String commonQry(String reqJsonStr) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("queryCountFlag", (Object)false);
        jsonObject.put("reqParams", (Object)reqJsonStr);
        return HttpUtil.post((String)this.generalQueryUrl, (String)jsonObject.toJSONString(), (int)6000);
    }

    private void setDataAuth(FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO, DycFscQueryServiceListAbilityReqBO reqBO) {
        if (null != reqBO.getMenuId()) {
            DycAuthUserDataPowerQryFunctionReqBo dycAuthUserDataPowerQryFunctionReqBo = new DycAuthUserDataPowerQryFunctionReqBo();
            if (!StringUtils.isEmpty((CharSequence)reqBO.getMenuCode())) {
                dycAuthUserDataPowerQryFunctionReqBo.setMenuCode(reqBO.getMenuCode());
            }
            dycAuthUserDataPowerQryFunctionReqBo.setUserId(reqBO.getUserId());
            dycAuthUserDataPowerQryFunctionReqBo.setLoginTagIn(reqBO.getLoginTagIn());
            dycAuthUserDataPowerQryFunctionReqBo.setOrgTreePathIn(reqBO.getOrgTreePathIn());
            dycAuthUserDataPowerQryFunctionReqBo.setMenuId(reqBO.getMenuId());
            DycAuthUserDataPowerQryFunctionRspBo dycAuthUserDataPowerQryFunctionRspBo = this.dycAuthUserDataPowerQryFunction.qryUserDataPower(dycAuthUserDataPowerQryFunctionReqBo);
            if (!"0000".equals(dycAuthUserDataPowerQryFunctionRspBo.getRespCode())) {
                throw new ZTBusinessException("\u83b7\u53d6\u6570\u636e\u6743\u9650\u5f02\u5e38:" + dycAuthUserDataPowerQryFunctionRspBo.getRespDesc());
            }
            fscComOrderListQueryAbilityReqBO.setSeflFlag(dycAuthUserDataPowerQryFunctionRspBo.getSeflFlag());
            if (!CollectionUtils.isEmpty((Collection)dycAuthUserDataPowerQryFunctionRspBo.getPurExtendOrgIds())) {
                fscComOrderListQueryAbilityReqBO.setPurExtendOrgIds(dycAuthUserDataPowerQryFunctionRspBo.getPurExtendOrgIds());
            }
            if (!CollectionUtils.isEmpty((Collection)dycAuthUserDataPowerQryFunctionRspBo.getPurNotExtendOrgIds())) {
                fscComOrderListQueryAbilityReqBO.setPurNotExtendOrgIds(dycAuthUserDataPowerQryFunctionRspBo.getPurNotExtendOrgIds());
            }
            if (!CollectionUtils.isEmpty((Collection)dycAuthUserDataPowerQryFunctionRspBo.getProExtendOrgIds())) {
                fscComOrderListQueryAbilityReqBO.setPurExtendOrgIds(dycAuthUserDataPowerQryFunctionRspBo.getProExtendOrgIds());
            }
            if (!CollectionUtils.isEmpty((Collection)dycAuthUserDataPowerQryFunctionRspBo.getProNotExtendOrgIds())) {
                fscComOrderListQueryAbilityReqBO.setProNotExtendOrgIds(dycAuthUserDataPowerQryFunctionRspBo.getProNotExtendOrgIds());
            }
            if (!CollectionUtils.isEmpty((Collection)dycAuthUserDataPowerQryFunctionRspBo.getSupNotExtendOrgIds())) {
                fscComOrderListQueryAbilityReqBO.setSupExtendOrgIds(dycAuthUserDataPowerQryFunctionRspBo.getSupNotExtendOrgIds());
            }
            if (!CollectionUtils.isEmpty((Collection)dycAuthUserDataPowerQryFunctionRspBo.getSupExtendOrgIds())) {
                fscComOrderListQueryAbilityReqBO.setSupExtendOrgIds(dycAuthUserDataPowerQryFunctionRspBo.getSupExtendOrgIds());
            }
        }
    }
}

