/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycUmcQryFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUmcQryFunctionReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycUmcQryFunctionRspBo;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.api.DycGeneralBusiRuleExecFunction;
import com.tydic.dyc.atom.common.api.DycUmcQuerySupplierListFunction;
import com.tydic.dyc.atom.common.api.DycUocQryAuditConfListFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralBusiRuleExecFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralBusiRuleExecFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycUmcQuerySupplierListFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycUmcQuerySupplierListFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycUmcSupplierSignContractFuncBO;
import com.tydic.dyc.atom.common.bo.DycUocQryAuditConfListBo;
import com.tydic.dyc.atom.common.bo.DycUocQryAuditConfListFuncReqBo;
import com.tydic.dyc.atom.common.bo.DycUocQryAuditConfListFuncRspBo;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocDeductPlanNumFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocDeductSkuNumFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocOrderSaleCreateFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocProfessionalDetailQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocShopCartGoodsDeleteFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocSupplierInfoQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocSupplierPayConfigQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocBaseExtParallelFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCreateSaleOrderAgrFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductPlanNumFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductPlanNumFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductPlanNumFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocOrderSaleCreateFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocOrderSaleCreateFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSaleOrderInfoFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSaleOrderItemFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocShopCartGoodsDeleteFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocShopCartGoodsDeleteFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierPayConfigFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierPayConfigQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierPayConfigQryFuncRspBO;
import com.tydic.dyc.atom.zone.api.DycUocAgrQryFunction;
import com.tydic.dyc.atom.zone.bo.DycUocAgrQryFunctionReqBo;
import com.tydic.dyc.atom.zone.bo.DycUocAgrQryFunctionRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.mall.order.api.DycUocCreateOrderService;
import com.tydic.dyc.mall.order.bo.DycUocCommodityBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderRspBO;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycUocCreateOrderServiceImpl
implements DycUocCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCreateOrderServiceImpl.class);
    private static final String YES = "01";
    @Autowired
    private DycUocCommodityBatchQryFunction dycUocCommodityBatchQryFunction;
    @Autowired
    private DycUocSupplierInfoQryFunction dycUocSupplierInfoQryFunction;
    @Autowired
    private DycUocProfessionalDetailQryFunction dycUocProfessionalDetailQryFunction;
    @Autowired
    private DycUocSupplierPayConfigQryFunction dycUocSupplierPayConfigQryFunction;
    @Autowired
    private DycUocDeductSkuNumFunction dycUocDeductSkuNumFunction;
    @Autowired
    private DycUocOrderSaleCreateFunction dycUocOrderSaleCreateFunction;
    @Autowired
    private DycUocDeductPlanNumFunction dycUocDeductPlanNumFunction;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private DycUocShopCartGoodsDeleteFunction dycUocShopCartGoodsDeleteFunction;
    @Autowired
    private DycGeneralBusiRuleExecFunction dycGeneralBusiRuleExecFunction;
    @Autowired
    private DycUocAgrQryFunction dycUocAgrQryFunction;
    @Autowired
    private DycUmcQuerySupplierListFunction dycUmcQuerySupplierListFunction;
    @Autowired
    private DycUmcQryFunction dycUmcQryFunction;
    @Autowired
    private DycUocQryAuditConfListFunction dycUocQryAuditConfListFunction;
    @Value(value="${uoc.orderCreateNeedAudit:0}")
    private String orderCreateNeedAudit;
    public static final Long ZORE = 0L;
    private String autidStartflag = "1";
    private String autidCompleteflag = "1";

    @Override
    public DycUocCreateOrderRspBO createOrder(DycUocCreateOrderReqBO reqBO) {
        log.info("\u8ba2\u5355\u5927N\u5165\u53c2" + JSON.toJSONString((Object)((Object)reqBO)));
        DycUocCreateOrderRspBO rsp = new DycUocCreateOrderRspBO();
        List<DycUocCommodityFuncBO> commodityBos = this.doQryCommodityByBatch(reqBO);
        List<Long> supllierIds = reqBO.getCommodityBos().stream().map(DycUocCommodityBO::getSupplierId).distinct().collect(Collectors.toList());
        List<DycUocSupplierInfoFuncBO> supplierBos = this.doQrySupplierInfo(supllierIds);
        DycUocProfessionalDetailFuncBO professionalDetailBO = this.doQryProfessionalDetail(reqBO.getPurAccountId());
        List<DycUocSupplierPayConfigFuncBO> supplierPayConfigBos = this.doQrySupplierPayConfig(reqBO.getCompanyId(), Long.valueOf(professionalDetailBO.getProId()), supllierIds);
        this.doDealDeductSkuNum(reqBO.getCommodityBos());
        List<DycUocCreateSaleOrderAgrFuncBO> agrFuncBoList = this.doQryAgrInfo(reqBO, commodityBos);
        List<DycUmcSupplierSignContractFuncBO> signContractFuncBOS = this.getSupplierSignContract(reqBO.getCommodityBos());
        DycUocOrderSaleCreateFuncRspBO dycUocOrderSaleCreateFuncRspBO = this.doDealOrderSaleCreate(reqBO, commodityBos, supplierBos, professionalDetailBO, supplierPayConfigBos, signContractFuncBOS, agrFuncBoList);
        this.doDealDeductPlanNum(commodityBos, dycUocOrderSaleCreateFuncRspBO);
        this.doStartBusiProcess(reqBO, dycUocOrderSaleCreateFuncRspBO, agrFuncBoList);
        this.doDealShopCartGoodsDelete(reqBO.getUserId(), reqBO.getCommodityBos().stream().map(DycUocCommodityBO::getSpId).collect(Collectors.toList()));
        rsp.setOrderId(dycUocOrderSaleCreateFuncRspBO.getOrderId());
        return rsp;
    }

    private List<DycUmcSupplierSignContractFuncBO> getSupplierSignContract(List<DycUocCommodityBO> commodityBos) {
        List supplierIds = commodityBos.stream().map(DycUocCommodityBO::getSupplierId).distinct().collect(Collectors.toList());
        DycUmcQuerySupplierListFuncReqBO dycUmcQuerySupplierListFuncReqBO = new DycUmcQuerySupplierListFuncReqBO();
        dycUmcQuerySupplierListFuncReqBO.setSupplierIds(supplierIds);
        DycUmcQuerySupplierListFuncRspBO dycUmcQuerySupplierListFuncRspBO = this.dycUmcQuerySupplierListFunction.querySupplierList(dycUmcQuerySupplierListFuncReqBO);
        return dycUmcQuerySupplierListFuncRspBO.getSignContractBOS();
    }

    private List<DycUocCreateSaleOrderAgrFuncBO> doQryAgrInfo(DycUocCreateOrderReqBO reqBO, List<DycUocCommodityFuncBO> commodityBos) {
        Map<String, DycUocCommodityFuncBO> skuAgrMap = commodityBos.stream().collect(Collectors.toMap(DycUocCommodityFuncBO::getSkuId, item -> item));
        ArrayList<DycUocCreateSaleOrderAgrFuncBO> agrFuncBoList = new ArrayList<DycUocCreateSaleOrderAgrFuncBO>();
        List<DycUocCommodityBO> reqCommodityBos = reqBO.getCommodityBos();
        for (DycUocCommodityBO commodityBo : reqCommodityBos) {
            String agreementId = skuAgrMap.get(commodityBo.getSkuId().toString()).getAgreementId();
            if (!ObjectUtil.isNotEmpty((Object)agreementId)) continue;
            DycUocAgrQryFunctionReqBo qryAgrReqBo = new DycUocAgrQryFunctionReqBo();
            qryAgrReqBo.setAgreementId(Long.valueOf(agreementId));
            DycUocAgrQryFunctionRspBo qryAgrRspBo = this.dycUocAgrQryFunction.qryAgr(qryAgrReqBo);
            DycUocCreateSaleOrderAgrFuncBO agrFuncBo = (DycUocCreateSaleOrderAgrFuncBO)JUtil.js((Object)qryAgrRspBo, DycUocCreateSaleOrderAgrFuncBO.class);
            agrFuncBoList.add(agrFuncBo);
        }
        return agrFuncBoList;
    }

    private List<DycUocCommodityFuncBO> doQryCommodityByBatch(DycUocCreateOrderReqBO reqBO) {
        DycUocCommodityBatchQryFuncReqBO dycUocCommodityBatchQryFuncReqBO = new DycUocCommodityBatchQryFuncReqBO();
        dycUocCommodityBatchQryFuncReqBO.setOrgIdIn(reqBO.getOrgIdIn());
        dycUocCommodityBatchQryFuncReqBO.setProvince(Long.valueOf(reqBO.getAddressBo().getContactProvinceId()));
        dycUocCommodityBatchQryFuncReqBO.setCity(Long.valueOf(reqBO.getAddressBo().getContactCityId()));
        dycUocCommodityBatchQryFuncReqBO.setCounty(Long.valueOf(reqBO.getAddressBo().getContactCountyId()));
        dycUocCommodityBatchQryFuncReqBO.setTown(Long.valueOf(reqBO.getAddressBo().getContactTownId()));
        dycUocCommodityBatchQryFuncReqBO.setCompanyId(reqBO.getCompanyId());
        dycUocCommodityBatchQryFuncReqBO.setIsprofess(reqBO.getIsprofess());
        dycUocCommodityBatchQryFuncReqBO.setPsDiscountRate(reqBO.getPsDiscountRate());
        List commodityBatchQryBos = reqBO.getCommodityBos().stream().map(bo -> {
            DycUocCommodityBatchQryFuncBO dycUocCommodityBatchQryFuncBO = new DycUocCommodityBatchQryFuncBO();
            dycUocCommodityBatchQryFuncBO.setSupplierShopId(bo.getSupplierShopId());
            dycUocCommodityBatchQryFuncBO.setSkuId(bo.getSkuId());
            dycUocCommodityBatchQryFuncBO.setNum(bo.getPurchaseCount());
            dycUocCommodityBatchQryFuncBO.setCommodityId(bo.getCommodityId());
            dycUocCommodityBatchQryFuncBO.setSalePrice(bo.getSalePrice());
            return dycUocCommodityBatchQryFuncBO;
        }).collect(Collectors.toList());
        dycUocCommodityBatchQryFuncReqBO.setCommodityBatchQryBos(commodityBatchQryBos);
        DycUocCommodityBatchQryFuncRspBO dycUocCommodityBatchQryFuncRspBO = this.dycUocCommodityBatchQryFunction.qryCommodityByBatch(dycUocCommodityBatchQryFuncReqBO);
        return dycUocCommodityBatchQryFuncRspBO.getCommodityBos();
    }

    private List<DycUocSupplierInfoFuncBO> doQrySupplierInfo(List<Long> supllierIds) {
        DycUocSupplierInfoQryFuncReqBO dycUocSupplierInfoQryFuncReqBO = new DycUocSupplierInfoQryFuncReqBO();
        dycUocSupplierInfoQryFuncReqBO.setSupplierIds(supllierIds);
        DycUocSupplierInfoQryFuncRspBO dycUocSupplierInfoQryFuncRspBO = this.dycUocSupplierInfoQryFunction.qrySupplierInfo(dycUocSupplierInfoQryFuncReqBO);
        return dycUocSupplierInfoQryFuncRspBO.getSupplierBos();
    }

    private DycUocProfessionalDetailFuncBO doQryProfessionalDetail(Long purAccountId) {
        DycUocProfessionalDetailQryFuncReqBO dycUocProfessionalDetailQryFuncReqBO = new DycUocProfessionalDetailQryFuncReqBO();
        dycUocProfessionalDetailQryFuncReqBO.setPurAccountId(purAccountId);
        DycUocProfessionalDetailQryFuncRspBO dycUocProfessionalDetailQryFuncRspBO = this.dycUocProfessionalDetailQryFunction.qryProfessionalDetail(dycUocProfessionalDetailQryFuncReqBO);
        return dycUocProfessionalDetailQryFuncRspBO.getProfessionalDetailBO();
    }

    private List<DycUocSupplierPayConfigFuncBO> doQrySupplierPayConfig(Long purchaseOrgId, Long operationOrgId, List<Long> supplierIds) {
        DycUocSupplierPayConfigQryFuncReqBO dycUocSupplierPayConfigQryFuncReqBO = new DycUocSupplierPayConfigQryFuncReqBO();
        dycUocSupplierPayConfigQryFuncReqBO.setPurchaseOrgId(purchaseOrgId);
        dycUocSupplierPayConfigQryFuncReqBO.setOperationOrgId(operationOrgId);
        dycUocSupplierPayConfigQryFuncReqBO.setSupplierIds(supplierIds);
        DycUocSupplierPayConfigQryFuncRspBO dycUocSupplierPayConfigQryFuncRspBO = this.dycUocSupplierPayConfigQryFunction.qrySupplierPayConfig(dycUocSupplierPayConfigQryFuncReqBO);
        return dycUocSupplierPayConfigQryFuncRspBO.getSupplierBos();
    }

    private void doDealDeductSkuNum(List<DycUocCommodityBO> commodityBos) {
        DycUocDeductSkuNumFuncReqBO dycUocDeductSkuNumFuncReqBO = new DycUocDeductSkuNumFuncReqBO();
        List skuDetailBos = commodityBos.stream().map(bo -> {
            DycUocDeductSkuNumFuncBO dycUocDeductSkuNumFuncBO = new DycUocDeductSkuNumFuncBO();
            dycUocDeductSkuNumFuncBO.setSupplierShopId(bo.getSupplierShopId());
            dycUocDeductSkuNumFuncBO.setSkuId(bo.getSkuId());
            dycUocDeductSkuNumFuncBO.setPurchaseCount(bo.getPurchaseCount());
            return dycUocDeductSkuNumFuncBO;
        }).collect(Collectors.toList());
        dycUocDeductSkuNumFuncReqBO.setSkuDetailBos(skuDetailBos);
        dycUocDeductSkuNumFuncReqBO.setOpFlag("1");
        DycUocDeductSkuNumFuncRspBO dycUocDeductSkuNumFuncRspBO = this.dycUocDeductSkuNumFunction.dealDeductSkuNum(dycUocDeductSkuNumFuncReqBO);
    }

    private DycUocOrderSaleCreateFuncRspBO doDealOrderSaleCreate(DycUocCreateOrderReqBO reqBO, List<DycUocCommodityFuncBO> commodityBos, List<DycUocSupplierInfoFuncBO> supplierBos, DycUocProfessionalDetailFuncBO professionalDetailBO, List<DycUocSupplierPayConfigFuncBO> supplierPayConfigBos, List<DycUmcSupplierSignContractFuncBO> signContractFuncBOS, List<DycUocCreateSaleOrderAgrFuncBO> agrFuncBoList) {
        DycUocOrderSaleCreateFuncReqBO dycUocOrderSaleCreateFuncReqBO = (DycUocOrderSaleCreateFuncReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocOrderSaleCreateFuncReqBO.class);
        Map<String, DycUocCommodityFuncBO> skuInfoMap = commodityBos.stream().collect(Collectors.toMap(DycUocCommodityFuncBO::getSkuId, dycUocCommodityFuncBO -> dycUocCommodityFuncBO));
        Map<Long, DycUocCommodityBO> commodityBOMap = reqBO.getCommodityBos().stream().collect(Collectors.toMap(DycUocCommodityBO::getSkuId, commodityBO -> commodityBO));
        ArrayList commodityBos1 = new ArrayList();
        reqBO.getCommodityBos().forEach(bo -> {
            DycUocCommodityFuncBO bo1 = (DycUocCommodityFuncBO)JSON.parseObject((String)JSON.toJSONString(skuInfoMap.get(bo.getSkuId().toString())), DycUocCommodityFuncBO.class);
            bo1.setSaleItemParallelExtList(JSON.parseArray((String)JSON.toJSONString(bo.getSaleItemParallelExtList()), DycUocBaseExtParallelFuncBO.class));
            bo1.setSkuExtSkuId(bo1.getExtSkuId());
            bo1.setCmpOrderNo(bo.getCmpOrderNo());
            bo1.setCmpRemark(bo.getCmpRemark());
            commodityBos1.add(bo1);
        });
        JSONObject supSignContractInfo = new JSONObject(signContractFuncBOS.stream().collect(Collectors.toMap(o -> Convert.toStr((Object)o.getSupplierId()), o -> o)));
        dycUocOrderSaleCreateFuncReqBO.setJsonObj(supSignContractInfo);
        dycUocOrderSaleCreateFuncReqBO.setCommodityBos(commodityBos1);
        dycUocOrderSaleCreateFuncReqBO.setSupplierBos(supplierBos);
        dycUocOrderSaleCreateFuncReqBO.setProfessionalDetailBO(professionalDetailBO);
        dycUocOrderSaleCreateFuncReqBO.setSupplierPayConfigBos(supplierPayConfigBos);
        dycUocOrderSaleCreateFuncReqBO.setAgrBoList(agrFuncBoList);
        dycUocOrderSaleCreateFuncReqBO.setTraceId(reqBO.getTraceId());
        dycUocOrderSaleCreateFuncReqBO.setCreatedResult(UocConstant.CREATED_RESULT.SUCCESS);
        return this.dycUocOrderSaleCreateFunction.dealOrderSaleCreate(dycUocOrderSaleCreateFuncReqBO);
    }

    private void doDealDeductPlanNum(List<DycUocCommodityFuncBO> commodityBos, DycUocOrderSaleCreateFuncRspBO dycUocOrderSaleCreateFuncRspBO) {
        Map commodityMap = commodityBos.stream().collect(Collectors.toMap(DycUocCommodityFuncBO::getSkuId, Function.identity()));
        ArrayList<DycUocDeductPlanNumFuncBO> planDetailBos = new ArrayList<DycUocDeductPlanNumFuncBO>();
        for (DycUocSaleOrderInfoFuncBO bo : dycUocOrderSaleCreateFuncRspBO.getSaleOrderInfoBo()) {
            for (DycUocSaleOrderItemFuncBO bo2 : bo.getItemBoList()) {
                if (!StringUtils.hasText((String)bo2.getPlanId())) continue;
                DycUocDeductPlanNumFuncBO dycUocDeductPlanNumFuncBO = new DycUocDeductPlanNumFuncBO();
                dycUocDeductPlanNumFuncBO.setSaleOrderId(bo.getSaleOrderId());
                dycUocDeductPlanNumFuncBO.setSaleOrderNo(bo.getSaleOrderNo());
                dycUocDeductPlanNumFuncBO.setPlanId(Long.valueOf(bo2.getPlanId()));
                dycUocDeductPlanNumFuncBO.setPlanItemId(Long.valueOf(bo2.getPlanItemId()));
                dycUocDeductPlanNumFuncBO.setSalePrice(((DycUocCommodityFuncBO)commodityMap.get(bo2.getSkuId())).getSalePrice());
                dycUocDeductPlanNumFuncBO.setPurchaseCount(((DycUocCommodityFuncBO)commodityMap.get(bo2.getSkuId())).getPurchaseCount());
                planDetailBos.add(dycUocDeductPlanNumFuncBO);
            }
        }
        if (!CollectionUtils.isEmpty(planDetailBos)) {
            DycUocDeductPlanNumFuncReqBO dycUocDeductPlanNumFuncReqBO = new DycUocDeductPlanNumFuncReqBO();
            dycUocDeductPlanNumFuncReqBO.setOpFlag("1");
            dycUocDeductPlanNumFuncReqBO.setPlanDetailBos(planDetailBos);
            DycUocDeductPlanNumFuncRspBO dycUocDeductPlanNumFuncRspBO = this.dycUocDeductPlanNumFunction.dealDeductPlanNum(dycUocDeductPlanNumFuncReqBO);
        }
    }

    private void doStartBusiProcess(DycUocCreateOrderReqBO reqBO, DycUocOrderSaleCreateFuncRspBO dycUocOrderSaleCreateFuncRspBO, List<DycUocCreateSaleOrderAgrFuncBO> agrFuncBoList) {
        Map<Object, Object> agrMap = new HashMap();
        if (ObjectUtil.isNotEmpty(agrFuncBoList)) {
            agrMap = agrFuncBoList.stream().collect(Collectors.toMap(DycUocCreateSaleOrderAgrFuncBO::getAgreementId, item -> item));
        }
        for (DycUocSaleOrderInfoFuncBO bo : dycUocOrderSaleCreateFuncRspBO.getSaleOrderInfoBo()) {
            DycGeneralBusiRuleExecFuncReqBO dycGeneralBusiRuleExecFuncReqBO = new DycGeneralBusiRuleExecFuncReqBO();
            dycGeneralBusiRuleExecFuncReqBO.setServiceCode("B0001");
            dycGeneralBusiRuleExecFuncReqBO.setParamJsonStr(JSON.toJSONString((Object)bo));
            DycGeneralBusiRuleExecFuncRspBO rspBO = this.dycGeneralBusiRuleExecFunction.generalBusiRuleExec(dycGeneralBusiRuleExecFuncReqBO);
            DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
            if (StringUtils.hasText((String)rspBO.getBusiRuleExecResult())) {
                JSONObject callRuleRspJsonObj = JSON.parseObject((String)rspBO.getBusiRuleExecResult());
                String createOrderProcessKey = callRuleRspJsonObj.getString("processKey");
                if (StringUtils.isEmpty((Object)createOrderProcessKey)) {
                    throw new ZTBusinessException("\u8ba2\u5355\u4e1a\u52a1\u6d41\u7a0bkey\u672a\u914d\u7f6e");
                }
                dycBusiProcessStartFuncReqBO.setProcDefKey(createOrderProcessKey);
            }
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("orderId", dycUocOrderSaleCreateFuncRspBO.getOrderId());
            variables.put("saleOrderNo", bo.getSaleOrderNo());
            variables.put("saleOrderId", bo.getSaleOrderId());
            variables.put("auditObjId", bo.getSaleOrderId());
            variables.put("objId", bo.getSaleOrderId());
            variables.put("orgId", reqBO.getOrgId());
            variables.put("orgName", reqBO.getOrgName());
            variables.put("userId", reqBO.getUserId());
            variables.put("userName", reqBO.getUsername());
            variables.put("autidStartflag", this.autidStartflag);
            variables.put("autidCompleteflag", this.autidCompleteflag);
            variables.put("shipStartflag", 0);
            variables.put("shipCompleteflag", 0);
            variables.put("subOrderStartflag", 0);
            variables.put("subOrderCompleteflag", 0);
            variables.put("orderSale", bo.getTotalSaleFee());
            variables.put("orderCreateNeedAudit", this.orderCreateNeedAudit);
            Integer orderSource = bo.getOrderSource();
            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(orderSource)) {
                variables.put("proDeliveryFlag", "1");
                String agrId = bo.getAgrId();
                DycUocCreateSaleOrderAgrFuncBO agrFuncBO = (DycUocCreateSaleOrderAgrFuncBO)agrMap.get(Long.valueOf(agrId));
                Long producerId = agrFuncBO.getProducerId();
                DycUmcQryFunctionReqBo qryUserBo = new DycUmcQryFunctionReqBo();
                qryUserBo.setMemId(producerId);
                DycUmcQryFunctionRspBo dycUmcQryFunctionRspBo = this.dycUmcQryFunction.qryUser(qryUserBo);
                if (dycUmcQryFunctionRspBo.getUmcMemDetailInfoAbilityRspBO() == null) {
                    variables.put("proDeliveryFlag", "0");
                }
                if (!dycUmcQryFunctionRspBo.getUmcMemDetailInfoAbilityRspBO().getStopStatus().equals(YES)) {
                    variables.put("proDeliveryFlag", "0");
                }
                if (UocDicConstant.ADJUST_PRICE.IN_THE_THING.equals(agrFuncBO.getAdjustPrice().intValue())) {
                    variables.put("adjustPrice", "1");
                } else {
                    variables.put("adjustPrice", "0");
                }
            } else if (UocDicConstant.ORDER_SOURCE.SELF_SUPPORT_PRODUCT.equals(orderSource)) {
                // empty if block
            }
            if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(bo.getPayType())) {
                variables.put("dayPag", "1");
            } else {
                variables.put("prePay", "1");
            }
            dycBusiProcessStartFuncReqBO.setVariables(variables);
            dycBusiProcessStartFuncReqBO.setSysCode("UOC");
            dycBusiProcessStartFuncReqBO.setPartitonKey(dycUocOrderSaleCreateFuncRspBO.getOrderId());
            this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        }
    }

    private void startWholeOrderBusiProcess(DycUocCreateOrderReqBO reqBO, DycUocOrderSaleCreateFuncRspBO dycUocOrderSaleCreateFuncRspBO) {
        Map<Long, DycUocQryAuditConfListBo> auditConfMap = this.getAuditConf();
        if (CollectionUtils.isEmpty(auditConfMap)) {
            return;
        }
        DycUocQryAuditConfListBo dycUocQryAuditConfListBo = auditConfMap.get(reqBO.getOrgId());
        if (null == dycUocQryAuditConfListBo) {
            dycUocQryAuditConfListBo = auditConfMap.get(ZORE);
        }
        if (null == dycUocQryAuditConfListBo) {
            return;
        }
        if (UocConstant.CONF_AUDIT_FLAG.NO.equals(dycUocQryAuditConfListBo.getAuditFlag())) {
            return;
        }
        if (UocConstant.CONF_AUDIT_TYPE.WHOLE.equals(dycUocQryAuditConfListBo.getAuditType())) {
            this.orderCreateNeedAudit = "1";
            this.autidStartflag = "0";
            this.autidCompleteflag = "0";
            DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
            dycBusiProcessStartFuncReqBO.setProcDefKey("whole_order_busi_flow");
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("autidStartflag", "1");
            variables.put("autidCompleteflag", "1");
            variables.put("orderId", dycUocOrderSaleCreateFuncRspBO.getOrderId());
            dycBusiProcessStartFuncReqBO.setVariables(variables);
            dycBusiProcessStartFuncReqBO.setSysCode("UOC");
            dycBusiProcessStartFuncReqBO.setPartitonKey(dycUocOrderSaleCreateFuncRspBO.getOrderId());
            this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
        }
    }

    private Map<Long, DycUocQryAuditConfListBo> getAuditConf() {
        DycUocQryAuditConfListFuncReqBo dycUocQryAuditConfListFuncReqBo = new DycUocQryAuditConfListFuncReqBo();
        dycUocQryAuditConfListFuncReqBo.setConfCode("order_approve_code");
        DycUocQryAuditConfListFuncRspBo dycUocQryAuditConfListFuncRspBo = this.dycUocQryAuditConfListFunction.qryAuditConfList(dycUocQryAuditConfListFuncReqBo);
        if (CollectionUtils.isEmpty((Collection)dycUocQryAuditConfListFuncRspBo.getRows())) {
            return new HashMap<Long, DycUocQryAuditConfListBo>();
        }
        return dycUocQryAuditConfListFuncRspBo.getRows().stream().collect(Collectors.toMap(DycUocQryAuditConfListBo::getOrgId, o -> o));
    }

    private void doDealShopCartGoodsDelete(Long userId, List<Long> spIds) {
        DycUocShopCartGoodsDeleteFuncReqBO dycUocShopCartGoodsDeleteFuncReqBO = new DycUocShopCartGoodsDeleteFuncReqBO();
        dycUocShopCartGoodsDeleteFuncReqBO.setUserId(userId);
        dycUocShopCartGoodsDeleteFuncReqBO.setSpIds(spIds);
        DycUocShopCartGoodsDeleteFuncRspBO dycUocShopCartGoodsDeleteFuncRspBO = this.dycUocShopCartGoodsDeleteFunction.dealShopCartGoodsDelete(dycUocShopCartGoodsDeleteFuncReqBO);
    }
}

