/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.busicommon.bo.GeminiReceiverBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.api.DycGeneralBusiRuleExecFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralBusiRuleExecFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralBusiRuleExecFuncRspBO;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocDeductSkuNumFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocProfessionalDetailQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocSupplierInfoQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocAgreementFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoQryFuncRspBO;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.mall.order.api.DycUocCreateOrderService;
import com.tydic.dyc.mall.order.bo.DycUocCommodityBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderContextBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqArgPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqCommodityBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqInvoiceBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqProfessionalBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.dyc.umc.service.shoppingcart.UmcRemoveShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartRspBo;
import com.tydic.dyc.umc.service.user.UmcMemDetailQueryService;
import com.tydic.dyc.umc.service.user.bo.UmcMemDetailQueryReqBO;
import com.tydic.dyc.umc.service.user.bo.UmcMemDetailQueryRspBO;
import com.tydic.ppc.ability.api.PpcOrderFeedbackAbilityService;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityRspBO;
import com.tydic.ppc.ability.bo.PpcpurchasePlanSscBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocCreateOrderService"})
public class DycUocCreateOrderServiceImpl
implements DycUocCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCreateOrderServiceImpl.class);
    private static final String YES = "01";
    @Autowired
    private UmcRemoveShoppingCartService umcRemoveShoppingCartService;
    @Autowired
    private PpcOrderFeedbackAbilityService ppcOrderFeedbackAbilityService;
    @Autowired
    private UmcMemDetailQueryService umcMemDetailQueryAbilityService;
    @Autowired
    private DycUocCommodityBatchQryFunction dycUocCommodityBatchQryFunction;
    @Autowired
    private DycUocSupplierInfoQryFunction dycUocSupplierInfoQryFunction;
    @Autowired
    private DycUocProfessionalDetailQryFunction dycUocProfessionalDetailQryFunction;
    @Autowired
    private UocCreateOrderService uocCreateOrderService;
    @Autowired
    private DycUocDeductSkuNumFunction dycUocDeductSkuNumFunction;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private DycGeneralBusiRuleExecFunction dycGeneralBusiRuleExecFunction;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;

    @Override
    @PostMapping(value={"createOrder"})
    public DycUocCreateOrderRspBO createOrder(@RequestBody DycUocCreateOrderReqBO reqBO) {
        this.verifyParam(reqBO);
        DycUocCreateOrderContextBO contextBO = (DycUocCreateOrderContextBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocCreateOrderContextBO.class));
        this.batchQuerySkuAndAgreementInfo(contextBO);
        this.queryProfessionalInfo(contextBO);
        this.querySupplierInfo(contextBO);
        this.minusInventory(contextBO);
        this.createSaleOrder(contextBO);
        this.startSaleOrderProcess(contextBO);
        this.minusPlan(contextBO);
        this.deleteShopCartGoods(contextBO);
        this.buryPoint(contextBO);
        DycUocCreateOrderRspBO rspBO = new DycUocCreateOrderRspBO();
        rspBO.setOrderId(String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
        return rspBO;
    }

    private void minusInventory(DycUocCreateOrderContextBO contextBO) {
        DycUocDeductSkuNumFuncReqBO dycUocDeductSkuNumFuncReqBO = new DycUocDeductSkuNumFuncReqBO();
        List skuDetailBos = contextBO.getCommodityBos().stream().map(bo -> {
            DycUocDeductSkuNumFuncBO dycUocDeductSkuNumFuncBO = new DycUocDeductSkuNumFuncBO();
            BeanUtils.copyProperties((Object)bo, (Object)dycUocDeductSkuNumFuncBO);
            return dycUocDeductSkuNumFuncBO;
        }).collect(Collectors.toList());
        dycUocDeductSkuNumFuncReqBO.setSkuDetailBos(skuDetailBos);
        dycUocDeductSkuNumFuncReqBO.setOperType("0");
        DycUocDeductSkuNumFuncRspBO dycUocDeductSkuNumFuncRspBO = this.dycUocDeductSkuNumFunction.dealDeductSkuNum(dycUocDeductSkuNumFuncReqBO);
        if (!"0000".equals(dycUocDeductSkuNumFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff1a" + dycUocDeductSkuNumFuncRspBO.getRespDesc());
        }
    }

    private void querySupplierInfo(DycUocCreateOrderContextBO contextBO) {
        DycUocSupplierInfoQryFuncReqBO dycUocSupplierInfoQryFuncReqBO = new DycUocSupplierInfoQryFuncReqBO();
        dycUocSupplierInfoQryFuncReqBO.setSupplierIds(contextBO.getCommodityBos().stream().map(DycUocCommodityBO::getSupplierId).distinct().collect(Collectors.toList()));
        dycUocSupplierInfoQryFuncReqBO.setOperationOrgId(Long.valueOf(contextBO.getProfessionalDetailBO().getProId()));
        dycUocSupplierInfoQryFuncReqBO.setPurchaseOrgId(contextBO.getCompanyId());
        dycUocSupplierInfoQryFuncReqBO.setUserId(contextBO.getUserId());
        dycUocSupplierInfoQryFuncReqBO.setUserTypeIn(contextBO.getUserTypeIn());
        DycUocSupplierInfoQryFuncRspBO dycUocSupplierInfoQryFuncRspBO = this.dycUocSupplierInfoQryFunction.qrySupplierInfo(dycUocSupplierInfoQryFuncReqBO);
        if (!"0000".equals(dycUocSupplierInfoQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u8865\u5168\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocSupplierInfoQryFuncRspBO.getRespDesc());
        }
        contextBO.setSupplierBos(dycUocSupplierInfoQryFuncRspBO.getSupplierBos());
    }

    private void queryProfessionalInfo(DycUocCreateOrderContextBO contextBO) {
        DycUocProfessionalDetailQryFuncReqBO dycUocProfessionalDetailQryFuncReqBO = new DycUocProfessionalDetailQryFuncReqBO();
        dycUocProfessionalDetailQryFuncReqBO.setPurAccountId(contextBO.getPurAccountId());
        DycUocProfessionalDetailQryFuncRspBO dycUocProfessionalDetailQryFuncRspBO = this.dycUocProfessionalDetailQryFunction.qryProfessionalDetail(dycUocProfessionalDetailQryFuncReqBO);
        if (!"0000".equals(dycUocProfessionalDetailQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocProfessionalDetailQryFuncRspBO.getRespDesc());
        }
        contextBO.setProfessionalDetailBO(dycUocProfessionalDetailQryFuncRspBO.getProfessionalDetailBO());
    }

    private void batchQuerySkuAndAgreementInfo(DycUocCreateOrderContextBO contextBO) {
        DycUocCommodityBatchQryFuncReqBO dycUocCommodityBatchQryFuncReqBO = new DycUocCommodityBatchQryFuncReqBO();
        BeanUtils.copyProperties((Object)((Object)contextBO), (Object)dycUocCommodityBatchQryFuncReqBO);
        dycUocCommodityBatchQryFuncReqBO.setProvince(Long.valueOf(contextBO.getAddressBo().getContactProvinceId()));
        dycUocCommodityBatchQryFuncReqBO.setCity(Long.valueOf(contextBO.getAddressBo().getContactCityId()));
        dycUocCommodityBatchQryFuncReqBO.setCounty(Long.valueOf(contextBO.getAddressBo().getContactCountyId()));
        if (!StringUtils.isEmpty((Object)contextBO.getAddressBo().getContactTownId())) {
            dycUocCommodityBatchQryFuncReqBO.setTown(Long.valueOf(contextBO.getAddressBo().getContactTownId()));
        }
        List skuOrderList = JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(DycUocCommodityBatchQryFuncBO.class);
        dycUocCommodityBatchQryFuncReqBO.setSkuOrderList(skuOrderList);
        DycUocCommodityBatchQryFuncRspBO dycUocCommodityBatchQryFuncRspBO = this.dycUocCommodityBatchQryFunction.qryCommodityByBatch(dycUocCommodityBatchQryFuncReqBO);
        if (!"0000".equals(dycUocCommodityBatchQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocCommodityBatchQryFuncRspBO.getRespDesc());
        }
        contextBO.setCommodityInfos(dycUocCommodityBatchQryFuncRspBO.getCommodityInfos());
        contextBO.setAgreementInfos(dycUocCommodityBatchQryFuncRspBO.getAgreementInfos());
    }

    private void createSaleOrder(DycUocCreateOrderContextBO contextBO) {
        UocCreateOrderServiceReqBo uocCreateOrderServiceReqBo = new UocCreateOrderServiceReqBo();
        uocCreateOrderServiceReqBo.setExtFields(contextBO.getExtFields());
        uocCreateOrderServiceReqBo.setTraceId(contextBO.getTraceId());
        uocCreateOrderServiceReqBo.setUserId(contextBO.getUserId());
        uocCreateOrderServiceReqBo.setName(contextBO.getName());
        uocCreateOrderServiceReqBo.setUserName(contextBO.getUserName());
        uocCreateOrderServiceReqBo.setOrgId(contextBO.getOrgId());
        uocCreateOrderServiceReqBo.setOrgName(contextBO.getOrgName());
        uocCreateOrderServiceReqBo.setOrgPath(contextBO.getOrgPath());
        uocCreateOrderServiceReqBo.setCompanyId(contextBO.getCompanyId());
        uocCreateOrderServiceReqBo.setCompanyName(contextBO.getCompanyName());
        uocCreateOrderServiceReqBo.setUserType(contextBO.getUserTypeIn());
        uocCreateOrderServiceReqBo.setTotalSaleFee(contextBO.getTotalSaleFee());
        uocCreateOrderServiceReqBo.setTotalPurchaseFee(contextBO.getCommodityInfos().stream().map(bo -> bo.getPurchasePrice().multiply(bo.getPurchaseCount())).reduce(BigDecimal.ZERO, BigDecimal::add));
        uocCreateOrderServiceReqBo.setTotalTransFee(contextBO.getTotalTransFee());
        uocCreateOrderServiceReqBo.setRemark(contextBO.getRemark());
        uocCreateOrderServiceReqBo.setPurAccount(String.valueOf(contextBO.getPurAccountId()));
        uocCreateOrderServiceReqBo.setPurAccountName(contextBO.getPurAccountName());
        uocCreateOrderServiceReqBo.setPurContactName(contextBO.getPurPlaceOrderName());
        uocCreateOrderServiceReqBo.setPurMobile(contextBO.getPurMobile());
        uocCreateOrderServiceReqBo.setPurNeedName(contextBO.getPurNeedName());
        uocCreateOrderServiceReqBo.setPurNeedMobile(contextBO.getPurNeedMobile());
        uocCreateOrderServiceReqBo.setSendTime(contextBO.getSendTime());
        uocCreateOrderServiceReqBo.setOrderItems(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityInfos())).toJavaList(UocCreateOrderServiceReqCommodityBo.class));
        this.setItemExtFields(contextBO, uocCreateOrderServiceReqBo);
        uocCreateOrderServiceReqBo.setUocOrdInvoice((UocCreateOrderServiceReqInvoiceBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getInvoiceBo()), UocCreateOrderServiceReqInvoiceBo.class));
        uocCreateOrderServiceReqBo.setOperating((UocCreateOrderServiceReqProfessionalBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getProfessionalDetailBO()), UocCreateOrderServiceReqProfessionalBo.class));
        uocCreateOrderServiceReqBo.setSupplierBos(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getSupplierBos())).toJavaList(UocSupplierInfoBo.class));
        if (!CollectionUtils.isEmpty(contextBO.getAgreementInfos())) {
            uocCreateOrderServiceReqBo.setAgrPayConfigList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getAgreementInfos())).toJavaList(UocCreateOrderServiceReqArgPayConfSupBo.class));
        }
        uocCreateOrderServiceReqBo.setReceiverAddress((UocCreateOrderServiceReqAddressBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getAddressBo()), UocCreateOrderServiceReqAddressBo.class));
        uocCreateOrderServiceReqBo.setInvoiceAddress((UocCreateOrderServiceReqAddressBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getInvoiceAddressBo()), UocCreateOrderServiceReqAddressBo.class));
        uocCreateOrderServiceReqBo.setAccessoryList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getAttachBos())).toJavaList(UocCreateOrderServiceReqAccessoryBo.class));
        log.debug("contextBO.getCommodityBos()" + JSON.toJSONString(contextBO.getCommodityBos()));
        log.debug("contextBO.getCommodityInfos()" + JSON.toJSONString(contextBO.getCommodityInfos()));
        log.debug("uocCreateOrderServiceReqBo.getOrderItems()" + JSON.toJSONString((Object)uocCreateOrderServiceReqBo.getOrderItems()));
        UocCreateOrderServiceRspBo uocCreateOrderServiceRspBo = this.uocCreateOrderService.createOrder(uocCreateOrderServiceReqBo);
        if (!"0000".equals(uocCreateOrderServiceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u9500\u552e\u5355\u5931\u8d25\uff1a" + uocCreateOrderServiceRspBo.getRespDesc());
        }
        contextBO.setCreateOrderResult(uocCreateOrderServiceRspBo);
    }

    private void setItemExtFields(DycUocCreateOrderContextBO contextBO, UocCreateOrderServiceReqBo uocCreateOrderServiceReqBo) {
        Map<Long, List<DycUocCommodityBO>> contextMap = contextBO.getCommodityBos().stream().collect(Collectors.groupingBy(DycUocCommodityBO::getSkuId));
        List orderItems = uocCreateOrderServiceReqBo.getOrderItems();
        if (ObjectUtil.isNotEmpty(contextMap) && ObjectUtil.isNotEmpty((Object)orderItems)) {
            for (UocCreateOrderServiceReqCommodityBo orderItem : orderItems) {
                List<DycUocCommodityBO> dycUocCommodityBOS = contextMap.get(Long.parseLong(orderItem.getSkuId()));
                if (!ObjectUtil.isNotEmpty(dycUocCommodityBOS)) continue;
                orderItem.setExtFields(dycUocCommodityBOS.get(0).getExtFields());
            }
        }
    }

    private void verifyParam(DycUocCreateOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getCommodityBos().forEach(obj -> {
            if (obj.getPurchaseCount().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            }
        });
    }

    private void minusPlan(DycUocCreateOrderContextBO contextBO) {
        Map<String, List<DycUocCommodityBO>> commodityMap = contextBO.getCommodityBos().stream().filter(obj -> !StringUtils.isEmpty((Object)obj.getPlanId())).collect(Collectors.groupingBy(obj -> obj.getSkuId() + "_" + obj.getPlanId()));
        ArrayList<PpcpurchasePlanSscBO> purchasePlanSscBOS = new ArrayList<PpcpurchasePlanSscBO>();
        for (UocCreateOrderServiceRspSaleOrderBo saleOrderInfo : contextBO.getCreateOrderResult().getSaleOrderList()) {
            for (UocCreateOrderServiceRspSaleOrderItemBo saleOrderItemInfo : saleOrderInfo.getItemBoList()) {
                if (StringUtils.isEmpty((Object)saleOrderItemInfo.getPlanId())) continue;
                String key = saleOrderItemInfo.getSkuId() + "_" + saleOrderItemInfo.getPlanId();
                List<DycUocCommodityBO> dycUocCommodityBOS = commodityMap.get(key);
                DycUocCommodityBO dycUocCommodityBO = dycUocCommodityBOS.get(0);
                PpcpurchasePlanSscBO ppcpurchasePlanSscBO = new PpcpurchasePlanSscBO();
                ppcpurchasePlanSscBO.setOrderId(saleOrderInfo.getSaleOrderId());
                ppcpurchasePlanSscBO.setOrderCode(saleOrderInfo.getSaleOrderNo());
                ppcpurchasePlanSscBO.setPurchasePlanItemId(Long.valueOf(saleOrderItemInfo.getPlanItemId()));
                ppcpurchasePlanSscBO.setPurchasePlanId(Long.valueOf(saleOrderItemInfo.getPlanId()));
                ppcpurchasePlanSscBO.setPurchaserNumber(dycUocCommodityBO.getPurchaseCount());
                ppcpurchasePlanSscBO.setAllPrice(dycUocCommodityBO.getPurchaseCount().multiply(dycUocCommodityBO.getSalePrice()));
                purchasePlanSscBOS.add(ppcpurchasePlanSscBO);
            }
        }
        if (CollectionUtils.isEmpty(purchasePlanSscBOS)) {
            PpcOrderFeedbackAbilityReqBO ppcOrderFeedbackAbilityReqBO = new PpcOrderFeedbackAbilityReqBO();
            ppcOrderFeedbackAbilityReqBO.setPurchasePlanSscBOS(purchasePlanSscBOS);
            PpcOrderFeedbackAbilityRspBO ppcOrderFeedbackAbilityRspBO = this.ppcOrderFeedbackAbilityService.orderFeedback(ppcOrderFeedbackAbilityReqBO);
            if (!"0000".equals(ppcOrderFeedbackAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8ba1\u5212\u6263\u51cf\u5931\u8d25\uff1a" + ppcOrderFeedbackAbilityRspBO.getRespDesc());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startSaleOrderProcess(DycUocCreateOrderContextBO contextBO) {
        Map<String, DycUocAgreementFuncBO> agreementInfosMap = null;
        if (!CollectionUtils.isEmpty(contextBO.getAgreementInfos())) {
            agreementInfosMap = contextBO.getAgreementInfos().stream().collect(Collectors.toMap(DycUocAgreementFuncBO::getAgrId, item -> item));
        }
        for (UocCreateOrderServiceRspSaleOrderBo saleOrderInfo : contextBO.getCreateOrderResult().getSaleOrderList()) {
            DycGeneralBusiRuleExecFuncReqBO dycGeneralBusiRuleExecFuncReqBO = new DycGeneralBusiRuleExecFuncReqBO();
            dycGeneralBusiRuleExecFuncReqBO.setServiceCode("B0001");
            dycGeneralBusiRuleExecFuncReqBO.setParamJsonStr(JSON.toJSONString((Object)saleOrderInfo));
            DycGeneralBusiRuleExecFuncRspBO dycGeneralBusiRuleExecFuncRspBO = this.dycGeneralBusiRuleExecFunction.generalBusiRuleExec(dycGeneralBusiRuleExecFuncReqBO);
            if (!"0000".equals(dycGeneralBusiRuleExecFuncRspBO.getRespCode())) throw new ZTBusinessException("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\u5931\u8d25\uff1a" + dycGeneralBusiRuleExecFuncRspBO.getRespDesc());
            if (StringUtils.isEmpty((Object)dycGeneralBusiRuleExecFuncRspBO.getBusiRuleExecResult())) throw new ZTBusinessException("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\uff0c\u8fd4\u56de\u8fd0\u7b97\u7ed3\u679c\u4e3a\u7a7a");
            JSONObject callRuleRspJsonObj = JSON.parseObject((String)dycGeneralBusiRuleExecFuncRspBO.getBusiRuleExecResult());
            String createOrderProcessKey = callRuleRspJsonObj.getString("processKey");
            if (StringUtils.isEmpty((Object)createOrderProcessKey)) throw new ZTBusinessException("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\uff0c\u672a\u83b7\u53d6\u5230\u9700\u8981\u542f\u52a8\u7684\u6d41\u7a0bkey");
            DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
            dycBusiProcessStartFuncReqBO.setProcDefKey(createOrderProcessKey);
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("orderId", String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
            variables.put("saleOrderNo", saleOrderInfo.getSaleOrderNo());
            variables.put("saleOrderId", saleOrderInfo.getSaleOrderId());
            variables.put("auditObjId", saleOrderInfo.getSaleOrderId());
            variables.put("objId", saleOrderInfo.getSaleOrderId());
            variables.put("orgId", contextBO.getOrgId());
            variables.put("orgName", contextBO.getOrgName());
            variables.put("userId", contextBO.getUserId());
            variables.put("createOperId", contextBO.getUserId());
            variables.put("userName", contextBO.getName());
            variables.put("modelSettle", saleOrderInfo.getModelSettle());
            variables.put("supId", saleOrderInfo.getSupId());
            variables.put("proId", saleOrderInfo.getProId());
            variables.put("shipStartflag", 0);
            variables.put("shipCompleteflag", 0);
            variables.put("subOrderStartflag", 0);
            variables.put("subOrderCompleteflag", 0);
            variables.put("orderSale", contextBO.getTotalSaleFee());
            variables.put("autidStartflag", "1");
            variables.put("autidCompleteflag", "1");
            variables.put("adjustPriceAutidStartflag", "1");
            variables.put("adjustPriceAutidCompleteflag", "1");
            variables.put("orderCreateNeedAudit", "1");
            variables.put("todoOrderNo", saleOrderInfo.getSaleOrderNo());
            if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(saleOrderInfo.getPayType())) {
                variables.put("dayPag", "1");
            } else {
                variables.put("prePay", "1");
            }
            variables.put("auditResult", "1");
            variables.put("auditOrderStatus", "1");
            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderInfo.getOrderSource())) {
                DycUocAgreementFuncBO agreementFuncBO = agreementInfosMap.get(saleOrderInfo.getAgrId());
                UmcMemDetailQueryReqBO umcMemDetailQueryReqBO = new UmcMemDetailQueryReqBO();
                umcMemDetailQueryReqBO.setMemId(Long.valueOf(agreementFuncBO.getProDeliveryId()));
                UmcMemDetailQueryRspBO umcMemDetailQueryRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryReqBO);
                if ("0000".equals(umcMemDetailQueryRspBO.getRespCode()) && umcMemDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO() != null && umcMemDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO().getStopStatus().equals(YES)) {
                    variables.put("proDeliveryFlag", "1");
                } else {
                    variables.put("proDeliveryFlag", "0");
                }
                if (UocDicConstant.ADJUST_PRICE.IN_THE_THING.equals(agreementFuncBO.getAdjustPrice())) {
                    variables.put("adjustPrice", "1");
                } else {
                    variables.put("adjustPrice", "0");
                }
            }
            dycBusiProcessStartFuncReqBO.setVariables(variables);
            dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
            dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
            DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
            if (!"0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) {
                throw new ZTBusinessException("\u9500\u552e\u5355\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
            }
            try {
                this.sendMessage(contextBO, saleOrderInfo);
            }
            catch (Exception e) {
                log.error("\u9500\u552e\u5355" + saleOrderInfo.getSaleOrderNo() + "\u8ba2\u5355\u63d0\u4ea4\u53d1\u9001\u901a\u77e5\u5931\u8d25!");
            }
        }
    }

    private void sendMessage(DycUocCreateOrderContextBO contextBO, UocCreateOrderServiceRspSaleOrderBo saleOrderInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskCode", "create_order");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("saleOrderNo", saleOrderInfo.getSaleOrderNo());
        map.put("data", dataMap);
        map.put("sendId", contextBO.getUserId() + "");
        map.put("sendName", contextBO.getName());
        ArrayList receiverBOList = new ArrayList();
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        authGetUserByRoleAndOrgReqBo.setOrgIdWeb(contextBO.getOrgId());
        authGetUserByRoleAndOrgReqBo.setRoleCodes(Arrays.asList("tenant:10000:caigoudanweikuguanyuan"));
        authGetUserByRoleAndOrgReqBo.setPageNo(-1);
        authGetUserByRoleAndOrgReqBo.setPageSize(-1);
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        List rows = userByRoleAndOrg.getRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            rows.forEach(v -> {
                GeminiReceiverBO geminiReceiverBO = new GeminiReceiverBO();
                geminiReceiverBO.setReceiverId(String.valueOf(v.getUserId()));
                geminiReceiverBO.setReceiverName(v.getLoginName());
                receiverBOList.add(geminiReceiverBO);
            });
        }
        map.put("receiverIdList", JSON.toJSONString(receiverBOList));
        this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
    }

    private void deleteShopCartGoods(DycUocCreateOrderContextBO contextBO) {
        UmcRemoveShoppingCartReqBo umcRemoveShoppingCartReqBo = new UmcRemoveShoppingCartReqBo();
        umcRemoveShoppingCartReqBo.setUserId(contextBO.getUserId());
        umcRemoveShoppingCartReqBo.setGoodsInfoList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(UmcAddShoppingCartBo.class));
        UmcRemoveShoppingCartRspBo umcRemoveShoppingCartRspBo = this.umcRemoveShoppingCartService.removeShoppingCart(umcRemoveShoppingCartReqBo);
        if (!"0000".equals(umcRemoveShoppingCartRspBo.getRespCode())) {
            throw new ZTBusinessException("\u6e05\u9664\u8d2d\u7269\u8f66\u4e2d\u672c\u6b21\u5df2\u4e0b\u5355\u7684\u5546\u54c1\u5931\u8d25\uff1a" + umcRemoveShoppingCartRspBo.getRespDesc());
        }
    }

    private void buryPoint(DycUocCreateOrderContextBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        List saleOrderBoList = contextBO.getCreateOrderResult().getSaleOrderList();
        Long orderId = contextBO.getCreateOrderResult().getOrderId();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (Object each : saleOrderBoList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("saleOrderId", (Object)each.getSaleOrderId());
            jsonObject.put("orderId", (Object)orderId);
            list.add(jsonObject);
        }
        ArrayList<DycBuriedPointCallFuncBo> buildList = new ArrayList<DycBuriedPointCallFuncBo>();
        for (JSONObject j : list) {
            DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
            bo.setData((Object)j);
            bo.setIdent("ADD");
            bo.setDycCenterCode("UOC");
            bo.setDycBusiCode("saleOrderSync");
            bo.setDesc("\u65b0\u589e\u9500\u552e\u5355");
            buildList.add(bo);
        }
        funcReqBo.setBusiList(buildList);
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u8ba2\u5355\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }
}

