/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.mall.order.api.DycUocCheckBargainingRulesService;
import com.tydic.dyc.mall.order.bo.DycUocCheckBargainingRulesReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCheckBargainingRulesRspBO;
import com.tydic.dyc.mall.order.bo.DycUocShoppingCartSkuCheckBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocCheckBargainingRulesService"})
public class DycUocCheckBargainingRulesServiceImpl
implements DycUocCheckBargainingRulesService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCheckBargainingRulesServiceImpl.class);
    @Value(value="${uoc.bargaining.enable:false}")
    private boolean isBargainingSku;
    @Value(value="${uoc.bargaining.check.brand.totalprice:200000}")
    private BigDecimal brandTotalPrice;
    @Value(value="${uoc.bargaining.check.max.salenum:1000}")
    private BigDecimal maxSaleNum;
    @Value(value="${uoc.bargaining.check.min.salenum:500}")
    private BigDecimal minSaleNum;
    @Value(value="${uoc.bargaining.check.price:150}")
    private BigDecimal salePrice;
    public static final Integer SOURCE_ECOM = 2;

    @Override
    @PostMapping(value={"checkBargainingRules"})
    public DycUocCheckBargainingRulesRspBO checkBargainingRules(@RequestBody DycUocCheckBargainingRulesReqBO dycUocCheckBargainingRulesReqBO) {
        DycUocCheckBargainingRulesRspBO rspBo = new DycUocCheckBargainingRulesRspBO();
        if (this.isBargainingSku) {
            this.verifyParam(dycUocCheckBargainingRulesReqBO);
            List<DycUocShoppingCartSkuCheckBO> shoppingCartSkuList = dycUocCheckBargainingRulesReqBO.getShoppingCartSkuList();
            Map<Long, List<DycUocShoppingCartSkuCheckBO>> shopMap = shoppingCartSkuList.stream().collect(Collectors.groupingBy(DycUocShoppingCartSkuCheckBO::getBrandId));
            log.debug("\u6821\u9a8c\uff1a\u6807\u51c6 \u3010\u5355\u54c1\u724c\u91c7\u8d2d\u91d1\u989d\uff1a" + this.brandTotalPrice + ",\u91c7\u8d2d\u603b\u91cf\uff1a" + this.minSaleNum + "--" + this.maxSaleNum + ",\u5546\u54c1\u5355\u4ef7\uff1a" + this.salePrice + "\u3011");
            ArrayList<DycUocShoppingCartSkuCheckBO> bargainingSkuList = new ArrayList<DycUocShoppingCartSkuCheckBO>();
            for (DycUocShoppingCartSkuCheckBO dycUocShoppingCartSkuCheckBO : shoppingCartSkuList) {
                if (!SOURCE_ECOM.equals(dycUocShoppingCartSkuCheckBO.getSkuSource())) continue;
                List<DycUocShoppingCartSkuCheckBO> skuCheckBrandBOS = shopMap.get(dycUocShoppingCartSkuCheckBO.getBrandId());
                BigDecimal totalPriceSub = new BigDecimal(0);
                for (DycUocShoppingCartSkuCheckBO skuCheckBO : skuCheckBrandBOS) {
                    if (skuCheckBO.getPriceSub().compareTo(BigDecimal.ZERO) == 0) continue;
                    totalPriceSub = totalPriceSub.add(skuCheckBO.getPriceSub());
                }
                BigDecimal saleNum = dycUocShoppingCartSkuCheckBO.getSaleNum();
                BigDecimal price = dycUocShoppingCartSkuCheckBO.getPrice();
                log.debug("\u6821\u9a8c\uff1a\u5355\u54c1\u724c\u91c7\u8d2d\u603b\u91d1\u989d\uff1a" + totalPriceSub + ",\u6570\u91cf\uff1a" + saleNum + ",\u4ef7\u683c\uff1a" + price);
                if (totalPriceSub.compareTo(this.brandTotalPrice) < 0 && saleNum.compareTo(this.maxSaleNum) < 0 && (saleNum.compareTo(this.maxSaleNum) >= 0 || saleNum.compareTo(this.minSaleNum) < 0 || price.compareTo(this.salePrice) < 0)) continue;
                bargainingSkuList.add(dycUocShoppingCartSkuCheckBO);
            }
            rspBo.setShoppingCartSkuList(bargainingSkuList);
        }
        return rspBo;
    }

    private void verifyParam(DycUocCheckBargainingRulesReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtil.isNotEmpty(reqBO.getShoppingCartSkuList())) {
            throw new ZTBusinessException("\u5546\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getShoppingCartSkuList().forEach(obj -> {
            if (ObjectUtil.isEmpty((Object)obj.getSkuId())) {
                throw new ZTBusinessException("\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getBrandId())) {
                throw new ZTBusinessException("\u5546\u54c1\u54c1\u724cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)obj.getSupplierId())) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (obj.getSaleNum().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            }
            if (obj.getPrice().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a0");
            }
            if (obj.getPriceSub().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u5546\u54c1\u5c0f\u8ba1\u4e0d\u80fd\u4e3a0");
            }
        });
    }
}

