/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.mall.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.venus.extension.Extension;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocGemiSendMessageAtomFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import com.tydic.dyc.atom.busicommon.bo.GeminiReceiverBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.api.DycGeneralBusiRuleExecFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralBusiRuleExecFuncReqBO;
import com.tydic.dyc.atom.estore.api.DycUocJdAddressQryFunction;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionRspBO;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocDeductSkuNumFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocInvokPriceFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocProfessionalDetailQryFunction;
import com.tydic.dyc.atom.selfrun.api.DycUocSupplierInfoQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocAgreementFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocProfessionalDetailQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocSupplierInfoQryFuncRspBO;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.conf.SaasUocBaseProperties;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.mall.order.api.DycUocCreateOrderService;
import com.tydic.dyc.mall.order.api.DycUocUpdateBargainingOrderedService;
import com.tydic.dyc.mall.order.bo.DycUocCommodityBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderContextBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderReqApproveBo;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderReqBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateOrderRspBO;
import com.tydic.dyc.mall.order.bo.DycUocCreateSaleOrderBO;
import com.tydic.dyc.mall.order.bo.DycUocUpdateBargainingOrderedReqBO;
import com.tydic.dyc.mall.order.bo.DycUocUpdateBargainingOrderedRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqArgPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqCommodityBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqInvoiceBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqProfessionalBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderPlanBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderStateService;
import com.tydic.dyc.saas.uoc.api.DycUocCreateOrderApproveExtPt;
import com.tydic.dyc.saas.uoc.bo.DycUocCreateOrderApproveExtPtReqBo;
import com.tydic.dyc.saas.uoc.bo.DycUocCreateOrderApproveExtPtRspBo;
import com.tydic.dyc.umc.service.shoppingcart.UmcRemoveShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcRemoveShoppingCartRspBo;
import com.tydic.dyc.umc.service.user.UmcMemDetailQueryService;
import com.tydic.dyc.umc.service.user.bo.UmcMemDetailQueryReqBO;
import com.tydic.dyc.umc.service.user.bo.UmcMemDetailQueryRspBO;
import com.tydic.ppc.ability.api.PpcOrderFeedbackAbilityService;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityReqBO;
import com.tydic.ppc.ability.bo.PpcOrderFeedbackAbilityRspBO;
import com.tydic.ppc.ability.bo.PpcpurchasePlanSscBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.mall.order.api.DycUocCreateOrderService"})
public class DycUocCreateOrderServiceImpl
implements DycUocCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocCreateOrderServiceImpl.class);
    private static final String YES = "01";
    private static final String ORDER_CALL_PLAN_SYSTEM = "DYC";
    private static final String ORDER_INVOKE_PRICE_SYSTEM = "DYC";
    @Autowired
    private UmcRemoveShoppingCartService umcRemoveShoppingCartService;
    @Autowired
    private PpcOrderFeedbackAbilityService ppcOrderFeedbackAbilityService;
    @Autowired
    private UmcMemDetailQueryService umcMemDetailQueryAbilityService;
    @Autowired
    private DycUocCommodityBatchQryFunction dycUocCommodityBatchQryFunction;
    @Autowired
    private DycUocSupplierInfoQryFunction dycUocSupplierInfoQryFunction;
    @Autowired
    private DycUocProfessionalDetailQryFunction dycUocProfessionalDetailQryFunction;
    @Autowired
    private UocCreateOrderService uocCreateOrderService;
    @Autowired
    private DycUocDeductSkuNumFunction dycUocDeductSkuNumFunction;
    @Autowired
    private DycBusiProcessStartFunction dycBusiProcessStartFunction;
    @Autowired
    private DycGeneralBusiRuleExecFunction dycGeneralBusiRuleExecFunction;
    @Autowired
    private DycUocGemiSendMessageAtomFunction dycUocGemiSendMessageAtomFunction;
    @Autowired
    private AuthGetUserByRoleAndOrgService authGetUserByRoleAndOrgService;
    @Autowired
    private DycBuriedPointCallFunction dycBuriedPointCallFunction;
    @Autowired
    private DycUocJdAddressQryFunction dycUocJdAddressQryFunction;
    @Value(value="${process.sysCode:DYC}")
    private String SYS_CODE;
    @Value(value="${uoc.buriedpoint.enable:false}")
    private boolean buryPointEnable;
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String buriedpointUrl;
    @Autowired
    private DycUocInvokPriceFunction dycUocInvokPriceFunction;
    @Resource(name="uocSyncPriceProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${uoc.sale.price.sync.tag:2}")
    private String priceSyncTag;
    @Value(value="${uoc.price.sync.topic:UOC_SYNC_PRICE_TOPIC}")
    private String priceSyncTopic;
    @Value(value="${uoc.price.sync.enable:true}")
    private boolean priceSyncEnable;
    @Value(value="${uoc.audit.price:10000}")
    private String uocAuditPrice;
    @Value(value="${uoc.audit.flag:true}")
    private boolean uocAuditFlag;
    @Value(value="${uoc.changePurchasePriceWithModelSettle:true}")
    private boolean changePurchasePriceWithModelSettle;
    @Value(value="${dyc.system.name:DYC}")
    private String systemName;
    @Value(value="${agrSaleOrderProcessKey:JH_AGREEMENT_ORDER_BUSI_FLOW}")
    private String agrSaleOrderProcessKey;
    @Value(value="${estoreSaleOrderProcessKey:JH_AGREEMENT_ORDER_BUSI_FLOW}")
    private String esSaleOrderProcessKey;
    @Autowired
    private UocUpdateSaleOrderStateService uocUpdateSaleOrderStateService;
    @Autowired
    private DycUocUpdateBargainingOrderedService dycUocUpdateBargainingOrderedService;
    @Value(value="${saas.uoc.minusInventoryReturnFail:true}")
    private boolean minusInventoryReturnFail;
    @Extension
    @Autowired
    private DycUocCreateOrderApproveExtPt dycUocCreateOrderApproveExtPt;
    @Autowired
    private SaasUocBaseProperties saasUocBaseProperties;

    @Override
    @PostMapping(value={"createOrder"})
    public DycUocCreateOrderRspBO createOrder(@RequestBody DycUocCreateOrderReqBO reqBO) {
        log.info("\u4e0b\u5355\u63a5\u53e3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        this.verifyParam(reqBO);
        DycUocCreateOrderContextBO contextBO = (DycUocCreateOrderContextBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocCreateOrderContextBO.class));
        this.createOrderApproveExt(reqBO, contextBO);
        this.queryAndVerifyJdAddressInfo(contextBO);
        this.batchQuerySkuAndAgreementInfo(contextBO);
        this.queryProfessionalInfo(contextBO);
        this.querySupplierInfo(contextBO);
        this.minusInventory(contextBO);
        this.createSaleOrder(contextBO);
        this.startSaleOrderProcess(contextBO);
        log.info("\u542f\u52a8\u9500\u552e\u5355\u4e1a\u52a1\u6d41\u7a0b\u6210\u529f");
        if ("DYC".equals(this.systemName)) {
            this.minusPlan(contextBO);
        }
        this.deleteShopCartGoods(contextBO);
        this.buryPoint(contextBO);
        if ("DYC".equals(this.systemName)) {
            this.invokPrice(contextBO);
        }
        this.callBargain(contextBO);
        DycUocCreateOrderRspBO rspBO = new DycUocCreateOrderRspBO();
        rspBO.setOrderId(String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
        rspBO.setSaleOrderList(JSONArray.parseArray((String)JSON.toJSONString((Object)contextBO.getCreateOrderResult().getSaleOrderList()), DycUocCreateSaleOrderBO.class));
        return rspBO;
    }

    private void createOrderApproveExt(DycUocCreateOrderReqBO reqBo, DycUocCreateOrderContextBO contextBO) {
        List<DycUocCreateOrderReqApproveBo> approveBoS;
        log.info("\u4e0b\u5355\u8c03\u7528\u5ba1\u6279\u6269\u5c55\u670d\u52a1\u8c03\u7528\u5f00\u5173\uff1a" + this.saasUocBaseProperties.isCreateOrderCallApproveExt());
        log.info("\u4e0b\u5355\u8c03\u7528\u5ba1\u6279\u6269\u5c55\u670d\u52a1\u5b57\u6bb5\uff1a{}", (Object)JSON.toJSONString(reqBo.getApproveBoS()));
        if (this.saasUocBaseProperties.isCreateOrderCallApproveExt() && ObjectUtil.isNotEmpty(approveBoS = reqBo.getApproveBoS())) {
            long orderId = IdUtil.nextId();
            log.info("\u4e0b\u5355\u8c03\u7528\u5ba1\u6279\u6269\u5c55\u670d\u52a1\u751f\u6210\u8ba2\u5355id\uff1a" + orderId);
            contextBO.setOrderId(orderId);
            DycUocCreateOrderApproveExtPtReqBo approveExtBo = new DycUocCreateOrderApproveExtPtReqBo();
            BeanUtils.copyProperties((Object)approveBoS.get(0), (Object)approveExtBo);
            approveExtBo.setOrderId(Long.valueOf(orderId));
            log.info("\u4e0b\u5355\u8c03\u7528\u5ba1\u6279\u6269\u5c55\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)approveExtBo));
            DycUocCreateOrderApproveExtPtRspBo orderApproveExt = this.dycUocCreateOrderApproveExtPt.createOrderApproveExt(approveExtBo);
            log.info("\u4e0b\u5355\u8c03\u7528\u5ba1\u6279\u6269\u5c55\u670d\u52a1\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)orderApproveExt));
            if (!"0".equals(orderApproveExt.getCode())) {
                log.error("\u4e0b\u5355\u5ba1\u6279\u6269\u5c55\u8c03\u7528\u5f02\u5e38\uff1a{}", (Object)orderApproveExt.getMessage());
                throw new ZTBusinessException("\u4e0b\u5355\u5ba1\u6279\u6269\u5c55\u8c03\u7528\u5f02\u5e38\uff1a" + orderApproveExt.getMessage());
            }
        }
    }

    private void callBargain(DycUocCreateOrderContextBO reqBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getBargainingId())) {
            DycUocUpdateBargainingOrderedReqBO updateBargainingOrderedReqBO = new DycUocUpdateBargainingOrderedReqBO();
            updateBargainingOrderedReqBO.setBargainingId(reqBO.getBargainingId());
            updateBargainingOrderedReqBO.setUserId(reqBO.getUserId());
            updateBargainingOrderedReqBO.setName(reqBO.getName());
            updateBargainingOrderedReqBO.setOrderId(reqBO.getCreateOrderResult().getOrderId());
            updateBargainingOrderedReqBO.setSaleOrderInfo(reqBO.getCreateOrderResult().getSaleOrderList());
            log.info("\u8c03\u7528\u8bae\u4ef7\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)updateBargainingOrderedReqBO)));
            DycUocUpdateBargainingOrderedRspBO bargainingOrderedRspBO = this.dycUocUpdateBargainingOrderedService.updateBargaining(updateBargainingOrderedReqBO);
            log.info("\u8c03\u7528\u8bae\u4ef7\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)((Object)bargainingOrderedRspBO)));
            if (!"0000".equals(bargainingOrderedRspBO.getRespCode())) {
                log.error("\u8c03\u7528\u8bae\u4ef7\u5355\u5f02\u5e38\uff1a{}", (Object)bargainingOrderedRspBO.getRespDesc());
            }
        }
    }

    private void queryAndVerifyJdAddressInfo(DycUocCreateOrderContextBO contextBO) {
        List supplierIdList = contextBO.getCommodityBos().stream().map(v -> String.valueOf(v.getSupplierId())).collect(Collectors.toList());
        if (supplierIdList.contains(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"))) {
            if (Objects.isNull(contextBO.getAddressBo()) || StringUtils.isEmpty((Object)contextBO.getAddressBo().getContactAddress())) {
                throw new ZTBusinessException("\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
            }
            DycUocJdAddressQryFunctionReqBO dycUocJdAddressQryFunctionReqBO = new DycUocJdAddressQryFunctionReqBO();
            dycUocJdAddressQryFunctionReqBO.setAddress(contextBO.getAddressBo().getContactAddress());
            dycUocJdAddressQryFunctionReqBO.setSupplierId(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID"));
            dycUocJdAddressQryFunctionReqBO.setContactProvinceId(contextBO.getAddressBo().getContactProvinceId());
            dycUocJdAddressQryFunctionReqBO.setContactCityId(contextBO.getAddressBo().getContactCityId());
            dycUocJdAddressQryFunctionReqBO.setContactCountyId(contextBO.getAddressBo().getContactCountyId());
            dycUocJdAddressQryFunctionReqBO.setContactTownId(contextBO.getAddressBo().getContactTownId());
            dycUocJdAddressQryFunctionReqBO.setIsCheckArea(Boolean.valueOf(true));
            DycUocJdAddressQryFunctionRspBO dycUocJdAddressQryFunctionRspBO = this.dycUocJdAddressQryFunction.qryAddressInfo(dycUocJdAddressQryFunctionReqBO);
            if ("0000".equals(dycUocJdAddressQryFunctionRspBO.getRespCode())) {
                contextBO.getAddressBo().setContactCountryId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCountryId());
                contextBO.getAddressBo().setContactProvinceId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactProvinceId());
                contextBO.getAddressBo().setContactCityId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCityId());
                contextBO.getAddressBo().setContactCountyId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactCountyId());
                contextBO.getAddressBo().setContactTownId(dycUocJdAddressQryFunctionRspBO.getAddressBo().getContactTownId());
            } else {
                throw new ZTBusinessException(dycUocJdAddressQryFunctionRspBO.getRespDesc());
            }
        }
    }

    private void minusInventory(DycUocCreateOrderContextBO contextBO) {
        DycUocDeductSkuNumFuncReqBO dycUocDeductSkuNumFuncReqBO = new DycUocDeductSkuNumFuncReqBO();
        List skuDetailBos = contextBO.getCommodityBos().stream().map(bo -> {
            DycUocDeductSkuNumFuncBO dycUocDeductSkuNumFuncBO = new DycUocDeductSkuNumFuncBO();
            BeanUtils.copyProperties((Object)bo, (Object)dycUocDeductSkuNumFuncBO);
            return dycUocDeductSkuNumFuncBO;
        }).collect(Collectors.toList());
        dycUocDeductSkuNumFuncReqBO.setSkuDetailBos(skuDetailBos);
        dycUocDeductSkuNumFuncReqBO.setOperType("0");
        DycUocDeductSkuNumFuncRspBO dycUocDeductSkuNumFuncRspBO = this.dycUocDeductSkuNumFunction.dealDeductSkuNum(dycUocDeductSkuNumFuncReqBO);
        if (!"0000".equals(dycUocDeductSkuNumFuncRspBO.getRespCode())) {
            if (this.minusInventoryReturnFail) {
                throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff1a" + dycUocDeductSkuNumFuncRspBO.getRespDesc());
            }
            log.error("\u5546\u54c1\u5e93\u5b58\u6263\u51cf\u5931\u8d25\uff08\u8df3\u8fc7\u62a5\u9519\uff09:" + dycUocDeductSkuNumFuncRspBO.getRespDesc());
        }
    }

    private void querySupplierInfo(DycUocCreateOrderContextBO contextBO) {
        DycUocSupplierInfoQryFuncReqBO dycUocSupplierInfoQryFuncReqBO = new DycUocSupplierInfoQryFuncReqBO();
        dycUocSupplierInfoQryFuncReqBO.setSupplierIds(contextBO.getCommodityBos().stream().map(DycUocCommodityBO::getSupplierId).distinct().collect(Collectors.toList()));
        if (ObjectUtil.isNotEmpty((Object)contextBO.getProfessionalDetailBO())) {
            dycUocSupplierInfoQryFuncReqBO.setOperationOrgId(Long.valueOf(contextBO.getProfessionalDetailBO().getProId()));
        }
        dycUocSupplierInfoQryFuncReqBO.setPurchaseOrgId(contextBO.getCompanyId());
        dycUocSupplierInfoQryFuncReqBO.setUserId(contextBO.getUserId());
        dycUocSupplierInfoQryFuncReqBO.setUserTypeIn(contextBO.getUserTypeIn());
        DycUocSupplierInfoQryFuncRspBO dycUocSupplierInfoQryFuncRspBO = this.dycUocSupplierInfoQryFunction.qrySupplierInfo(dycUocSupplierInfoQryFuncReqBO);
        if (!"0000".equals(dycUocSupplierInfoQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u8865\u5168\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocSupplierInfoQryFuncRspBO.getRespDesc());
        }
        contextBO.setSupplierBos(dycUocSupplierInfoQryFuncRspBO.getSupplierBos());
    }

    private void queryProfessionalInfo(DycUocCreateOrderContextBO contextBO) {
        DycUocProfessionalDetailQryFuncReqBO dycUocProfessionalDetailQryFuncReqBO = new DycUocProfessionalDetailQryFuncReqBO();
        dycUocProfessionalDetailQryFuncReqBO.setPurAccountId(contextBO.getPurAccountId());
        DycUocProfessionalDetailQryFuncRspBO dycUocProfessionalDetailQryFuncRspBO = this.dycUocProfessionalDetailQryFunction.qryProfessionalDetail(dycUocProfessionalDetailQryFuncReqBO);
        if (!"0000".equals(dycUocProfessionalDetailQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocProfessionalDetailQryFuncRspBO.getRespDesc());
        }
        contextBO.setProfessionalDetailBO(dycUocProfessionalDetailQryFuncRspBO.getProfessionalDetailBO());
    }

    private void batchQuerySkuAndAgreementInfo(DycUocCreateOrderContextBO contextBO) {
        DycUocCommodityBatchQryFuncReqBO dycUocCommodityBatchQryFuncReqBO = new DycUocCommodityBatchQryFuncReqBO();
        BeanUtils.copyProperties((Object)((Object)contextBO), (Object)dycUocCommodityBatchQryFuncReqBO);
        Map<Object, Object> extMap = new HashMap();
        String unifiedPurOrderFlag = null;
        if (ObjectUtil.isNotEmpty((Object)contextBO.getExtFields())) {
            extMap = contextBO.getExtFields().stream().collect(Collectors.toMap(BaseExtendFieldBo::getFieldCode, BaseExtendFieldBo::getFieldValue));
            unifiedPurOrderFlag = (String)extMap.get("unifiedPurOrderFlag");
        }
        if ("1".equals(unifiedPurOrderFlag)) {
            dycUocCommodityBatchQryFuncReqBO.setProvince(Long.valueOf(contextBO.getAddressBo().getContactProvinceId()));
            dycUocCommodityBatchQryFuncReqBO.setCity(Long.valueOf(contextBO.getAddressBo().getContactCityId()));
            dycUocCommodityBatchQryFuncReqBO.setCounty(Long.valueOf(contextBO.getAddressBo().getContactCountyId()));
            if (!StringUtils.isEmpty((Object)contextBO.getAddressBo().getContactTownId())) {
                dycUocCommodityBatchQryFuncReqBO.setTown(Long.valueOf(contextBO.getAddressBo().getContactTownId()));
            }
        }
        List skuOrderList = JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(DycUocCommodityBatchQryFuncBO.class);
        dycUocCommodityBatchQryFuncReqBO.setSkuOrderList(skuOrderList);
        DycUocCommodityBatchQryFuncRspBO dycUocCommodityBatchQryFuncRspBO = this.dycUocCommodityBatchQryFunction.qryCommodityByBatch(dycUocCommodityBatchQryFuncReqBO);
        if (!"0000".equals(dycUocCommodityBatchQryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + dycUocCommodityBatchQryFuncRspBO.getRespDesc());
        }
        contextBO.setCommodityInfos(dycUocCommodityBatchQryFuncRspBO.getCommodityInfos());
        contextBO.setAgreementInfos(dycUocCommodityBatchQryFuncRspBO.getAgreementInfos());
    }

    private void createSaleOrder(DycUocCreateOrderContextBO contextBO) {
        this.changePurchasePriceWithCuoheMode(contextBO);
        UocCreateOrderServiceReqBo uocCreateOrderServiceReqBo = new UocCreateOrderServiceReqBo();
        uocCreateOrderServiceReqBo.setExtFields(contextBO.getExtFields());
        uocCreateOrderServiceReqBo.setTraceId(contextBO.getTraceId());
        uocCreateOrderServiceReqBo.setUserId(contextBO.getUserId());
        uocCreateOrderServiceReqBo.setName(contextBO.getName());
        uocCreateOrderServiceReqBo.setUserName(contextBO.getUserName());
        uocCreateOrderServiceReqBo.setOrgId(contextBO.getOrgId());
        uocCreateOrderServiceReqBo.setOrgName(contextBO.getOrgName());
        uocCreateOrderServiceReqBo.setOrgPath(contextBO.getOrgPath());
        uocCreateOrderServiceReqBo.setCompanyId(contextBO.getCompanyId());
        uocCreateOrderServiceReqBo.setCompanyName(contextBO.getCompanyName());
        uocCreateOrderServiceReqBo.setUserType(contextBO.getUserTypeIn());
        uocCreateOrderServiceReqBo.setTotalSaleFee(contextBO.getTotalSaleFee());
        uocCreateOrderServiceReqBo.setTotalPurchaseFee(contextBO.getCommodityInfos().stream().map(bo -> bo.getPurchasePrice().multiply(bo.getPurchaseCount())).reduce(BigDecimal.ZERO, BigDecimal::add));
        uocCreateOrderServiceReqBo.setTotalTransFee(contextBO.getTotalTransFee());
        uocCreateOrderServiceReqBo.setRemark(contextBO.getRemark());
        uocCreateOrderServiceReqBo.setPurAccount(String.valueOf(contextBO.getPurAccountId()));
        uocCreateOrderServiceReqBo.setPurAccountName(contextBO.getPurAccountName());
        uocCreateOrderServiceReqBo.setPurContactName(contextBO.getPurPlaceOrderName());
        uocCreateOrderServiceReqBo.setPurMobile(contextBO.getPurMobile());
        uocCreateOrderServiceReqBo.setPurNeedName(contextBO.getPurNeedName());
        uocCreateOrderServiceReqBo.setPurNeedMobile(contextBO.getPurNeedMobile());
        uocCreateOrderServiceReqBo.setSendTime(contextBO.getSendTime());
        uocCreateOrderServiceReqBo.setOrderItems(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityInfos())).toJavaList(UocCreateOrderServiceReqCommodityBo.class));
        uocCreateOrderServiceReqBo.setUocOrdInvoice((UocCreateOrderServiceReqInvoiceBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getInvoiceBo()), UocCreateOrderServiceReqInvoiceBo.class));
        uocCreateOrderServiceReqBo.setOperating((UocCreateOrderServiceReqProfessionalBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getProfessionalDetailBO()), UocCreateOrderServiceReqProfessionalBo.class));
        uocCreateOrderServiceReqBo.setSupplierBos(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getSupplierBos())).toJavaList(UocSupplierInfoBo.class));
        if (!CollectionUtils.isEmpty(contextBO.getAgreementInfos())) {
            uocCreateOrderServiceReqBo.setAgrPayConfigList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getAgreementInfos())).toJavaList(UocCreateOrderServiceReqArgPayConfSupBo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)contextBO.getAddressBo())) {
            uocCreateOrderServiceReqBo.setReceiverAddress((UocCreateOrderServiceReqAddressBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getAddressBo()), UocCreateOrderServiceReqAddressBo.class));
        }
        if (ObjectUtil.isNotEmpty((Object)contextBO.getInvoiceAddressBo())) {
            uocCreateOrderServiceReqBo.setInvoiceAddress((UocCreateOrderServiceReqAddressBo)JSONObject.parseObject((String)JSON.toJSONString((Object)contextBO.getInvoiceAddressBo()), UocCreateOrderServiceReqAddressBo.class));
        }
        uocCreateOrderServiceReqBo.setAccessoryList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getAttachBos())).toJavaList(UocCreateOrderServiceReqAccessoryBo.class));
        uocCreateOrderServiceReqBo.setBargainingId(contextBO.getBargainingId());
        uocCreateOrderServiceReqBo.setBargainingNo(contextBO.getBargainingNo());
        uocCreateOrderServiceReqBo.setOrderName(contextBO.getOrderName());
        log.debug("contextBO.getCommodityBos()" + JSON.toJSONString(contextBO.getCommodityBos()));
        log.debug("contextBO.getCommodityInfos()" + JSON.toJSONString(contextBO.getCommodityInfos()));
        log.debug("uocCreateOrderServiceReqBo.getOrderItems()" + JSON.toJSONString((Object)uocCreateOrderServiceReqBo.getOrderItems()));
        log.info("\u8c03\u7528\u8ba2\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocCreateOrderServiceReqBo));
        uocCreateOrderServiceReqBo.setOrderId(contextBO.getOrderId());
        UocCreateOrderServiceRspBo uocCreateOrderServiceRspBo = this.uocCreateOrderService.createOrder(uocCreateOrderServiceReqBo);
        log.info("\u8c03\u7528\u8ba2\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uocCreateOrderServiceRspBo));
        if (!"0000".equals(uocCreateOrderServiceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u9500\u552e\u5355\u5931\u8d25\uff1a" + uocCreateOrderServiceRspBo.getRespDesc());
        }
        contextBO.setCreateOrderResult(uocCreateOrderServiceRspBo);
    }

    private void changePurchasePriceWithCuoheMode(DycUocCreateOrderContextBO contextBO) {
        if (this.changePurchasePriceWithModelSettle) {
            log.info("\u9700\u8981\u5904\u7406\u64ae\u5408\u6a21\u5f0f\u4e0b\uff0c\u6709\u9636\u68af\u4ef7\u683c\u7684\u91c7\u8d2d\u4ef7\u683c");
            log.info("\u9700\u8981\u5904\u7406\u64ae\u5408\u6a21\u5f0f\u4e0b\uff0c\u5165\u53c2\uff1a" + JSON.toJSONString((Object)((Object)contextBO)));
            List<DycUocAgreementFuncBO> agreementInfos = contextBO.getAgreementInfos();
            Map<Object, Object> agrMap = new HashMap();
            if (ObjectUtil.isNotEmpty(agreementInfos)) {
                agrMap = agreementInfos.stream().collect(Collectors.toMap(DycUocAgreementFuncBO::getAgrId, item -> item));
            }
            List<DycUocSupplierInfoFuncBO> supplierBos = contextBO.getSupplierBos();
            Map<Object, Object> supplierMap = new HashMap();
            if (ObjectUtil.isNotEmpty(supplierBos)) {
                supplierMap = supplierBos.stream().collect(Collectors.toMap(DycUocSupplierInfoFuncBO::getSupplierId, item -> item));
            }
            List<DycUocCommodityFuncBO> commodityInfos = contextBO.getCommodityInfos();
            for (DycUocCommodityFuncBO commodityInfo : commodityInfos) {
                String agreementId = commodityInfo.getAgreementId();
                DycUocAgreementFuncBO dycUocAgreementFuncBO = (DycUocAgreementFuncBO)agrMap.get(agreementId);
                String supplierId = commodityInfo.getSupplierId();
                DycUocSupplierInfoFuncBO dycUocSupplierInfoFuncBO = (DycUocSupplierInfoFuncBO)supplierMap.get(Long.parseLong(supplierId));
                Boolean ladderPrice = commodityInfo.getLadderPrice();
                if (ObjectUtil.isNotEmpty((Object)agreementId) && ObjectUtil.isNotEmpty((Object)dycUocAgreementFuncBO) && ladderPrice.booleanValue()) {
                    if (dycUocAgreementFuncBO.getConfBos().size() != 1) continue;
                    commodityInfo.setPurchasePrice(commodityInfo.getSalePrice());
                    continue;
                }
                if (!ObjectUtil.isNotEmpty((Object)supplierId) || !ObjectUtil.isNotEmpty((Object)dycUocSupplierInfoFuncBO) || !ladderPrice.booleanValue() || dycUocSupplierInfoFuncBO.getPayConfigBos().size() != 1) continue;
                commodityInfo.setPurchasePrice(commodityInfo.getSalePrice());
            }
            log.info("\u9700\u8981\u5904\u7406\u64ae\u5408\u6a21\u5f0f\u4e0b\uff0c\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)((Object)contextBO)));
        } else {
            log.info("\u4e0d\u9700\u8981\u5904\u7406\u64ae\u5408\u6a21\u5f0f\u4e0b\uff0c\u6709\u9636\u68af\u4ef7\u683c\u7684\u91c7\u8d2d\u4ef7\u683c");
        }
    }

    private void setItemExtFields(DycUocCreateOrderContextBO contextBO, UocCreateOrderServiceReqBo uocCreateOrderServiceReqBo) {
        Map<Long, List<DycUocCommodityBO>> contextMap = contextBO.getCommodityBos().stream().collect(Collectors.groupingBy(DycUocCommodityBO::getSkuId));
        List orderItems = uocCreateOrderServiceReqBo.getOrderItems();
        if (ObjectUtil.isNotEmpty(contextMap) && ObjectUtil.isNotEmpty((Object)orderItems)) {
            for (UocCreateOrderServiceReqCommodityBo orderItem : orderItems) {
                List<DycUocCommodityBO> dycUocCommodityBOS = contextMap.get(Long.parseLong(orderItem.getSkuId()));
                if (!ObjectUtil.isNotEmpty(dycUocCommodityBOS)) continue;
                orderItem.setExtFields(dycUocCommodityBOS.get(0).getExtFields());
            }
        }
    }

    private void verifyParam(DycUocCreateOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getCommodityBos().forEach(obj -> {
            if (obj.getPurchaseCount().compareTo(BigDecimal.ZERO) == 0) {
                throw new ZTBusinessException("\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a0");
            }
        });
    }

    private void minusPlan(DycUocCreateOrderContextBO contextBO) {
        Map<String, List<DycUocCommodityBO>> commodityMap = contextBO.getCommodityBos().stream().filter(obj -> !StringUtils.isEmpty((Object)obj.getPlanId())).collect(Collectors.groupingBy(obj -> obj.getSkuId() + "_" + obj.getPlanId()));
        ArrayList<PpcpurchasePlanSscBO> purchasePlanSscBOS = new ArrayList<PpcpurchasePlanSscBO>();
        for (UocCreateOrderServiceRspSaleOrderBo saleOrderInfo : contextBO.getCreateOrderResult().getSaleOrderList()) {
            for (UocCreateOrderServiceRspSaleOrderItemBo saleOrderItemInfo : saleOrderInfo.getItemBoList()) {
                List orderPlanBOList = saleOrderItemInfo.getOrderPlanBOList();
                if (!ObjectUtil.isNotEmpty((Object)orderPlanBOList)) continue;
                for (UocOrderPlanBO planBO : orderPlanBOList) {
                    if (StringUtils.isEmpty((Object)planBO.getPlanId())) continue;
                    String key = saleOrderItemInfo.getSkuId() + "_" + saleOrderItemInfo.getPlanId();
                    List<DycUocCommodityBO> dycUocCommodityBOS = commodityMap.get(key);
                    DycUocCommodityBO dycUocCommodityBO = dycUocCommodityBOS.get(0);
                    PpcpurchasePlanSscBO ppcpurchasePlanSscBO = new PpcpurchasePlanSscBO();
                    ppcpurchasePlanSscBO.setOrderId(saleOrderInfo.getSaleOrderId());
                    ppcpurchasePlanSscBO.setOrderCode(saleOrderInfo.getSaleOrderNo());
                    ppcpurchasePlanSscBO.setPurchasePlanItemId(Long.valueOf(saleOrderItemInfo.getPlanItemId()));
                    ppcpurchasePlanSscBO.setPurchasePlanId(Long.valueOf(saleOrderItemInfo.getPlanId()));
                    ppcpurchasePlanSscBO.setPurchaserNumber(planBO.getPurchaseCount());
                    ppcpurchasePlanSscBO.setAllPrice(planBO.getPurchaseCount().multiply(dycUocCommodityBO.getSalePrice()));
                    purchasePlanSscBOS.add(ppcpurchasePlanSscBO);
                }
            }
        }
        if (!CollectionUtils.isEmpty(purchasePlanSscBOS)) {
            PpcOrderFeedbackAbilityReqBO ppcOrderFeedbackAbilityReqBO = new PpcOrderFeedbackAbilityReqBO();
            ppcOrderFeedbackAbilityReqBO.setPurchasePlanSscBOS(purchasePlanSscBOS);
            PpcOrderFeedbackAbilityRspBO ppcOrderFeedbackAbilityRspBO = this.ppcOrderFeedbackAbilityService.orderFeedback(ppcOrderFeedbackAbilityReqBO);
            if (!"0000".equals(ppcOrderFeedbackAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8ba1\u5212\u6263\u51cf\u5931\u8d25\uff1a" + ppcOrderFeedbackAbilityRspBO.getRespDesc());
            }
        }
    }

    private void startSaleOrderProcess(DycUocCreateOrderContextBO contextBO) {
        Map<String, DycUocAgreementFuncBO> agreementInfosMap = null;
        if (!CollectionUtils.isEmpty(contextBO.getAgreementInfos())) {
            agreementInfosMap = contextBO.getAgreementInfos().stream().collect(Collectors.toMap(DycUocAgreementFuncBO::getAgrId, item -> item));
        }
        for (UocCreateOrderServiceRspSaleOrderBo saleOrderInfo : contextBO.getCreateOrderResult().getSaleOrderList()) {
            DycGeneralBusiRuleExecFuncReqBO dycGeneralBusiRuleExecFuncReqBO = new DycGeneralBusiRuleExecFuncReqBO();
            dycGeneralBusiRuleExecFuncReqBO.setServiceCode("B0001");
            dycGeneralBusiRuleExecFuncReqBO.setParamJsonStr(JSON.toJSONString((Object)saleOrderInfo));
            String createOrderProcessKey = null;
            if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderInfo.getOrderSource())) {
                createOrderProcessKey = this.agrSaleOrderProcessKey;
            } else if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderInfo.getOrderSource())) {
                createOrderProcessKey = this.esSaleOrderProcessKey;
            }
            if (!StringUtils.isEmpty((Object)createOrderProcessKey)) {
                DycBusiProcessStartFuncReqBO dycBusiProcessStartFuncReqBO = new DycBusiProcessStartFuncReqBO();
                dycBusiProcessStartFuncReqBO.setProcDefKey(createOrderProcessKey);
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("orderId", String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
                variables.put("saleOrderNo", saleOrderInfo.getSaleOrderNo());
                variables.put("saleOrderId", saleOrderInfo.getSaleOrderId());
                variables.put("auditObjId", saleOrderInfo.getSaleOrderId());
                variables.put("objId", saleOrderInfo.getSaleOrderId());
                variables.put("orgId", contextBO.getOrgId());
                variables.put("orgName", contextBO.getOrgName());
                variables.put("userId", contextBO.getUserId());
                variables.put("createOperId", contextBO.getUserId());
                variables.put("userName", contextBO.getName());
                variables.put("modelSettle", saleOrderInfo.getModelSettle());
                variables.put("supId", saleOrderInfo.getSupId());
                variables.put("supplierId", saleOrderInfo.getSupId());
                variables.put("proId", saleOrderInfo.getProId());
                variables.put("shipStartflag", 0);
                variables.put("shipCompleteflag", 0);
                variables.put("subOrderStartflag", 0);
                variables.put("subOrderCompleteflag", 0);
                variables.put("orderSale", contextBO.getTotalSaleFee());
                variables.put("autidStartflag", "1");
                variables.put("autidCompleteflag", "1");
                variables.put("adjustPriceAutidStartflag", "1");
                variables.put("adjustPriceAutidCompleteflag", "1");
                Map<String, BaseExtendFieldBo> baseExtendFieldBoMap = contextBO.getExtFields().stream().collect(Collectors.toMap(BaseExtendFieldBo::getFieldCode, e -> e));
                if (ObjectUtil.isNotEmpty((Object)baseExtendFieldBoMap.get("budgetModelCode"))) {
                    variables.put("budgetModelCode", baseExtendFieldBoMap.get("budgetModelCode").getFieldValue());
                }
                int flag = saleOrderInfo.getTotalSaleFee().compareTo(new BigDecimal(this.uocAuditPrice));
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderInfo.getOrderSource())) {
                    if (1 == flag && this.uocAuditFlag) {
                        log.info("\u534f\u8bae\u8ba2\u5355\u91d1\u989d\u5927\u4e8e{}", (Object)this.uocAuditPrice);
                        variables.put("orderCreateNeedAudit", "1");
                    } else {
                        log.info("\u534f\u8bae\u8ba2\u5355\u91d1\u989d\u4e0d\u5927\u4e8e{}", (Object)this.uocAuditPrice);
                        variables.put("orderCreateNeedAudit", "0");
                    }
                } else {
                    variables.put("orderCreateNeedAudit", "1");
                }
                variables.put("todoOrderNo", saleOrderInfo.getSaleOrderNo());
                if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(saleOrderInfo.getPayType())) {
                    variables.put("dayPag", "1");
                } else {
                    variables.put("prePay", "1");
                }
                variables.put("auditResult", "1");
                variables.put("auditOrderStatus", "1");
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderInfo.getOrderSource())) {
                    DycUocAgreementFuncBO agreementFuncBO = agreementInfosMap.get(saleOrderInfo.getAgrId());
                    UmcMemDetailQueryReqBO umcMemDetailQueryReqBO = new UmcMemDetailQueryReqBO();
                    umcMemDetailQueryReqBO.setMemId(Long.valueOf(agreementFuncBO.getProDeliveryId()));
                    UmcMemDetailQueryRspBO umcMemDetailQueryRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryReqBO);
                    if ("0000".equals(umcMemDetailQueryRspBO.getRespCode()) && umcMemDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO() != null && umcMemDetailQueryRspBO.getUmcMemDetailInfoAbilityRspBO().getStopStatus().equals(YES)) {
                        variables.put("proDeliveryFlag", "1");
                    } else {
                        variables.put("proDeliveryFlag", "0");
                    }
                    if (UocDicConstant.ADJUST_PRICE.IN_THE_THING.equals(agreementFuncBO.getAdjustPrice())) {
                        variables.put("adjustPrice", "1");
                    } else {
                        variables.put("adjustPrice", "0");
                    }
                }
                dycBusiProcessStartFuncReqBO.setVariables(variables);
                dycBusiProcessStartFuncReqBO.setSysCode(this.SYS_CODE);
                dycBusiProcessStartFuncReqBO.setPartitonKey(String.valueOf(contextBO.getCreateOrderResult().getOrderId()));
                DycBusiProcessStartFuncRspBO dycBusiProcessStartFuncRspBO = this.dycBusiProcessStartFunction.startBusiProcess(dycBusiProcessStartFuncReqBO);
                if ("0000".equals(dycBusiProcessStartFuncRspBO.getRespCode())) continue;
                throw new ZTBusinessException("\u9500\u552e\u5355\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + dycBusiProcessStartFuncRspBO.getRespDesc());
            }
            throw new ZTBusinessException("\u8c03\u7528\u89c4\u5219\u5f15\u64ce\uff0c\u672a\u83b7\u53d6\u5230\u9700\u8981\u542f\u52a8\u7684\u6d41\u7a0bkey");
        }
    }

    private void sendMessage(DycUocCreateOrderContextBO contextBO, UocCreateOrderServiceRspSaleOrderBo saleOrderInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskCode", "create_order");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("saleOrderNo", saleOrderInfo.getSaleOrderNo());
        map.put("data", dataMap);
        map.put("sendId", contextBO.getUserId() + "");
        map.put("sendName", contextBO.getName());
        ArrayList receiverBOList = new ArrayList();
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        authGetUserByRoleAndOrgReqBo.setOrgIdWeb(contextBO.getOrgId());
        authGetUserByRoleAndOrgReqBo.setRoleCodes(Arrays.asList("tenant:10000:caigoudanweikuguanyuan"));
        authGetUserByRoleAndOrgReqBo.setPageNo(-1);
        authGetUserByRoleAndOrgReqBo.setPageSize(-1);
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.authGetUserByRoleAndOrgService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        List rows = userByRoleAndOrg.getRows();
        if (!CollectionUtils.isEmpty((Collection)rows)) {
            rows.forEach(v -> {
                GeminiReceiverBO geminiReceiverBO = new GeminiReceiverBO();
                geminiReceiverBO.setReceiverId(String.valueOf(v.getUserId()));
                geminiReceiverBO.setReceiverName(v.getLoginName());
                receiverBOList.add(geminiReceiverBO);
            });
        }
        map.put("receiverIdList", JSON.toJSONString(receiverBOList));
        this.dycUocGemiSendMessageAtomFunction.sendMessage(map);
    }

    private void deleteShopCartGoods(DycUocCreateOrderContextBO contextBO) {
        UmcRemoveShoppingCartReqBo umcRemoveShoppingCartReqBo = new UmcRemoveShoppingCartReqBo();
        umcRemoveShoppingCartReqBo.setUserId(contextBO.getUserId());
        umcRemoveShoppingCartReqBo.setGoodsInfoList(JSONArray.parseArray((String)JSON.toJSONString(contextBO.getCommodityBos())).toJavaList(UmcAddShoppingCartBo.class));
        log.info("\u6e05\u9664\u8d2d\u7269\u8f66\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)umcRemoveShoppingCartReqBo));
        UmcRemoveShoppingCartRspBo umcRemoveShoppingCartRspBo = this.umcRemoveShoppingCartService.removeShoppingCart(umcRemoveShoppingCartReqBo);
        log.info("\u6e05\u9664\u8d2d\u7269\u8f66\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)umcRemoveShoppingCartRspBo));
        if (!"0000".equals(umcRemoveShoppingCartRspBo.getRespCode())) {
            throw new ZTBusinessException("\u6e05\u9664\u8d2d\u7269\u8f66\u4e2d\u672c\u6b21\u5df2\u4e0b\u5355\u7684\u5546\u54c1\u5931\u8d25\uff1a" + umcRemoveShoppingCartRspBo.getRespDesc());
        }
    }

    private void buryPoint(DycUocCreateOrderContextBO contextBO) {
        DycBuriedPointCallFuncReqBo funcReqBo = new DycBuriedPointCallFuncReqBo();
        funcReqBo.setEnable(Boolean.valueOf(this.buryPointEnable));
        List saleOrderBoList = contextBO.getCreateOrderResult().getSaleOrderList();
        Long orderId = contextBO.getCreateOrderResult().getOrderId();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (Object each : saleOrderBoList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("saleOrderId", (Object)each.getSaleOrderId());
            jsonObject.put("orderId", (Object)orderId);
            list.add(jsonObject);
        }
        ArrayList<DycBuriedPointCallFuncBo> buildList = new ArrayList<DycBuriedPointCallFuncBo>();
        for (JSONObject j : list) {
            DycBuriedPointCallFuncBo bo = new DycBuriedPointCallFuncBo();
            bo.setData((Object)j);
            bo.setIdent("ADD");
            bo.setDycCenterCode("UOC");
            bo.setDycBusiCode("saleOrderSync");
            bo.setDesc("\u65b0\u589e\u9500\u552e\u5355");
            buildList.add(bo);
        }
        funcReqBo.setBusiList(buildList);
        log.info("\u57cb\u70b9\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)funcReqBo));
        DycBuriedPointCallFuncRspBo funcRspBo = this.dycBuriedPointCallFunction.callAbility(funcReqBo);
        log.info("\u57cb\u70b9\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)funcRspBo));
        if (!"0000".equals(funcRspBo.getRespCode())) {
            log.error("\u521b\u5efa\u8ba2\u5355\u540e\u8fdb\u884c\u57cb\u70b9\u5931\u8d25\uff1a" + funcRspBo.getRespDesc());
        }
    }

    private void invokPrice(DycUocCreateOrderContextBO contextBO) {
        if (this.priceSyncEnable) {
            List<DycUocCommodityBO> commodityBOS = contextBO.getCommodityBos();
            log.info("\u4e0b\u5355\u8c03\u7528\u4e00\u7269\u4e00\u7801\u5f00\u59cb");
            this.proxyMessageProducer.send(new ProxyMessage(this.priceSyncTopic, this.priceSyncTag, JSON.toJSONString(commodityBOS)));
        }
    }
}

