/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.procinst.AgrSaveTodoService;
import com.tydic.dyc.agr.service.procinst.bo.AgrSaveTodoReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrSaveTodoRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocTodoBo;
import com.tydic.dyc.atom.selfrun.api.DycAgrDealToDoFunction;
import com.tydic.dyc.atom.selfrun.bo.DycTodoInfo;
import com.tydic.dyc.atom.selfrun.bo.DycUocTaskBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.umc.service.todo.UmcQueryToDoItemListService;
import com.tydic.dyc.umc.service.todo.UmcSendTodoService;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoItemListReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoItemListRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoItemBo;
import com.tydic.dyc.umc.service.todo.bo.UmcTodoBo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycAgrDealToDoFunctionImpl
implements DycAgrDealToDoFunction {
    private static final Logger log = LoggerFactory.getLogger(DycAgrDealToDoFunctionImpl.class);
    @Autowired
    private AgrSaveTodoService agrSaveTodoService;
    @Autowired
    private UmcSendTodoService umcSendTodoService;
    @Autowired
    private UmcQueryToDoItemListService umcQueryToDoItemListService;
    private static final String TODO_MODULE_CODE = "agr";
    @Value(value="${agr.audit.url.addAudit:lcpAgrApprovalAddList}")
    private String addAuditUrl;
    @Value(value="${agr.audit.url.changeAudit:lcpAgrApprovalChangeList}")
    private String changeAuditUrl;
    @Value(value="${agr.todoUrl.enableAgrTypeFlag:false}")
    private Boolean enableAgrTypeFlag;
    @Value(value="#{'${agr.todoUrl.agrTypeTodoUrlList:agrTypeUrl1,agrTypeUrl2}'.split(',')}")
    private List<String> agrTypeTodoUrlList;

    @Override
    public void dealTodo(DycUocTaskBO nextTaskInfo, Long orderId, DycTodoInfo todoInfo, String todoTempCode, Integer objType, String todoUrl) {
        if (StrUtil.isNotEmpty((CharSequence)todoTempCode)) {
            UmcQueryToDoItemListReqBo itemListReqBo = new UmcQueryToDoItemListReqBo();
            itemListReqBo.setTodoItemCode(todoTempCode);
            itemListReqBo.setTodoModuleCode(TODO_MODULE_CODE);
            UmcQueryToDoItemListRspBo itemListRspBo = this.umcQueryToDoItemListService.queryToDoItemList(itemListReqBo);
            log.info("\u534f\u8bae\u67e5\u8be2\u5f85\u529e\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)itemListRspBo));
            if (!"0000".equals(itemListRspBo.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u5f85\u529e\u6a21\u677f\u67e5\u8be2\u5931\u8d25: " + itemListRspBo.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)itemListRspBo.getRows()) || itemListRspBo.getRows().size() != 1) {
                throw new ZTBusinessException("\u534f\u8bae\u4ee3\u529e\u9879\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u552f\u4e00");
            }
            UmcToDoItemBo umcToDoItemBo = (UmcToDoItemBo)itemListRspBo.getRows().get(0);
            String finalTodoCode = todoInfo.getTodoNo();
            List todoBoList = nextTaskInfo.getCandidates().stream().map(e -> {
                UmcTodoBo umcTodoBo = new UmcTodoBo();
                umcTodoBo.setBusiId(nextTaskInfo.getTaskId());
                umcTodoBo.setTodoName(umcToDoItemBo.getTodoItemName() + "\uff1a" + finalTodoCode);
                umcTodoBo.setTodoItemCode(umcToDoItemBo.getTodoItemCode());
                this.setTodoUrl(umcTodoBo, umcToDoItemBo, todoInfo.getAgrType(), objType, todoUrl);
                umcTodoBo.setTodoModuleCode(umcToDoItemBo.getTodoModuleCode());
                umcTodoBo.setTodoModuleName(umcToDoItemBo.getTodoModuleName());
                umcTodoBo.setCandidateOperId(e.getCandidateId());
                umcTodoBo.setCandidateOperName(e.getCandidateName());
                umcTodoBo.setCreateOperId("1");
                umcTodoBo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                umcTodoBo.setProcInstId(nextTaskInfo.getProcInstId());
                umcTodoBo.setProcInstKey(nextTaskInfo.getProcDefId());
                return umcTodoBo;
            }).collect(Collectors.toList());
            UmcSendTodoReqBo todoReqBo = new UmcSendTodoReqBo();
            todoReqBo.setTodoList(todoBoList);
            log.info("\u534f\u8bae\u53d1\u9001\u5f85\u529e\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)todoReqBo));
            UmcSendTodoRspBo umcSendTodoRspBo = this.umcSendTodoService.sendTodo(todoReqBo);
            if (!"0000".equals(umcSendTodoRspBo.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u53d1\u9001\u5f85\u529e\u5931\u8d25: " + umcSendTodoRspBo.getRespDesc());
            }
            this.saveTodoInfo(umcSendTodoRspBo, orderId, nextTaskInfo.getTaskId());
        }
    }

    private void saveTodoInfo(UmcSendTodoRspBo umcSendTodoRspBo, Long orderId, String taskId) {
        List todoList = umcSendTodoRspBo.getTodoList();
        List agrUocTodoBoList = todoList.stream().map(e -> {
            AgrUocTodoBo agrUocTodoBo = (AgrUocTodoBo)JUtil.js((Object)e, AgrUocTodoBo.class);
            agrUocTodoBo.setBusiId(taskId);
            agrUocTodoBo.setOrderId(orderId);
            agrUocTodoBo.setCreateTime(new Date());
            agrUocTodoBo.setTodoState(SscCommConstant.YesOrNoEnum.NO.getCode());
            return agrUocTodoBo;
        }).collect(Collectors.toList());
        AgrSaveTodoReqBO agrSaveTodoReqBO = new AgrSaveTodoReqBO();
        agrSaveTodoReqBO.setAgrUocTodo(agrUocTodoBoList);
        log.info("\u534f\u8bae\u4e2d\u5fc3\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)agrSaveTodoReqBO));
        AgrSaveTodoRspBO agrSaveTodoRspBO = this.agrSaveTodoService.saveTodo(agrSaveTodoReqBO);
        if (!"0000".equals(agrSaveTodoRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u4e2d\u5fc3\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5931\u8d25: " + agrSaveTodoRspBO.getRespDesc());
        }
    }

    private void setTodoUrl(UmcTodoBo umcTodoBo, UmcToDoItemBo umcToDoItemBo, Integer agrType, Integer objType, String todoUrl) {
        if (this.enableAgrTypeFlag.booleanValue() && ObjectUtil.isNotNull((Object)agrType)) {
            umcTodoBo.setTodoUrl(this.agrTypeTodoUrlList.get(agrType));
        } else if (StrUtil.isNotEmpty((CharSequence)todoUrl)) {
            umcTodoBo.setTodoUrl(todoUrl);
        } else if (AgrCommConstant.ObjType.AGREEMENT.equals(objType)) {
            umcTodoBo.setTodoUrl(this.addAuditUrl);
        } else if (AgrCommConstant.ObjType.CHANGE.equals(objType)) {
            umcTodoBo.setTodoUrl(this.changeAuditUrl);
        } else {
            umcTodoBo.setTodoUrl(umcToDoItemBo.getTodoUrl());
        }
    }

    public static enum AgrTempCodeEnum {
        AGR_AUDIT_ADD_WAIT("1", "AGR_AUDIT_ADD_WAIT"),
        AGR_AUDIT_CHANGE_WAIT("2", "AGR_AUDIT_CHANGE_WAIT");

        private final String objType;
        private final String tempCode;

        private AgrTempCodeEnum(String objType, String tempCode) {
            this.objType = objType;
            this.tempCode = tempCode;
        }

        public static AgrTempCodeEnum getTempCodeByObjType(String objType) {
            return Arrays.stream(AgrTempCodeEnum.values()).filter(e -> e.getObjType().equals(objType)).findAny().orElse(null);
        }

        public String getObjType() {
            return this.objType;
        }

        public String getTempCode() {
            return this.tempCode;
        }
    }
}

