/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallCommodityPoolBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuOrderQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.dyc.agr.service.agr.AgrGetAgrDetailService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrDetailRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrRelBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocAgreementFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityQryArrivalTimeFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCreateSaleOrderAgrFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocPayConfigInfoFuncBO;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageReqBo;
import com.tydic.dyc.oc.service.bargaining.UocBargainingItemPageRspBo;
import com.tydic.dyc.oc.service.bargaining.UocQryBargainingItemService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocCommodityBatchQryFunctionImpl
implements DycUocCommodityBatchQryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocCommodityBatchQryFunctionImpl.class);
    private static final String PLA = "1";
    private static final String PUR = "0";
    private static final Integer UOC_PUR = 1;
    private static final Integer UOC_PLA = 2;
    private static final String ZQ_PAY = "2";
    private static final String JD_PAY = "1";
    private static final String PRE_PAY = "0";
    private static final Integer UOC_ZQ_PAY = 2;
    private static final Integer UOC_JD_PAY = 1;
    private static final Integer UOC_YF_PAY = 0;
    private static final String PAY_DAY = "2";
    private static final String ASSIGN = "1";
    private static final Integer ECOM_SOURCE = 2;
    private static final String NEED_QRY_ARRIVAL_TIME = "1";
    @Value(value="${uoc.neadQryArrivalTimeConfig:0}")
    private String neadQryArrivalTimeConfig;
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;
    @Autowired
    private AgrGetAgrDetailService agrGetAgrDetailService;
    @Autowired
    private AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    private UocQryBargainingItemService uocQryBargainingItemService;
    @Value(value="${noAgrPayTypeSup:true}")
    private boolean noAgrPayTypeSup;

    @Override
    public DycUocCommodityBatchQryFuncRspBO qryCommodityByBatch(DycUocCommodityBatchQryFuncReqBO reqBO) {
        UccMallSpuOrderListQueryAbilityReqBO uccMallSpuOrderListQueryAbilityReqBO = new UccMallSpuOrderListQueryAbilityReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)uccMallSpuOrderListQueryAbilityReqBO);
        ArrayList<UccMallSkuOrderQryReqBO> skuOrderList = new ArrayList<UccMallSkuOrderQryReqBO>();
        for (DycUocCommodityBatchQryFuncBO uocCommodityBatchQryFuncBO : reqBO.getSkuOrderList()) {
            UccMallSkuOrderQryReqBO uccMallSkuOrderQryReqBO = new UccMallSkuOrderQryReqBO();
            BeanUtils.copyProperties((Object)((Object)uocCommodityBatchQryFuncBO), (Object)uccMallSkuOrderQryReqBO);
            uccMallSkuOrderQryReqBO.setNum(uocCommodityBatchQryFuncBO.getPurchaseCount());
            uccMallSkuOrderQryReqBO.setNumStr(uocCommodityBatchQryFuncBO.getPurchaseCount().toString());
            skuOrderList.add(uccMallSkuOrderQryReqBO);
        }
        uccMallSpuOrderListQueryAbilityReqBO.setSkuOrderList(skuOrderList);
        log.debug("\u8c03\u7528\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)uccMallSpuOrderListQueryAbilityReqBO));
        UccMallSpuOrderListQueryAbilityRspBO uccMallSpuOrderListQueryAbilityRspBO = this.uccMallSpuOrderListQueryAbilityService.querySpuOrderListInfo(uccMallSpuOrderListQueryAbilityReqBO);
        log.debug("\u8c03\u7528\u5546\u54c1\u6279\u91cf\u67e5\u8be2\u51fa\u53c2" + JSON.toJSONString((Object)uccMallSpuOrderListQueryAbilityRspBO));
        if ("0000".equals(uccMallSpuOrderListQueryAbilityRspBO.getRespCode())) {
            int skuCount = 0;
            for (UccMallSpuOrderListQueryBO item : uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList()) {
                skuCount += item.getOrderSkuList().size();
            }
            if (reqBO.getSkuOrderList().size() == skuCount) {
                DycUocCommodityBatchQryFuncRspBO rspBO = this.comparePriceAndAssembleData(reqBO.getSkuOrderList(), uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList(), reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u4e0b\u5355\u5546\u54c1\u4fe1\u606f\u6279\u91cf\u67e5\u8be2\u6210\u529f\uff01");
                if (ObjectUtil.isNotEmpty((Object)reqBO.getBargainingId())) {
                    UocBargainingItemPageReqBo itemPageReqBo = new UocBargainingItemPageReqBo();
                    itemPageReqBo.setBargainingId(reqBO.getBargainingId());
                    itemPageReqBo.setInterfaceType("2");
                    itemPageReqBo.setPageNo(-1);
                    itemPageReqBo.setPageSize(-1);
                    UocBargainingItemPageRspBo itemPageRspBo = this.uocQryBargainingItemService.qryBargainingItemPage(itemPageReqBo);
                    log.info("\u67e5\u8be2\u8bae\u4ef7\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)itemPageRspBo));
                    if ("0000".equals(itemPageRspBo.getRespCode())) {
                        List list = itemPageRspBo.getBasePageRspBo().getRows();
                        Map<String, UocBargainingItemPageBo> itemPageBoMap = list.stream().collect(Collectors.toMap(UocBargainingItemPageBo::getSkuId, e -> e));
                        for (DycUocCommodityFuncBO commodityFuncBO : rspBO.getCommodityInfos()) {
                            if (!ObjectUtil.isNotEmpty((Object)itemPageBoMap.get(commodityFuncBO.getSkuId()))) continue;
                            commodityFuncBO.setSalePrice(itemPageBoMap.get(commodityFuncBO.getSkuId()).getConfirmedPrice());
                            commodityFuncBO.setPurchasePrice(itemPageBoMap.get(commodityFuncBO.getSkuId()).getConfirmedPrice());
                        }
                    } else {
                        log.info("\u67e5\u8be2\u8bae\u4ef7\u5355\u62a5\u9519\uff1a{}", (Object)itemPageRspBo.getRespDesc());
                        throw new ZTBusinessException("\u67e5\u8be2\u8bae\u4ef7\u5355\u4ef7\u683c\u62a5\u9519\uff01" + itemPageRspBo.getRespDesc());
                    }
                }
                return rspBO;
            }
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u4e0b\u5355\u5546\u54c1\u6570\u636e\u67e5\u8be2API\u5931\u8d25\uff1a" + uccMallSpuOrderListQueryAbilityRspBO.getRespDesc());
    }

    private DycUocCommodityQryArrivalTimeFuncBO qryEsCommodityArrivalTime(UccMallSkuDetailInfoBO item, DycUocCommodityBatchQryFuncReqBO reqBO) {
        if ("1".equals(this.neadQryArrivalTimeConfig)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("skuId", (Object)item.getExtSkuId());
            jsonObject.put("num", (Object)Double.valueOf(item.getNum().toString()).intValue());
            jsonObject.put("province", (Object)reqBO.getProvince());
            jsonObject.put("city", (Object)reqBO.getCity());
            jsonObject.put("county", (Object)reqBO.getCounty());
            jsonObject.put("town", (Object)(Objects.isNull(reqBO.getTown()) ? 0L : reqBO.getTown()));
            String callUrl = null;
            if (DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID").equals(String.valueOf(item.getSupplierShopId()))) {
                DycUocCommodityQryArrivalTimeFuncBO submitOrderRsp = new DycUocCommodityQryArrivalTimeFuncBO();
                submitOrderRsp.setRespCode("0000");
                submitOrderRsp.setRespDesc("\u6210\u529f");
                return submitOrderRsp;
            }
            callUrl = DycPropertiesUtil.getProperty((String)"NO_JD_QRY_PROMISE_TIPS_URL");
            String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + item.getSupplierShopId()));
            String jsonString = JSON.toJSONString((Object)jsonObject);
            log.info("\u7535\u5546\u5546\u54c1\u4e0b\u5355\u67e5\u8be2\u9001\u8fbe\u65f6\u95f4\u5165\u53c2:{}", (Object)jsonString);
            log.info("\u7535\u5546\u5546\u54c1\u4e0b\u5355\u67e5\u8be2\u9001\u8fbe\u65f6\u95f4\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
            log.info("\u7535\u5546\u5546\u54c1\u4e0b\u5355\u67e5\u8be2\u9001\u8fbe\u65f6\u95f4\u8bf7\u6c42hsn:{}", (Object)hsn);
            String returnString = DycEsbUtil.doPostReuest((String)callUrl, (String)jsonString, (String)hsn);
            log.info("\u7535\u5546\u5546\u54c1\u4e0b\u5355\u67e5\u8be2\u9001\u8fbe\u65f6\u95f4\u51fa\u53c2: " + returnString);
            return this.resolveRsp(returnString);
        }
        DycUocCommodityQryArrivalTimeFuncBO submitOrderRsp = new DycUocCommodityQryArrivalTimeFuncBO();
        submitOrderRsp.setRespCode("0000");
        submitOrderRsp.setRespDesc("\u6210\u529f");
        return submitOrderRsp;
    }

    private DycUocCommodityQryArrivalTimeFuncBO resolveRsp(String returnString) {
        DycUocCommodityQryArrivalTimeFuncBO submitOrderRsp = new DycUocCommodityQryArrivalTimeFuncBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            String tips = (String)jsonObject.get((Object)"tips");
            submitOrderRsp.setTips(tips);
            String eta = (String)jsonObject.get((Object)"eta");
            try {
                Date date = DateUtils.parseDate((String)eta, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
                submitOrderRsp.setEta(date);
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25\uff01");
            }
            submitOrderRsp.setRespCode("0000");
            submitOrderRsp.setRespDesc("\u6210\u529f");
            return submitOrderRsp;
        }
        submitOrderRsp.setRespCode(rspJsonObject.getString("resultCode"));
        submitOrderRsp.setRespDesc(rspJsonObject.getString("resultMessage"));
        return submitOrderRsp;
    }

    private DycUocCommodityBatchQryFuncRspBO comparePriceAndAssembleData(List<DycUocCommodityBatchQryFuncBO> inputCommodityInfos, List<UccMallSpuOrderListQueryBO> uccSpuInfos, DycUocCommodityBatchQryFuncReqBO reqBO) {
        ArrayList<DycUocCommodityFuncBO> commodityInfos = new ArrayList<DycUocCommodityFuncBO>();
        inputCommodityInfos.forEach(bo -> bo.setSkuIdAndCount(bo.getSkuId() + "_" + bo.getPurchaseCount()));
        Map<String, List<DycUocCommodityBatchQryFuncBO>> inputCommodityInfosMap = inputCommodityInfos.stream().collect(Collectors.groupingBy(DycUocCommodityBatchQryFuncBO::getSkuIdAndCount));
        HashMap<Long, DycUocAgreementFuncBO> resultAgreementInfosMap = new HashMap<Long, DycUocAgreementFuncBO>();
        ArrayList uccSkuInfoList = new ArrayList();
        for (UccMallSpuOrderListQueryBO uccSpuInfo : uccSpuInfos) {
            uccSkuInfoList.addAll(uccSpuInfo.getOrderSkuList());
        }
        Map spuInfoMap = uccSpuInfos.stream().collect(Collectors.toMap(UccMallSpuOrderListQueryBO::getCommodityId, Function.identity()));
        Map<String, List<UccMallSkuDetailInfoBO>> rspSkuMap = uccSkuInfoList.stream().collect(Collectors.groupingBy(UccMallSkuDetailInfoBO::getKey));
        for (Map.Entry<String, List<UccMallSkuDetailInfoBO>> entry : rspSkuMap.entrySet()) {
            List<DycUocCommodityBatchQryFuncBO> reqSkuBOs = inputCommodityInfosMap.get(entry.getKey());
            for (int i = 0; i < entry.getValue().size(); ++i) {
                BaseExtendFieldBo baseExtendFieldBo;
                if (!entry.getValue().get(i).getSalePrice().equals(this.BigDecimal2Long(reqSkuBOs.get(i).getSalePrice())) && ObjectUtil.isEmpty((Object)reqBO.getBargainingId())) {
                    throw new ZTBusinessException(entry.getValue().get(i).getSkuId() + "\u5165\u53c2\u4ef7\u683c\u548c\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u4ef7\u683c\u4e0d\u4e00\u81f4\uff01");
                }
                DycUocCommodityFuncBO commodityInfo = new DycUocCommodityFuncBO();
                BeanUtils.copyProperties((Object)entry.getValue().get(i), (Object)((Object)commodityInfo));
                if (ObjectUtil.isNotEmpty((Object)entry.getValue().get(i).getUccMallLadderPriceBos())) {
                    commodityInfo.setLadderPrice(true);
                }
                commodityInfo.setPlanId(reqSkuBOs.get(i).getPlanId());
                commodityInfo.setPlanNo(reqSkuBOs.get(i).getPlanNo());
                commodityInfo.setPlanItemId(reqSkuBOs.get(i).getPlanItemId());
                commodityInfo.setPlanItemNo(reqSkuBOs.get(i).getPlanItemNo());
                commodityInfo.setOrderPlanBOList(reqSkuBOs.get(i).getOrderPlanBOList());
                commodityInfo.setUnitDigit(reqSkuBOs.get(i).getUnitDigit());
                commodityInfo.setCmpOrderNo(reqSkuBOs.get(i).getCmpOrderNo());
                commodityInfo.setCmpRemark(reqSkuBOs.get(i).getCmpRemark());
                commodityInfo.setNoCmpReason(reqSkuBOs.get(i).getNoCmpReason());
                commodityInfo.setAttachBos(reqSkuBOs.get(i).getAttachBos());
                commodityInfo.setSkuId(String.valueOf(entry.getValue().get(i).getSkuId()));
                commodityInfo.setCommodityId(String.valueOf(entry.getValue().get(i).getCommodityId()));
                commodityInfo.setCommodityTypeId(String.valueOf(entry.getValue().get(i).getCommodityTypeId()));
                commodityInfo.setSupplierId(String.valueOf(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getVendorId()));
                commodityInfo.setSupplierShopId(String.valueOf(entry.getValue().get(i).getSupplierShopId()));
                commodityInfo.setSupplierShopName(entry.getValue().get(i).getShopName());
                commodityInfo.setPurchasePrice(this.Long2BigDecimal(entry.getValue().get(i).getAgreementPrice()));
                commodityInfo.setSalePrice(this.Long2BigDecimal(entry.getValue().get(i).getSalePrice()));
                commodityInfo.setPurchaseCount(entry.getValue().get(i).getNum());
                commodityInfo.setUnitName(entry.getValue().get(i).getMeasureName());
                commodityInfo.setSettleUnit(entry.getValue().get(i).getSettlementUnit());
                commodityInfo.setTax(String.valueOf(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getRate()));
                if (ObjectUtil.isNotEmpty((Object)entry.getValue().get(i).getTaxCatCode())) {
                    log.info("\u8bbe\u7f6e\u5546\u54c1tax\u4fe1\u606f\uff1a{}", (Object)entry.getValue().get(i).getTaxCatCode());
                    commodityInfo.setTaxId(entry.getValue().get(i).getTaxCatCode().toString());
                } else {
                    log.info("\u8bbe\u7f6e\u5546\u54c1tax\u4fe1\u606f\uff1ataxCatCode\u8fd4\u56de\u4e3a\u7a7a\u4e86");
                }
                commodityInfo.setSkuMaterialId(String.valueOf(entry.getValue().get(i).getMaterialId()));
                commodityInfo.setSkuMaterialCode(String.valueOf(entry.getValue().get(i).getMaterialCode()));
                commodityInfo.setSkuBrandId(String.valueOf(entry.getValue().get(i).getBrandId()));
                commodityInfo.setSkuBrandName(entry.getValue().get(i).getBrandName());
                commodityInfo.setSkuMaterialName(entry.getValue().get(i).getMaterialName());
                commodityInfo.setSkuMaterialTypeName(entry.getValue().get(i).getCatalogName());
                commodityInfo.setSkuMaterialTypeId(String.valueOf(entry.getValue().get(i).getCatalogId()));
                commodityInfo.setSkuExtSkuId(entry.getValue().get(i).getExtSkuId());
                commodityInfo.setSkuMainPicUrl(entry.getValue().get(i).getSkuMainPic());
                commodityInfo.setRejectAllowDate(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getRejectAllowDate());
                commodityInfo.setExchangeAllowDate(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getExchangeAllowDate());
                commodityInfo.setMaintainAllowDate(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getMaintainAllowDate());
                commodityInfo.setServerReturnTypeList(((UccMallSpuOrderListQueryBO)spuInfoMap.get(entry.getValue().get(i).getCommodityId())).getServerReturnTypeList());
                if (null != entry.getValue().get(i).getAgreementId()) {
                    commodityInfo.setAgreementId(String.valueOf(entry.getValue().get(i).getAgreementId()));
                    if (null != entry.getValue().get(i).getAgreementDetailsId()) {
                        commodityInfo.setDeliveryTimeDate(this.arrivalSysle(entry.getValue().get(i).getAgreementDetailsId(), entry.getValue().get(i).getAgreementId()));
                    }
                    AgrGetAgrDetailReqBo agrGetAgrDetailReqBo = new AgrGetAgrDetailReqBo();
                    agrGetAgrDetailReqBo.setAgrId(entry.getValue().get(i).getAgreementId());
                    log.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)agrGetAgrDetailReqBo));
                    AgrGetAgrDetailRspBo agrGetAgrDetailRspBo = this.agrGetAgrDetailService.getAgrDetail(agrGetAgrDetailReqBo);
                    log.info("\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)agrGetAgrDetailRspBo));
                    if ("0000".equals(agrGetAgrDetailRspBo.getRespCode())) {
                        List agrContractList;
                        DycUocCreateSaleOrderAgrFuncBO agrFuncBO = (DycUocCreateSaleOrderAgrFuncBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)agrGetAgrDetailRspBo.getAgrMainSaveBO()), DycUocCreateSaleOrderAgrFuncBO.class));
                        agrFuncBO.setAgreementId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrId());
                        agrFuncBO.setAgreementName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrName());
                        agrFuncBO.setAgreementCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrMode());
                        agrFuncBO.setPlaAgreementCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrCode());
                        agrFuncBO.setIsDispatch(agrGetAgrDetailRspBo.getAgrMainSaveBO().getWhetherDispatch() == null ? (byte)1 : agrGetAgrDetailRspBo.getAgrMainSaveBO().getWhetherDispatch().byteValue());
                        agrFuncBO.setSupplierId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierId());
                        agrFuncBO.setSupplierName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getManagementOrgName());
                        agrFuncBO.setVendorId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierId());
                        agrFuncBO.setVendorName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierName());
                        agrFuncBO.setVendorContact(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierContact());
                        agrFuncBO.setVendorPhone(agrGetAgrDetailRspBo.getAgrMainSaveBO().getSupplierPhone());
                        agrFuncBO.setEntAgreementCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getEnAgrCode());
                        agrFuncBO.setProducerId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorId());
                        agrFuncBO.setProducerName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorName());
                        agrFuncBO.setRelCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getRelCode());
                        agrFuncBO.setRelName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getRelName());
                        agrFuncBO.setManagementOrgId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getManagementOrgId());
                        agrFuncBO.setManagementOrgName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getManagementOrgName());
                        agrFuncBO.setAgrSrcName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrcName());
                        agrFuncBO.setAgrSrcCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrcCode());
                        agrFuncBO.setAgrSrcId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrcId());
                        agrFuncBO.setAgrSrc(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrc());
                        agrFuncBO.setAgrSrcStr(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrcStr());
                        if (agrFuncBO.getPrePaySup() == null) {
                            agrFuncBO.setPrePaySup(BigDecimal.ZERO);
                        }
                        if (agrFuncBO.getVerPaySup() == null) {
                            agrFuncBO.setVerPaySup(BigDecimal.ZERO);
                        }
                        if (agrFuncBO.getPilPaySup() == null) {
                            agrFuncBO.setPilPaySup(BigDecimal.ZERO);
                        }
                        if (agrFuncBO.getQuaPaySup() == null) {
                            agrFuncBO.setQuaPaySup(BigDecimal.ZERO);
                        }
                        if (ObjectUtil.isNotEmpty((Object)agrGetAgrDetailRspBo.getAgrRel()) && ObjectUtil.isNotEmpty(agrContractList = agrGetAgrDetailRspBo.getAgrRel().stream().filter(bo -> AgrCommConstant.RelObjType.CONTRACT.equals(bo.getObjType())).collect(Collectors.toList()))) {
                            if (agrContractList.size() != 1) {
                                throw new ZTBusinessException("\u534f\u8bae[" + entry.getValue().get(i).getAgreementId() + "]\u5bf9\u5e94\u7684\u5408\u540c\u7f16\u53f7\u6709\u591a\u4e2a\uff01");
                            }
                            agrFuncBO.setContractId(Long.valueOf(((AgrRelBo)agrContractList.get(0)).getObjId()));
                            agrFuncBO.setContractNo(((AgrRelBo)agrContractList.get(0)).getObjNo());
                        }
                        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrMainExtendBo()));
                        log.info("\u534f\u8bae\u6269\u5c55\u5b57\u6bb5", (Object)jsonObject.toJSONString());
                        ArrayList<BaseExtendFieldBo> extFields = new ArrayList<BaseExtendFieldBo>();
                        for (Map.Entry each : jsonObject.entrySet()) {
                            baseExtendFieldBo = new BaseExtendFieldBo();
                            baseExtendFieldBo.setFieldCode(String.valueOf(each.getKey()));
                            baseExtendFieldBo.setFieldValue(String.valueOf(each.getValue()));
                            extFields.add(baseExtendFieldBo);
                        }
                        agrFuncBO.setExtFields(extFields);
                        commodityInfo.setAgrBo(agrFuncBO);
                        if (!resultAgreementInfosMap.containsKey(entry.getValue().get(i).getAgreementId())) {
                            AgrPayConfigDetailBo payTypeSup;
                            DycUocAgreementFuncBO agreementFuncBO = new DycUocAgreementFuncBO();
                            agreementFuncBO.setAdjustPrice(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAdjustPrice());
                            agreementFuncBO.setAgrDataId(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrId());
                            agreementFuncBO.setAgrId(String.valueOf(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrId()));
                            agreementFuncBO.setProDeliveryId(String.valueOf(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorId()));
                            agreementFuncBO.setProDeliveryName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrOperatorName());
                            agreementFuncBO.setRelCode(agrGetAgrDetailRspBo.getAgrMainSaveBO().getRelCode());
                            agreementFuncBO.setRelName(agrGetAgrDetailRspBo.getAgrMainSaveBO().getRelName());
                            agreementFuncBO.setAgreementVariety(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgreementVariety());
                            agreementFuncBO.setAgreementVarietyStr(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgreementVarietyStr());
                            agreementFuncBO.setAgrSrc(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrc());
                            agreementFuncBO.setAgrSrcStr(agrGetAgrDetailRspBo.getAgrMainSaveBO().getAgrSrcStr());
                            ArrayList<DycUocPayConfigInfoFuncBO> confBos = new ArrayList<DycUocPayConfigInfoFuncBO>();
                            Integer tradeMode = agrGetAgrDetailRspBo.getAgrMainSaveBO().getTradeMode();
                            AgrPayConfigDetailBo payTypePur = agrGetAgrDetailRspBo.getAgrMainSaveBO().getPayTypePur();
                            if (!Objects.isNull(payTypePur) && null != payTypePur.getPayType()) {
                                this.setPayInfo(confBos, payTypePur, tradeMode);
                            }
                            if (!Objects.isNull(payTypeSup = agrGetAgrDetailRspBo.getAgrMainSaveBO().getPayTypeSup())) {
                                this.setPayInfo(confBos, payTypeSup, tradeMode);
                            }
                            if (this.noAgrPayTypeSup && Objects.isNull(payTypeSup) && Objects.isNull(payTypePur)) {
                                this.setPayInfo(confBos, tradeMode);
                            }
                            agreementFuncBO.setConfBos(confBos);
                            resultAgreementInfosMap.put(entry.getValue().get(i).getAgreementId(), agreementFuncBO);
                        }
                    } else {
                        throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1\uff0c\u67e5\u8be2\u534f\u8bae\u4fe1\u606f\u5931\u8d25");
                    }
                }
                if (null != entry.getValue().get(i).getSkuSource() && entry.getValue().get(i).getSkuSource().equals(ECOM_SOURCE)) {
                    DycUocCommodityQryArrivalTimeFuncBO dycUocCommodityQryArrivalTimeFuncBO = this.qryEsCommodityArrivalTime(entry.getValue().get(i), reqBO);
                    if ("0000".equals(dycUocCommodityQryArrivalTimeFuncBO.getRespCode())) {
                        if (!Objects.isNull(dycUocCommodityQryArrivalTimeFuncBO.getEta())) {
                            commodityInfo.setPreOfferTime(dycUocCommodityQryArrivalTimeFuncBO.getEta());
                        }
                    } else {
                        throw new ZTBusinessException("\u7535\u5546\u5546\u54c1\u67e5\u8be2\u9884\u8ba1\u9001\u8fbe\u65f6\u95f4\u5931\u8d25:" + dycUocCommodityQryArrivalTimeFuncBO.getRespDesc());
                    }
                }
                commodityInfo.setExtFields(new ArrayList());
                List poolBOList = entry.getValue().get(i).getUccCommodityPoolList();
                log.info("\u5546\u54c1\u6269\u5c55\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)poolBOList));
                ArrayList<BaseExtendFieldBo> extFields = new ArrayList<BaseExtendFieldBo>();
                if (ObjectUtil.isNotEmpty((Object)poolBOList)) {
                    for (UccMallCommodityPoolBO poolBO : poolBOList) {
                        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)poolBO));
                        for (Map.Entry each : jsonObject.entrySet()) {
                            baseExtendFieldBo = new BaseExtendFieldBo();
                            baseExtendFieldBo.setFieldCode(String.valueOf(each.getKey()));
                            baseExtendFieldBo.setFieldValue(String.valueOf(each.getValue()));
                            extFields.add(baseExtendFieldBo);
                        }
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)reqSkuBOs.get(i).getExtFields())) {
                    commodityInfo.getExtFields().addAll(reqSkuBOs.get(i).getExtFields());
                }
                commodityInfo.getExtFields().addAll(extFields);
                commodityInfos.add(commodityInfo);
            }
        }
        DycUocCommodityBatchQryFuncRspBO rspBO = new DycUocCommodityBatchQryFuncRspBO();
        rspBO.setCommodityInfos(commodityInfos);
        if (!resultAgreementInfosMap.isEmpty()) {
            ArrayList<DycUocAgreementFuncBO> agreementInfos = new ArrayList<DycUocAgreementFuncBO>();
            Iterator agreementInfosIterator = resultAgreementInfosMap.keySet().iterator();
            while (agreementInfosIterator.hasNext()) {
                DycUocAgreementFuncBO agreementInfo = (DycUocAgreementFuncBO)resultAgreementInfosMap.get(agreementInfosIterator.next());
                agreementInfos.add(agreementInfo);
            }
            rspBO.setAgreementInfos(agreementInfos);
        }
        return rspBO;
    }

    private BigDecimal Long2BigDecimal(Long money) {
        try {
            BigDecimal price = MoneyUtils.Long2BigDecimal((Long)money);
            return price;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aLong\u8f6c\u5316\u4e3aBigDecimal\u5f02\u5e38");
        }
    }

    private Long BigDecimal2Long(BigDecimal money) {
        try {
            Long price = MoneyUtils.BigDecimal2Long((BigDecimal)money);
            return price;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff1aBigDecimal\u8f6c\u5316\u4e3aLong\u5f02\u5e38");
        }
    }

    private String arrivalSysle(Long agrItemId, Long agrId) {
        AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
        agrGetAgrItemListReqBO.setAgrId(agrId);
        agrGetAgrItemListReqBO.setAgrItemId(agrItemId);
        agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
        agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
        log.info("\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)agrGetAgrItemListReqBO));
        AgrGetAgrItemListRspBO agrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
        if (!"0000".equals(agrItemListRspBO.getRespCode())) {
            throw new ZTBusinessException(agrItemListRspBO.getRespDesc());
        }
        List agrItemDetailBosList = agrItemListRspBO.getRows();
        if (!CollectionUtils.isEmpty((Collection)agrItemDetailBosList)) {
            AgrItemDetailBo agrItemDetailBo = (AgrItemDetailBo)agrItemDetailBosList.get(0);
            return String.valueOf(agrItemDetailBo.getSupplyCycle());
        }
        return null;
    }

    private void setPayInfo(List<DycUocPayConfigInfoFuncBO> confBos, AgrPayConfigDetailBo agrPayConfigDetailBo, Integer tradeMode) {
        DycUocPayConfigInfoFuncBO agrPayConfInfo = new DycUocPayConfigInfoFuncBO();
        agrPayConfInfo.setModelSettle(tradeMode);
        if (DycFuncCommonConstants.ARGEEMENT_TRADE_MODE.MY.equals(tradeMode.byteValue())) {
            if ("0".equals(String.valueOf(agrPayConfigDetailBo.getPayObj()))) {
                agrPayConfInfo.setUserType(UOC_PUR);
            } else {
                agrPayConfInfo.setUserType(UOC_PLA);
            }
        } else {
            agrPayConfInfo.setUserType(UOC_PUR);
        }
        if ("0".equals(String.valueOf(agrPayConfigDetailBo.getPayType()))) {
            agrPayConfInfo.setPayType(UOC_YF_PAY);
            agrPayConfInfo.setPrePaySup(new BigDecimal(100));
            agrPayConfInfo.setVerPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setPilPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setQuaPaySup(BigDecimal.ZERO);
        } else if ("2".equals(String.valueOf(agrPayConfigDetailBo.getPayType()))) {
            agrPayConfInfo.setPayType(UOC_ZQ_PAY);
            agrPayConfInfo.setPaymentDays(Integer.valueOf(agrPayConfigDetailBo.getSettlementDate()));
            if ("2".equals(agrPayConfigDetailBo.getAssign())) {
                agrPayConfInfo.setPayRule(Integer.valueOf("2"));
                agrPayConfInfo.setPayNodeRule(agrPayConfigDetailBo.getBusiNode());
                agrPayConfInfo.setPaymentDays(Integer.valueOf(agrPayConfigDetailBo.getSettlementDate()));
            } else {
                agrPayConfInfo.setPayRule(Integer.valueOf("1"));
                agrPayConfInfo.setPayAccountDay(Integer.valueOf(agrPayConfigDetailBo.getSettlementDate()));
                agrPayConfInfo.setPayAccountDayRule(agrPayConfigDetailBo.getBusiNode());
            }
            agrPayConfInfo.setPrePaySup(BigDecimal.ZERO);
            agrPayConfInfo.setVerPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setPilPaySup(BigDecimal.ZERO);
            agrPayConfInfo.setQuaPaySup(BigDecimal.ZERO);
        } else if ("1".equals(String.valueOf(agrPayConfigDetailBo.getPayType()))) {
            agrPayConfInfo.setPayType(UOC_JD_PAY);
            agrPayConfInfo.setPrePaySup(agrPayConfigDetailBo.getPrePay());
            agrPayConfInfo.setVerPaySup(agrPayConfigDetailBo.getMatPay());
            agrPayConfInfo.setPilPaySup(agrPayConfigDetailBo.getVerPay());
            agrPayConfInfo.setQuaPaySup(agrPayConfigDetailBo.getQuaPay());
        }
        confBos.add(agrPayConfInfo);
    }

    private void setPayInfo(List<DycUocPayConfigInfoFuncBO> confBos, Integer tradeMode) {
        DycUocPayConfigInfoFuncBO agrPayConfInfo = new DycUocPayConfigInfoFuncBO();
        agrPayConfInfo.setModelSettle(tradeMode);
        confBos.add(agrPayConfInfo);
    }
}

