/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.auditorder.AgrGetAuditObjService;
import com.tydic.dyc.agr.service.procinst.AgrSaveTodoService;
import com.tydic.dyc.agr.service.procinst.bo.AgrSaveTodoReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrSaveTodoRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocTodoBo;
import com.tydic.dyc.atom.selfrun.api.DycAgrDealToDoFunction;
import com.tydic.dyc.atom.selfrun.bo.DycAgrDealToDoFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycAgrDealToDoFuncRspBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.umc.service.todo.UmcQueryToDoItemListService;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoItemListReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcQueryToDoItemListRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendTodoRspBo;
import com.tydic.dyc.umc.service.todo.bo.UmcToDoItemBo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycAgrDealToDoFunctionImpl
implements DycAgrDealToDoFunction {
    private static final Logger log = LoggerFactory.getLogger(DycAgrDealToDoFunctionImpl.class);
    @Autowired
    private AgrSaveTodoService agrSaveTodoService;
    @Autowired
    private UmcQueryToDoItemListService umcQueryToDoItemListService;
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private AgrGetAgrChngApplyDetailService agrGetAgrChngApplyDetailService;
    private static final String TODO_MODULE_CODE = "agr";
    @Autowired
    private AgrGetAuditObjService agrGetAuditObjService;
    @Value(value="${agr.busiType.todoItemCode.map:refer_agr_audit->AGR_AUDIT_ADD_WAIT,agr_audit->AGR_AUDIT_ADD_WAIT,chng_audit->AGR_AUDIT_CHANGE_WAIT,agr_confirm->AGR_CONFIRM_ADD_WAIT,chng_confirm->AGR_CONFIRM_CHANGE_WAIT,agr_edit->AGR_ADD_EDIT}")
    private String[] busiTypeTodoItemCodeMap;
    @Value(value="${agr.busiType.todoCode.map:agr_audit->agr,chng_audit->chng,agr_confirm->agr,chng_confirm->chng,agr_edit->agr}")
    private String[] busiTypeTodoCodeMap;

    @Override
    public DycAgrDealToDoFuncRspBO dealTodo(DycAgrDealToDoFuncReqBO reqBO) {
        DycAgrDealToDoFuncRspBO rspBO = new DycAgrDealToDoFuncRspBO();
        String todoCode = this.getTodoCode(reqBO, rspBO);
        UmcToDoItemBo umcToDoItemBo = this.getTodoItemInfo(reqBO.getBusiType());
        rspBO.setTodoItemCode(umcToDoItemBo.getTodoItemCode());
        return rspBO;
    }

    private void saveTodoInfo(UmcSendTodoRspBo umcSendTodoRspBo, Long orderId, String taskId) {
        List todoList = umcSendTodoRspBo.getTodoList();
        List agrUocTodoBoList = todoList.stream().map(e -> {
            AgrUocTodoBo agrUocTodoBo = (AgrUocTodoBo)JUtil.js((Object)e, AgrUocTodoBo.class);
            agrUocTodoBo.setBusiId(taskId);
            agrUocTodoBo.setOrderId(orderId);
            agrUocTodoBo.setCreateTime(new Date());
            agrUocTodoBo.setTodoState(SscCommConstant.YesOrNoEnum.NO.getCode());
            return agrUocTodoBo;
        }).collect(Collectors.toList());
        AgrSaveTodoReqBO agrSaveTodoReqBO = new AgrSaveTodoReqBO();
        agrSaveTodoReqBO.setAgrUocTodo(agrUocTodoBoList);
        log.info("\u534f\u8bae\u4e2d\u5fc3\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)agrSaveTodoReqBO));
        AgrSaveTodoRspBO agrSaveTodoRspBO = this.agrSaveTodoService.saveTodo(agrSaveTodoReqBO);
        if (!"0000".equals(agrSaveTodoRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u4e2d\u5fc3\u4fdd\u5b58\u5f85\u529e\u4fe1\u606f\u5931\u8d25: " + agrSaveTodoRspBO.getRespDesc());
        }
    }

    private String getTodoCode(DycAgrDealToDoFuncReqBO reqBO, DycAgrDealToDoFuncRspBO rspBO) {
        String todoCode = "";
        for (String busiTypeTodoCode : this.busiTypeTodoCodeMap) {
            String[] temp2 = busiTypeTodoCode.split("->");
            if (!temp2[0].equals(reqBO.getBusiType())) continue;
            todoCode = temp2[1];
        }
        if (StrUtil.isEmpty((CharSequence)todoCode)) {
            throw new ZTBusinessException("\u534f\u8bae\u5f85\u529e\u7f16\u7801\u4e3a\u7a7a");
        }
        if (todoCode.equals(TODO_MODULE_CODE)) {
            AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
            agrGetAgrMainReqBo.setAgrId(reqBO.getOrderId());
            AgrGetAgrMainRspBo agrMain = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
            rspBO.setTodoCode(agrMain.getAgrCode());
            rspBO.setTodoName(agrMain.getAgrName());
            rspBO.setAgrCode(agrMain.getAgrCode());
            todoCode = agrMain.getAgrCode();
            if (agrMain.getAgrType().equals(1)) {
                reqBO.setBusiType("refer_" + reqBO.getBusiType());
            }
        }
        if (todoCode.equals("chng")) {
            AgrGetAgrChngApplyDetailReqBO chngApplyDetailReqBO = new AgrGetAgrChngApplyDetailReqBO();
            chngApplyDetailReqBO.setAgrId(reqBO.getOrderId());
            chngApplyDetailReqBO.setChngApplyId(reqBO.getObjId());
            AgrGetAgrChngApplyDetailRspBO agrChngApplyDetail = this.agrGetAgrChngApplyDetailService.getAgrChngApplyDetail(chngApplyDetailReqBO);
            rspBO.setTodoCode(agrChngApplyDetail.getChngApplyNo());
            rspBO.setAgrCode(agrChngApplyDetail.getAgrCode());
            todoCode = agrChngApplyDetail.getChngApplyNo();
        }
        return todoCode;
    }

    private UmcToDoItemBo getTodoItemInfo(String busiType) {
        String todoTempCode = "";
        for (String busiTypeTodoItemCode : this.busiTypeTodoItemCodeMap) {
            String[] temp1 = busiTypeTodoItemCode.split("->");
            if (!temp1[0].equals(busiType)) continue;
            todoTempCode = temp1[1];
        }
        UmcQueryToDoItemListReqBo itemListReqBo = new UmcQueryToDoItemListReqBo();
        itemListReqBo.setTodoItemCode(todoTempCode);
        itemListReqBo.setTodoModuleCode(TODO_MODULE_CODE);
        UmcQueryToDoItemListRspBo itemListRspBo = this.umcQueryToDoItemListService.queryToDoItemList(itemListReqBo);
        log.info("\u534f\u8bae\u67e5\u8be2\u5f85\u529e\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)itemListRspBo));
        if (!"0000".equals(itemListRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u5f85\u529e\u6a21\u677f\u67e5\u8be2\u5931\u8d25: " + itemListRspBo.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)itemListRspBo.getRows()) || itemListRspBo.getRows().size() != 1) {
            throw new ZTBusinessException("\u534f\u8bae\u4ee3\u529e\u9879\u7f16\u7801\u4e3a\u7a7a\u6216\u4e0d\u552f\u4e00");
        }
        UmcToDoItemBo umcToDoItemBo = (UmcToDoItemBo)itemListRspBo.getRows().get(0);
        return umcToDoItemBo;
    }
}

