/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.supplier.transf.qualif.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.member.task.api.DycUmcAuditProcessCreateFunction;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionReqBo;
import com.tydic.dyc.atom.common.member.task.bo.DycUmcAuditProcessCreateFunctionRspBo;
import com.tydic.dyc.supplier.transf.qualif.api.DycUmcCommonEnterpriseQualifSaveService;
import com.tydic.dyc.supplier.transf.qualif.bo.DycUmcCommonEnterpriseQualifSaveReqBO;
import com.tydic.dyc.supplier.transf.qualif.bo.DycUmcCommonEnterpriseQualifSaveRspBO;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.service.domainservice.UmcApproveCreateService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcApproveCreateServiceReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcApproveCreateServiceRspBo;
import com.tydic.dyc.umc.service.qualif.bo.UmcEnterpriseQualifSaveAbilityReqBO;
import com.tydic.dyc.umc.service.qualif.bo.UmcEnterpriseQualifSaveAbilityRspBO;
import com.tydic.dyc.umc.service.qualif.service.UmcEnterpriseQualifSaveAbilityService;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.supplier.transf.qualif.api.DycUmcCommonEnterpriseQualifSaveService"})
public class DycUmcCommonEnterpriseQualifSaveServiceImpl
implements DycUmcCommonEnterpriseQualifSaveService {
    @Autowired
    private UmcEnterpriseQualifSaveAbilityService umcEnterpriseQualifSaveAbilityService;
    @Autowired
    private UmcApproveCreateService umcApproveCreateService;
    @Autowired
    private DycUmcAuditProcessCreateFunction dycUmcAuditProcessCreateFunction;
    @Value(value="${SYS_CODE:DYC}")
    private String sys_code;
    @Value(value="${enterprise_qualif_audit_key:supplier_qualification_approval}")
    private String enterprise_qualif_audit_key;
    @Value(value="${qualif_audit_flag:false}")
    private Boolean qualif_audit_flag;

    @Override
    @PostMapping(value={"saveEnterpriseQualif"})
    public DycUmcCommonEnterpriseQualifSaveRspBO saveEnterpriseQualif(@RequestBody DycUmcCommonEnterpriseQualifSaveReqBO reqBO) {
        String jsonString = JSONObject.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        UmcEnterpriseQualifSaveAbilityReqBO abilityReqBO = (UmcEnterpriseQualifSaveAbilityReqBO)JSONObject.parseObject((String)jsonString, UmcEnterpriseQualifSaveAbilityReqBO.class);
        if (this.qualif_audit_flag.booleanValue()) {
            abilityReqBO.setAuditStatus("1");
        } else {
            abilityReqBO.setAuditStatus("2");
        }
        UmcEnterpriseQualifSaveAbilityRspBO abilityRspBO = this.umcEnterpriseQualifSaveAbilityService.saveEnterpriseQualif(abilityReqBO);
        if ("0000".equals(abilityRspBO.getRespCode())) {
            if (this.qualif_audit_flag.booleanValue()) {
                this.startProcess(reqBO, abilityRspBO.getQualifId());
            }
            DycUmcCommonEnterpriseQualifSaveRspBO rspBO = new DycUmcCommonEnterpriseQualifSaveRspBO();
            rspBO.setCode(abilityRspBO.getRespCode());
            rspBO.setMessage(abilityRspBO.getRespDesc());
            return rspBO;
        }
        throw new ZTBusinessException(abilityRspBO.getRespDesc());
    }

    public void startProcess(DycUmcCommonEnterpriseQualifSaveReqBO reqBo, Long qualifId) {
        UmcApproveCreateServiceReqBo umcApproveCreateServiceReqBo = new UmcApproveCreateServiceReqBo();
        umcApproveCreateServiceReqBo.setObjBusiType(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_QUALIF);
        umcApproveCreateServiceReqBo.setOrderId(qualifId);
        umcApproveCreateServiceReqBo.setUserId(reqBo.getUserId());
        umcApproveCreateServiceReqBo.setUsername(reqBo.getUserName());
        umcApproveCreateServiceReqBo.setObjType(UmcCommConstant.OBJ_BUSI_TYPE.ENTERPRISE_QUALIF);
        umcApproveCreateServiceReqBo.setObjId(qualifId);
        UmcApproveCreateServiceRspBo umcApproveCreateServiceRspBo = this.umcApproveCreateService.createApprove(umcApproveCreateServiceReqBo);
        if (!"0000".equals(umcApproveCreateServiceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u4f1a\u5458\u5ba1\u6279\u5355\u5931\u8d25");
        }
        DycUmcAuditProcessCreateFunctionReqBo abilityReqBO = new DycUmcAuditProcessCreateFunctionReqBo();
        abilityReqBO.setOrgId(Convert.toStr((Object)reqBo.getOrgId()));
        ArrayList<String> busiList = new ArrayList<String>();
        busiList.add(qualifId.toString());
        abilityReqBO.setBusinessIdList(busiList);
        abilityReqBO.setProcDefKey(this.enterprise_qualif_audit_key);
        abilityReqBO.setSysCode(this.sys_code);
        abilityReqBO.setUserId(reqBo.getUserId().toString());
        abilityReqBO.setUserName(reqBo.getUserName());
        abilityReqBO.setOrgName(reqBo.getOrgName());
        abilityReqBO.setBusinessType("SUP_BASE_INFO_AUDIT");
        abilityReqBO.setPartitionKey(qualifId.toString());
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("auditId", umcApproveCreateServiceRspBo.getAuditOrderId());
        abilityReqBO.setVariables(map);
        DycUmcAuditProcessCreateFunctionRspBo abilityRspBO = this.dycUmcAuditProcessCreateFunction.createProcess(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
    }
}

