/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.dyc.agr.bo.AgrItemBo;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrItemService;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrCodeService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainSaveBo;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigBo;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAgrImportFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrImportFuncReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrImportFuncRspBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrMainImportFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrImportFailReasonFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrItemFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycCommonImportFailReasonFuncBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycAgrAgrImportFunctionImpl
implements DycAgrAgrImportFunction {
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    AgrCreateAgrItemService agrCreateAgrItemService;
    @Autowired
    AgrGetAgrItemListService agrGetAgrItemListService;
    @Autowired
    AgrCreateAgrService agrCreateAgrService;
    @Autowired
    private AgrGetAgrCodeService agrGetAgrCodeService;

    @Override
    public DycAgrAgrImportFuncRspBO dealAgrImport(DycAgrAgrImportFuncReqBO reqBO) {
        ArrayList<DycCommonImportFailReasonFuncBO> failReasonBOs = new ArrayList<DycCommonImportFailReasonFuncBO>();
        if (ObjectUtil.isNotEmpty(reqBO.getAgrMain())) {
            this.importAgr(failReasonBOs, reqBO);
        }
        if (ObjectUtil.isNotEmpty(reqBO.getAgrItem())) {
            this.importAgrItem(failReasonBOs, reqBO);
        }
        DycAgrAgrImportFuncRspBO rspBO = new DycAgrAgrImportFuncRspBO();
        rspBO.setFailReasonList(failReasonBOs);
        rspBO.setRespCode("0000");
        rspBO.setAgrMain(reqBO.getAgrMain());
        return rspBO;
    }

    private void importAgrItem(List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrImportFuncReqBO reqBO) {
        ArrayList<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS = new ArrayList<DycAgrImportFailReasonFuncBO>();
        this.validPuplicate(reqBO.getAgrItem(), dycAgrImportFailReasonFuncBOS, reqBO.getAgrId());
        if (dycAgrImportFailReasonFuncBOS.size() == 0) {
            this.saveAgrItem(reqBO);
        } else {
            HashMap<Integer, String> errorMsgMap = new HashMap<Integer, String>();
            dycAgrImportFailReasonFuncBOS.forEach(dycAgrImportFailReasonFuncBO -> {
                String msg = (String)errorMsgMap.get(errorMsgMap.get(dycAgrImportFailReasonFuncBO.getLineNum()));
                msg = msg != null ? msg + ",\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason() : "\u884c\u3010" + dycAgrImportFailReasonFuncBO.getLineNum() + "\u3011\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason();
                errorMsgMap.put(dycAgrImportFailReasonFuncBO.getLineNum(), msg);
            });
            errorMsgMap.forEach((k, v) -> {
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setLineNum((Integer)k);
                bo.setFailReason((String)v);
                failReasonBOs.add(bo);
            });
        }
    }

    private void importAgr(List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrImportFuncReqBO reqBO) {
        ArrayList dycAgrImportFailReasonFuncBOS = new ArrayList();
        reqBO.getAgrMain().forEach(dycAgrAgrMainImportFuncBO -> {
            if (ObjectUtil.isNotEmpty(dycAgrAgrMainImportFuncBO.getAgrItem())) {
                this.validPuplicate(dycAgrAgrMainImportFuncBO.getAgrItem(), dycAgrImportFailReasonFuncBOS, null);
            }
        });
        if (failReasonBOs.size() == 0) {
            reqBO.getAgrMain().forEach(dycAgrAgrMainImportFuncBO -> {
                AgrGetAgrCodeReqBO agrGetAgrCodeReqBO = (AgrGetAgrCodeReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrGetAgrCodeReqBO.class);
                AgrGetAgrCodeRspBO agrGetAgrCodeRspBO = this.agrGetAgrCodeService.getAgrCode(agrGetAgrCodeReqBO);
                if (!"0000".equals(agrGetAgrCodeRspBO.getRespCode())) {
                    throw new ZTBusinessException(agrGetAgrCodeRspBO.getRespDesc());
                }
                dycAgrAgrMainImportFuncBO.setAgrCode(agrGetAgrCodeRspBO.getPlaAgreementCode());
                this.saveAgr((DycAgrAgrMainImportFuncBO)dycAgrAgrMainImportFuncBO, reqBO);
            });
        } else {
            HashMap<Integer, String> errorMsgMap = new HashMap<Integer, String>();
            dycAgrImportFailReasonFuncBOS.forEach(dycAgrImportFailReasonFuncBO -> {
                String msg = (String)errorMsgMap.get(errorMsgMap.get(dycAgrImportFailReasonFuncBO.getLineNum()));
                msg = msg != null ? msg + ",\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason() : "\u534f\u8bae\u660e\u7ec6\u884c\u3010" + dycAgrImportFailReasonFuncBO.getLineNum() + "\u3011\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason();
                errorMsgMap.put(dycAgrImportFailReasonFuncBO.getLineNum(), msg);
            });
            errorMsgMap.forEach((k, v) -> {
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setFailReason((String)v);
                bo.setLineNum((Integer)k);
                failReasonBOs.add(bo);
            });
        }
    }

    private void saveAgr(DycAgrAgrMainImportFuncBO agrMain, DycAgrAgrImportFuncReqBO reqBO) {
        AgrCreateAgrReqBo agrCreateAgrReqBo = (AgrCreateAgrReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrCreateAgrReqBo.class);
        AgrMainSaveBo agrMainSaveBO = new AgrMainSaveBo();
        BeanUtils.copyProperties((Object)agrMain, (Object)agrMainSaveBO);
        agrMainSaveBO.setAgrOperatorId(reqBO.getUserId());
        agrMainSaveBO.setAgrOperatorName(reqBO.getName());
        agrMainSaveBO.setAgrOperatorUsername(reqBO.getUsername());
        if (ObjectUtil.isNotEmpty((Object)agrMain.getAgrAppScopeCode())) {
            ArrayList<AgrAppScopeBo> agrAppScopeBOs = new ArrayList<AgrAppScopeBo>();
            AgrAppScopeBo agrAppScopeBo = new AgrAppScopeBo();
            agrAppScopeBo.setScopeCode(agrMain.getAgrAppScopeCode());
            agrAppScopeBo.setScopeName(agrMain.getAgrAppScopeName() + "");
            agrAppScopeBOs.add(agrAppScopeBo);
            agrCreateAgrReqBo.setAgrAppScopeBOs(agrAppScopeBOs);
        }
        if (ObjectUtil.isNotEmpty((Object)agrMain.getPayTypePur())) {
            AgrPayConfigBo payTypePur = new AgrPayConfigBo();
            payTypePur.setPayType(agrMain.getPayTypePur());
            payTypePur.setAssign(agrMain.getAssignPur());
            payTypePur.setBusiNode(agrMain.getBusiNodePur());
            payTypePur.setCurrency(agrMain.getCurrencyPur());
            payTypePur.setMatPay(agrMain.getMatPayPur());
            payTypePur.setPilPay(agrMain.getPilPayPur());
            payTypePur.setPrePay(agrMain.getPrePayPur());
            payTypePur.setProPay(agrMain.getProPayPur());
            payTypePur.setQuaPay(agrMain.getQuaPayPur());
            payTypePur.setServiceRate(agrMain.getServiceRatePur());
            payTypePur.setSettlementDate(agrMain.getSettlementDatePur());
            payTypePur.setSettlementMonth(agrMain.getSettlementMonthPur());
            payTypePur.setTaxRate(agrMain.getTaxRatePur());
            payTypePur.setVerPay(agrMain.getVerPayPur());
            agrMainSaveBO.setPayTypePur(payTypePur);
        }
        if (ObjectUtil.isNotEmpty((Object)agrMain.getPayTypeSup())) {
            AgrPayConfigBo payTypeSup = new AgrPayConfigBo();
            payTypeSup.setPayType(agrMain.getPayTypeSup());
            payTypeSup.setAssign(agrMain.getAssignSup());
            payTypeSup.setBusiNode(agrMain.getBusiNodeSup());
            payTypeSup.setCurrency(agrMain.getCurrencySup());
            payTypeSup.setMatPay(agrMain.getMatPaySup());
            payTypeSup.setPilPay(agrMain.getPilPaySup());
            payTypeSup.setPrePay(agrMain.getPrePaySup());
            payTypeSup.setProPay(agrMain.getProPaySup());
            payTypeSup.setQuaPay(agrMain.getQuaPaySup());
            payTypeSup.setServiceRate(agrMain.getServiceRateSup());
            payTypeSup.setSettlementDate(agrMain.getSettlementDateSup());
            payTypeSup.setSettlementMonth(agrMain.getSettlementMonthSup());
            payTypeSup.setTaxRate(agrMain.getTaxRateSup());
            payTypeSup.setVerPay(agrMain.getVerPaySup());
            agrMainSaveBO.setPayTypePur(payTypeSup);
        }
        if (ObjectUtil.isNotEmpty(agrMain.getAgrItem())) {
            agrCreateAgrReqBo.setAgrItem(JSON.parseArray((String)JSON.toJSONString(agrMain.getAgrItem()), AgrItemBo.class));
        }
        agrCreateAgrReqBo.setAgrMainSaveBO(agrMainSaveBO);
        AgrCreateAgrRspBo agrCreateAgrRspBo = this.agrCreateAgrService.createAgr(agrCreateAgrReqBo);
        if (!"0000".equals(agrCreateAgrRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u65b0\u589e\u8c03\u7528\u5931\u8d25" + agrCreateAgrRspBo.getRespDesc());
        }
        agrMain.setAgrId(agrCreateAgrRspBo.getAgrId());
    }

    private void saveAgrItem(DycAgrAgrImportFuncReqBO reqBO) {
        AgrCreateAgrItemReqBo agrCreateAgrItemReqBo = new AgrCreateAgrItemReqBo();
        agrCreateAgrItemReqBo.setAgrId(reqBO.getAgrId());
        ArrayList<AgrItemBo> agrItem = new ArrayList<AgrItemBo>();
        for (int i = 0; i < reqBO.getAgrItem().size(); ++i) {
            AgrItemBo bo = (AgrItemBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrItem().get(i)), AgrItemBo.class);
            if (bo.getMarkupRate() == null) {
                bo.setMarkupRate(new BigDecimal("0"));
            }
            bo.setBuyPriceSum(bo.getBuyPrice().multiply(bo.getBuyNumber()));
            bo.setSalePrice(bo.getBuyPrice().add(bo.getBuyPrice().multiply(bo.getMarkupRate())));
            bo.setSalePriceSum(bo.getSalePrice().multiply(bo.getBuyNumber()));
            bo.setSerialNumber(Integer.valueOf(i));
            agrItem.add(bo);
        }
        agrCreateAgrItemReqBo.setAgrItem(agrItem);
        AgrCreateAgrItemRspBo agrCreateAgrItemRspBo = this.agrCreateAgrItemService.createAgrItem(agrCreateAgrItemReqBo);
        if (!"0000".equals(agrCreateAgrItemRspBo.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u65b0\u589e\u5931\u8d25" + agrCreateAgrItemRspBo.getRespDesc());
        }
    }

    private void uccCheck(List<DycAgrItemFuncBO> agrItem, List<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS) {
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        ArrayList<UccAgrSkuImportCheckBO> rows = new ArrayList<UccAgrSkuImportCheckBO>();
        for (int i = 0; i < agrItem.size(); ++i) {
            DycAgrItemFuncBO DycAgrItemFuncBO2 = agrItem.get(i);
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(Integer.valueOf(i));
            bo.setCommodityTypeName(DycAgrItemFuncBO2.getCommodityTypeName());
            bo.setCatalogCode(DycAgrItemFuncBO2.getCatalogCode());
            bo.setMaterialCode(DycAgrItemFuncBO2.getMaterialCode());
            bo.setMeasureName(DycAgrItemFuncBO2.getMeasureName());
            rows.add(bo);
        }
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        UccAgrSkuImportCheckAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        if (!"0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u4e2d\u5fc3\u6821\u9a8c\u8c03\u7528\u5931\u8d25" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
        }
        Map uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckBO::getSerialNumber, Function.identity()));
        for (int i = 0; i < agrItem.size(); ++i) {
            if (((UccAgrSkuImportCheckBO)uccRspMap.get(i)).isPass()) {
                agrItem.get(i).setMeasureId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMeasureId());
                agrItem.get(i).setMaterialId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMaterialId().toString());
                agrItem.get(i).setCatalogId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCatalogId().toString());
                agrItem.get(i).setCommodityTypeId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCommodityTypeId());
                continue;
            }
            DycAgrImportFailReasonFuncBO failReasonBO = new DycAgrImportFailReasonFuncBO();
            failReasonBO.setLineNum(agrItem.get(i).getGluttonLineNum());
            failReasonBO.setFailReason(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getReson());
            failReasonBO.setColumnNo(agrItem.get(i).getColumnNo());
            dycAgrImportFailReasonFuncBOS.add(failReasonBO);
        }
    }

    private void validPuplicate(List<DycAgrItemFuncBO> agrItem, List<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS, Long agrId) {
        ArrayList uniqueKeys = new ArrayList();
        HashMap uniqueKeyMap = new HashMap();
        agrItem.forEach(dycAgrItemFuncBO -> {
            String key = dycAgrItemFuncBO.getCommodityTypeId() + "_" + dycAgrItemFuncBO.getMaterialCode();
            if (uniqueKeyMap.get(key) != null) {
                DycAgrImportFailReasonFuncBO failReasonBO = new DycAgrImportFailReasonFuncBO();
                failReasonBO.setFailReason("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                failReasonBO.setLineNum(dycAgrItemFuncBO.getGluttonLineNum());
                failReasonBO.setColumnNo(dycAgrItemFuncBO.getColumnNo());
                dycAgrImportFailReasonFuncBOS.add(failReasonBO);
            } else {
                uniqueKeyMap.put(key, dycAgrItemFuncBO);
                uniqueKeys.add(key);
            }
        });
        if (uniqueKeys.size() > 0 && agrId != null) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setAgrId(agrId);
            agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25" + agrGetAgrItemListRspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
                agrGetAgrItemListRspBO.getRows().forEach(agrItemDetailBo -> {
                    DycAgrImportFailReasonFuncBO failReasonBO = new DycAgrImportFailReasonFuncBO();
                    failReasonBO.setLineNum(((DycAgrItemFuncBO)uniqueKeyMap.get(agrItemDetailBo.getUniqueKey())).getGluttonLineNum());
                    failReasonBO.setColumnNo(((DycAgrItemFuncBO)uniqueKeyMap.get(agrItemDetailBo.getUniqueKey())).getColumnNo());
                    failReasonBO.setFailReason("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                    dycAgrImportFailReasonFuncBOS.add(failReasonBO);
                });
            }
        }
    }
}

