/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryItemAbilityService;
import com.tydic.contract.ability.UpdateContractInfoAbilityService;
import com.tydic.contract.ability.bo.ContractQryItemAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryItemAbilityRspBO;
import com.tydic.contract.ability.bo.UpdateContractInfoAbilityReqBO;
import com.tydic.contract.ability.bo.UpdateContractInfoAbilityRspBO;
import com.tydic.dyc.agr.bo.AgrItemBo;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrItemService;
import com.tydic.dyc.agr.service.agr.AgrCreateAgrService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrCodeService;
import com.tydic.dyc.agr.service.agr.AgrGetAgrMainService;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrService;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrItemRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrCreateAgrRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrCodeRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrRspBo;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAgrSaveAndSubmitFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrSaveAndSubmitFuncReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrSaveAndSubmitFuncRspBO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycAgrAgrSaveAndSubmitFunctionImpl
implements DycAgrAgrSaveAndSubmitFunction {
    private static final Logger log = LoggerFactory.getLogger(DycAgrAgrSaveAndSubmitFunctionImpl.class);
    @Autowired
    private AgrGetAgrMainService agrGetAgrMainService;
    @Autowired
    private AgrCreateAgrService agrCreateAgrService;
    @Autowired
    private AgrUpdateAgrService agrUpdateAgrService;
    @Autowired
    private AgrGetAgrCodeService agrGetAgrCodeService;
    @Autowired
    private UpdateContractInfoAbilityService updateContractInfoAbilityService;
    @Autowired
    private ContractQryItemAbilityService contractQryItemAbilityService;
    @Autowired
    private AgrCreateAgrItemService agrCreateAgrItemService;
    private static final Integer IS_QUOTE_FLAG = 1;

    @Override
    public DycAgrAgrSaveAndSubmitFuncRspBO dealAgrSaveAndSubmit(DycAgrAgrSaveAndSubmitFuncReqBO reqBO) {
        DycAgrAgrSaveAndSubmitFuncRspBO rspBo = new DycAgrAgrSaveAndSubmitFuncRspBO();
        Long agrId = reqBO.getAgrId();
        String respDesc = this.checkAgrCode(reqBO);
        if (agrId == null) {
            AgrCreateAgrReqBo agrCreateAgrReqBo = (AgrCreateAgrReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), AgrCreateAgrReqBo.class);
            AgrCreateAgrRspBo agrCreateAgrRspBo = this.agrCreateAgrService.createAgr(agrCreateAgrReqBo);
            if (!"0000".equals(agrCreateAgrRspBo.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u65b0\u589e\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrCreateAgrRspBo.getRespCode() + "\u3011," + agrCreateAgrRspBo.getRespDesc());
            }
            this.updateContractInfo(reqBO);
            agrCreateAgrRspBo.setAgrId(agrCreateAgrRspBo.getAgrId());
            rspBo.setAgrId(agrCreateAgrRspBo.getAgrId());
            this.agrCreateAgrItem(reqBO, rspBo.getAgrId());
        } else {
            AgrUpdateAgrReqBo agrUpdateAgrReqBo = (AgrUpdateAgrReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), AgrUpdateAgrReqBo.class);
            AgrUpdateAgrRspBo agrUpdateAgrRspBo = this.agrUpdateAgrService.updateAgr(agrUpdateAgrReqBo);
            if (!"0000".equals(agrUpdateAgrRspBo.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4fee\u6539\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrUpdateAgrRspBo.getRespCode() + "\u3011," + agrUpdateAgrRspBo.getRespDesc());
            }
        }
        rspBo.setRespDesc(respDesc);
        rspBo.setRespCode("0000");
        return rspBo;
    }

    private String checkAgrCode(DycAgrAgrSaveAndSubmitFuncReqBO reqBO) {
        String rspStr = "\u64cd\u4f5c\u6210\u529f";
        AgrGetAgrMainReqBo agrGetAgrMainReqBo = new AgrGetAgrMainReqBo();
        agrGetAgrMainReqBo.setAgrId(reqBO.getAgrId());
        agrGetAgrMainReqBo.setAgrCode(reqBO.getAgrMainSaveBO().getAgrCode());
        AgrGetAgrMainRspBo agrMain = this.agrGetAgrMainService.getAgrMain(agrGetAgrMainReqBo);
        if (!"0000".equals(agrMain.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4e3b\u4f53\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrMain.getRespCode() + "\u3011," + agrMain.getRespDesc());
        }
        if (reqBO.getAgrId() == null && StringUtils.hasText((String)agrMain.getAgrCode())) {
            AgrGetAgrCodeReqBO agrGetAgrCodeReqBO = (AgrGetAgrCodeReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), AgrGetAgrCodeReqBO.class);
            AgrGetAgrCodeRspBO agrGetAgrCodeRspBO = this.agrGetAgrCodeService.getAgrCode(agrGetAgrCodeReqBO);
            if (!"0000".equals(agrGetAgrCodeRspBO.getRespCode())) {
                throw new ZTBusinessException(agrGetAgrCodeRspBO.getRespDesc());
            }
            rspStr = "\u7f16\u53f7" + reqBO.getAgrMainSaveBO().getAgrCode() + "\u91cd\u590d\u5df2\u81ea\u52a8\u91cd\u65b0\u83b7\u53d6\u7f16\u53f7" + agrGetAgrCodeRspBO.getPlaAgreementCode();
            reqBO.getAgrMainSaveBO().setAgrCode(agrGetAgrCodeRspBO.getPlaAgreementCode());
            return rspStr;
        }
        return rspStr;
    }

    private void updateContractInfo(DycAgrAgrSaveAndSubmitFuncReqBO reqBO) {
        if (ObjectUtil.isNotEmpty(reqBO.getAgrRel())) {
            reqBO.getAgrRel().forEach(agrRel -> {
                if (StringUtils.hasText((String)agrRel.getObjId())) {
                    UpdateContractInfoAbilityReqBO updateContractInfoAbilityReqBO = new UpdateContractInfoAbilityReqBO();
                    updateContractInfoAbilityReqBO.setContractId(Long.valueOf(Long.parseLong(agrRel.getObjId())));
                    updateContractInfoAbilityReqBO.setIsQuoteFlag(IS_QUOTE_FLAG);
                    log.debug("\u8c03\u7528\u5408\u540c\u540c\u6b65\u5165\u53c2================================" + updateContractInfoAbilityReqBO);
                    UpdateContractInfoAbilityRspBO updateContractInfoAbilityRspBO = this.updateContractInfoAbilityService.updateContractInfo(updateContractInfoAbilityReqBO);
                    log.debug("\u8c03\u7528\u5408\u540c\u540c\u6b65\u51fa\u53c2================================" + updateContractInfoAbilityRspBO);
                    if (!"0000".equals(updateContractInfoAbilityRspBO.getRespCode())) {
                        throw new ZTBusinessException(updateContractInfoAbilityRspBO.getRespDesc());
                    }
                }
            });
        }
    }

    private void agrCreateAgrItem(DycAgrAgrSaveAndSubmitFuncReqBO reqBO, Long agrId) {
        String relateId;
        if (ObjectUtil.isNotEmpty(reqBO.getAgrRel()) && StringUtils.hasText((String)(relateId = reqBO.getAgrRel().get(0).getObjId()))) {
            ContractQryItemAbilityReqBO contractQryItemAbilityReqBO = new ContractQryItemAbilityReqBO();
            contractQryItemAbilityReqBO.setRelateId(Long.valueOf(Long.parseLong(relateId)));
            contractQryItemAbilityReqBO.setPageNo(Integer.valueOf(1));
            contractQryItemAbilityReqBO.setPageSize(Integer.valueOf(1000));
            log.debug("\u8c03\u7528\u5408\u540c\u660e\u7ec6\u63a5\u53e3\u5165\u53c2================================" + contractQryItemAbilityReqBO);
            ContractQryItemAbilityRspBO contractQryItemAbilityRspBO = this.contractQryItemAbilityService.qryContractItem(contractQryItemAbilityReqBO);
            if (!"0000".equals(contractQryItemAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException(contractQryItemAbilityRspBO.getRespDesc());
            }
            log.debug("\u8c03\u7528\u5408\u540c\u660e\u7ec6\u63a5\u53e3\u51fa\u53c2================================" + contractQryItemAbilityRspBO);
            if (contractQryItemAbilityRspBO.getTotal() > 0) {
                int total = contractQryItemAbilityRspBO.getTotal();
                for (int i = 1; i <= total; ++i) {
                    contractQryItemAbilityReqBO.setPageNo(Integer.valueOf(i));
                    contractQryItemAbilityReqBO.setPageSize(Integer.valueOf(1000));
                    ContractQryItemAbilityRspBO contractQryItemAbilityRspBO1 = this.contractQryItemAbilityService.qryContractItem(contractQryItemAbilityReqBO);
                    ArrayList agrItemBos = new ArrayList();
                    contractQryItemAbilityRspBO1.getRows().forEach(r -> {
                        AgrItemBo agrItemBo = new AgrItemBo();
                        agrItemBo.setAgrId(agrId);
                        agrItemBo.setAgrItemId(r.getItemId());
                        agrItemBo.setCatalogId(r.getMaterialTypeId());
                        agrItemBo.setCatalogName(r.getMaterialType());
                        agrItemBo.setMaterialId(r.getMaterialId() + "");
                        agrItemBo.setMaterialCode(r.getMaterialCode());
                        agrItemBo.setMaterialName(r.getMaterialName());
                        agrItemBo.setModel(r.getModel());
                        agrItemBo.setSpec(r.getSpec());
                        agrItemBo.setBrandName(r.getBrand());
                        agrItemBo.setSupplyCycle(r.getSupplyCycle());
                        agrItemBo.setBuyNumber(r.getBuyCount());
                        agrItemBo.setMeasureName(r.getUnitName());
                        agrItemBo.setSalePrice(r.getUnitPriceMoney());
                        agrItemBo.setSalePriceSum(r.getTotalAmountMoney());
                        agrItemBos.add(agrItemBo);
                    });
                    AgrCreateAgrItemReqBo agrCreateAgrItemReqBo = new AgrCreateAgrItemReqBo();
                    agrCreateAgrItemReqBo.setAgrId(agrId);
                    agrCreateAgrItemReqBo.setAgrItem(agrItemBos);
                    log.debug("\u8c03\u7528\u534f\u8bae\u660e\u7ec6\u65b0\u589e\u63a5\u53e3\u5165\u53c2================================" + agrCreateAgrItemReqBo);
                    AgrCreateAgrItemRspBo agrCreateAgrItemRspBo = this.agrCreateAgrItemService.createAgrItem(agrCreateAgrItemReqBo);
                    if ("0000".equals(agrCreateAgrItemRspBo.getRespCode())) continue;
                    throw new ZTBusinessException(agrCreateAgrItemRspBo.getRespDesc());
                }
            }
        }
    }
}

