/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.agr.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.zone.ability.api.UccAgrSkuImportCheckAbilityService;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityReqBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckAbilityRspBO;
import com.tydic.commodity.zone.ability.bo.UccAgrSkuImportCheckBO;
import com.tydic.dyc.agr.service.agr.AgrGetAgrItemListService;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrItemListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrItemDetailBo;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainRspBO;
import com.tydic.dyc.agr.service.agrchange.AgrCreateAgrItemChngService;
import com.tydic.dyc.agr.service.agrchange.AgrCreateArgChngApplyService;
import com.tydic.dyc.agr.service.agrchange.AgrCreateArgMainChngService;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngCodeService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrAppScopeChngBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateAgrItemChngRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgChngApplyReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgChngApplyRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgMainChngReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrCreateArgMainChngRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngCodeRspBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrMainChngBo;
import com.tydic.dyc.agr.service.agrchange.bo.AgrPayConfigChngBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrSyncUccService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccRspBO;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAgrChngImportFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrChngImportFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrChngImportFuncReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAgrChngImportFuncRspBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrImportFailReasonFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrItemChngFuncBO;
import com.tydic.dyc.atom.zone.agr.bo.DycCommonImportFailReasonFuncBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycAgrAgrChngImportFunctionImpl
implements DycAgrAgrChngImportFunction {
    @Autowired
    private UccAgrSkuImportCheckAbilityService uccAgrSkuImportCheckAbilityService;
    @Autowired
    private AgrCreateAgrItemChngService agrCreateAgrItemChngService;
    @Autowired
    private AgrCreateArgMainChngService agrCreateArgMainChngService;
    @Autowired
    private AgrCreateArgChngApplyService agrCreateArgChngApplyService;
    @Autowired
    private AgrUpdateAgrMainService agrUpdateAgrMainService;
    @Autowired
    private AgrSyncUccService agrSyncUccService;
    @Autowired
    private AgrGetAgrChngCodeService agrGetAgrChngCodeService;
    @Autowired
    AgrGetAgrItemListService agrGetAgrItemListService;

    @Override
    public DycAgrAgrChngImportFuncRspBO dealAgrChngImport(DycAgrAgrChngImportFuncReqBO reqBO) {
        ArrayList<DycCommonImportFailReasonFuncBO> failReasonBOs = new ArrayList<DycCommonImportFailReasonFuncBO>();
        if (ObjectUtil.isNotEmpty(reqBO.getAgrChng())) {
            this.importAgrChng(failReasonBOs, reqBO);
        }
        if (ObjectUtil.isNotEmpty(reqBO.getAgrItemChng())) {
            this.importAgrItemChng(failReasonBOs, reqBO);
        }
        DycAgrAgrChngImportFuncRspBO rspBO = new DycAgrAgrChngImportFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setFailReasonList(failReasonBOs);
        return rspBO;
    }

    private void importAgrItemChng(List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrChngImportFuncReqBO reqBO) {
        ArrayList<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS = new ArrayList<DycAgrImportFailReasonFuncBO>();
        if (AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(reqBO.getChngType())) {
            this.validChngPrice(reqBO.getAgrItemChng(), reqBO.getAgrId(), dycAgrImportFailReasonFuncBOS);
        } else {
            this.validPuplicate(reqBO.getAgrItemChng(), dycAgrImportFailReasonFuncBOS, reqBO.getAgrId());
        }
        if (failReasonBOs.size() == 0) {
            this.saveAgrItemChng(reqBO);
        } else {
            HashMap<Integer, String> errorMsgMap = new HashMap<Integer, String>();
            dycAgrImportFailReasonFuncBOS.forEach(dycAgrImportFailReasonFuncBO -> {
                String msg = (String)errorMsgMap.get(errorMsgMap.get(dycAgrImportFailReasonFuncBO.getLineNum()));
                msg = msg != null ? msg + ",\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason() : "\u884c\u3010" + dycAgrImportFailReasonFuncBO.getLineNum() + "\u3011\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason();
                errorMsgMap.put(dycAgrImportFailReasonFuncBO.getLineNum(), msg);
            });
            errorMsgMap.forEach((k, v) -> {
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setLineNum((Integer)k);
                bo.setFailReason((String)v);
                failReasonBOs.add(bo);
            });
        }
    }

    private void importAgrChng(List<DycCommonImportFailReasonFuncBO> failReasonBOs, DycAgrAgrChngImportFuncReqBO reqBO) {
        ArrayList dycAgrImportFailReasonFuncBOS = new ArrayList();
        reqBO.getAgrChng().forEach(dycAgrAgrChngImportFuncBO -> {
            if (ObjectUtil.isNotEmpty(dycAgrAgrChngImportFuncBO.getAgrItemChng())) {
                if (AgrCommConstant.AgreementChangeType.CHANGE_PRICE.equals(dycAgrAgrChngImportFuncBO.getChngType())) {
                    this.validChngPrice(dycAgrAgrChngImportFuncBO.getAgrItemChng(), dycAgrAgrChngImportFuncBO.getAgrId(), dycAgrImportFailReasonFuncBOS);
                } else {
                    this.validPuplicate(dycAgrAgrChngImportFuncBO.getAgrItemChng(), dycAgrImportFailReasonFuncBOS, dycAgrAgrChngImportFuncBO.getAgrId());
                }
            }
        });
        if (failReasonBOs.size() == 0) {
            reqBO.getAgrChng().forEach(dycAgrAgrChngImportFuncBO -> {
                AgrGetAgrChngCodeReqBO agrGetAgrChngCodeReqBO = (AgrGetAgrChngCodeReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrGetAgrChngCodeReqBO.class);
                AgrGetAgrChngCodeRspBO agrGetAgrChngCodeRspBO = this.agrGetAgrChngCodeService.getAgrChngCode(agrGetAgrChngCodeReqBO);
                if (!"0000".equals(agrGetAgrChngCodeRspBO.getRespCode())) {
                    throw new ZTBusinessException(agrGetAgrChngCodeRspBO.getRespDesc());
                }
                dycAgrAgrChngImportFuncBO.setChngApplyNo(agrGetAgrChngCodeRspBO.getChngApplyNo());
                dycAgrAgrChngImportFuncBO.setChngApplyId(agrGetAgrChngCodeRspBO.getChngApplyId());
                this.saveAgrChng((DycAgrAgrChngImportFuncBO)dycAgrAgrChngImportFuncBO, reqBO);
                if (dycAgrAgrChngImportFuncBO.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)) {
                    this.updateAgr(dycAgrAgrChngImportFuncBO.getAgrId(), AgrCommConstant.AgreementStatus.FROZEN);
                    this.syncUcc(dycAgrAgrChngImportFuncBO.getAgrId(), null, AgrCommConstant.SyncType.FROZEN);
                }
                if (dycAgrAgrChngImportFuncBO.getChngType().equals(AgrCommConstant.AgreementChangeType.CHANGE_PRICE)) {
                    this.updateAgr(dycAgrAgrChngImportFuncBO.getAgrId(), AgrCommConstant.AgreementStatus.FROZEN);
                    this.syncUcc(dycAgrAgrChngImportFuncBO.getAgrId(), null, AgrCommConstant.SyncType.FROZEN);
                }
            });
        } else {
            HashMap<Integer, String> errorMsgMap = new HashMap<Integer, String>();
            dycAgrImportFailReasonFuncBOS.forEach(dycAgrImportFailReasonFuncBO -> {
                String msg = (String)errorMsgMap.get(errorMsgMap.get(dycAgrImportFailReasonFuncBO.getLineNum()));
                msg = msg != null ? msg + ",\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason() : "\u660e\u7ec6\u884c\u3010" + dycAgrImportFailReasonFuncBO.getLineNum() + "\u3011\u5217\u3010" + dycAgrImportFailReasonFuncBO.getColumnNo() + "\u3011" + dycAgrImportFailReasonFuncBO.getFailReason();
                errorMsgMap.put(dycAgrImportFailReasonFuncBO.getLineNum(), msg);
            });
            errorMsgMap.forEach((k, v) -> {
                DycCommonImportFailReasonFuncBO bo = new DycCommonImportFailReasonFuncBO();
                bo.setLineNum((Integer)k);
                bo.setFailReason((String)v);
                failReasonBOs.add(bo);
            });
        }
    }

    private void updateAgr(Long agrId, Integer agrStatus) {
        AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO = new AgrUpdateAgrMainReqBO();
        agrUpdateAgrMainReqBO.setAgrStatus(agrStatus);
        agrUpdateAgrMainReqBO.setAgrId(agrId);
        AgrUpdateAgrMainRspBO agrUpdateAgrMainRspBO = this.agrUpdateAgrMainService.updateAgrMain(agrUpdateAgrMainReqBO);
        if (!"0000".equals(agrUpdateAgrMainRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4e3b\u4f53\u53d8\u66f4\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrUpdateAgrMainRspBO.getRespCode() + "\u3011," + agrUpdateAgrMainRspBO.getRespDesc());
        }
    }

    private void syncUcc(Long agrId, Long chngApplyId, Integer syncType) {
        AgrSyncUccReqBO agrSyncUccReqBO = new AgrSyncUccReqBO();
        agrSyncUccReqBO.setSyncType(syncType);
        agrSyncUccReqBO.setAgrId(agrId);
        agrSyncUccReqBO.setChngApplyId(chngApplyId);
        AgrSyncUccRspBO agrSyncUccRspBO = this.agrSyncUccService.dealAgrSyncUcc(agrSyncUccReqBO);
        if (!"0000".equals(agrSyncUccRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u540c\u6b65\u5931\u8d25\u3010" + agrSyncUccRspBO.getRespCode() + "\u3011," + agrSyncUccRspBO.getRespDesc());
        }
    }

    private void saveAgrChng(DycAgrAgrChngImportFuncBO dycAgrAgrChngImportFuncBO, DycAgrAgrChngImportFuncReqBO reqBO) {
        if (dycAgrAgrChngImportFuncBO.getChngType().equals(AgrCommConstant.AgreementChangeType.OTHER)) {
            AgrCreateArgMainChngRspBO agrCreateArgMainChngRspBO;
            AgrCreateArgMainChngReqBO mainChngReqBO = (AgrCreateArgMainChngReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), AgrCreateArgMainChngReqBO.class);
            BeanUtils.copyProperties((Object)dycAgrAgrChngImportFuncBO, (Object)mainChngReqBO);
            ArrayList<AgrPayConfigChngBo> agrPayConfigChng = new ArrayList<AgrPayConfigChngBo>();
            if (ObjectUtil.isNotEmpty((Object)dycAgrAgrChngImportFuncBO.getPayTypePur())) {
                AgrPayConfigChngBo payTypePur = new AgrPayConfigChngBo();
                payTypePur.setPayType(dycAgrAgrChngImportFuncBO.getPayTypePur());
                payTypePur.setAssign(dycAgrAgrChngImportFuncBO.getAssignPur());
                payTypePur.setBusiNode(dycAgrAgrChngImportFuncBO.getBusiNodePur());
                payTypePur.setCurrency(dycAgrAgrChngImportFuncBO.getCurrencyPur());
                payTypePur.setMatPay(dycAgrAgrChngImportFuncBO.getMatPayPur());
                payTypePur.setPilPay(dycAgrAgrChngImportFuncBO.getPilPayPur());
                payTypePur.setPrePay(dycAgrAgrChngImportFuncBO.getPrePayPur());
                payTypePur.setProPay(dycAgrAgrChngImportFuncBO.getProPayPur());
                payTypePur.setQuaPay(dycAgrAgrChngImportFuncBO.getQuaPayPur());
                payTypePur.setServiceRate(dycAgrAgrChngImportFuncBO.getServiceRatePur());
                payTypePur.setSettlementDate(dycAgrAgrChngImportFuncBO.getSettlementDatePur());
                payTypePur.setSettlementMonth(dycAgrAgrChngImportFuncBO.getSettlementMonthPur());
                payTypePur.setTaxRate(dycAgrAgrChngImportFuncBO.getTaxRatePur());
                payTypePur.setVerPay(dycAgrAgrChngImportFuncBO.getVerPayPur());
                agrPayConfigChng.add(payTypePur);
            }
            if (ObjectUtil.isNotEmpty((Object)dycAgrAgrChngImportFuncBO.getPayTypeSup())) {
                AgrPayConfigChngBo payTypeSup = new AgrPayConfigChngBo();
                payTypeSup.setPayType(dycAgrAgrChngImportFuncBO.getPayTypeSup());
                payTypeSup.setAssign(dycAgrAgrChngImportFuncBO.getAssignSup());
                payTypeSup.setBusiNode(dycAgrAgrChngImportFuncBO.getBusiNodeSup());
                payTypeSup.setCurrency(dycAgrAgrChngImportFuncBO.getCurrencySup());
                payTypeSup.setMatPay(dycAgrAgrChngImportFuncBO.getMatPaySup());
                payTypeSup.setPilPay(dycAgrAgrChngImportFuncBO.getPilPaySup());
                payTypeSup.setPrePay(dycAgrAgrChngImportFuncBO.getPrePaySup());
                payTypeSup.setProPay(dycAgrAgrChngImportFuncBO.getProPaySup());
                payTypeSup.setQuaPay(dycAgrAgrChngImportFuncBO.getQuaPaySup());
                payTypeSup.setServiceRate(dycAgrAgrChngImportFuncBO.getServiceRateSup());
                payTypeSup.setSettlementDate(dycAgrAgrChngImportFuncBO.getSettlementDateSup());
                payTypeSup.setSettlementMonth(dycAgrAgrChngImportFuncBO.getSettlementMonthSup());
                payTypeSup.setTaxRate(dycAgrAgrChngImportFuncBO.getTaxRateSup());
                payTypeSup.setVerPay(dycAgrAgrChngImportFuncBO.getVerPaySup());
                agrPayConfigChng.add(payTypeSup);
            }
            mainChngReqBO.setAgrPayConfigChng(agrPayConfigChng);
            AgrMainChngBo agrMainChng = (AgrMainChngBo)JSON.parseObject((String)JSON.toJSONString((Object)dycAgrAgrChngImportFuncBO), AgrMainChngBo.class);
            mainChngReqBO.setAgrMainChng(agrMainChng);
            if (ObjectUtil.isNotEmpty((Object)dycAgrAgrChngImportFuncBO.getAgrAppScopeCode())) {
                ArrayList<AgrAppScopeChngBo> agrAppScopeBOs = new ArrayList<AgrAppScopeChngBo>();
                AgrAppScopeChngBo agrAppScopeBo = new AgrAppScopeChngBo();
                agrAppScopeBo.setScopeCode(dycAgrAgrChngImportFuncBO.getAgrAppScopeCode());
                agrAppScopeBo.setScopeName(dycAgrAgrChngImportFuncBO.getAgrAppScopeName() + "");
                agrAppScopeBOs.add(agrAppScopeBo);
                mainChngReqBO.setAgrAppScopeChng(agrAppScopeBOs);
            }
            if (!"0000".equals((agrCreateArgMainChngRspBO = this.agrCreateArgMainChngService.createAgrMainChng(mainChngReqBO)).getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4e3b\u4f53\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrCreateArgMainChngRspBO.getRespCode() + "\u3011," + agrCreateArgMainChngRspBO.getRespDesc());
            }
        } else {
            AgrCreateArgChngApplyReqBO chngApplyReqBO = (AgrCreateArgChngApplyReqBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)dycAgrAgrChngImportFuncBO), AgrCreateArgChngApplyReqBO.class);
            BeanUtils.copyProperties((Object)reqBO, (Object)chngApplyReqBO);
            AgrCreateArgChngApplyRspBO agrCreateArgChngApplyRspBO = this.agrCreateArgChngApplyService.createAgrChngApply(chngApplyReqBO);
            if (!"0000".equals(agrCreateArgChngApplyRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u65b0\u589e\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrCreateArgChngApplyRspBO.getRespCode() + "\u3011," + agrCreateArgChngApplyRspBO.getRespDesc());
            }
        }
    }

    private void saveAgrItemChng(DycAgrAgrChngImportFuncReqBO reqBO) {
        AgrCreateAgrItemChngReqBO agrCreateAgrItemChngReqBO = (AgrCreateAgrItemChngReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), AgrCreateAgrItemChngReqBO.class);
        agrCreateAgrItemChngReqBO.getAgrItemChng().forEach(agrItemChngBO -> {
            if (agrItemChngBO.getMarkupRate() == null) {
                agrItemChngBO.setMarkupRate(new BigDecimal("0"));
            }
            agrItemChngBO.setBuyPriceSum(agrItemChngBO.getBuyPrice().multiply(agrItemChngBO.getBuyNumber()));
            agrItemChngBO.setSalePrice(agrItemChngBO.getBuyPrice().add(agrItemChngBO.getBuyPrice().multiply(agrItemChngBO.getMarkupRate())));
            agrItemChngBO.setSalePriceSum(agrItemChngBO.getSalePrice().multiply(agrItemChngBO.getBuyNumber()));
        });
        AgrCreateAgrItemChngRspBO agrCreateAgrItemChngRspBO = this.agrCreateAgrItemChngService.createAgrItemChng(agrCreateAgrItemChngReqBO);
        if (!"0000".equals(agrCreateAgrItemChngRspBO.getRespCode())) {
            throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u65b0\u589e\u5931\u8d25" + agrCreateAgrItemChngRspBO.getRespDesc());
        }
    }

    private void validChngPrice(List<DycAgrItemChngFuncBO> agrItemChng, Long agrId, List<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS) {
        ArrayList uniqueKeys = new ArrayList();
        agrItemChng.forEach(dycAgrItemChngFuncBO -> {
            dycAgrItemChngFuncBO.setItemChngType(AgrCommConstant.AgreementSkuChangeType.UPDATE);
            uniqueKeys.add(dycAgrItemChngFuncBO.getCommodityTypeId() + "_" + dycAgrItemChngFuncBO.getMaterialCode());
        });
        AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
        agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
        agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
        agrGetAgrItemListReqBO.setAgrId(agrId);
        agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
        AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
        ArrayList existUniqueKeys = new ArrayList();
        if ("0000".equals(agrGetAgrItemListRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)agrGetAgrItemListRspBO.getRows())) {
            agrGetAgrItemListRspBO.getRows().forEach(agrItemDetailBo -> existUniqueKeys.add(agrItemDetailBo.getUniqueKey()));
        }
        agrItemChng.forEach(dycAgrItemChngFuncBO -> {
            if (!existUniqueKeys.contains(dycAgrItemChngFuncBO.getCommodityTypeId() + "_" + dycAgrItemChngFuncBO.getMaterialCode())) {
                DycAgrImportFailReasonFuncBO failReasonBO = new DycAgrImportFailReasonFuncBO();
                failReasonBO.setFailReason("\u534f\u8bae\u660e\u7ec6\u4e0d\u5b58\u5728");
                failReasonBO.setLineNum(dycAgrItemChngFuncBO.getGluttonLineNum());
                failReasonBO.setColumnNo(dycAgrItemChngFuncBO.getColumnNo());
                dycAgrImportFailReasonFuncBOS.add(failReasonBO);
            }
        });
    }

    private void uccCheck(List<DycAgrItemChngFuncBO> agrItemChng, List<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS) {
        UccAgrSkuImportCheckAbilityReqBO uccAgrSkuImportCheckAbilityReqBO = new UccAgrSkuImportCheckAbilityReqBO();
        ArrayList<UccAgrSkuImportCheckBO> rows = new ArrayList<UccAgrSkuImportCheckBO>();
        for (int i = 0; i < agrItemChng.size(); ++i) {
            DycAgrItemChngFuncBO DycAgrItemChngFuncBO2 = agrItemChng.get(i);
            UccAgrSkuImportCheckBO bo = new UccAgrSkuImportCheckBO();
            bo.setSerialNumber(Integer.valueOf(i));
            bo.setCommodityTypeName(DycAgrItemChngFuncBO2.getCommodityTypeName());
            bo.setCatalogCode(DycAgrItemChngFuncBO2.getCatalogCode());
            bo.setMaterialCode(DycAgrItemChngFuncBO2.getMaterialCode());
            bo.setMeasureName(DycAgrItemChngFuncBO2.getMeasureName());
            rows.add(bo);
        }
        uccAgrSkuImportCheckAbilityReqBO.setRows(rows);
        UccAgrSkuImportCheckAbilityRspBO uccAgrSkuImportCheckAbilityRspBO = this.uccAgrSkuImportCheckAbilityService.checkInfo(uccAgrSkuImportCheckAbilityReqBO);
        if (!"0000".equals(uccAgrSkuImportCheckAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5546\u54c1\u4e2d\u5fc3\u6821\u9a8c\u8c03\u7528\u5931\u8d25" + uccAgrSkuImportCheckAbilityRspBO.getRespDesc());
        }
        Map uccRspMap = uccAgrSkuImportCheckAbilityRspBO.getRows().stream().collect(Collectors.toMap(UccAgrSkuImportCheckBO::getSerialNumber, Function.identity()));
        for (int i = 0; i < agrItemChng.size(); ++i) {
            if (((UccAgrSkuImportCheckBO)uccRspMap.get(i)).isPass()) {
                agrItemChng.get(i).setMeasureId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMeasureId());
                agrItemChng.get(i).setMaterialId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getMaterialId().toString());
                agrItemChng.get(i).setCatalogId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCatalogId().toString());
                agrItemChng.get(i).setCommodityTypeId(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getCommodityTypeId());
                continue;
            }
            DycAgrImportFailReasonFuncBO failReasonBO = new DycAgrImportFailReasonFuncBO();
            failReasonBO.setFailReason(((UccAgrSkuImportCheckBO)uccRspMap.get(i)).getReson());
            failReasonBO.setLineNum(agrItemChng.get(i).getGluttonLineNum());
            failReasonBO.setColumnNo(agrItemChng.get(i).getColumnNo());
            dycAgrImportFailReasonFuncBOS.add(failReasonBO);
        }
    }

    private void validPuplicate(List<DycAgrItemChngFuncBO> agrItemChng, List<DycAgrImportFailReasonFuncBO> dycAgrImportFailReasonFuncBOS, Long agrId) {
        ArrayList uniqueKeys = new ArrayList();
        HashMap uniqueKeyMap = new HashMap();
        agrItemChng.forEach(dycAgrItemChngFuncBO -> {
            String key = dycAgrItemChngFuncBO.getCommodityTypeId() + "_" + dycAgrItemChngFuncBO.getMaterialCode();
            if (uniqueKeyMap.get(key) != null) {
                DycAgrImportFailReasonFuncBO failReasonBO = new DycAgrImportFailReasonFuncBO();
                failReasonBO.setLineNum(dycAgrItemChngFuncBO.getGluttonLineNum());
                failReasonBO.setColumnNo(dycAgrItemChngFuncBO.getColumnNo());
                failReasonBO.setFailReason("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                dycAgrImportFailReasonFuncBOS.add(failReasonBO);
            } else {
                uniqueKeyMap.put(key, dycAgrItemChngFuncBO);
                uniqueKeys.add(key);
            }
        });
        if (uniqueKeys.size() > 0) {
            AgrGetAgrItemListReqBO agrGetAgrItemListReqBO = new AgrGetAgrItemListReqBO();
            agrGetAgrItemListReqBO.setPageNo(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setPageSize(Integer.valueOf(-1));
            agrGetAgrItemListReqBO.setAgrId(agrId);
            agrGetAgrItemListReqBO.setUniqueKeys(uniqueKeys);
            AgrGetAgrItemListRspBO agrGetAgrItemListRspBO = this.agrGetAgrItemListService.getAgrItemList(agrGetAgrItemListReqBO);
            if (!"0000".equals(agrGetAgrItemListRspBO.getRespCode())) {
                throw new ZTBusinessException("\u534f\u8bae\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u5931\u8d25" + agrGetAgrItemListRspBO.getRespDesc());
            }
            Map agrItemMap = agrGetAgrItemListRspBO.getRows().stream().collect(Collectors.toMap(AgrItemDetailBo::getUniqueKey, Function.identity()));
            agrItemChng.forEach(dycAgrItemChngFuncBO -> {
                DycAgrImportFailReasonFuncBO failReasonBO;
                String key = dycAgrItemChngFuncBO.getCommodityTypeId() + "_" + dycAgrItemChngFuncBO.getMaterialCode();
                AgrItemDetailBo agrItemDetailBo = (AgrItemDetailBo)agrItemMap.get(key);
                if (AgrCommConstant.AgreementSkuChangeType.ADD.equals(dycAgrItemChngFuncBO.getItemChngType()) && null != agrItemDetailBo) {
                    failReasonBO = new DycAgrImportFailReasonFuncBO();
                    failReasonBO.setLineNum(((DycAgrItemChngFuncBO)uniqueKeyMap.get(agrItemDetailBo.getUniqueKey())).getGluttonLineNum());
                    failReasonBO.setFailReason("\u534f\u8bae\u660e\u7ec6\u91cd\u590d");
                    failReasonBO.setColumnNo(((DycAgrItemChngFuncBO)uniqueKeyMap.get(agrItemDetailBo.getUniqueKey())).getColumnNo());
                    dycAgrImportFailReasonFuncBOS.add(failReasonBO);
                }
                if (AgrCommConstant.AgreementSkuChangeType.DELETE.equals(dycAgrItemChngFuncBO.getItemChngType())) {
                    if (null != agrItemDetailBo) {
                        dycAgrItemChngFuncBO.setAgrItemId(agrItemDetailBo.getAgrItemId());
                    } else {
                        failReasonBO = new DycAgrImportFailReasonFuncBO();
                        failReasonBO.setLineNum(dycAgrItemChngFuncBO.getGluttonLineNum());
                        failReasonBO.setColumnNo(dycAgrItemChngFuncBO.getColumnNo());
                        failReasonBO.setFailReason("\u534f\u8bae\u660e\u7ec6\u4e0d\u5b58\u5728");
                        dycAgrImportFailReasonFuncBOS.add(failReasonBO);
                    }
                }
            });
        }
    }
}

