/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.zone.agr.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.service.agr.AgrAgrAddAuditCallBackService;
import com.tydic.dyc.agr.service.agr.AgrAgrHisCreateService;
import com.tydic.dyc.agr.service.agr.AgrUpdateAgrMainService;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAddAuditCallBackReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrAddAuditCallBackRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAgrHisCreateReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrUpdateAgrMainRspBO;
import com.tydic.dyc.agr.service.agrchange.AgrGetAgrChngApplyDetailService;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailReqBO;
import com.tydic.dyc.agr.service.agrchange.bo.AgrGetAgrChngApplyDetailRspBO;
import com.tydic.dyc.agr.service.auditorder.AgrGetAuditObjService;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrAgrAddChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.AgrAgrAdjustChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.AgrAgrDeferChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.AgrAgrMainChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.AgrAgrStatusChngAuditCallBackService;
import com.tydic.dyc.agr.service.domainservice.AgrSyncUccService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAddChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAddChngAuditCallBackRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAdjustChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrAdjustChngAuditCallBackRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrDeferChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrDeferChngAuditCallBackRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrMainChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrMainChngAuditCallBackRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrStatusChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrStatusChngAuditCallBackRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSyncUccReqBO;
import com.tydic.dyc.agr.service.procinst.AgrGetProcInstService;
import com.tydic.dyc.agr.service.procinst.AgrGetTaskInstService;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstReqBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetProcInstRspBO;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstReqBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocOrderTaskInstBo;
import com.tydic.dyc.atom.zone.agr.api.DycAgrAuditCallBackFunction;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAuditCallBackFunctionReqBO;
import com.tydic.dyc.atom.zone.agr.bo.DycAgrAuditCallBackFunctionRspBO;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycAgrAuditCallBackFunctionImpl
implements DycAgrAuditCallBackFunction {
    @Autowired
    private AgrGetProcInstService agrGetProcInstService;
    @Autowired
    private AgrAgrAddAuditCallBackService agrAgrAddAuditCallBackService;
    @Autowired
    private AgrGetAgrChngApplyDetailService agrGetAgrChngApplyDetailService;
    @Autowired
    private AgrAgrStatusChngAuditCallBackService agrAgrStatusChngAuditCallBackService;
    @Autowired
    private AgrAgrAddChngAuditCallBackService agrAgrAddChngAuditCallBackService;
    @Autowired
    private AgrAgrDeferChngAuditCallBackService agrAgrDeferChngAuditCallBackService;
    @Autowired
    private AgrAgrAdjustChngAuditCallBackService agrAgrAdjustChngAuditCallBackService;
    @Autowired
    private AgrAgrMainChngAuditCallBackService agrAgrMainChngAuditCallBackService;
    @Autowired
    private AgrUpdateAgrMainService agrUpdateAgrMainService;
    @Autowired
    private AgrSyncUccService agrSyncUccService;
    @Autowired
    private AgrGetAuditObjService agrGetAuditObjService;
    @Autowired
    private AgrAgrHisCreateService agrAgrHisCreateService;
    @Autowired
    private AgrGetTaskInstService agrGetTaskInstService;

    @Override
    public DycAgrAuditCallBackFunctionRspBO dealAuditCallBack(DycAgrAuditCallBackFunctionReqBO functionReqBO) {
        AgrGetProcInstRspBO arGetProcInstRspBO = this.getProcInst(functionReqBO);
        if (functionReqBO.getAuditResult().booleanValue()) {
            if (arGetProcInstRspBO.getObjType().equals(AgrCommConstant.ObjType.AGREEMENT)) {
                this.invokeAgrAddAuditCallBack(arGetProcInstRspBO.getObjId());
            }
            if (arGetProcInstRspBO.getObjType().equals(AgrCommConstant.ObjType.CHANGE)) {
                AgrAgrHisCreateReqBO agrAgrHisCreateReqBO;
                AgrGetAgrChngApplyDetailRspBO applyDetailRspBO = this.getChngApplyDetail(arGetProcInstRspBO);
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.START)) {
                    this.invokeStatusChngAuditCallBack(arGetProcInstRspBO, applyDetailRspBO.getChngType());
                    this.syncUcc(applyDetailRspBO.getAgrId(), null, AgrCommConstant.SyncType.UP_SHELF);
                }
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.TERMINATION)) {
                    this.invokeStatusChngAuditCallBack(arGetProcInstRspBO, applyDetailRspBO.getChngType());
                    this.syncUcc(applyDetailRspBO.getAgrId(), null, AgrCommConstant.SyncType.INVALID);
                }
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)) {
                    this.invokeStatusChngAuditCallBack(arGetProcInstRspBO, applyDetailRspBO.getChngType());
                    this.syncUcc(applyDetailRspBO.getAgrId(), null, AgrCommConstant.SyncType.FROZEN);
                }
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.SUPPLEMENT)) {
                    agrAgrHisCreateReqBO = new AgrAgrHisCreateReqBO();
                    agrAgrHisCreateReqBO.setAgrId(applyDetailRspBO.getAgrId());
                    this.agrAgrHisCreateService.saveAgrHis(agrAgrHisCreateReqBO);
                    this.invokeAddChngAuditCallBack(arGetProcInstRspBO);
                    this.syncUcc(applyDetailRspBO.getAgrId(), null, AgrCommConstant.SyncType.AGR_ITEM_DELETE);
                }
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.CHANGE_PRICE)) {
                    agrAgrHisCreateReqBO = new AgrAgrHisCreateReqBO();
                    agrAgrHisCreateReqBO.setAgrId(applyDetailRspBO.getAgrId());
                    this.agrAgrHisCreateService.saveAgrHis(agrAgrHisCreateReqBO);
                    this.invokeAdjustChngAuditCallBack(arGetProcInstRspBO);
                    this.updateAgrInfo(applyDetailRspBO.getAgrId());
                    this.syncUcc(applyDetailRspBO.getAgrId(), applyDetailRspBO.getChngApplyId(), AgrCommConstant.SyncType.UP_SHELF);
                    this.syncUcc(applyDetailRspBO.getAgrId(), applyDetailRspBO.getChngApplyId(), AgrCommConstant.SyncType.AGR_ITEM_ADJUST_PRICE);
                }
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.OTHER)) {
                    agrAgrHisCreateReqBO = new AgrAgrHisCreateReqBO();
                    agrAgrHisCreateReqBO.setAgrId(applyDetailRspBO.getAgrId());
                    this.agrAgrHisCreateService.saveAgrHis(agrAgrHisCreateReqBO);
                    this.invokeMainChngAuditCallBack(arGetProcInstRspBO);
                    this.syncUcc(applyDetailRspBO.getAgrId(), applyDetailRspBO.getChngApplyId(), AgrCommConstant.SyncType.AGR_SCOPE_CHNG);
                }
                if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.DELAY)) {
                    agrAgrHisCreateReqBO = new AgrAgrHisCreateReqBO();
                    agrAgrHisCreateReqBO.setAgrId(applyDetailRspBO.getAgrId());
                    this.agrAgrHisCreateService.saveAgrHis(agrAgrHisCreateReqBO);
                    this.invokeDeferChngAuditCallBack(arGetProcInstRspBO);
                    this.syncUcc(applyDetailRspBO.getAgrId(), applyDetailRspBO.getChngApplyId(), AgrCommConstant.SyncType.UP_SHELF);
                }
            }
        } else if (arGetProcInstRspBO.getObjType().equals(AgrCommConstant.ObjType.CHANGE)) {
            AgrGetAgrChngApplyDetailRspBO applyDetailRspBO = this.getChngApplyDetail(arGetProcInstRspBO);
            if (applyDetailRspBO.getChngType().equals(AgrCommConstant.AgreementChangeType.STOP)) {
                this.updateAgrInfo(applyDetailRspBO.getAgrId());
                this.syncUcc(applyDetailRspBO.getAgrId(), null, AgrCommConstant.SyncType.UP_SHELF);
            }
        } else if (arGetProcInstRspBO.getObjType().equals(AgrCommConstant.ObjType.AGREEMENT)) {
            AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO = new AgrUpdateAgrMainReqBO();
            agrUpdateAgrMainReqBO.setAgrId(arGetProcInstRspBO.getObjId());
            agrUpdateAgrMainReqBO.setAgrStatus(AgrCommConstant.AgreementStatus.REJECT);
            this.agrUpdateAgrMainService.updateAgrMain(agrUpdateAgrMainReqBO);
        }
        return new DycAgrAuditCallBackFunctionRspBO();
    }

    private void syncUcc(Long agrId, Long chngApplyId, Integer syncType) {
        AgrSyncUccReqBO agrSyncUccReqBO = new AgrSyncUccReqBO();
        agrSyncUccReqBO.setAgrId(agrId);
        agrSyncUccReqBO.setSyncType(syncType);
        agrSyncUccReqBO.setChngApplyId(chngApplyId);
        this.agrSyncUccService.dealAgrSyncUcc(agrSyncUccReqBO);
    }

    private void updateAgrInfo(Long agrId) {
        AgrUpdateAgrMainReqBO agrUpdateAgrMainReqBO = new AgrUpdateAgrMainReqBO();
        agrUpdateAgrMainReqBO.setAgrId(agrId);
        agrUpdateAgrMainReqBO.setAgrStatus(AgrCommConstant.AgreementStatus.ENABLE);
        AgrUpdateAgrMainRspBO agrUpdateAgrMainRspBO = this.agrUpdateAgrMainService.updateAgrMain(agrUpdateAgrMainReqBO);
        if (!"0000".equals(agrUpdateAgrMainRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u4e3b\u4f53\u53d8\u66f4\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrUpdateAgrMainRspBO.getRespCode() + "\u3011," + agrUpdateAgrMainRspBO.getRespDesc());
        }
    }

    private void invokeDeferChngAuditCallBack(AgrGetProcInstRspBO arGetProcInstRspBO) {
        AgrAgrDeferChngAuditCallBackReqBO reqBO = new AgrAgrDeferChngAuditCallBackReqBO();
        reqBO.setAgrId(arGetProcInstRspBO.getOrderId());
        reqBO.setChngApplyId(arGetProcInstRspBO.getObjId());
        AgrAgrDeferChngAuditCallBackRspBO rspBO = this.agrAgrDeferChngAuditCallBackService.dealDeferChngAuditCallBack(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u5ef6\u671f\u53d8\u66f4\u5ba1\u6279\u56de\u8c03\u670d\u52a1\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
    }

    private void invokeMainChngAuditCallBack(AgrGetProcInstRspBO arGetProcInstRspBO) {
        AgrAgrMainChngAuditCallBackReqBO reqBO = new AgrAgrMainChngAuditCallBackReqBO();
        reqBO.setAgrId(arGetProcInstRspBO.getOrderId());
        reqBO.setChngApplyId(arGetProcInstRspBO.getObjId());
        AgrAgrMainChngAuditCallBackRspBO rspBO = this.agrAgrMainChngAuditCallBackService.dealMainChngAuditCallBack(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4e3b\u4f53\u53d8\u66f4\u5ba1\u6279\u56de\u8c03\u670d\u52a1\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
    }

    private void invokeAdjustChngAuditCallBack(AgrGetProcInstRspBO arGetProcInstRspBO) {
        AgrAgrAdjustChngAuditCallBackReqBO reqBO = new AgrAgrAdjustChngAuditCallBackReqBO();
        reqBO.setAgrId(arGetProcInstRspBO.getOrderId());
        reqBO.setChngApplyId(arGetProcInstRspBO.getObjId());
        AgrAgrAdjustChngAuditCallBackRspBO rspBO = this.agrAgrAdjustChngAuditCallBackService.dealAdjustChngAuditCallBack(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u660e\u7ec6\u8c03\u4ef7\u53d8\u66f4\u5ba1\u6279\u56de\u8c03\u670d\u52a1\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
    }

    private void invokeAddChngAuditCallBack(AgrGetProcInstRspBO arGetProcInstRspBO) {
        AgrAgrAddChngAuditCallBackReqBO reqBO = new AgrAgrAddChngAuditCallBackReqBO();
        reqBO.setAgrId(arGetProcInstRspBO.getOrderId());
        reqBO.setChngApplyId(arGetProcInstRspBO.getObjId());
        AgrAgrAddChngAuditCallBackRspBO rspBO = this.agrAgrAddChngAuditCallBackService.dealAddChngAuditCallBack(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u660e\u7ec6\u8865\u5145\u53d8\u66f4\u5ba1\u6279\u56de\u8c03\u670d\u52a1\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
    }

    private void invokeStatusChngAuditCallBack(AgrGetProcInstRspBO arGetProcInstRspBO, Integer chngType) {
        AgrAgrStatusChngAuditCallBackReqBO reqBO = new AgrAgrStatusChngAuditCallBackReqBO();
        reqBO.setAgrId(arGetProcInstRspBO.getOrderId());
        reqBO.setChngApplyId(arGetProcInstRspBO.getObjId());
        reqBO.setChngType(chngType);
        AgrAgrStatusChngAuditCallBackRspBO rspBO = this.agrAgrStatusChngAuditCallBackService.dealStatusChngAuditCallBack(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u72b6\u6001\u53d8\u66f4\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
    }

    private AgrGetAgrChngApplyDetailRspBO getChngApplyDetail(AgrGetProcInstRspBO arGetProcInstRspBO) {
        AgrGetAgrChngApplyDetailReqBO reqBO = new AgrGetAgrChngApplyDetailReqBO();
        reqBO.setAgrId(arGetProcInstRspBO.getOrderId());
        reqBO.setChngApplyId(arGetProcInstRspBO.getObjId());
        AgrGetAgrChngApplyDetailRspBO rspBO = this.agrGetAgrChngApplyDetailService.getAgrChngApplyDetail(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u53d8\u66f4\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
        if (rspBO.getChngApplyId() == null) {
            throw new ZTBusinessException("\u53d8\u66f4\u7533\u8bf7\u4fe1\u606f\u4e0d\u5b58\u5728" + arGetProcInstRspBO.getObjId());
        }
        return rspBO;
    }

    private void invokeAgrAddAuditCallBack(Long agrId) {
        AgrAgrAddAuditCallBackReqBO reqBO = new AgrAgrAddAuditCallBackReqBO();
        reqBO.setAgrId(agrId);
        AgrAgrAddAuditCallBackRspBO rspBO = this.agrAgrAddAuditCallBackService.dealAgrAddAuditCallBack(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u65b0\u589e\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
    }

    private AgrGetProcInstRspBO getProcInst(DycAgrAuditCallBackFunctionReqBO functionReqBO) {
        AgrGetProcInstReqBO reqBO = new AgrGetProcInstReqBO();
        reqBO.setProcInstId(functionReqBO.getProcInstId());
        AgrGetProcInstRspBO rspBO = this.agrGetProcInstService.getProcInst(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + rspBO.getRespCode() + "\u3011," + rspBO.getRespDesc());
        }
        if (StringUtils.isEmpty((Object)rspBO.getProcInstId())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u4fe1\u606f\u4e0d\u5b58\u5728" + functionReqBO.getProcInstId());
        }
        AgrGetTaskInstReqBo agrGetTaskInstReqBo = new AgrGetTaskInstReqBo();
        agrGetTaskInstReqBo.setOrderId(rspBO.getOrderId());
        agrGetTaskInstReqBo.setObjId(rspBO.getObjId());
        agrGetTaskInstReqBo.setFinishTag(Integer.valueOf(1));
        agrGetTaskInstReqBo.setOrderBy("create_time desc");
        AgrGetTaskInstRspBo agrGetTaskInstRspBo = this.agrGetTaskInstService.getTaskInstList(agrGetTaskInstReqBo);
        if (!"0000".equals(agrGetTaskInstRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u534f\u8bae\u4efb\u52a1\u67e5\u8be2\u5931\u8d25\uff01\u5f02\u5e38\u7f16\u7801\u3010" + agrGetTaskInstRspBo.getRespCode() + "\u3011," + agrGetTaskInstRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)agrGetTaskInstRspBo.getRows())) {
            if (((AgrUocOrderTaskInstBo)agrGetTaskInstRspBo.getRows().get(0)).getDealResult() == 1) {
                functionReqBO.setAuditResult(true);
            } else {
                functionReqBO.setAuditResult(false);
            }
        } else {
            functionReqBO.setAuditResult(true);
        }
        return rspBO;
    }
}

