/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeAcceptRecord;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeEntrustRecord;
import com.tydic.dyc.ssc.service.scheme.SscAcceptPurchaseSchemeService;
import com.tydic.dyc.ssc.service.scheme.bo.SscAcceptPurchaseSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAcceptPurchaseSchemeRspBO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscAcceptPurchaseSchemeService"})
public class SscAcceptPurchaseSchemeServiceImpl
implements SscAcceptPurchaseSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @PostMapping(value={"acceptPurchaseScheme"})
    public SscAcceptPurchaseSchemeRspBO acceptPurchaseScheme(@RequestBody SscAcceptPurchaseSchemeReqBO sscAcceptPurchaseSchemeReqBO) {
        this.validData(sscAcceptPurchaseSchemeReqBO);
        SscSchemeDo updateSscSchemeDo = new SscSchemeDo();
        updateSscSchemeDo.setSchemeId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        updateSscSchemeDo.setImplId(sscAcceptPurchaseSchemeReqBO.getAcceptUserId());
        updateSscSchemeDo.setImplName(sscAcceptPurchaseSchemeReqBO.getAcceptUserName());
        if (!sscAcceptPurchaseSchemeReqBO.getOperStatus().booleanValue()) {
            updateSscSchemeDo.setSchemeAuditStatus(SscCommConstant.SchemeAuditStatus.DRAW.getCode());
            updateSscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.FORWARDING.getCode());
        }
        updateSscSchemeDo.setSchemeStatus(sscAcceptPurchaseSchemeReqBO.getOperStatus() != false ? SscCommConstant.SchemeStatus.FORWARDING.getCode() : SscCommConstant.SchemeStatus.BACK.getCode());
        updateSscSchemeDo.setOperTime(new Date());
        this.iSscSchemeModel.updateSchemeMain(updateSscSchemeDo);
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(sscAcceptPurchaseSchemeReqBO.getUserId());
        uocOrderTaskInst.setDealOperName(sscAcceptPurchaseSchemeReqBO.getUsername());
        uocOrderTaskInst.setOrderId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setTaskInstId(sscAcceptPurchaseSchemeReqBO.getTaskId());
        uocOrderTaskInst.setObjId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setObjType(1);
        SscProcInstDo sscProcInstDo = new SscProcInstDo();
        ArrayList<UocOrderTaskInst> taskList = new ArrayList<UocOrderTaskInst>();
        taskList.add(uocOrderTaskInst);
        sscProcInstDo.setSscUocOrderTaskInst(taskList);
        this.iSscProcInstModel.updateTask(sscProcInstDo);
        ArrayList<SscSchemeAcceptRecord> sscSchemeAcceptRecords = new ArrayList<SscSchemeAcceptRecord>();
        SscSchemeAcceptRecord sscSchemeAcceptRecord = new SscSchemeAcceptRecord();
        sscSchemeAcceptRecord.setSchemeId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        sscSchemeAcceptRecord.setAcceptUserId(sscAcceptPurchaseSchemeReqBO.getUserId());
        sscSchemeAcceptRecord.setAcceptUserName(sscAcceptPurchaseSchemeReqBO.getUsername());
        sscSchemeAcceptRecord.setRemark(sscAcceptPurchaseSchemeReqBO.getRemark());
        sscSchemeAcceptRecord.setCreateTime(new Date());
        if (sscAcceptPurchaseSchemeReqBO.getOperStatus().booleanValue()) {
            sscSchemeAcceptRecord.setStatus(SscCommConstant.AcceptStatusEnum.ASSIGNED.getCode());
        } else {
            sscSchemeAcceptRecord.setStatus(SscCommConstant.AcceptStatusEnum.NO_ACCEPT.getCode());
        }
        sscSchemeAcceptRecords.add(sscSchemeAcceptRecord);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemeAcceptRecord(sscSchemeAcceptRecords);
        this.iSscSchemeModel.addSchemeAcceptRecord(sscSchemeDo);
        ArrayList<SscSchemeEntrustRecord> sscSchemeEntrustRecords = new ArrayList<SscSchemeEntrustRecord>();
        SscSchemeEntrustRecord sscSchemeEntrustRecord = new SscSchemeEntrustRecord();
        sscSchemeEntrustRecord.setSchemeId(sscAcceptPurchaseSchemeReqBO.getSchemeId());
        sscSchemeEntrustRecord.setAgencyCode(sscAcceptPurchaseSchemeReqBO.getAgencyCode());
        sscSchemeEntrustRecord.setAgencyName(sscAcceptPurchaseSchemeReqBO.getAgencyName());
        sscSchemeEntrustRecord.setRemark(sscAcceptPurchaseSchemeReqBO.getRemark());
        sscSchemeEntrustRecord.setCreateTime(new Date());
        if (sscAcceptPurchaseSchemeReqBO.getOperStatus().booleanValue()) {
            sscSchemeEntrustRecord.setSchemeStatus(String.valueOf(SscCommConstant.SchemeStatus.FORWARDING.getCode()));
        } else {
            sscSchemeEntrustRecord.setSchemeStatus(String.valueOf(SscCommConstant.SchemeStatus.BACK.getCode()));
        }
        sscSchemeEntrustRecords.add(sscSchemeEntrustRecord);
        sscSchemeDo.setSscSchemeEntrustRecord(sscSchemeEntrustRecords);
        this.iSscSchemeModel.addSchemeEntrustRecord(sscSchemeDo);
        return new SscAcceptPurchaseSchemeRspBO();
    }

    private void validData(SscAcceptPurchaseSchemeReqBO reqBo) {
        if (reqBo.getOperStatus() == false & reqBo.getRemark() == null) {
            throw new BaseBusinessException("292001", "\u62d2\u7edd\u65f6\uff0c\u539f\u56e0\u5fc5\u586b");
        }
        if (reqBo == null) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (reqBo.getOperStatus().booleanValue() && reqBo.getAcceptUserId() == null) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u64cd\u4f5c\u4ebaid\u4e3a\u7a7a");
        }
        if (reqBo.getOperStatus().booleanValue() && reqBo.getAcceptUserName() == null) {
            throw new BaseBusinessException("292001", "\u5165\u53c2\u6267\u884c\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
    }
}

