/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeMatListReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeMatListRspBO;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemeMatListService;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeMatListPageRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscQrySchemeMatListService"})
public class SscQrySchemeMatListServiceImpl
implements SscQrySchemeMatListService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"qrySchemeMatList"})
    public SscQrySchemeMatListPageRspBO qrySchemeMatList(@RequestBody SscQrySchemeMatListPageReqBO reqBO) {
        this.validationParam(reqBO);
        SscQrySchemeMatListReqBO qrySchemeMatListReqBO = SscRu.js(reqBO, SscQrySchemeMatListReqBO.class);
        SscQrySchemeMatListRspBO sscQrySchemeMatListRspBO = this.iSscSchemeModel.qrySchemeMatList(qrySchemeMatListReqBO);
        SscQrySchemeMatListPageRspBO rspBO = SscRu.js((Object)sscQrySchemeMatListRspBO, SscQrySchemeMatListPageRspBO.class);
        if (CollectionUtil.isNotEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(e -> {
                if (ObjectUtil.isNotEmpty((Object)e.getCentralPurTag())) {
                    e.setCentralPurTagStr(SscCommConstant.YesOrNoEnum.findDescByCode((Integer)e.getCentralPurTag()).getDesc());
                }
                if (ObjectUtil.isNotNull((Object)e.getNoTaxPrice())) {
                    if (ObjectUtil.isNotNull((Object)e.getPurchaseNum())) {
                        e.setTotalNoTaxPrice(e.getNoTaxPrice().multiply(e.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                    }
                    if (ObjectUtil.isNotNull((Object)e.getTaxRate())) {
                        if (Objects.isNull(e.getTaxPrice())) {
                            e.setTaxPrice(e.getNoTaxPrice().multiply(new BigDecimal("1").add(e.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                        }
                        if (ObjectUtil.isNotNull((Object)e.getPurchaseNum()) && Objects.isNull(e.getTotalTaxPrice())) {
                            e.setTotalTaxPrice(e.getTaxPrice().multiply(e.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                        }
                    }
                }
            });
        }
        this.setExtInfo(reqBO, rspBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validationParam(SscQrySchemeMatListPageReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getEnableDraft())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[enableDraft]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPageNo())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[PageNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPageSize())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61[PageSize]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void setExtInfo(SscQrySchemeMatListPageReqBO reqBO, SscQrySchemeMatListPageRspBO rspBO) {
        List rows = rspBO.getRows();
        if (CollectionUtil.isNotEmpty((Collection)rows)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            boolean hisFlag = ObjectUtil.isNotNull((Object)reqBO.getSchemeHisId()) || ObjectUtil.isNotNull((Object)reqBO.getPackHisId());
            Boolean enableDraft = reqBO.getEnableDraft();
            List<SscExtObjInfo> objInfoList = rows.stream().map(e -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                if (enableDraft.booleanValue()) {
                    objInfo.setObjId(e.getSchemeMatId());
                    objInfo.setObjType("ssc_scheme_mat_ext_draft");
                } else if (hisFlag) {
                    objInfo.setObjId(e.getSchemeMatHisId());
                    objInfo.setObjType("ssc_scheme_mat_his_ext");
                } else {
                    objInfo.setObjId(e.getSchemeMatId());
                    objInfo.setObjType("ssc_scheme_mat_ext");
                }
                return objInfo;
            }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(objInfoList);
            SscCommonDo qryExtInfo = this.iSscCommonModel.qryExtInfo(sscCommonDo);
            List<SscExtObjInfo> resultList = qryExtInfo.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(resultList)) {
                Map<Long, List> objExtObjInfoMap = resultList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo));
                rows.forEach(e -> e.setExtFields(SscRu.jsl((List)objExtObjInfoMap.get(hisFlag ? e.getSchemeMatHisId() : e.getSchemeMatId()), BaseExtendFieldBo.class)));
            }
        }
    }
}

