/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.SscUpdateSchemeService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscUpdateSchemeService"})
public class SscUpdateSchemeServiceImpl
implements SscUpdateSchemeService {
    private static final Logger log = LoggerFactory.getLogger(SscUpdateSchemeServiceImpl.class);
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"updateScheme"})
    public SscUpdateSchemeRspBO updateScheme(@RequestBody SscUpdateSchemeReqBO sscUpdateSchemeReqBO0) {
        log.info("\u65b9\u6848\u66f4\u65b0\u5165\u53c2\u4fe1\u606f\u4e3a: {}", (Object)JSON.toJSONString((Object)sscUpdateSchemeReqBO0));
        SscUpdateSchemeRspBO rspBO = SscRu.success(SscUpdateSchemeRspBO.class);
        SscSchemeDo updateDo = SscRu.js(sscUpdateSchemeReqBO0, SscSchemeDo.class);
        this.setNull(sscUpdateSchemeReqBO0);
        updateDo.setOperTime(new Date());
        this.iSscSchemeModel.updateScheme(updateDo);
        SscSchemeDo copyDo = new SscSchemeDo();
        copyDo.setSchemeId(sscUpdateSchemeReqBO0.getSchemeId());
        if (CollectionUtil.isNotEmpty((Collection)sscUpdateSchemeReqBO0.getSscSchemePack())) {
            copyDo.setPackIds(sscUpdateSchemeReqBO0.getSscSchemePack().stream().map(SscSchemePackBO::getPackId).collect(Collectors.toList()));
        }
        this.iSscSchemeModel.copyScheme(copyDo);
        this.deleteExtInfo(sscUpdateSchemeReqBO0);
        this.addExtInfo(sscUpdateSchemeReqBO0);
        return rspBO;
    }

    private void setNull(SscUpdateSchemeReqBO sscUpdateSchemeReqBO0) {
        if (!Boolean.TRUE.equals(sscUpdateSchemeReqBO0.getNullFlag())) {
            if (StrUtil.isEmpty((CharSequence)sscUpdateSchemeReqBO0.getAgencyCode())) {
                sscUpdateSchemeReqBO0.setAgencyCode(null);
            }
            if (StrUtil.isEmpty((CharSequence)sscUpdateSchemeReqBO0.getAgencyName())) {
                sscUpdateSchemeReqBO0.setAgencyName(null);
            }
            if (StrUtil.isEmpty((CharSequence)sscUpdateSchemeReqBO0.getOrganizationForm())) {
                sscUpdateSchemeReqBO0.setOrganizationForm(null);
            }
        }
    }

    private void addExtInfo(SscUpdateSchemeReqBO reqBO) {
        List packList;
        List extFieldList = reqBO.getExtFields();
        ArrayList<SscExtObjInfo> extObjInfoList = new ArrayList<SscExtObjInfo>();
        SscCommonDo sscCommonDo = new SscCommonDo();
        if (CollectionUtil.isNotEmpty((Collection)extFieldList)) {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getSchemeId());
            objInfo.setObjType("ssc_scheme_ext");
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            extObjInfoList.add(objInfo);
        }
        if (CollectionUtil.isNotEmpty((Collection)(packList = reqBO.getSscSchemePack()))) {
            List packExtObjInfoList = packList.stream().filter(e -> CollectionUtil.isNotEmpty((Collection)e.getExtFields())).map(e -> {
                List packExtFieldList = e.getExtFields();
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(e.getPackId());
                objInfo.setOrderId(e.getSchemeId());
                objInfo.setObjType("ssc_scheme_pack_ext");
                objInfo.setExtInfo(SscRu.jsl(packExtFieldList, SscExtInfo.class));
                return objInfo;
            }).collect(Collectors.toList());
            extObjInfoList.addAll(packExtObjInfoList);
        }
        if (CollectionUtil.isNotEmpty(extObjInfoList)) {
            sscCommonDo.setExtObjInfos(extObjInfoList);
            this.iSscCommonModel.addExtInfo(sscCommonDo);
        }
    }

    private void deleteExtInfo(SscUpdateSchemeReqBO reqBO) {
        SscExtObjInfo objInfoScheme = new SscExtObjInfo();
        objInfoScheme.setOrderId(reqBO.getSchemeId());
        objInfoScheme.setObjType("ssc_scheme_ext");
        SscExtObjInfo objInfoPack = new SscExtObjInfo();
        objInfoPack.setOrderId(reqBO.getSchemeId());
        objInfoPack.setObjType("ssc_scheme_pack_ext");
        SscCommonDo sscCommonDo = new SscCommonDo();
        ArrayList<SscExtObjInfo> extObjInfos = new ArrayList<SscExtObjInfo>();
        extObjInfos.add(objInfoScheme);
        extObjInfos.add(objInfoPack);
        sscCommonDo.setExtObjInfos(extObjInfos);
        this.iSscCommonModel.deleteExtInfo(sscCommonDo);
    }
}

