package com.tydic.dyc.ssc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.repository.aop.BatchInsert;
import com.tydic.dyc.ssc.repository.po.SscSchemeExtPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：方案拓展
 * 
 * @author auto_gen
 * @date 2023-03-21 13:28
 **/
@Mapper
@Repository
public interface SscSchemeExtMapper {

	/**
	 * 插入单条数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @return int 影响数量
	 */
	int insert(SscSchemeExtPO sscschemeextpo);

	/**
	 * 根据条件删除数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(SscSchemeExtPO sscschemeextpo);

	/**
	 * 根据主键更新数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(SscSchemeExtPO sscschemeextpo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") SscSchemeExtPO set, @Param("where") SscSchemeExtPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(SscSchemeExtPO sscschemeextpo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @return SscSchemeExtPO 结果对象
	 */
	SscSchemeExtPO getModelBy(SscSchemeExtPO sscschemeextpo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @return List<SscSchemeExtPO> 结果对象
	 */
	List<SscSchemeExtPO> getList(SscSchemeExtPO sscschemeextpo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param sscschemeextpo 参数对象
	 * @param page 分页参数
	 * @return List<SscSchemeExtPO> 结果对象
	 */
	List<SscSchemeExtPO> getListPage(SscSchemeExtPO sscschemeextpo, Page<SscSchemeExtPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	/**
	 * 直接在Mapper方法上添加@BatchInsert注解
	 * 参数位置为0（第一个参数）
	 */
	@BatchInsert(batchSize = "${batch.insert.size:500}")
	void insertBatch(List<SscSchemeExtPO> list);

}
