/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.order.impl.busi.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.order.atom.order.bo.CommodityAttrRspBO;
import com.tydic.order.bo.common.AccessoryBO;
import com.tydic.order.bo.common.OrdAccessoryPO;
import com.tydic.order.bo.order.UocCoreActiveReqBO;
import com.tydic.order.bo.saleorder.PebExtAddressInfoIntfceReqBO;
import com.tydic.order.bo.saleorder.PebExtAgreementCreateOrderReqBO;
import com.tydic.order.bo.saleorder.PebExtAgreementCreateOrderRspBO;
import com.tydic.order.bo.saleorder.PebExtAgreementSkuInfo;
import com.tydic.order.busi.saleorder.PebExtAgreementCreateOrderBusiService;
import com.tydic.order.constant.PebExtConstant;
import com.tydic.order.constant.PecConstant;
import com.tydic.order.constant.UocConstant;
import com.tydic.order.constant.UocCoreConstant;
import com.tydic.order.extend.dao.OrdPayConfMapper;
import com.tydic.order.extend.dao.po.OrdPayConfPO;
import com.tydic.order.impl.atom.core.UocCoreCreateLogisticsRelaAtomService;
import com.tydic.order.impl.atom.core.UocCoreCreateOrderAtomService;
import com.tydic.order.impl.atom.core.UocCoreCreatePayOrderAtomService;
import com.tydic.order.impl.atom.core.UocCoreCreateSaleOrderAtomService;
import com.tydic.order.impl.atom.core.bo.AtomUocCoreCreateOrderReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreAddOrdSaleCouponInfoBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreateLogisticsRelaReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreateLogisticsRelaRspBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreateOrderRspBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreatePayOrderReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreatePayOrderRspBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreateSaleOrderReqBO;
import com.tydic.order.impl.atom.core.bo.UocCoreCreateSaleOrderRspBO;
import com.tydic.order.impl.atom.impl.other.UocProGetVoucherNoAtomService;
import com.tydic.order.impl.atom.impl.other.bo.UocProGetVoucherNoAtomReqBo;
import com.tydic.order.impl.atom.impl.other.bo.UocProGetVoucherNoAtomRspBo;
import com.tydic.order.impl.bo.order.OrdGoodsAttrBO;
import com.tydic.order.impl.bo.order.OrdGoodsBO;
import com.tydic.order.impl.bo.order.UocOrderGoodsGiftBO;
import com.tydic.order.impl.bo.order.UocOrderItemBO;
import com.tydic.order.impl.bo.order.UocOrderPayItemBO;
import com.tydic.order.impl.utils.ElUtils;
import com.tydic.order.impl.utils.OrderGenerateIdUtil;
import com.tydic.order.impl.utils.UocMoneyUtil;
import com.tydic.order.third.intf.ability.umc.PebIntfSgOrgAmountDeductAbilityService;
import com.tydic.order.third.intf.bo.agr.AgreementSettlementBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseAccountBO;
import com.tydic.order.third.intf.bo.umc.SgOrgAmountDeductReqBO;
import com.tydic.order.third.intf.bo.umc.SgOrgAmountDeductRspBO;
import com.tydic.order.uoc.dao.ConfSupplierMapper;
import com.tydic.order.uoc.dao.OrdAccessoryMapper;
import com.tydic.order.uoc.dao.OrdExtMapMapper;
import com.tydic.order.uoc.dao.OrdInvoiceMapper;
import com.tydic.order.uoc.dao.OrdItemMapMapper;
import com.tydic.order.uoc.dao.OrdItemMapper;
import com.tydic.order.uoc.dao.po.ConfSupplierPO;
import com.tydic.order.uoc.dao.po.OrdExtMapPO;
import com.tydic.order.uoc.dao.po.OrdInvoicePO;
import com.tydic.order.uoc.dao.po.OrdItemMapPO;
import com.tydic.order.uoc.dao.po.OrdItemPO;
import com.tydic.uoc.base.exception.UocProBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PebExtAgreementCreateOrderBusiServiceImpl
implements PebExtAgreementCreateOrderBusiService {
    private Logger log = LoggerFactory.getLogger(PebExtAgreementCreateOrderBusiServiceImpl.class);
    @Autowired
    private UocCoreCreateOrderAtomService uocCoreCreateOrderAtomService;
    @Autowired
    private UocCoreCreateLogisticsRelaAtomService uocCoreCreateLogisticsRelaTionAtomService;
    @Autowired
    private UocCoreCreateSaleOrderAtomService uocCoreCreateSaleOrderAtomService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UocCoreCreatePayOrderAtomService uocCoreCreatePayOrderAtomService;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private PebIntfSgOrgAmountDeductAbilityService pebIntfSgOrgAmountDeductAbilityService;
    @Autowired
    private OrdItemMapMapper ordItemMapMapper;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Value(value="${uoc.saveJdOrgId:false}")
    private Boolean saveJdOrgId;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private UocProGetVoucherNoAtomService uocProGetVoucherNoAtomService;

    public PebExtAgreementCreateOrderRspBO dealPebExtAgreementCreateOrder(PebExtAgreementCreateOrderReqBO reqBO) {
        List ordItemList;
        Long limit;
        PebExtAgreementCreateOrderRspBO rspBO = new PebExtAgreementCreateOrderRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Long orderId = this.idUtil.nextId();
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getAddressInfo());
        UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
        if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
        }
        Long contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = this.buildCreateSaleOrderParam(reqBO, orderId, contactId);
        uocCoreCreateSaleOrderReqBO.setProcKey(reqBO.getProcKey());
        Long saleFee = uocCoreCreateSaleOrderReqBO.getSaleFee();
        Long skuSupplierId = ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierId();
        String supplierName = ((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getSkuSupplierName();
        ConfSupplierPO qrySup = new ConfSupplierPO();
        qrySup.setSupNo(skuSupplierId);
        ConfSupplierPO modelBy = this.confSupplierMapper.getModelBy(qrySup);
        if (modelBy != null && (limit = modelBy.getOrderLimit()) != null && limit > 0L && limit > saleFee) {
            String money = null;
            try {
                money = UocMoneyUtil.Long2BigDecimal((Long)limit).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw new UocProBusinessException("8888", supplierName + "\u4e0b\u7684\u8ba2\u5355\u4e0d\u6ee1\u8db3" + money + "\u5143\uff0c\u4e0d\u5141\u8bb8\u4e0b\u5355\u3002");
        }
        UocCoreCreateSaleOrderRspBO uocCoreCreateSaleOrderRspBO = this.uocCoreCreateSaleOrderAtomService.dealCoreCreateSaleOrder(uocCoreCreateSaleOrderReqBO);
        if (!"0000".equals(uocCoreCreateSaleOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", uocCoreCreateSaleOrderRspBO.getRespDesc());
        }
        OrdItemPO ordItemPo = new OrdItemPO();
        ordItemPo.setOrderId(orderId);
        try {
            ordItemList = this.ordItemMapper.getList(ordItemPo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u67e5\u8be2\u9500\u552e\u660e\u7ec6\u5931\u8d25!");
        }
        UocCoreCreatePayOrderReqBO uocCoreCreatePayOrderReqBO = this.buildCreatePayOrderParam(orderId, reqBO, ordItemList, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        UocCoreCreatePayOrderRspBO uocCoreCreatePayOrderRspBO = this.uocCoreCreatePayOrderAtomService.dealCoreCreatePayOrder(uocCoreCreatePayOrderReqBO);
        if (!"0000".equals(uocCoreCreatePayOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", uocCoreCreatePayOrderRspBO.getRespDesc());
        }
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = this.buildCreateOrderParam(orderId, reqBO);
        UocCoreCreateOrderRspBO uocCoreCreateOrderRspBO = this.uocCoreCreateOrderAtomService.dealCoreCreateOrder(uocCoreCreateOrderReqBO);
        if (!"0000".equals(uocCoreCreateOrderRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", uocCoreCreateOrderRspBO.getRespDesc());
        }
        this.saveAccessory(reqBO, orderId);
        this.saveExt(reqBO, orderId, ordItemList);
        rspBO.setSaleOrderCode(uocCoreCreateSaleOrderReqBO.getSaleVoucherNo());
        rspBO.setSaleOrderId(String.valueOf(uocCoreCreateSaleOrderRspBO.getSaleVoucherId()));
        rspBO.setStatusName(uocCoreCreateSaleOrderRspBO.getSaleStateStr());
        rspBO.setGoodSupplierName(reqBO.getAgreementBO().getSupplierName());
        rspBO.setGoodsSupplierId(uocCoreCreateOrderReqBO.getSupId());
        rspBO.setOrderId(orderId);
        this.saveInvoice(reqBO, orderId, uocCoreCreateSaleOrderRspBO.getSaleVoucherId());
        this.savePayConfInfo(reqBO, rspBO);
        return rspBO;
    }

    private void saveInvoice(PebExtAgreementCreateOrderReqBO reqBO, Long orderId, Long saleId) {
        if (reqBO.getInvoiceBO() != null) {
            Long contactId;
            if (reqBO.getInvoiceAddressInfo() != null) {
                UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = this.buildLogisticsRelaTionParam(orderId, reqBO.getInvoiceAddressInfo());
                UocCoreCreateLogisticsRelaRspBO uocCoreCreateLogisticsRelaRspBO = this.uocCoreCreateLogisticsRelaTionAtomService.dealCoreCreateLogisticsRela(uocCoreCreateLogisticsRelaReqBO);
                if (!"0000".equals(uocCoreCreateLogisticsRelaRspBO.getRespCode())) {
                    throw new UocProBusinessException("8888", uocCoreCreateLogisticsRelaRspBO.getRespDesc());
                }
                contactId = uocCoreCreateLogisticsRelaRspBO.getContactId();
            } else {
                contactId = saleId;
            }
            Long id = this.idUtil.nextId();
            OrdInvoicePO ordInvoicePO = new OrdInvoicePO();
            ordInvoicePO.setInvoiceUrl(reqBO.getInvoiceBO().getInvoiceUrl());
            ordInvoicePO.setBankAccount(reqBO.getInvoiceBO().getBankAccount());
            ordInvoicePO.setBuyerName(reqBO.getInvoiceBO().getBuyerName());
            ordInvoicePO.setCompanyAddress(reqBO.getInvoiceBO().getCompanyAddress());
            ordInvoicePO.setDepositBank(reqBO.getInvoiceBO().getDepositBank());
            ordInvoicePO.setFixPhone(reqBO.getInvoiceBO().getFixPhone());
            ordInvoicePO.setInvoiceNo(reqBO.getInvoiceBO().getInvoiceNo());
            ordInvoicePO.setInvoiceSn(reqBO.getInvoiceBO().getInvoiceSn());
            ordInvoicePO.setInvoiceType(reqBO.getInvoiceBO().getInvoiceType());
            ordInvoicePO.setRelaEmail(reqBO.getInvoiceBO().getRelaEmail());
            ordInvoicePO.setRelaPhone(reqBO.getInvoiceBO().getRelaPhone());
            ordInvoicePO.setOrderId(orderId);
            ordInvoicePO.setId(id);
            ordInvoicePO.setSaleVoucherId(contactId);
            ordInvoicePO.setOutInvoiceId(reqBO.getInvoiceBO().getUmcInvoiceId());
            this.ordInvoiceMapper.insert(ordInvoicePO);
        }
    }

    private void editOrgAmount(PebExtAgreementCreateOrderReqBO reqBO) {
        SgOrgAmountDeductReqBO sgOrgAmountDeductReqBO = new SgOrgAmountDeductReqBO();
        sgOrgAmountDeductReqBO.setAmount(reqBO.getTotalAmount().divide(new BigDecimal(10000)).toString());
        sgOrgAmountDeductReqBO.setOrgId(reqBO.getOrgId());
        sgOrgAmountDeductReqBO.setBalanceType(PebExtConstant.BalanceType.ND);
        sgOrgAmountDeductReqBO.setOperType("2");
        SgOrgAmountDeductRspBO sgOrgAmountDeductRspBO = this.pebIntfSgOrgAmountDeductAbilityService.editOrgAmount(sgOrgAmountDeductReqBO);
        if (!("2".equals(reqBO.getMemUserType()) || "1".equals(reqBO.getMemUserType()) || "0000".equals(sgOrgAmountDeductRspBO.getRespCode()))) {
            throw new UocProBusinessException("8888", sgOrgAmountDeductRspBO.getRespDesc());
        }
    }

    private void saveExt(PebExtAgreementCreateOrderReqBO reqBO, Long orderId, List<OrdItemPO> ordItemList) {
        OrdExtMapPO transactionNoticeNo;
        OrdExtMapPO ordExtMapPO;
        ArrayList<OrdExtMapPO> list = new ArrayList<OrdExtMapPO>();
        ArrayList<OrdItemMapPO> itemMapPOS = new ArrayList<OrdItemMapPO>();
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            if (skuInfo.getChannel() == null) continue;
            for (OrdItemPO itemPO : ordItemList) {
                OrdExtMapPO extMapPO = new OrdExtMapPO();
                extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                extMapPO.setFieldValue(skuInfo.getChannel().toString());
                extMapPO.setFieldName("\u5546\u54c1\u9891\u9053");
                extMapPO.setFieldCode("channel");
                extMapPO.setOrderId(orderId);
                extMapPO.setObjId(itemPO.getOrdItemId());
                extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
                list.add(extMapPO);
                OrdItemMapPO mapPO = new OrdItemMapPO();
                mapPO.setOrderId(orderId);
                mapPO.setId(Long.valueOf(this.idUtil.nextId()));
                mapPO.setOrderItemId(itemPO.getOrdItemId());
                mapPO.setFieldValue(String.valueOf(skuInfo.getSoldNumber()));
                mapPO.setFieldName("\u5e93\u5b58");
                mapPO.setFieldCode("stock");
                itemMapPOS.add(mapPO);
            }
        }
        if (CollectionUtils.isNotEmpty(itemMapPOS)) {
            this.ordItemMapMapper.insertBatch(itemMapPOS);
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
        extMapPO.setFieldValue(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getPurchType().toString());
        extMapPO.setFieldName("\u91c7\u8d2d\u6a21\u5f0f");
        extMapPO.setFieldCode("purType");
        extMapPO.setOrderId(orderId);
        extMapPO.setObjId(orderId);
        extMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
        list.add(extMapPO);
        if (StringUtils.isNotBlank((CharSequence)((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getExtField2())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getExtField2());
            ordExtMapPO.setFieldName("\u534f\u8baeecp\u5408\u540c\u7f16\u53f7");
            ordExtMapPO.setFieldCode("agrEcpHt");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getExtField1())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getExtField1());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f");
            ordExtMapPO.setFieldCode("purMod");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        if (StringUtils.isNotBlank((CharSequence)((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getExtField1Str())) {
            ordExtMapPO = new OrdExtMapPO();
            ordExtMapPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordExtMapPO.setFieldValue(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getExtField1Str());
            ordExtMapPO.setFieldName("\u91c7\u8d2d\u65b9\u5f0f\u7ffb\u8bd1");
            ordExtMapPO.setFieldCode("purModStr");
            ordExtMapPO.setOrderId(orderId);
            ordExtMapPO.setObjId(orderId);
            ordExtMapPO.setObjType(PebExtConstant.OBJ_TYPE.EXT);
            list.add(ordExtMapPO);
        }
        OrdExtMapPO ecpPurType = new OrdExtMapPO();
        ecpPurType.setId(Long.valueOf(this.idUtil.nextId()));
        ecpPurType.setFieldValue(reqBO.getEcpPurType());
        ecpPurType.setFieldName("ecp\u91c7\u8d2d\u7c7b\u578b");
        ecpPurType.setFieldCode("ecpPurType");
        ecpPurType.setOrderId(orderId);
        ecpPurType.setObjId(orderId);
        ecpPurType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(ecpPurType);
        if (this.saveJdOrgId != null && this.saveJdOrgId.booleanValue()) {
            OrdExtMapPO jdOrgId = new OrdExtMapPO();
            jdOrgId.setId(Long.valueOf(this.idUtil.nextId()));
            jdOrgId.setFieldValue(reqBO.getCompanyId().toString());
            jdOrgId.setFieldName("\u91c7\u8d2d\u5355\u4f4did");
            jdOrgId.setFieldCode("jdOrgId");
            jdOrgId.setOrderId(orderId);
            jdOrgId.setObjId(orderId);
            jdOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(jdOrgId);
        }
        OrdExtMapPO orderCategory = new OrdExtMapPO();
        orderCategory.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            orderCategory.setFieldValue("1");
        } else {
            orderCategory.setFieldValue("0");
        }
        OrdExtMapPO payBusiType = new OrdExtMapPO();
        payBusiType.setId(Long.valueOf(this.idUtil.nextId()));
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            payBusiType.setFieldValue("3");
        } else {
            payBusiType.setFieldValue(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgreementMode());
        }
        payBusiType.setFieldName("\u4e1a\u52a1\u7c7b\u578b");
        payBusiType.setFieldCode("payBusiType");
        payBusiType.setOrderId(orderId);
        payBusiType.setObjId(orderId);
        payBusiType.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(payBusiType);
        orderCategory.setFieldName("\u5458\u5de5\u798f\u5229");
        orderCategory.setFieldCode("orderCategory");
        orderCategory.setOrderId(orderId);
        orderCategory.setObjId(orderId);
        orderCategory.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(orderCategory);
        OrdExtMapPO ComOrgId = new OrdExtMapPO();
        ComOrgId.setId(Long.valueOf(this.idUtil.nextId()));
        ComOrgId.setFieldValue(reqBO.getCompanyId().toString());
        ComOrgId.setFieldName("\u516c\u53f8id");
        ComOrgId.setFieldCode("companyId");
        ComOrgId.setOrderId(orderId);
        ComOrgId.setObjId(orderId);
        ComOrgId.setObjType(UocConstant.OBJ_TYPE.ORDER);
        list.add(ComOrgId);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionNoticeNo())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u6210\u4ea4\u901a\u77e5\u4e66\u7f16\u53f7");
            transactionNoticeNo.setFieldValue(reqBO.getTransactionNoticeNo());
            transactionNoticeNo.setFieldCode("transactionNoticeNo");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTransactionNoticeName())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u6210\u4ea4\u901a\u77e5\u4e66\u540d\u79f0");
            transactionNoticeNo.setFieldValue(reqBO.getTransactionNoticeName());
            transactionNoticeNo.setFieldCode("transactionNoticeName");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getComplianceTime())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u627f\u8bfa\u5230\u8d27\u65e5");
            transactionNoticeNo.setFieldValue(reqBO.getComplianceTime());
            transactionNoticeNo.setFieldCode("complianceTime");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDeliveryRequestMethod())) {
            transactionNoticeNo = new OrdExtMapPO();
            transactionNoticeNo.setId(Long.valueOf(this.idUtil.nextId()));
            transactionNoticeNo.setFieldName("\u4ea4\u8d27\u671f\u8981\u6c42\u65b9\u5f0f");
            transactionNoticeNo.setFieldValue(reqBO.getDeliveryRequestMethod());
            transactionNoticeNo.setFieldCode("deliveryRequestMethod");
            transactionNoticeNo.setOrderId(orderId);
            transactionNoticeNo.setObjId(orderId);
            transactionNoticeNo.setObjType(UocConstant.OBJ_TYPE.ORDER);
            list.add(transactionNoticeNo);
        }
        if (list.size() > 0) {
            this.ordExtMapMapper.insertBatch(list);
        }
    }

    private void saveAccessory(PebExtAgreementCreateOrderReqBO reqBO, Long orderId) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            return;
        }
        ArrayList<OrdAccessoryPO> list = new ArrayList<OrdAccessoryPO>(reqBO.getAccessoryList().size());
        for (AccessoryBO accessoryBO : reqBO.getAccessoryList()) {
            OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
            ordAccessoryPO.setId(Long.valueOf(this.idUtil.nextId()));
            ordAccessoryPO.setCreateTime(new Date());
            ordAccessoryPO.setOrderId(orderId);
            ordAccessoryPO.setAttachmentType(UocConstant.UOC_ATTACHMENT_TYPE.TYPE_AFTER_ORTHER);
            ordAccessoryPO.setObjectType(UocConstant.OBJ_TYPE.ORDER);
            ordAccessoryPO.setAccessoryName(accessoryBO.getAccessoryName());
            ordAccessoryPO.setAccessoryUrl(accessoryBO.getAccessoryUrl());
            ordAccessoryPO.setAccessoryId(accessoryBO.getAccessoryId());
            ordAccessoryPO.setCreateOperId(String.valueOf(reqBO.getUserId()));
            ordAccessoryPO.setObjectId(orderId);
            ordAccessoryPO.setRemark("CREATE_ORDER");
            list.add(ordAccessoryPO);
        }
        this.ordAccessoryMapper.insertBatch(list);
    }

    private AtomUocCoreCreateOrderReqBO buildCreateOrderParam(Long orderId, PebExtAgreementCreateOrderReqBO reqBO) {
        AtomUocCoreCreateOrderReqBO uocCoreCreateOrderReqBO = new AtomUocCoreCreateOrderReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreCreateOrderReqBO);
        if (PebExtConstant.OrderType.DA.equals(reqBO.getOrderType())) {
            uocCoreCreateOrderReqBO.setOrderName(reqBO.getOrderName() + "\u7684\u91c7\u8d2d\u8ba2\u5355");
        } else {
            uocCoreCreateOrderReqBO.setOrderName(String.valueOf(orderId));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getLoginSource())) {
            uocCoreCreateOrderReqBO.setExtField2(reqBO.getLoginSource());
        }
        if (((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getContractId() != null) {
            uocCoreCreateOrderReqBO.setExtField3(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getContractId().toString());
        }
        uocCoreCreateOrderReqBO.setUserId(reqBO.getUserId());
        uocCoreCreateOrderReqBO.setOrgId(reqBO.getOrgId());
        uocCoreCreateOrderReqBO.setUserType(reqBO.getMemUserType());
        uocCoreCreateOrderReqBO.setCompanyId(reqBO.getCompanyId());
        uocCoreCreateOrderReqBO.setCompanyName(reqBO.getCompanyName());
        if (reqBO.getOrgLevel() != null) {
            uocCoreCreateOrderReqBO.setOrgLevel(reqBO.getOrgLevel());
        }
        uocCoreCreateOrderReqBO.setOrderId(orderId);
        uocCoreCreateOrderReqBO.setOrderNo(ElUtils.long2String((Long)orderId));
        if (reqBO.getOrderType() == null) {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
                uocCoreCreateOrderReqBO.setOrderType(PebExtConstant.OrderType.FL);
            } else {
                uocCoreCreateOrderReqBO.setOrderType(Integer.valueOf(Integer.parseInt(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgreementMode())));
            }
        } else {
            uocCoreCreateOrderReqBO.setOrderType(reqBO.getOrderType());
        }
        uocCoreCreateOrderReqBO.setPayType(String.valueOf(reqBO.getPayType()));
        Long saleFee = reqBO.getTotalAmount().longValue();
        uocCoreCreateOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateOrderReqBO.setCreateOperId(ElUtils.long2String((Long)reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setOrderDesc(reqBO.getComment());
        uocCoreCreateOrderReqBO.setPurId(ElUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurName(reqBO.getOrgName());
        uocCoreCreateOrderReqBO.setPurAccount(String.valueOf(reqBO.getPurchaserAccount()));
        uocCoreCreateOrderReqBO.setPurAccountName(reqBO.getPurchaserAccountName());
        uocCoreCreateOrderReqBO.setPurPlaceOrderId(String.valueOf(reqBO.getUserId()));
        uocCoreCreateOrderReqBO.setPurPlaceOrderName(reqBO.getUsername());
        uocCoreCreateOrderReqBO.setPurOrgId(ElUtils.long2String((Long)reqBO.getOrgId()));
        uocCoreCreateOrderReqBO.setPurOrgPath(reqBO.getOrgPath());
        uocCoreCreateOrderReqBO.setSupId(reqBO.getAgreementBO().getVendorId());
        uocCoreCreateOrderReqBO.setSupName(reqBO.getAgreementBO().getVendorName());
        uocCoreCreateOrderReqBO.setProId(ElUtils.long2String((Long)reqBO.getProfessionalOrganizationId()));
        uocCoreCreateOrderReqBO.setPurAccountOwnId(ElUtils.long2String((Long)reqBO.getPurchaserAccountOrgId()));
        EnterpriseAccountBO accountBO = reqBO.getEnterpriseAccountBO();
        if (accountBO != null) {
            uocCoreCreateOrderReqBO.setPurMobile(accountBO.getTelephone());
            uocCoreCreateOrderReqBO.setProAccountRelaMobile(reqBO.getProPhone());
            uocCoreCreateOrderReqBO.setProName(accountBO.getDeliveryCenterName());
            uocCoreCreateOrderReqBO.setPurAccountName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurAccountOwnName(accountBO.getAccountName());
            uocCoreCreateOrderReqBO.setPurRelaName(reqBO.getUsername());
            uocCoreCreateOrderReqBO.setPurRelaMobile(accountBO.getTelephone());
        }
        uocCoreCreateOrderReqBO.setProAccountOwnName(reqBO.getProPath());
        if (reqBO.getProAccount() != null) {
            uocCoreCreateOrderReqBO.setProAccount(String.valueOf(reqBO.getProAccount()));
        }
        uocCoreCreateOrderReqBO.setProDeliveryId(String.valueOf(reqBO.getAgreementBO().getProducerId()));
        uocCoreCreateOrderReqBO.setProDeliveryName(reqBO.getAgreementBO().getProducerName());
        uocCoreCreateOrderReqBO.setPurLogName(reqBO.getCreateName());
        return uocCoreCreateOrderReqBO;
    }

    private UocCoreCreatePayOrderReqBO buildCreatePayOrderParam(Long orderId, PebExtAgreementCreateOrderReqBO reqBO, List<OrdItemPO> ordItemPOS, Long saleOrderId) {
        UocCoreCreatePayOrderReqBO payOrderReqBO = new UocCoreCreatePayOrderReqBO();
        payOrderReqBO.setPayVoucherNo(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMdd") + orderId);
        payOrderReqBO.setOrderId(orderId);
        payOrderReqBO.setObjId(saleOrderId);
        payOrderReqBO.setObjType(UocConstant.ORDER_TYPE.SALE_ORDER);
        payOrderReqBO.setInterType(PecConstant.PAY_FLAG);
        if (reqBO.getPayTypeIn() != null) {
            payOrderReqBO.setPayType(reqBO.getPayTypeIn());
        } else {
            payOrderReqBO.setPayType(reqBO.getPayType());
        }
        payOrderReqBO.setFeeType(PecConstant.FEE_TYPE_SALE);
        try {
            payOrderReqBO.setTotalFee(Long.valueOf(reqBO.getTotalAmount().longValue()));
            payOrderReqBO.setPreFee(Long.valueOf(reqBO.getPreFee().longValue()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u603b\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            if (reqBO.getActPrice() == null) {
                reqBO.setActPrice(BigDecimal.ZERO);
            }
            if (reqBO.getReducedPrice() == null) {
                reqBO.setReducedPrice(BigDecimal.ZERO);
            }
            Long disPrice = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getReducedPrice());
            Long actFee = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getActPrice());
            Long totalPrice = payOrderReqBO.getTotalFee();
            payOrderReqBO.setReduceFee(disPrice);
            payOrderReqBO.setActFee(actFee);
            payOrderReqBO.setTotalFee(totalPrice);
            payOrderReqBO.setPayFee(payOrderReqBO.getPreFee());
        }
        catch (Exception e) {
            throw new UocProBusinessException("8888", "\u603b\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        if (payOrderReqBO.getPayFee().equals(payOrderReqBO.getRedEnvelopeFee())) {
            payOrderReqBO.setPayTime(new Date());
            payOrderReqBO.setPayState(UocConstant.PAY_ORDER_STATUS.SUCCESS);
        } else {
            payOrderReqBO.setPayState(UocConstant.PAY_ORDER_STATUS.UNPAID);
        }
        payOrderReqBO.setCreateOperId(ElUtils.long2String((Long)reqBO.getUserId()));
        ArrayList<UocOrderPayItemBO> uocOrderPayItemBOList = new ArrayList<UocOrderPayItemBO>();
        OrdItemPO ordItemPO = null;
        UocOrderPayItemBO uocOrderPayItemBO = null;
        Iterator<OrdItemPO> iterator = ordItemPOS.iterator();
        while (iterator.hasNext()) {
            OrdItemPO ordItemPO1;
            ordItemPO = ordItemPO1 = iterator.next();
            uocOrderPayItemBO = new UocOrderPayItemBO();
            uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
            uocOrderPayItemBO.setPurchaseCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setOrdItemId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setPayObjId(ordItemPO.getOrdItemId());
            uocOrderPayItemBO.setCurrencyType(ordItemPO.getCurrencyType());
            uocOrderPayItemBO.setPayCount(ordItemPO.getPurchaseCount());
            uocOrderPayItemBO.setUnitName(ordItemPO.getUnitName());
            uocOrderPayItemBO.setSalePrice(ordItemPO.getSalePrice());
            uocOrderPayItemBO.setPurchasePrice(ordItemPO.getPurchasePrice());
            uocOrderPayItemBO.setTotalFee(ordItemPO.getTotalSaleFee());
            uocOrderPayItemBO.setRedEnvelopeFee(ordItemPO.getRedEnvelopeFee());
            uocOrderPayItemBO.setReduceFee(ordItemPO.getDisPrice());
            if (ordItemPO.getDisPrice() == null) {
                ordItemPO.setDisPrice(Long.valueOf(0L));
            }
            if (ordItemPO.getActShareFee() == null) {
                ordItemPO.setActShareFee(Long.valueOf(0L));
            }
            uocOrderPayItemBO.setPayFee(ordItemPO.getPreFee());
            uocOrderPayItemBO.setActFee(ordItemPO.getActShareFee());
            uocOrderPayItemBO.setPreFee(ordItemPO.getPreFee());
            uocOrderPayItemBOList.add(uocOrderPayItemBO);
        }
        payOrderReqBO.setUocOrderPayItemList(uocOrderPayItemBOList);
        return payOrderReqBO;
    }

    private UocCoreCreateSaleOrderReqBO buildCreateSaleOrderParam(PebExtAgreementCreateOrderReqBO reqBO, Long orderId, Long contactId) {
        UocCoreCreateSaleOrderReqBO uocCoreCreateSaleOrderReqBO = new UocCoreCreateSaleOrderReqBO();
        ArrayList<UocOrderItemBO> uocOrderItemList = new ArrayList<UocOrderItemBO>();
        Long purchaseFee = 0L;
        BigDecimal totalAm = BigDecimal.ZERO;
        BigDecimal totalPre = BigDecimal.ZERO;
        Long serPrice = 0L;
        if (null != reqBO.getAgreementBO().getServiceRate() && reqBO.getAgreementBO().getServiceRate() > 0.0) {
            BigDecimal serviceRate = BigDecimal.valueOf(reqBO.getAgreementBO().getServiceRate());
            serPrice = serviceRate.multiply(new BigDecimal(10000)).longValue();
        }
        for (PebExtAgreementSkuInfo skuInfo : reqBO.getSaleOrderItemList()) {
            UocOrderItemBO uocOrderItemBO = new UocOrderItemBO();
            if (!ObjectUtil.isEmpty((Object)skuInfo.getPlanItemNo())) {
                uocOrderItemBO.setPlanItemNo(skuInfo.getPlanItemNo());
            }
            uocOrderItemBO.setSerPrice(serPrice);
            totalAm = totalAm.add(skuInfo.getTotalPrice());
            totalPre = totalPre.add(skuInfo.getPreFee());
            uocOrderItemBO.setItemType(PecConstant.ORD_SALE_ITEM_TYPE_SKU);
            uocOrderItemBO.setTax(Long.valueOf(reqBO.getAgreementBO().getTaxRate().intValue()));
            uocOrderItemBO.setSkuId(skuInfo.getSkuId());
            uocOrderItemBO.setSkuItemId(skuInfo.getItemId());
            uocOrderItemBO.setSkuName(skuInfo.getSkuName());
            uocOrderItemBO.setTaxId(skuInfo.getTaxCode());
            uocOrderItemBO.setSkuSimpleName(skuInfo.getSkuSupplierName());
            uocOrderItemBO.setSupNo(String.valueOf(skuInfo.getGoodsSupplierId()));
            uocOrderItemBO.setSupplierShopId(skuInfo.getSupplierShopId());
            Long skuSalePrice = 0L;
            Long skupurchasePrice = 0L;
            Long skuSaleFee = 0L;
            Long skuPurchaseFee = 0L;
            Long redEnvelopeFee = 0L;
            Long disPricel = 0L;
            try {
                skuSalePrice = MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice());
                skupurchasePrice = MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice());
                BigDecimal divide = skuInfo.getSkuSalePrice().multiply(skuInfo.getPurchaseCount());
                skuSaleFee = MoneyUtils.BigDecimalToLong((BigDecimal)divide);
                BigDecimal multiply = skuInfo.getSkuAgreementPrice().multiply(skuInfo.getPurchaseCount());
                skuPurchaseFee = MoneyUtils.BigDecimalToLong((BigDecimal)multiply);
                purchaseFee = purchaseFee + skuPurchaseFee;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new UocProBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            uocOrderItemBO.setMarkUpRate(Double.valueOf(skuInfo.getAddCoefficient().doubleValue()));
            uocOrderItemBO.setPreFee(Long.valueOf(skuInfo.getPreFee().longValue()));
            uocOrderItemBO.setRedEnvelopeFee(redEnvelopeFee);
            uocOrderItemBO.setDisPrice(disPricel);
            uocOrderItemBO.setRedEnvelopeFee(redEnvelopeFee);
            uocOrderItemBO.setArrivalTime(skuInfo.getArrivalTime());
            uocOrderItemBO.setSalePrice(skuSalePrice);
            uocOrderItemBO.setPurchasePrice(skupurchasePrice);
            uocOrderItemBO.setTotalSaleFee(skuSaleFee);
            uocOrderItemBO.setTotalPurchaseFee(skuPurchaseFee);
            uocOrderItemBO.setCurrencyType(skuInfo.getSkuCurrencyType());
            uocOrderItemBO.setRecvAddr(skuInfo.getComparisonGoodsNo());
            uocOrderItemBO.setUnitName(skuInfo.getMeasureName());
            uocOrderItemBO.setSettleUnit(skuInfo.getSettlementUnit());
            uocOrderItemBO.setPurchaseCount(skuInfo.getPurchaseCount());
            ArrayList uocOrderItemEwBOList = new ArrayList();
            uocOrderItemBO.setUocOrderItemEwList(uocOrderItemEwBOList);
            ArrayList<UocOrderGoodsGiftBO> uocOrderGoodsGiftBOList = new ArrayList<UocOrderGoodsGiftBO>();
            List orderSaleGiftList = skuInfo.getUocOrderGoodsGiftBOList();
            if (!CollectionUtils.isEmpty((Collection)orderSaleGiftList)) {
                UocOrderGoodsGiftBO orderGoodsGiftBO = null;
                for (Object goodsGiftBO : orderSaleGiftList) {
                    orderGoodsGiftBO = new UocOrderGoodsGiftBO();
                    orderGoodsGiftBO.setGiftSkuId(goodsGiftBO.getGiftSkuId());
                    orderGoodsGiftBO.setGiftNum(Integer.valueOf(goodsGiftBO.getGiftNum().intValue()));
                    orderGoodsGiftBO.setGiftType(goodsGiftBO.getGiftType());
                    uocOrderGoodsGiftBOList.add(orderGoodsGiftBO);
                }
            }
            uocOrderItemBO.setUocOrderGoodsGiftList(uocOrderGoodsGiftBOList);
            OrdGoodsBO ordGoodsBO = new OrdGoodsBO();
            BeanUtils.copyProperties((Object)skuInfo, (Object)ordGoodsBO);
            ordGoodsBO.setSupplierShopName(skuInfo.getSupplierShopName());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuId(skuInfo.getSkuId() + "");
            ordGoodsBO.setSkuName(skuInfo.getSkuName());
            ordGoodsBO.setSkuSupplierId(skuInfo.getSkuSupplierId());
            ordGoodsBO.setSkuSupplierName(skuInfo.getSkuSupplierName());
            ordGoodsBO.setSkuMaterialId(skuInfo.getSkuMaterialId());
            ordGoodsBO.setSkuMaterialName(skuInfo.getSkuMaterialName());
            ordGoodsBO.setSkuExtSkuId(skuInfo.getSkuExtSkuId());
            ordGoodsBO.setSkuItemId(skuInfo.getItemId());
            ordGoodsBO.setSkuUpcCode(skuInfo.getSkuUpcCode());
            ordGoodsBO.setSkuCommodityTypeId(skuInfo.getSkuCommodityTypeId());
            ordGoodsBO.setSkuLocation(skuInfo.getSkuLocation());
            ordGoodsBO.setSkuMainPicUrl(skuInfo.getSkuMainPicUrl());
            ordGoodsBO.setSkuDetail(skuInfo.getSkuDetail());
            ordGoodsBO.setSkuSaleArea(skuInfo.getSkuSaleArea());
            ordGoodsBO.setSkuStatus(skuInfo.getSkuStatus());
            ordGoodsBO.setSkuBrandId(ElUtils.string2Long((String)skuInfo.getBrandId()));
            ordGoodsBO.setSkuBrandName(skuInfo.getSkuBrandName());
            ordGoodsBO.setSkuIsSupplierAgreement(skuInfo.getSkuIsSupplierAgreement());
            try {
                ordGoodsBO.setSkuMarketPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuMarketPrice()));
                ordGoodsBO.setSkuAgreementPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuAgreementPrice()));
                ordGoodsBO.setSkuMemberPrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuMemberPrice()));
                ordGoodsBO.setSkuSalePrice(MoneyUtils.BigDecimalToLong((BigDecimal)skuInfo.getSkuSalePrice()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
            }
            ordGoodsBO.setSkuCurrencyType(skuInfo.getSkuCurrencyType());
            ordGoodsBO.setSupplierShopId(skuInfo.getSupplierShopId());
            ArrayList<OrdGoodsAttrBO> ordGoodsAttrBOList = new ArrayList<OrdGoodsAttrBO>();
            if (CollectionUtils.isNotEmpty((Collection)skuInfo.getCommodityAttrList())) {
                Object goodsGiftBO;
                goodsGiftBO = skuInfo.getCommodityAttrList().iterator();
                while (goodsGiftBO.hasNext()) {
                    CommodityAttrRspBO commodityAttrRspBO = (CommodityAttrRspBO)goodsGiftBO.next();
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityId(commodityAttrRspBO.getSkuCommodityId());
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(commodityAttrRspBO.getSkuCommodityPropGrpId());
                    ordGoodsAttrBO.setSkuCommoditySpecId(commodityAttrRspBO.getSkuCommoditySpecId());
                    ordGoodsAttrBO.setSkuPropName(commodityAttrRspBO.getSkuPropName());
                    ordGoodsAttrBO.setSkuPropShowName(commodityAttrRspBO.getSkuPropShowName());
                    ordGoodsAttrBO.setSkuPropValue(commodityAttrRspBO.getSkuPropValue());
                    ordGoodsAttrBO.setSkuPropValueListId(commodityAttrRspBO.getSkuPropValueListId());
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
                if (skuInfo.getServenRejectAllow() != null && skuInfo.getServenRejectAllow().equals(PecConstant.SERVEN_REJECT_ALLOW)) {
                    OrdGoodsAttrBO ordGoodsAttrBO = new OrdGoodsAttrBO();
                    ordGoodsAttrBO.setSkuCommodityId(skuInfo.getSpuId());
                    ordGoodsAttrBO.setSkuCommodityPropGrpId(null);
                    ordGoodsAttrBO.setSkuCommoditySpecId(null);
                    ordGoodsAttrBO.setSkuPropName("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropShowName("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropValue("\u4e03\u5929\u9000\u6362");
                    ordGoodsAttrBO.setSkuPropValueListId(null);
                    ordGoodsAttrBOList.add(ordGoodsAttrBO);
                }
            }
            ordGoodsBO.setOrdGoodsAttrBOList(ordGoodsAttrBOList);
            uocOrderItemBO.setOrdGoodsBO(ordGoodsBO);
            uocOrderItemBO.setSpuId(skuInfo.getSpuId() + "");
            if (skuInfo.getPlanItemId() != null) {
                uocOrderItemBO.setPlanItemId(skuInfo.getPlanItemId());
            }
            if (skuInfo.getPlanId() != null) {
                uocOrderItemBO.setPlanId(skuInfo.getPlanId());
            }
            uocOrderItemList.add(uocOrderItemBO);
        }
        reqBO.setTotalAmount(totalAm);
        reqBO.setPreFee(totalPre);
        BeanUtils.copyProperties((Object)reqBO, (Object)uocCoreCreateSaleOrderReqBO);
        uocCoreCreateSaleOrderReqBO.setAgreementBO(reqBO.getAgreementBO());
        uocCoreCreateSaleOrderReqBO.setSaleVoucherNo(this.buildNo("ZH", "SALE_ORDER_NO", reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setPurchaseNo(this.buildNo("ZHCG", "PUR_ORDER_NO", reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setOrderId(orderId);
        uocCoreCreateSaleOrderReqBO.setOrderLevel(Integer.valueOf(2));
        uocCoreCreateSaleOrderReqBO.setOrderSource(reqBO.getOrderSource());
        uocCoreCreateSaleOrderReqBO.setPurchaseType(Integer.valueOf(reqBO.getOrderSource()));
        uocCoreCreateSaleOrderReqBO.setIsDispatch(PecConstant.IS_DISPATCH_YES);
        uocCoreCreateSaleOrderReqBO.setPreFee(Long.valueOf(reqBO.getPreFee().longValue()));
        Long base = 0L;
        Long remote = 0L;
        Long total = 0L;
        Long saleFee = 0L;
        try {
            total = MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTatleTransportationFee());
            saleFee = MoneyUtils.BigDecimalToLong((BigDecimal)reqBO.getTotalAmount());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UocProBusinessException("8888", "\u91d1\u989d\u8f6c\u6362\u5f02\u5e38!");
        }
        if (total == null) {
            total = 0L;
        }
        uocCoreCreateSaleOrderReqBO.setBaseTransFee(base);
        uocCoreCreateSaleOrderReqBO.setRemoteTransFee(remote);
        uocCoreCreateSaleOrderReqBO.setTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setOldTotalTransFee(total);
        uocCoreCreateSaleOrderReqBO.setSaleFee(saleFee);
        uocCoreCreateSaleOrderReqBO.setContactId(contactId);
        uocCoreCreateSaleOrderReqBO.setAccNbr(reqBO.getAddressInfo().getReceiverMobileNumber());
        uocCoreCreateSaleOrderReqBO.setProvinceId(reqBO.getAddressInfo().getReceiverProvinceId());
        uocCoreCreateSaleOrderReqBO.setCityId(reqBO.getAddressInfo().getReceiverCityId());
        uocCoreCreateSaleOrderReqBO.setAreaId(reqBO.getAddressInfo().getReceiverCountyId());
        uocCoreCreateSaleOrderReqBO.setAddress(reqBO.getAddressInfo().getReceiverAddress());
        uocCoreCreateSaleOrderReqBO.setPurchaseFee(purchaseFee);
        uocCoreCreateSaleOrderReqBO.setUocOrderItemList(uocOrderItemList);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getActiveBOList())) {
            ArrayList<UocCoreAddOrdSaleCouponInfoBO> list = new ArrayList<UocCoreAddOrdSaleCouponInfoBO>();
            for (UocCoreActiveReqBO activeReqBO : reqBO.getActiveBOList()) {
                UocCoreAddOrdSaleCouponInfoBO infoBO = new UocCoreAddOrdSaleCouponInfoBO();
                infoBO.setCouponGranter("");
                infoBO.setCouponName(activeReqBO.getActiveName());
                infoBO.setCouponNo(activeReqBO.getActiveId());
                infoBO.setCouponValue(uocCoreCreateSaleOrderReqBO.getSaleFee());
                infoBO.setTypeName(activeReqBO.getTypeName());
                infoBO.setCouponGranter(reqBO.getActiveNo());
                infoBO.setType("11111");
                infoBO.setCouponGranter(reqBO.getActiveNo());
                list.add(infoBO);
            }
            uocCoreCreateSaleOrderReqBO.setUocCoreAddOrdSaleCouponInfoBOList(list);
            uocCoreCreateSaleOrderReqBO.setTotalIntegralFee(uocCoreCreateSaleOrderReqBO.getSaleFee());
            uocCoreCreateSaleOrderReqBO.setTotalUsedIntegral(uocCoreCreateSaleOrderReqBO.getSaleFee());
        }
        uocCoreCreateSaleOrderReqBO.setAgreementMode(Integer.valueOf(Integer.parseInt(((PebExtAgreementSkuInfo)reqBO.getSaleOrderItemList().get(0)).getAgreementMode())));
        uocCoreCreateSaleOrderReqBO.setModelSettle(reqBO.getAgreementBO().getTradeMode());
        return uocCoreCreateSaleOrderReqBO;
    }

    private UocCoreCreateLogisticsRelaReqBO buildLogisticsRelaTionParam(Long orderId, PebExtAddressInfoIntfceReqBO addressInfoIntfceBO) {
        UocCoreCreateLogisticsRelaReqBO uocCoreCreateLogisticsRelaReqBO = new UocCoreCreateLogisticsRelaReqBO();
        uocCoreCreateLogisticsRelaReqBO.setOrderId(orderId);
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactTown(addressInfoIntfceBO.getReceiverTown());
        uocCoreCreateLogisticsRelaReqBO.setContactTownId(addressInfoIntfceBO.getReceiverTownId());
        uocCoreCreateLogisticsRelaReqBO.setContactAddress(addressInfoIntfceBO.getReceiverAddress());
        uocCoreCreateLogisticsRelaReqBO.setContactCompany(addressInfoIntfceBO.getReceiverCompany());
        uocCoreCreateLogisticsRelaReqBO.setContactFixPhone(addressInfoIntfceBO.getReceiverFixPhone());
        uocCoreCreateLogisticsRelaReqBO.setContactMobile(addressInfoIntfceBO.getReceiverMobileNumber());
        uocCoreCreateLogisticsRelaReqBO.setContactName(addressInfoIntfceBO.getReceiverName());
        uocCoreCreateLogisticsRelaReqBO.setContactEmail(addressInfoIntfceBO.getReceiverEmail());
        uocCoreCreateLogisticsRelaReqBO.setContactCountryName(addressInfoIntfceBO.getReceiverCountryName());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyId(addressInfoIntfceBO.getReceiverCountyId());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceName(addressInfoIntfceBO.getReceiverProvinceName());
        uocCoreCreateLogisticsRelaReqBO.setContactProvinceId(addressInfoIntfceBO.getReceiverProvinceId());
        uocCoreCreateLogisticsRelaReqBO.setContactCityName(addressInfoIntfceBO.getReceiverCityName());
        uocCoreCreateLogisticsRelaReqBO.setContactCityId(addressInfoIntfceBO.getReceiverCityId());
        uocCoreCreateLogisticsRelaReqBO.setContactCountyName(addressInfoIntfceBO.getReceiverCountyName());
        return uocCoreCreateLogisticsRelaReqBO;
    }

    private String buildNo(String start, String voucherNoKey, String orderSource) {
        UocProGetVoucherNoAtomReqBo getBo = new UocProGetVoucherNoAtomReqBo();
        getBo.setVoucherNoKey(voucherNoKey);
        getBo.setOrderSource(orderSource);
        UocProGetVoucherNoAtomRspBo voucherNoRsp = this.uocProGetVoucherNoAtomService.getVoucherNo(getBo);
        if (!"0000".equals(voucherNoRsp.getRespCode())) {
            throw new UocProBusinessException("8888", voucherNoRsp.getRespDesc());
        }
        if (!voucherNoRsp.isVoucherGenerated()) {
            return this.buildNo(start);
        }
        return voucherNoRsp.getVoucherNo();
    }

    private String buildNo(String start) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        return start + date + time.substring(time.length() - 6);
    }

    private void savePayConfInfo(PebExtAgreementCreateOrderReqBO reqBO, PebExtAgreementCreateOrderRspBO rspBO) {
        ArrayList<OrdPayConfPO> payConfPOS;
        if (UocCoreConstant.TradeMode.TRADE_MODEL.equals(reqBO.getAgreementBO().getTradeMode())) {
            payConfPOS = new ArrayList<OrdPayConfPO>(2);
            for (AgreementSettlementBO agreementSettlementBO : reqBO.getAgreementBO().getPaymentMethod()) {
                OrdPayConfPO payConfPO = new OrdPayConfPO();
                payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                payConfPO.setOrderId(rspBO.getOrderId());
                if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                    if (agreementSettlementBO.getSettlementType().equals("1")) {
                        payConfPO.setPayType(Integer.valueOf("2"));
                    } else if (agreementSettlementBO.getSettlementType().equals("2")) {
                        payConfPO.setPayType(Integer.valueOf("1"));
                    } else {
                        throw new UocProBusinessException("0100", "\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f[settlementType\uff1a" + agreementSettlementBO.getSettlementType() + "]\u5b9a\u4e49\u4e0d\u5408\u6cd5");
                    }
                    payConfPO.setUserType(UocCoreConstant.UserType.PRO);
                } else {
                    payConfPO.setPayType(reqBO.getPayType());
                    payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                }
                if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                    payConfPO.setPilPaySup(new BigDecimal(100));
                    if ("0".equals(agreementSettlementBO.getAssign())) {
                        payConfPO.setPayRule(Integer.valueOf(2));
                        payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    } else {
                        payConfPO.setPayRule(Integer.valueOf(1));
                        payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    }
                } else {
                    payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                    payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                    payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                    payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                }
                if (null == payConfPO.getPrePayFee()) {
                    payConfPO.setPrePayFee(Long.valueOf(0L));
                }
                payConfPO.setVerPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                payConfPO.setQuaPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                if (null != agreementSettlementBO.getQuaProtectCount()) {
                    payConfPO.setWarantty(Integer.valueOf(agreementSettlementBO.getQuaProtectCount().intValue()));
                }
                payConfPO.setIsPushQua(Integer.valueOf(0));
                payConfPO.setTime(new Date());
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
                payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                payConfPO.setPayNodeRule(Integer.valueOf(2));
                payConfPOS.add(payConfPO);
            }
        } else {
            payConfPOS = new ArrayList(1);
            OrdPayConfPO payConfPO = new OrdPayConfPO();
            for (AgreementSettlementBO agreementSettlementBO : reqBO.getAgreementBO().getPaymentMethod()) {
                if (!"1".equals(agreementSettlementBO.getSettlementObject())) continue;
                payConfPO.setId(Long.valueOf(this.idUtil.nextId()));
                payConfPO.setOrderId(rspBO.getOrderId());
                if ("1".equals(agreementSettlementBO.getSettlementObject())) {
                    if (agreementSettlementBO.getSettlementType().equals("1")) {
                        payConfPO.setPayType(Integer.valueOf("2"));
                    } else if (agreementSettlementBO.getSettlementType().equals("2")) {
                        payConfPO.setPayType(Integer.valueOf("1"));
                    } else {
                        throw new UocProBusinessException("0100", "\u534f\u8bae\u4ed8\u6b3e\u65b9\u5f0f\u4fe1\u606f[settlementType\uff1a" + agreementSettlementBO.getSettlementType() + "]\u5b9a\u4e49\u4e0d\u5408\u6cd5");
                    }
                    payConfPO.setUserType(UocCoreConstant.UserType.PUR);
                }
                if ("2".equals(String.valueOf(payConfPO.getPayType()))) {
                    payConfPO.setPilPaySup(new BigDecimal(100));
                    if ("0".equals(agreementSettlementBO.getAssign())) {
                        payConfPO.setPayRule(Integer.valueOf(2));
                        payConfPO.setPaymentDays(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    } else {
                        payConfPO.setPayRule(Integer.valueOf(1));
                        payConfPO.setPayAccountDay(Integer.valueOf(agreementSettlementBO.getSettlementDate()));
                    }
                } else {
                    payConfPO.setPrePaySup(agreementSettlementBO.getPrePay());
                    payConfPO.setVerPaySup(agreementSettlementBO.getComPay());
                    payConfPO.setPilPaySup(agreementSettlementBO.getTryPay());
                    payConfPO.setQuaPaySup(agreementSettlementBO.getQuaPay());
                }
                payConfPO.setPrePayFee(Long.valueOf(0L));
                payConfPO.setVerPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                payConfPO.setQuaPayFee(Long.valueOf(0L));
                payConfPO.setPilPayFee(Long.valueOf(0L));
                if (null != agreementSettlementBO.getQuaProtectCount()) {
                    payConfPO.setWarantty(Integer.valueOf(agreementSettlementBO.getQuaProtectCount().intValue()));
                }
                payConfPO.setIsPushQua(Integer.valueOf(0));
                payConfPO.setTime(new Date());
                payConfPO.setPayBreakScale(BigDecimal.ZERO);
                payConfPO.setPayAccountDayRule(Integer.valueOf(2));
                payConfPO.setPayNodeRule(Integer.valueOf(2));
                payConfPOS.add(payConfPO);
                break;
            }
        }
        this.ordPayConfMapper.insertBatch(payConfPOS);
    }
}

