package com.tydic.first.api.activity.po;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 类名：ActivityOrderPo
 * 标题：
 * 说明：
 * 时间：2024/5/23 10:18
 *
 * @author yangyf
**/
/**
    * 福利订单信息表
    */
@Data
public class ActivityOrderPo {
    /**
    * 主键ID
    */
    private Long id;

    /**
    * 订单ID
    */
    private String orderId;

    /**
    * 父订单ID
    */
    private String parentId;

    /**
    * 订单类型：1电商，2协议
    */
    private Integer orderType;

    /**
    * 支付方式 (1 仅积分支付，2混合支付)
    */
    private Integer payType;

    /**
    * 订单来源，保存供应商ID
    */
    private String orderSource;

    /**
    * 订单状态
    */
    private Integer orderState;

    /**
    * 订单金额
    */
    private BigDecimal orderMoney;

    /**
    * 运费
    */
    private BigDecimal freightMoney;

    /**
    * 订单积分支付金额
    */
    private BigDecimal orderScore;

    /**
    * 个人支付金额
    */
    private BigDecimal personMoney;

    /**
    * 订单创建时间
    */
    private Date createTime;

    /**
    * 订单发货时间
    */
    private Date sendTime;

    /**
    * 订单到货时间
    */
    private Date arriveTime;

    /**
    * 订单完成时间
    */
    private Date finishTime;

    /**
    * 下单人ID
    */
    private Long createUserId;

    /**
    * 下单人名称
    */
    private String createUserName;

    /**
    * 下单人机构ID
    */
    private Long createOrgId;

    /**
    * 下单人机构名称
    */
    private String createOrgName;

    /**
    * 下单人公司ID
    */
    private Long createCompanyId;

    /**
    * 下单人公司名称
    */
    private String createCompanyName;

    /**
    * 接收订单时间
    */
    private Date receiveTime;

    /**
    * 更新时间
    */
    private Date updateTime;

    /**
    * 1父订单，2 子订单（含无拆单）
    */
    private Integer parentFlag;

    /**
    * 订单备注
    */
    private String remark;

    /**
    * 结算状态：0未提交，1已提交，2开票中，3已开票，4已签收，5已付款
    */
    private Integer settleState;

    /**
    * 活动ID
    */
    private Long activityId;

    /**
    * 下单人账号
    */
    private String createUserAccount;

    /**
    * 下单人机构树路径
    */
    private String createOrgPath;

    /**
    * 订单取消时间
    */
    private Date cancelTime;

    /**
    * 订单编号
    */
    private String orderNo;

    /**
    * 详情跳转链接
    */
    private String detailUrl;

    /**
    * 预警类型
    */
    private Integer alertType;

    /**
    * 扩展字段1
    */
    private String extField1;

    /**
    * 扩展字段2
    */
    private String extField2;

    /**
    * 扩展字段3
    */
    private String extField3;

    /**
    * 扩展字段4
    */
    private String extField4;

    /**
    * 扩展字段5
    */
    private String extField5;

    /**
    * 外部订单状态
    */
    private Integer otherOrderState;

    /**
    * 外部活动ID
    */
    private String extActivityId;

    /**
     * 创建起始时间
     */
    private String createStartTime;
    private String createEndTime;
    /**
     * 提交起始时间
     */
    private String updateStartTime;
    private String updateEndTime;
}