package com.tydic.first.api.activity.po;

import java.util.Date;
import lombok.Data;

/**
 * 类名：ActivityPo
 * 标题：
 * 说明：活动表
 * 时间：2024/4/9 18:30
 *
 * @author yangyf
**/

@Data
public class ActivityPo {
    /**
     * 活动编号（修改时必传）
     */
    private String activityCode;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 结算方式
     */
    private Integer payType;

    /**
     * 活动状态 1:开启/2:关闭
     */
    private Integer activityState;

    /**
     * 发票信息-发票开具方式[集中开票:1,订单完成后开票:4]
     */
    private Integer generalMethod;

    /**
     * 发票信息-发票抬头
     */
    private String generalTitle;

    /**
     * 发票信息-税号
     */
    private String generalTaxId;

    /**
     * 发票信息-发票内容[0:明细,100:大类]
     */
    private Integer generalContent;

    /**
     * 发票信息-收票人电话
     */
    private String invoicePhone;

    /**
     * 发票信息-收票人邮箱
     */
    private String invoiceEmail;

    /**
     * 扩展信息-签编码
     */
    private String activityLabelCode;

    /**
     * 扩展信息-标签值
     */
    private String activityLabelValue;

    /**
     * 开始时间
     */
    private Date startDate;

    /**
     * 结束时间
     */
    private Date endDate;
}