package com.tydic.first.api.order.bo.fjdm;

import com.tydic.first.api.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 订单确认
 */
@Data
public class ConfirmOrderBO extends BaseEntity {


    @NotBlank(message = "orderId不能为空")
    private String orderId;

    /**
     * 1订单2发货单
     */
    private Integer type;


    /**
     * 京东的订单单号(下单返回的父订单号)
     */
    private String jdOrderId;

    /**
     * 是否返回订单的配送信息。0不返回配送信息。1，返回配送信息。只支持最近2个月的配送信息查询。
     */
    private Integer waybillCode;


}
