package com.tydic.first.api.order.bo.fjdm;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class OrderItemBO implements Serializable {


    /**
     * order_id
     */
    private String orderId;

    /**
     * spu_id
     */
    private Long spuId;

    /**
     * spu_name
     */
    private String spuName;

    /**
     * spu_pic
     */
    private String spuPic;

    /**
     * 品牌
     */
    private String spuBrand;

    /**
     * 商品分类id
     */
    private Long categoryId;

    /**
     * 京东响应categoryId
     */
    private Long category;

    /**
     * 商品sku编号
     */
    @NotNull(message = "skuId不能为空")
    private Long skuId;

    /**
     * 商品sku名字
     */
    private String name;

    /**
     * 商品sku图片
     */
    private String skuPic;

    /**
     * 商品sku价格
     */
    @NotNull(message = "price不能为空")
    private BigDecimal price;

    /**
     * 商品购买的数量
     */
    private Long num;

    /**
     * 商品类型。 0 普通、1 附件、2 赠品、3延保
     */
    private Integer type;


    /**
     * 物流类型0：京东物流 1：其他物流
     */
    private String logisticsType;

    private Integer tax;

    private BigDecimal taxPrice;

    private BigDecimal nakedPrice;

    private Integer oid;

    private String taxId;

    private String taxName;

    private String unit;

}
