package com.tydic.first.api.order.bo.fjdm;


import com.fasterxml.jackson.annotation.JsonFormat;
import com.tydic.first.api.BaseEntity;
import lombok.Data;

import java.util.Date;

@Data
public class PushMessagerReqBO extends BaseEntity {
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    /**
     * 消息类型
     */
    private Integer type;

    /**
     * 父订单id
     */
    private String pOrder;

    /**
     * 商品编号
     */
    private Long skuId;

    /**
     * 订单id
     */
    private String orderId;

    /**
     * 类型（1：订单2：发货单）
     */
    private Integer orderType;

    /**
     * 妥投状态（1；已妥投：2拒收）
     */
    private Integer status;

    /**
     * 取消类型（0：7天未确认自动取消1：电商因为自身原因无法发货而取消
     * 不填默认为0）
     */
    private Long cancelType;

    /**
     * 取消原因
     */
    private String cancelReason;

    /** 发货单号 */
    private String packageId;
}
