package com.tydic.first.api.order.bo.fjdm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tydic.first.api.BaseEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 标题：ServiceOrderReqBO
 * 说明：
 * 时间：2023/10/16 15:09
 *
 * @author hcl
 **/
@NoArgsConstructor
@Data
public class ServiceOrderReqBO extends BaseEntity {
    /**
     * 京东入参
     */
    @JsonProperty("param")
    private String param;

    @JsonProperty("orderId")
    private String orderId;
    @JsonProperty("packageId")
    private String packageId;
    @JsonProperty("serviceType")
    private Integer serviceType;
    @JsonProperty("questionDesc")
    private String questionDesc;
    @JsonProperty("questionPic")
    private String questionPic;
    @JsonProperty("isHasPackage")
    private Boolean isHasPackage;
    @JsonProperty("packageDesc")
    private Integer packageDesc;
    /**
     * 1true 0false
     */
    @JsonProperty("isNeedDetectionReport")
    private Boolean isNeedDetectionReport;
    @JsonProperty("customer")
    private Customer customer;
    @JsonProperty("pickware")
    private Pickware pickware;
    @JsonProperty("returnware")
    private Returnware returnware;
    @JsonProperty("detail")
    private List<Detail> detail;
    @JsonProperty("serviceId")
    private String serviceId;

    /**
     * jd商品编码集合
     */
    private List<Long> wareIds;

    @NoArgsConstructor
    @Data
    public static class Customer {
        @JsonProperty("customerName")
        private String customerName;
        @JsonProperty("customerContactName")
        private String customerContactName;
        @JsonProperty("customerTel")
        private String customerTel;
        @JsonProperty("customerMobilePhone")
        private String customerMobilePhone;
        @JsonProperty("customerEmail")
        private String customerEmail;
        @JsonProperty("customerPostcode")
        private String customerPostcode;
    }

    @NoArgsConstructor
    @Data
    public static class Pickware {
        @JsonProperty("pickwareType")
        private Integer pickwareType;
        @JsonProperty("pickwareProvince")
        private Integer pickwareProvince;
        @JsonProperty("pickwareCity")
        private Integer pickwareCity;
        @JsonProperty("pickwareCounty")
        private Integer pickwareCounty;
        @JsonProperty("pickwareVillage")
        private Long pickwareVillage;
        @JsonProperty("pickwareAddress")
        private String pickwareAddress;
        @JsonProperty("pickwareStartTime")
        private String pickwareStartTime;
        @JsonProperty("pickwareEndTime")
        private String pickwareEndTime;
    }

    @NoArgsConstructor
    @Data
    public static class Returnware {
        @JsonProperty("returnwareType")
        private Integer returnwareType;
        @JsonProperty("returnwareProvince")
        private String returnwareProvince;
        @JsonProperty("returnwareCity")
        private String returnwareCity;
        @JsonProperty("returnwareCounty")
        private String returnwareCounty;
        @JsonProperty("returnwareVillage")
        private String returnwareVillage;
        @JsonProperty("returnwareAddress")
        private String returnwareAddress;
    }

    @NoArgsConstructor
    @Data
    public static class Detail {
        @JsonProperty("skuId")
        private String skuId;
        @JsonProperty("skuNum")
        private Integer skuNum;
    }
}
