package com.tydic.first.api.order.bo.jdm;

import com.tydic.first.api.BaseEntity;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：afterSaleDeliverGoodsInfoReqBO
 * 说明：售后发运信息申请
 * 时间：2023/10/18 9:52
 *
 * @author hcl
 **/
@NoArgsConstructor
@Data
public class JdAfterSaleDeliverGoodsInfoReqBO extends BaseEntity {

    private String Param;

    private AfterSaleDeliverGoodsParam waybillInfoList;

    @Data
    public class AfterSaleDeliverGoodsParam {

        /**
         * 服务单号
         */
        private String afsServiceId;

        /**
         * 订单id
         */
        private String orderId;

        private List<WayBillInfo> wayBillInfoList;

        @Data
        public class WayBillInfo {
            /**
             * 运费
             */
            private BigDecimal freightMoney;
            /**
             * 发运公司：例如圆通快递、申通快递
             */
            private String expressCompany;
            /**
             * 发货日期，格式为yyyy-MM-dd HH:mm:ss
             */
            private String deliverDate;
            /**
             * 发货单号
             */
            private String expressCode;

            /**
             * 商品类型 10主商品，20赠品
             */
            private Integer wareType;
            /**
             * 商品编号
             */
            private Long wareId;
        }

    }

}
