package com.tydic.first.api.order.bo.jdm;


import com.tydic.first.api.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * 对账接口BO
 */
@Data
public class JdJlOrderListRspBO extends BaseEntity {
    /**
     * 订单号
     */
    private Long jdOrderId;

    /**
     * 商户账号
     */
    private String pin;

    /**
     * 订单金额
     */
    private BigDecimal orderPrice;

    /**
     * 商户支付金额
     */
    private BigDecimal payMoney;

    /**
     * 运费
     */
    private BigDecimal freight;

    /**
     * 订单类型（1 实物订单，2 电子卡订单）
     */
    private int orderType;

    /**
     * 支付方式 (1 货到付款，2 邮局付款，4 在线支付，5 公司转账，6 银行转账)
     */
    private int paymentType;

    /**
     * 价格类型（"KA_PRICE", "大客价"，"JD_PRICE", "京东价"）
     */
    private int priceType;

    /**
     * 拆单类型 （0 无需拆单，1 父订单，2 子订单）
     */
    private int type;

    /**
     * 来源类型（1 开放平台，2 大客户平台，3 大宗采购系统）
     */
    private int sourceType;

    /**
     * 物流状态 （0 刚下单，1 妥投，2 拒收）
     */
    private int state;

    /**
     * 订单状态 （0 处理中，1 是有效, 2 是拆单）
     */
    private int orderState;

    /**
     * 是否确认下单 （0 暂停，1 确认发货）
     */
    private int submitState;

    /**
     * 是否预占库存 （0 预占，1 非预占）
     */
    private int submitType;

    /**
     * 收货人名称
     */
    private String name;

    /**
     * 收货人详细地址
     */
    private String address;

    /**
     * 收货地邮编
     */
    private String zip;

    /**
     * 收货人座机
     */
    private String phone;

    /**
     * 收货人手机
     */
    private String mobile;

    /**
     * 收货人邮箱
     */
    private String email;

    /**
     * 父订单号
     */
    private Long parentId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间，格式：2016-12-14 17:31:02
     */
    private Date created;

    /**
     * 出库时间，格式：2016-12-14 17:31:02
     */
    private Date outTime;

    /**
     * 到货时间，格式：2016-12-14 17:31:02
     */
    private Date arriveTime;

    /**
     * 订单完成时间，格式：2016-12-14 17:31:02
     */
    private Date finishTime;

    /**
     * 京东订单状态，数值标识含义见表
     */
    private int jdOrderState;

    /**
     * 是否开票 0 不开、1 开票
     */
    private int invoiceState;

    /**
     * 费率
     */
    private int serviceRate;

    /**
     * SKU列表
     */
    private List<SkuItem> skuList;

    /**
     * 子订单，列表内值为空
     */
    private List<ChildOrder> childOrderList;

    /**
     * 订单确认方状态，1 客户 2 系统（厂直订单手动确认区分标识）
     */
    private int confirmedType;

    /**
     * 企业号
     */
    private String enterpriseId;

    /**
     * 一级地址名称
     */
    private String provinceName;

    /**
     * 二级地址名称
     */
    private String cityName;

    /**
     * 三级地址名称
     */
    private String countyName;

    /**
     * 四级地址名称
     */
    private String townName;

    /**
     * 订单积分，按设置积分费率换算后用户支付的积分金额
     */
    private int bp;

    /**
     * 积分费率-整数模式（>=1）
     */
    private int moneyBpRate;

    /**
     * 积分费率-小数模式（>=1.00）
     */
    private BigDecimal moneyBpRateDecimal;

    /**
     * 终端用户访问及下单 ID
     */
    private String uid;

    /**
     * 扩展字段
     */
    private ExtInfo extInfo;

    @Data
    public static class ChildOrder {
        // 定义子订单的字段及注释
    }

    @Data
    public static class SkuItem {
        /**
         * 商品编号
         */
        private Long skuId;

        /**
         * 商品数量
         */
        private int num;

        /**
         * 商品金额，采购价金额
         */
        private BigDecimal price;

        /**
         * 商品名称
         */
        private String name;

        /**
         * 商品图片
         */
        private String imgUrl;

        /**
         * 商品类别 0 普通 1 附件 2 赠品
         */
        private int type;

        /**
         * 主商品编号
         */
        private Long oid;

        /**
         * 商品积分
         */
        private int bp;

        /**
         * 积分费率-整数模式（>=1）
         */
        private int moneyBpRate;

        /**
         * 积分费率-小数模式（>=1.00）
         */
        private BigDecimal moneyBpRateDecimal;
    }

    @Data
    public static class ExtInfo {
        /**
         * 支付详情
         */
        private List<PayDetail> payDetails;

        @Data
        public static class PayDetail {
            /**
             * 支付标识：1 表示个人支付，2 表示企业支付
             */
            private int flag;

            /**
             * 支付金额(单位:元)
             */
            private BigDecimal payMoney;

            /**
             * 支付方式：17 微信支付；101 金采支付；4 余额支付
             */
            private int paymentType;
        }
    }
}