package com.tydic.first.api.order.bo.jdm;


import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 京东基础数据BO
 */


@NoArgsConstructor
@Data
public class JdOrderDetailRspBO {


    @JsonProperty("pOrder")
    private Integer pOrder;
    @JsonProperty("orderState")
    private Integer orderState;
    @JsonProperty("orderType")
    private Integer orderType;
    @JsonProperty("jdOrderId")
    private String jdOrderId;
    @JsonProperty("state")
    private Integer state;
    @JsonProperty("submitState")
    private Integer submitState;
    @JsonProperty("type")
    private Integer type;
    @JsonProperty("sku")
    private List<Sku> sku;
    @JsonProperty("jdOrderState")
    private Integer jdOrderState;
    @JsonProperty("poNo")
    private String poNo;
    @JsonProperty("freight")
    private Integer freight;
    @JsonProperty("orderPrice")
    private Double orderPrice;
    @JsonProperty("orderNakedPrice")
    private Double orderNakedPrice;
    @JsonProperty("orderTaxPrice")
    private Double orderTaxPrice;

    @NoArgsConstructor
    @Data
    public static class Sku {
        @JsonProperty("category")
        private Integer category;
        @JsonProperty("num")
        private Integer num;
        @JsonProperty("price")
        private String price;
        @JsonProperty("tax")
        private Integer tax;
        @JsonProperty("oid")
        private Integer oid;
        @JsonProperty("name")
        private String name;
        @JsonProperty("taxPrice")
        private Double taxPrice;
        @JsonProperty("skuId")
        private Integer skuId;
        @JsonProperty("nakedPrice")
        private Double nakedPrice;
        @JsonProperty("type")
        private Integer type;
    }
}
