package com.tydic.first.api.order.bo.jdm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.tydic.first.api.BaseEntity;
import com.tydic.first.api.order.bo.fjdm.ServiceOrderReqBO;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：ServiceOrderReqBO
 * 说明：
 * 时间：2023/10/16 15:09
 *
 * @author hcl
 **/
@NoArgsConstructor
@Data
public class JdServiceOrderReqBO extends BaseEntity {


    @JsonProperty("orderId")
    private String orderId;
    private String thirdApplyId;

    /**
     * 是否有发票
     */
    private Boolean isHasInvoice;
    @JsonProperty("questionDesc")
    private String questionDesc;
    @JsonProperty("questionPic")
    private String questionPic;
    @JsonProperty("isHasPackage")
    private Boolean isHasPackage;
    @JsonProperty("packageDesc")
    private Integer packageDesc;
    @JsonProperty("isNeedDetectionReport")
    private Boolean isNeedDetectionReport;
    /**
     * 客户信息实体
     */
    @JsonProperty("customerInfo")
    private ServiceOrderReqBO.Customer customerInfo;
    /**
     * 取件信息实体
     */
    @JsonProperty("pickwareInfo")
    private ServiceOrderReqBO.Pickware pickwareInfo;
    /**
     * 返件信息实体
     */
    @JsonProperty("returnWareInfo")
    private ServiceOrderReqBO.Returnware returnWareInfo;

    @JsonProperty("asDetailDto")
    private List<ServiceOrderReqBO.Detail> asDetailDto;

    private List<AfsApplyInfoItem> afsApplyInfoItemList;

    @JsonProperty("serviceId")
    private String serviceId;

    /**
     * jd商品编码集合
     */
    private List<Long> wareIds;

    @NoArgsConstructor
    @Data
    public static class AfsApplyInfoItem {

        @JsonProperty("customerExpect")
        private Integer customerExpect;
        @JsonProperty("wareDescInfo")
        private WareDescInfo wareDescInfo;
        @JsonProperty("wareDetailInfo")
        private WareDetailInfo wareDetailInfo;
    }

    @NoArgsConstructor
    @Data
    public static class AfsReturnWareInfo {
        @JsonProperty("returnwareType")
        private String returnwareType;
        @JsonProperty("returnwareProvince")
        private String returnwareProvince;
        @JsonProperty("returnwareCity")
        private String returnwareCity;
        @JsonProperty("returnwareCounty")
        private String returnwareCounty;
        @JsonProperty("returnwareVillage")
        private String returnwareVillage;
        @JsonProperty("returnwareAddress")
        private String returnwareAddress;
    }

    /**
     * 商品描述信息
     */
    @NoArgsConstructor
    @Data
    public static class WareDescInfo {
        @JsonProperty("isNeedDetectionReport")
        private Boolean isNeedDetectionReport;
        @JsonProperty("lossPreventionTagFlag")
        private Boolean lossPreventionTagFlag;
        @JsonProperty("isHasPackage")
        private Boolean isHasPackage;
        @JsonProperty("packageDesc")
        private Integer packageDesc;
        @JsonProperty("questionDesc")
        private String questionDesc;
        @JsonProperty("questionPic")
        private String questionPic;
    }

    /**
     * 商品明细
     */
    @NoArgsConstructor
    @Data
    public static class WareDetailInfo {
        @JsonProperty("wareId")
        private String wareId;
        @JsonProperty("mainWareId")
        private String mainWareId;
        @JsonProperty("wareName")
        private String wareName;
        @JsonProperty("wareNum")
        private Integer wareNum;
        @JsonProperty("wareDescribe")
        private String wareDescribe;
        @JsonProperty("payPrice")
        private BigDecimal payPrice;
        @JsonProperty("wareType")
        private Integer wareType;
    }


    @NoArgsConstructor
    @Data
    public static class WareType {

    }


}
