package com.tydic.first.api.order.po;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.io.Serializable;
import java.util.List;

/**
 * 发票信息(Invoice)实体类
 *
 * @author hcl
 * @since 2022-10-27 14:07:00
 */
@Data
public class Invoice implements Serializable {
    private static final long serialVersionUID = -99583428467130726L;
    /**
     * 发票代码
     */
    private String invoiceCode;
    /**
     * 发票状态
     */
    private Integer state;
    /**
     * 冲红的原始发票号
     */
    private String originalInvoiceid;
    /**
     * 冲红的原始发票代码
     */
    private String originalInvoiceCode;
    /**
     * 发票日期
     */
    private Date invoiceDate;
    /**
     * 发票金额（裸价）
     */
    private BigDecimal invoiceNakedAmount;
    /**
     * 发票税率
     */
    private String invoiceTaxRate;
    /**
     * 发票税额
     */
    private BigDecimal invoiceTaxAmount;
    /**
     * 价税合计
     */
    private BigDecimal invoiceAmount;
    /**
     * 发票类型
     */
    private Integer invoiceType;
    /**
     * 发票抬头
     */
    private String title;
    /**
     * 纳税人识别号
     */
    private String enterpriseTaxpayer;
    /**
     * 地址
     */
    private String address;
    /**
     * 电话
     */
    private String tel;
    /**
     * 开户行
     */
    private String bank;
    /**
     * 账号
     */
    private String account;
    /**
     * 发票号码
     */
    private String invoiceid;
    /**
     * 电子票下载地址/纸票影像下载地址
     */
    private String fileUrl;


    private String markId;

    List<InvoiceInventory> sku_entity;

    List<InvoiceInventory> skuDetails;

}

