package com.tydic.first.api.order.po.domain;

import java.math.BigDecimal;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotEmpty;

/**
 * 订单项信息对象 order_item
 *
 * @author hcl
 * @date 2022-09-26
 */
@Data
public class OrderItem {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * order_id
     */
    private String orderId;

    /**
     * spu_id
     */
    private Long spuId;

    /**
     * spu_name
     */
    private String spuName;

    /**
     * spu_pic
     */
    private String spuPic;

    /**
     * 品牌
     */
    private String spuBrand;

    /**
     * 商品分类id
     */
    private Long categoryId;

    /**
     * 商品sku编号
     */
    private String skuId;

    /**
     * 商品sku名字
     */
    private String name;

    /**
     * 商品sku图片
     */
    private String skuPic;

    /**
     * 商品sku价格
     */
    private BigDecimal price;

    /**
     * 商品购买的数量
     */
    private Long num;

    /**
     * 商品类型。 0 普通、1 附件、2 赠品、3延保
     */
    private Integer type;

    private Integer oid;

}
