package com.tydic.first.api.order.po.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 运单信息对象 waybill_info
 *
 * @author hcl
 * @date 2022-09-26
 */
public class WaybillInfo
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 快递名称 */
    private String carrier;

    /** 运单号 */
    private String deliveryOrderid;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date creteDate;

    /** 订单id */
    private String orderId;

    /** 发货单id */
    private String packageId;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setCarrier(String carrier)
    {
        this.carrier = carrier;
    }

    public String getCarrier()
    {
        return carrier;
    }
    public void setDeliveryOrderid(String deliveryOrderid)
    {
        this.deliveryOrderid = deliveryOrderid;
    }

    public String getDeliveryOrderid()
    {
        return deliveryOrderid;
    }
    public void setCreteDate(Date creteDate)
    {
        this.creteDate = creteDate;
    }

    public Date getCreteDate()
    {
        return creteDate;
    }
    public void setOrderId(String orderId)
    {
        this.orderId = orderId;
    }

    public String getOrderId()
    {
        return orderId;
    }
    public void setPackageId(String packageId)
    {
        this.packageId = packageId;
    }

    public String getPackageId()
    {
        return packageId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("carrier", getCarrier())
            .append("deliveryOrderid", getDeliveryOrderid())
            .append("creteDate", getCreteDate())
            .append("orderId", getOrderId())
            .append("packageId", getPackageId())
            .toString();
    }
}
