package com.tydic.first.api.product.bo.fjdm;

import com.tydic.first.api.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 类名：GetDetailFjdmRspBo
 * 标题：
 * 说明：
 * 时间：2023/10/16
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class GetDetailFjdmRspBo extends BaseEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品编号
     */
    private String spu;

    /**
     * 主图地址
     */
    private String imagePath;

    /**
     * 品牌
     */
    private String brandName;

    /**
     * 品牌图片	品牌图片地址，如果没有可不传
     */
    private String brandPic;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 产地
     */
    private String productArea;

    /**
     * 类目编码
     * 按提供该SKU对应的所有类目信息，并按照照一二三四级顺序提供
     */
    private List<String> category;

    /**
     * 是否允许退换货货
     * 0：允许退换货
     * 1：不允许退换货
     * 默认为0，不传默认按0处理
     */
    private int isReturn;

    /**
     * 商品描述
     * HTML页面，可直接展现
     */
    private String introduction;

    /**
     * 包装信息
     * 包装描述信息，HTML页面，可直接展现
     */
    private String wareQD;

    /**
     * 包装内的数量及单位
     * 例如：销售单位位箱，内包含24厅，则传输：24厅/箱
     */
    private String wareNum;

    /**
     * 规格属性信息
     */
    private List<AttributeBo> param;

    /**
     * 商品组信息
     */
    private String group;

    /**
     * 税率
     */
    private int tax;

    /**
     * 税收分类编码
     */
    private String taxCode;

    /**
     * 是否厂家直销	0否，1是（默认0，不传也按默认0处理）
     */
    private Integer isFactoryShip;

    /**
     * 单品组
     * skuGroup
     */
    private List<SkuInfoBo> skuGroup;

    private String wserve;
    private String jdPcUrl;
    private String inquiryCode;

}
