package com.tydic.first.api.product.bo.fjdm;

import lombok.Data;

import java.util.List;

/**
 * 类名：SkuInfo
 * 标题：
 * 说明：
 * 时间：2023/10/9
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class SkuInfoBo {

    /**
     * 单品编号
     */
    private String sku;

    /**
     * 主图地址
     */
    private String imagePath;

    /**
     * 单品名称
     */
    private String name;

    /**
     * 销售单位
     */
    private String saleUnit;

    /**
     * 销售结算单位是否一致
     * 1：一致
     * 0：不一致
     * 默认一致
     */
    private int type;

    /**
     * 结算单位
     * 销售单位结果单位不一致时，必须传输
     */
    private String settleUnit;

    /**
     * 结算转换率
     * 销售单位结算单位不一致时，必须传输。最大6位小数，结算转换率=分子/分母，比如：按桶销售，按升结算，1桶=209升，则结算转换率位209
     */
    private String settleRate;

    /**
     * 分子
     * 销售单位结算单位不一致时，必须传输。结算单位的数值
     */
    private int molecule;

    /**
     * 分母
     * 销售单位结算单位不一致时，必须传输。销售单位的数值
     */
    private int denominator;

    /**
     * 条形码
     */
    private String upc;

    /**
     * 预计发货日
     * Mro专用
     * 单位：天
     * 如果有现货则传0
     */
    private int deliveryTime;

    /**
     * 上下架状态
     * 1：上架
     * 0：下架
     */
    private int state;

    /**
     * 重量
     */
    private String weight;

    /**
     * 单品描述
     * HTML页面，可直接展现
     */
    private String introduction;

    /**
     * 最小起订量
     * Mro专用
     */
    private int moq;

    /**
     * 最小增量
     */
    private int mincrement;

    /**
     * 制造商型号
     * Mro专用
     */
    private String mfgSku;

    /**
     * 规格
     */
    private String spec;

    /**
     * 型号
     */
    private String model;

    private String jdSkuUrl;

    private String jdSku;
    /**
     * 质保信息
     */
    private String wserve;

    /**
     * 京东商城c端详情访问地址
     */
    private String jdPcUrl;

    /**
     * 询价单选中编号
     */
    private String inquiryCode;

    /**
     * 规格属性信息
     */
    private List<AttributeBo> param;

}
