package com.tydic.first.api.product.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名：ProductCategoryPo
 * 标题：产品类目标;product_category表持久层实体类
 * 说明：产品类目标;product_category表持久层实体类
 * 时间：2023/10/13
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class ProductCategoryPo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键系统id
     */
    private Long id;

    /**
     * 使用主数据物料分类清单-分类ID值
     */
    private Long catalogId;

    /**
     * 分类编码
     */
    private String catalogName;

    /**
     * 平台分类编码
     */
    private String catalogCode;

    /**
     * 分类版本
     */
    private Integer catalogVer;

    /**
     * 分类描述
     */
    private String catalogDesc;

    /**
     * 父类编码
     */
    private String parentCatalogCode;

    /**
     * 父类编码
     */
    private Long parentCatalogId;

    /**
     * 分类等级
     */
    private Integer catalogLevel;

    /**
     * UUID
     */
    private String uuid;

    /**
     * 停用标志 0 正常    1 停用
     */
    private Integer freezeFlag;

    /**
     * 创建者
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新者
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 0 正常　1 删除
     */
    private Integer isDelete;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否末级：0 非末级 1 末级：物料关联 2 末级：无下级子类目
     */
    private Integer lastLevel;

    /**
     * 排序
     */
    private Integer viewOrder;

}