package com.tydic.first.api.product.po;

import lombok.Data;

import java.io.Serializable;

/**
 * 类名：ProductLimitPo
 * 标题：商品限制表;product_limit表持久层实体类
 * 说明：商品限制表;product_limit表持久层实体类
 * 时间：2024/1/25
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class ProductLimitPo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品编码
     */
    private Long skuId;

    /**
     * 是否可售，1是，0否
     */
    private Integer isSale;

    /**
     * 是否区域限制，1是，0否
     */
    private Integer isAreaLimit;

    /**
     * 不进行区域限制的二级地址（city）。区域限制时才生效
     */
    private String notLimitCity;

    /**
     * 库存状态。33：有货 现货-下单立即发货 39：有货 在途-正在内部配货，预计2~6天到达本仓库 40：有货 可配货-下单后从有货仓库配货 36：预订 34：无货。默认33
     */
    private Integer stockState;

    /**
     * 仓库数量。库存状态为33时才生效。
     */
    private Integer stockNum;

    /**
     * 售后服务类型获取0 无 1 退货 2 换货 3 维修。jd：10退货，20换货，30维修预期
     */
    private String afterType;

    /**
     * 售后服务取件方式1 上门取件 2客户发货 3客户送货。jd：4上门取件， 7客户送货， 40客户发货
     */
    private String afterTake;

}