package com.tydic.first.api.product.po;

import lombok.Data;

import java.io.Serializable;

/**
 * 类名：ProductSpuPo
 * 标题：产品表;product_spu表持久层实体类
 * 说明：产品表;product_spu表持久层实体类
 * 时间：2023/10/13
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class ProductSpuPo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 产品编号
     */
    private Long spuId;

    /**
     * 主图地址
     */
    private String imagePath;

    /**
     * 品牌
     */
    private String brandName;

    /**
     * 品牌图片。为空可不传
     */
    private String brandPic;

    /**
     * 商品名称
     */
    private String name;

    /**
     * 产地
     */
    private String productArea;

    /**
     * 类目编码
     */
    private String categoryId;

    /**
     * 0：允许退换货 1：不允许退换货 默认为0，不传默认按0处理
     */
    private Integer isReturn;

    /**
     * 商品描述。HTML页面，可直接展现
     */
    private String introduction;

    /**
     * 包装信息。包装描述信息，HTML页面，可直接展现
     */
    private String wareQD;

    /**
     * 包装内的数量及单位
     */
    private String wareNum;

    /**
     * 商品组信息
     */
    private String group;

    /**
     * 税率
     */
    private Integer tax;

    /**
     * 税收分类编码
     */
    private String taxCode;

    /**
     * 是否厂家直销.0否，1是（默认0，不传也按默认0处理）
     */
    private Integer isFactoryShip;

}