package com.tydic.first.api.product.po;

import lombok.Data;

import java.io.Serializable;

/**
 * 类名：ProductStockPo
 * 标题：商品库存表;product_stock表持久层实体类
 * 说明：商品库存表;product_stock表持久层实体类
 * 时间：2023/10/13
 *
 * @author qinys
 * @copyright 2023 All rights reserved.
 **/
@Data
public class ProductStockPo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 商品编号
     */
    private Long skuId;

    /**
     * 配送地址id
     */
    private String areaId;

    /**
     * 描述
     */
    private String desc;

    /**
     * 库存状态编号。33,39,40,36,34
     */
    private Integer stockStateId;

    /**
     * 库存状态描述。33 有货 现货-下单立即发货 39 有货 在途-正在内部配货，预计2~6天到达本仓库 40 有货 可配货-下单后从有货仓库配货 36 预订 34 无货
     */
    private String stockStateDesc;

    /**
     * 剩余数量。-1未知；当库存小于200时展示真实库存数量
     */
    private Integer remainNum;

}