/**
 * @Author liuzhenhua
 * @Date: 2019年07月23日
 * @Copyright: 北京天源迪科信息技术有限公司，禁止外泄以及用于其他的商业目的 Inc. All rights reserved.
 */
package com.tydic.first.api.user.bo;

import com.ohaotian.plugin.base.bo.ReqInfo;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotEmpty;

/**
 * @author liuzhenhua
 * @since 2019-07-23
 */
public class AddUserReqBO extends ReqInfo {

    private Long authId;
    /**
     * 用户名
     */
    @NotEmpty(message = "用户名不能为空")
    private String userName;

    /**
     * 年龄
     */
    @Range(min = 0, max = 100, message = "年龄必须在0~100之间")
    private Integer age;

    /**
     * 邮件
     */
    private String email;

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }


    public Long getAuthId() {
        return authId;
    }

    public void setAuthId(Long authId) {
        this.authId = authId;
    }
}