/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dealNotice.bo.DealNoticeItemInfoBO;
import com.tydic.enquiry.api.dealNotice.bo.QryQuoteListByDealNoticeIdReqBO;
import com.tydic.enquiry.api.dealNotice.bo.QryQuoteListByDealNoticeIdRspBO;
import com.tydic.enquiry.api.dealNotice.service.QryQuoteListByDealNoticeIdService;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.dao.DIqrDealNoticeItemMapper;
import com.tydic.enquiry.dao.DIqrDealNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrDealNoticePO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.vo.DealNoticeItemInfoVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.dealNotice.service.QryQuoteListByDealNoticeIdService"})
public class QryQuoteListByDealNoticeIdServiceImpl
implements QryQuoteListByDealNoticeIdService {
    private static final Logger log = LoggerFactory.getLogger(QryQuoteListByDealNoticeIdServiceImpl.class);
    @Autowired
    private DIqrDealNoticeItemMapper dIqrDealNoticeItemMapper;
    @Autowired
    private DIqrDealNoticeMapper dIqrDealNoticeMapper;
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryQuoteListByDealNoticeId"})
    public QryQuoteListByDealNoticeIdRspBO qryQuoteListByDealNoticeId(@RequestBody QryQuoteListByDealNoticeIdReqBO reqBO) {
        QryQuoteListByDealNoticeIdRspBO rspBO = new QryQuoteListByDealNoticeIdRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        String deliveryDatePromise = "";
        List<Object> itemList = new ArrayList();
        List<Object> itemInfoBOS = new ArrayList();
        try {
            String quoteEndDate = "";
            DIqrDealNoticePO dIqrDealNoticePO = this.dIqrDealNoticeMapper.selectByPrimaryKey(reqBO.getDealNoticeId());
            if (dIqrDealNoticePO != null) {
                DIqrQuotationPO dIqrQuotationPO;
                DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(dIqrDealNoticePO.getInquiryId());
                if (inquiryMatePO != null && inquiryMatePO.getQuoteEndDate() != null) {
                    quoteEndDate = DateUtils.dateToStr((Date)new Date(inquiryMatePO.getQuoteEndDate().getTime() + 86400000L), (String)"yyyy-MM-dd") + "\u524d";
                }
                if ((dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(dIqrDealNoticePO.getQuotationId())) != null) {
                    deliveryDatePromise = dIqrQuotationPO.getDeliveryDatePromise() != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getDeliveryDatePromise(), (String)"yyyy-MM-dd") : (dIqrQuotationPO.getDeliveryIntPromise() != null && dIqrDealNoticePO.getSupConfirmTime() != null ? DateUtils.dateToStr((Date)DateUtils.getDate((Date)dIqrDealNoticePO.getSupConfirmTime(), (Integer)dIqrQuotationPO.getDeliveryIntPromise()), (String)"yyyy-MM-dd") : (dIqrQuotationPO.getDeliveryIntPromise() != null ? "\u4e0b\u5355\u4e4b\u65e5\u540e" + dIqrQuotationPO.getDeliveryIntPromise() + "\u5929" : "--"));
                    log.info("======\u627f\u8bfa\u5230\u8d27\u65e5=======deliveryDatePromise=" + deliveryDatePromise);
                }
            }
            if (CollectionUtils.isNotEmpty(itemList = this.dIqrDealNoticeItemMapper.selectByDealNoticeId(reqBO.getDealNoticeId(), (Page<DealNoticeItemInfoVO>)page))) {
                String deliveryDatePromiseTemp = deliveryDatePromise;
                String finalQuoteEndDate = quoteEndDate;
                itemInfoBOS = itemList.stream().map(e -> {
                    DealNoticeItemInfoBO dealNoticeInfoBO = new DealNoticeItemInfoBO();
                    BeanUtils.copyProperties((Object)e, (Object)dealNoticeInfoBO);
                    try {
                        dealNoticeInfoBO.setQuoteEndDate(finalQuoteEndDate);
                        dealNoticeInfoBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)e.getBudgetAmount()));
                        dealNoticeInfoBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)e.getQuoteAmount()));
                        dealNoticeInfoBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)e.getBudgetPrice()));
                        dealNoticeInfoBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)e.getQuotePrice()));
                        dealNoticeInfoBO.setPurcharseNum(MoneyUtils.Long2BigDecimal((Long)e.getPurcharseNum()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    dealNoticeInfoBO.setQuotationCreateTime(DateUtils.dateToStr((Date)e.getQuotationCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    dealNoticeInfoBO.setDeliveryDatePromise(deliveryDatePromiseTemp);
                    dealNoticeInfoBO.setMaterialClassIdStr(this.qryDicAtomService.getDicCodeName("MATERIAL_CLASS_ID", e.getMaterialClassId() + ""));
                    dealNoticeInfoBO.setDocStatusDesc(this.qryDicAtomService.getDicCodeName("INQDT_DOC_STATUS", e.getDocStatus() + ""));
                    return dealNoticeInfoBO;
                }).collect(Collectors.toList());
            }
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setRows(itemInfoBOS);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        }
        catch (Exception e2) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc(e2.toString());
            log.error("\u5f02\u5e38\u4fe1\u606f\uff1ae=" + e2.toString());
            return rspBO;
        }
        return rspBO;
    }
}

