/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillPkgListReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillPkgListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.service.QryQuotationBillPkgListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.QryQuotationBillPkgListService"})
public class QryQuotationBillPkgListServiceImpl
implements QryQuotationBillPkgListService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationBillPkgListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;

    @PostMapping(value={"qryQuotationBillPkgList"})
    public QryQuotationBillPkgListRspBO qryQuotationBillPkgList(@RequestBody QryQuotationBillPkgListReqBO reqBO) {
        DIqrInquiryMatePO dIqrInquiryMatePO;
        QryQuotationBillPkgListRspBO rspBO = new QryQuotationBillPkgListRspBO();
        ArrayList<QuotationPackageBO> quotePackageList = new ArrayList<QuotationPackageBO>();
        DIqrQuotationPO dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
        if (dIqrQuotationPO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (!"1".equals(dIqrQuotationPO.getHisStatus()) || dIqrQuotationPO.getValidStatus() == null || Constants.IS_VALID_Y != dIqrQuotationPO.getValidStatus()) {
            DIqrQuotationPO record = new DIqrQuotationPO();
            record.setSupplierId(dIqrQuotationPO.getSupplierId());
            record.setHisStatus("1");
            record.setValidStatus(Constants.IS_VALID_Y);
            record.setInquiryId(dIqrQuotationPO.getInquiryId());
            record.setOrderBy("QUOTATION_ID DESC");
            List<DIqrQuotationPO> dIqrQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
            if (CollectionUtils.isEmpty(dIqrQuotationPOs)) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6b64\u4f9b\u5e94\u5546\u4e0d\u5b58\u5728\u6709\u6548\u7684\u62a5\u4ef7\u4fe1\u606f\uff01");
                rspBO.setPackageList(quotePackageList);
                log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
                return rspBO;
            }
            dIqrQuotationPO = dIqrQuotationPOs.get(0);
        }
        if ((dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(dIqrQuotationPO.getInquiryId())) == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u5bf9\u5e94\u7684\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (dIqrInquiryMatePO.getDelayCnt() != null && dIqrInquiryMatePO.getDelayCnt() > 0) {
            rspBO.setIsDelay(Integer.valueOf(1));
            rspBO.setDelayCnt(dIqrInquiryMatePO.getDelayCnt());
        } else {
            rspBO.setIsDelay(Integer.valueOf(0));
            rspBO.setDelayCnt(Integer.valueOf(0));
        }
        if (dIqrInquiryMatePO.getDelayLengthTime() != null && dIqrInquiryMatePO.getDelayLengthTime() > 0) {
            rspBO.setDelayLengthTime(dIqrInquiryMatePO.getDelayLengthTime());
        } else {
            rspBO.setDelayLengthTime(Integer.valueOf(0));
        }
        rspBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        rspBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        List<DIqrInquiryMateItemPO> dIqrInquiryMateItemPOList = this.dIqrInquiryMateItemMapper.selectInquiryItemByInquiryId(dIqrQuotationPO.getInquiryId());
        if (CollectionUtils.isEmpty(dIqrInquiryMateItemPOList)) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728\u5305\u4fe1\u606f\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        List<DIqrQuotationPkgPO> dIqrQuotationPkgPOList = this.dIqrQuotationPkgMapper.selectByQuotationId(dIqrQuotationPO.getQuotationId());
        if (CollectionUtils.isEmpty(dIqrQuotationPkgPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPkgPO qryQuotationPkgPO = new DIqrQuotationPkgPO();
        qryQuotationPkgPO.setInquiryId(dIqrQuotationPO.getInquiryId());
        qryQuotationPkgPO.setHisStatus("1");
        qryQuotationPkgPO.setDocStatus(Integer.valueOf("4002"));
        qryQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
        List<DIqrQuotationPkgPO> quotationPkgPOList = this.dIqrQuotationPkgMapper.selectByInquiryIdStatusForList(qryQuotationPkgPO);
        HashMap<String, Long> pkgLowestAmountMap = new HashMap<String, Long>();
        HashMap<String, Long> pkgHighestAmountMap = new HashMap<String, Long>();
        if (CollectionUtils.isNotEmpty(quotationPkgPOList)) {
            for (DIqrQuotationPkgPO quotationPkgPO : quotationPkgPOList) {
                Long amount = quotationPkgPO.getAmount();
                if (StringUtils.isNotEmpty((CharSequence)quotationPkgPO.getAmountSec())) {
                    amount = QuoteUtil.decode(quotationPkgPO.getAmountSec(), quotationPkgPO.getQuotationId().toString());
                }
                if (pkgLowestAmountMap == null || pkgLowestAmountMap.size() <= 0 || pkgLowestAmountMap.get(quotationPkgPO.getInquiryPkgId()) == null) {
                    pkgLowestAmountMap.put(quotationPkgPO.getInquiryPkgId(), amount);
                } else if ((Long)pkgLowestAmountMap.get(quotationPkgPO.getInquiryPkgId()) > amount) {
                    pkgLowestAmountMap.put(quotationPkgPO.getInquiryPkgId(), amount);
                }
                if (pkgHighestAmountMap == null || pkgHighestAmountMap.size() <= 0 || pkgHighestAmountMap.get(quotationPkgPO.getInquiryPkgId()) == null) {
                    pkgHighestAmountMap.put(quotationPkgPO.getInquiryPkgId(), amount);
                    continue;
                }
                if ((Long)pkgHighestAmountMap.get(quotationPkgPO.getInquiryPkgId()) >= amount) continue;
                pkgHighestAmountMap.put(quotationPkgPO.getInquiryPkgId(), amount);
            }
        }
        log.info("\u62a5\u4ef7\u5305\u4fe1\u606f\uff1apkgLowestAmountMap=" + JSON.toJSONString(pkgLowestAmountMap));
        log.info("\u62a5\u4ef7\u5305\u4fe1\u606f\uff1apkgHighestAmountMap=" + JSON.toJSONString(pkgHighestAmountMap));
        block3: for (DIqrQuotationPkgPO dIqrQuotationPkgPO : dIqrQuotationPkgPOList) {
            for (DIqrInquiryMateItemPO dIqrInquiryMateItemPO : dIqrInquiryMateItemPOList) {
                if (!dIqrInquiryMateItemPO.getInquiryPkgId().equals(dIqrQuotationPkgPO.getInquiryPkgId())) continue;
                QuotationPackageBO quotationPackageBO = new QuotationPackageBO();
                quotationPackageBO.setInquiryId(dIqrInquiryMateItemPO.getInquiryId());
                quotationPackageBO.setInquiryPkgId(dIqrInquiryMateItemPO.getInquiryPkgId());
                quotationPackageBO.setPkgOrderNo(dIqrInquiryMateItemPO.getInquiryPkgId());
                quotationPackageBO.setPkgCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMateItemPO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                try {
                    Long amount = dIqrQuotationPkgPO.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPkgPO.getAmountSec())) {
                        amount = QuoteUtil.decode(dIqrQuotationPkgPO.getAmountSec(), dIqrQuotationPkgPO.getQuotationId().toString());
                    }
                    quotationPackageBO.setPkgTotalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryMateItemPO.getPkgTotalAmount()));
                    quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                    if (pkgLowestAmountMap.size() > 0 && pkgLowestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()) != null) {
                        quotationPackageBO.setLowestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)((Long)pkgLowestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()))));
                    } else {
                        quotationPackageBO.setLowestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                    }
                    if (pkgHighestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()) != null) {
                        quotationPackageBO.setHighestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)((Long)pkgHighestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()))));
                    } else {
                        quotationPackageBO.setHighestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                    }
                    if ("2".equals(dIqrInquiryMatePO.getBusiType()) && pkgHighestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()) != null) {
                        quotationPackageBO.setMostQuoteAmount(MoneyUtils.Long2BigDecimal((Long)((Long)pkgHighestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()))));
                    } else if (!"2".equals(dIqrInquiryMatePO.getBusiType()) && pkgHighestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()) != null) {
                        quotationPackageBO.setMostQuoteAmount(MoneyUtils.Long2BigDecimal((Long)((Long)pkgLowestAmountMap.get(dIqrInquiryMateItemPO.getInquiryPkgId()))));
                    } else {
                        quotationPackageBO.setMostQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                    }
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                quotationPackageBO.setDetailNum(dIqrQuotationPkgPO.getQuotePkgDetailNum());
                quotationPackageBO.setQuotationId(dIqrQuotationPkgPO.getQuotationId());
                quotationPackageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                quotationPackageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
                quotationPackageBO.setQuotationSubmitTime(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                quotationPackageBO.setLastTimeQuoteDate(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                quotePackageList.add(quotationPackageBO);
                continue block3;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u5305\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        rspBO.setPackageList(quotePackageList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

