/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.enquiry.api.quote.bo.UpdateQuotationMarginPayReqBO;
import com.tydic.enquiry.api.quote.bo.UpdateQuotationMarginPayRspBO;
import com.tydic.enquiry.api.quote.service.UpdateQuotationMarginPayService;
import com.tydic.enquiry.api.registdoc.bo.RecvRefMarginPayReqBO;
import com.tydic.enquiry.api.registdoc.bo.RecvRefMarginPayRspBO;
import com.tydic.enquiry.api.registdoc.service.RecvRefMarginPayService;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.dao.DIqrRegistMarginMapper;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.po.DIqrRegistMarginPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.RecvRefMarginPayService"})
public class RecvRefMarginPayServiceImpl
implements RecvRefMarginPayService {
    private static final Logger log = LoggerFactory.getLogger(RecvRefMarginPayServiceImpl.class);
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    UpdateQuotationMarginPayService updateQuotationMarginPayService;
    @Autowired
    private DIqrRegistMarginMapper dIqrRegistMarginMapper;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"submitMarginPay"})
    public RecvRefMarginPayRspBO submitMarginPay(@RequestBody RecvRefMarginPayReqBO reqBO) {
        log.info("===submitMarginPay\u5165\u53c2\u6570\u636e::reqBO=" + reqBO.toString());
        RecvRefMarginPayRspBO rspBO = new RecvRefMarginPayRspBO();
        Date operDate = new Date();
        Long registId = reqBO.getRegistId();
        log.info("==\u8fd4\u56de\u7684\u62a5\u540d\u5355ID==registId=" + registId);
        List<DIqrRegistMarginPO> registMarginList = this.dIqrRegistMarginMapper.selectRegistMarginByOutOrderId(reqBO.getOutOrderId());
        if (!CollectionUtils.isEmpty(registMarginList)) {
            registId = registMarginList.get(0).getRegistId();
            log.info("==selectRegistMarginByOutOrderId==registId=" + registId);
        }
        log.info("==end==registId=" + registId);
        DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(registId);
        if (dIqrRegistDocPO != null) {
            DIqrRegistDocPO docPO = new DIqrRegistDocPO();
            log.info("reqBO.getPayFlag()=" + reqBO.getPayFlag());
            if ("1".equals(reqBO.getPayFlag())) {
                docPO.setRegistId(registId);
                docPO.setDocStatus(Integer.parseInt("3003"));
                docPO.setPayStatus("2");
                docPO.setPayDate(operDate);
                if (reqBO.getOperId() != null) {
                    docPO.setPayUserId(reqBO.getOperId());
                } else {
                    docPO.setPayUserId(reqBO.getUserId());
                }
                if (reqBO.getOperId() != null) {
                    docPO.setPayUserName(reqBO.getOperName());
                } else {
                    docPO.setPayUserName(reqBO.getUsername());
                }
                log.info("reqBO.getMarginOrderId()=" + reqBO.getMarginOrderId());
                docPO.setMarginOrderId(reqBO.getMarginOrderId());
            } else {
                docPO.setRegistId(registId);
                docPO.setPayStatus("4");
                docPO.setPayDate(operDate);
                docPO.setPayUserId(reqBO.getOperId());
                docPO.setPayUserName(reqBO.getOperName());
            }
            int registDocResult = this.dIqrRegistDocMapper.updateByPrimaryKeySelective(docPO);
            if (registDocResult < 1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u540d\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
            log.info("UpdateQuotationMarginPayReqBO==dIqrRegistDocPO.getMarginAmount()=" + dIqrRegistDocPO.getMarginAmount());
            UpdateQuotationMarginPayReqBO updateQuotationMarginPayReqBO = new UpdateQuotationMarginPayReqBO();
            updateQuotationMarginPayReqBO.setRegistId(registId);
            updateQuotationMarginPayReqBO.setMarginAmount(dIqrRegistDocPO.getMarginAmount());
            updateQuotationMarginPayReqBO.setPayUserId(reqBO.getOperId());
            updateQuotationMarginPayReqBO.setPayUserName(reqBO.getOperName());
            updateQuotationMarginPayReqBO.setPayDate(operDate);
            updateQuotationMarginPayReqBO.setPayStatus("2");
            UpdateQuotationMarginPayRspBO updateQuotationMarginPayRspBO = this.updateQuotationMarginPayService.updateQuotationMarginPay(updateQuotationMarginPayReqBO);
            if (!"0000".equals(updateQuotationMarginPayRspBO.getRespCode())) {
                throw new ZTBusinessException(updateQuotationMarginPayRspBO.getRespDesc());
            }
            log.info("\u66f4\u65b0\u62a5\u540d\u5305\u72b6\u6001==registId=" + registId);
            DIqrRegistMarginPO dIqrRegistMarginPO = new DIqrRegistMarginPO();
            dIqrRegistMarginPO.setRegistId(registId);
            dIqrRegistMarginPO.setPayStatus("Y");
            dIqrRegistMarginPO.setPayDate(operDate);
            int i = this.dIqrRegistMarginMapper.updateByPrimaryRegistId(dIqrRegistMarginPO);
            if (i < 1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u540d\u5305\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        rspBO.setDocId(registId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("==submitMarginPay==rspBO=" + rspBO.toString());
        return rspBO;
    }

    @PostMapping(value={"updateMarginOutOrderId"})
    public RecvRefMarginPayRspBO updateMarginOutOrderId(@RequestBody RecvRefMarginPayReqBO recvRefMarginPayReqBO) {
        log.info("==updateMarginOutOrderId==recvRefMarginPayReqBO=" + recvRefMarginPayReqBO.toString());
        RecvRefMarginPayRspBO rspBO = new RecvRefMarginPayRspBO();
        log.info("==updateMarginOutOrderId==recvRefMarginPayReqBO.getIsSplitFlag()=" + recvRefMarginPayReqBO.getIsSplitFlag());
        if ("Y".equals(recvRefMarginPayReqBO.getIsSplitFlag())) {
            DIqrRegistMarginPO marginPO = new DIqrRegistMarginPO();
            marginPO.setRegistId(recvRefMarginPayReqBO.getRegistId());
            marginPO.setOutOrderId(recvRefMarginPayReqBO.getOutOrderId());
            marginPO.setMarginOrderId(recvRefMarginPayReqBO.getMarginOrderId());
            int marginResult = this.dIqrRegistMarginMapper.updateByPrimaryRegistId(marginPO);
            log.info("==updateMarginOutOrderId==marginResult=" + marginResult);
            if (marginResult < 1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u540d\u5305\u4fdd\u8bc1\u91d1\u4fe1\u606f\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        } else {
            DIqrRegistDocPO docPO = new DIqrRegistDocPO();
            docPO.setMarginOrderId(recvRefMarginPayReqBO.getMarginOrderId());
            docPO.setRegistId(recvRefMarginPayReqBO.getRegistId());
            log.info("==updateMarginOutOrderId==recvRefMarginPayReqBO.getMarginOrderId()=" + recvRefMarginPayReqBO.getMarginOrderId());
            int registDocResult = this.dIqrRegistDocMapper.updateByPrimaryKeySelective(docPO);
            if (registDocResult < 1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u540d\u8868\u4fdd\u8bc1\u91d1\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01");
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("==updateMarginOutOrderId==rspBO.toString()=" + rspBO.toString());
        return rspBO;
    }
}

