/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.common;

import com.tydic.enquiry.config.RedisConfig;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Service
public class RedisPoolFactory {
    @Autowired
    RedisConfig redisConfig;

    @Bean
    public JedisPool JedisPoolFactory() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(this.redisConfig.getPoolMaxIdle());
        poolConfig.setMaxTotal(this.redisConfig.getPoolMaxTotal());
        poolConfig.setMaxWaitMillis((long)(this.redisConfig.getPoolMaxWait() * 1000));
        JedisPool jp = new JedisPool((GenericObjectPoolConfig)poolConfig, this.redisConfig.getHost(), this.redisConfig.getPort(), this.redisConfig.getTimeout() * 1000, this.redisConfig.getPwd(), 0);
        return jp;
    }
}

