/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.performlist.bo.BiddingGoodsBO;
import com.tydic.enquiry.api.performlist.bo.QryBiddingNoticeListReqBO;
import com.tydic.enquiry.api.performlist.bo.QryBiddingNoticeListRspBO;
import com.tydic.enquiry.api.performlist.service.QryBiddingNoticeListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailPicMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPicPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.QryBiddingNoticeListService"})
public class QryBiddingNoticeListServiceImpl
implements QryBiddingNoticeListService {
    private static final Logger log = LoggerFactory.getLogger(QryBiddingNoticeListServiceImpl.class);
    @Autowired
    DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    DIqrInquiryDetailPicMapper dIqrInquiryDetailPicMapper;

    @PostMapping(value={"qryBiddingNoticeList"})
    public QryBiddingNoticeListRspBO qryBiddingNoticeList(@RequestBody QryBiddingNoticeListReqBO qryBiddingNoticeListReqBO) {
        List<DIqrPurchaseNoticePO> overNoticeList;
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryBiddingNoticeListReqBO=" + qryBiddingNoticeListReqBO.toString());
        QryBiddingNoticeListRspBO qryBiddingNoticeListRspBO = new QryBiddingNoticeListRspBO();
        BigDecimal amount = new BigDecimal(10000);
        if (StringUtils.isEmpty((Object)qryBiddingNoticeListReqBO.getBusiType())) {
            qryBiddingNoticeListReqBO.setBusiType("2");
        }
        Date nowDate = new Date();
        Date yesterdayDate = DateUtils.getDate((Date)nowDate, (Integer)-1);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("busiType", qryBiddingNoticeListReqBO.getBusiType());
        String ydStartTime = DateUtils.dateToStrYYYYMMdd((Date)yesterdayDate) + "000000";
        String ydEndTime = DateUtils.dateToStrYYYYMMdd((Date)yesterdayDate) + "235959";
        map.put("startTime", ydStartTime);
        map.put("endTime", ydEndTime);
        List<DIqrPurchaseNoticePO> yesterBiddingNoticeList = this.dIqrPurchaseNoticeMapper.selectBiddingNoticeByTime(map);
        if (!CollectionUtils.isEmpty(yesterBiddingNoticeList)) {
            qryBiddingNoticeListRspBO.setYesdNoticeNum(Integer.valueOf(yesterBiddingNoticeList.size()));
        } else {
            qryBiddingNoticeListRspBO.setYesdNoticeNum(Integer.valueOf(0));
        }
        String startTime = DateUtils.dateToStrYYYYMMdd((Date)nowDate) + "000000";
        String endTime = DateUtils.dateToStrYYYYMMdd((Date)nowDate) + "235959";
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        List<DIqrPurchaseNoticePO> nowBiddingNoticeList = this.dIqrPurchaseNoticeMapper.selectBiddingNoticeByTime(map);
        if (!CollectionUtils.isEmpty(nowBiddingNoticeList)) {
            qryBiddingNoticeListRspBO.setNowNoticeNum(Integer.valueOf(nowBiddingNoticeList.size()));
            ArrayList<Object> nowBiddingList = new ArrayList<Object>();
            for (DIqrPurchaseNoticePO nowNotice : nowBiddingNoticeList) {
                DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(nowNotice.getInquiryId());
                List<DIqrInquiryDetailPO> detailList = this.dIqrInquiryDetailMapper.selectByInquiryId(nowNotice.getInquiryId());
                if (dIqrInquiryMatePO == null || CollectionUtils.isEmpty(detailList)) continue;
                for (DIqrInquiryDetailPO dIqrInquiryDetailPO : detailList) {
                    BiddingGoodsBO biddingGoodsBO = new BiddingGoodsBO();
                    biddingGoodsBO.setGoodsName(dIqrInquiryDetailPO.getGoodsName());
                    biddingGoodsBO.setInquiryItemId(dIqrInquiryDetailPO.getInquiryItemId());
                    DIqrInquiryDetailPicPO dIqrInquiryDetailPicPO = this.dIqrInquiryDetailPicMapper.selectDetailMainPicByInquiryItemId(dIqrInquiryDetailPO.getInquiryItemId());
                    if (dIqrInquiryDetailPicPO != null) {
                        biddingGoodsBO.setMainPicUrl(dIqrInquiryDetailPicPO.getPicUrl());
                    }
                    biddingGoodsBO.setInquiryId(dIqrInquiryDetailPO.getInquiryId());
                    biddingGoodsBO.setNoticeId(nowNotice.getNoticeId());
                    biddingGoodsBO.setLimitQuoteDate(DateUtils.dateToStrLong((Date)dIqrInquiryMatePO.getLimitQuoteDate()));
                    biddingGoodsBO.setQuoteEndDate(DateUtils.dateToStrLong((Date)dIqrInquiryMatePO.getQuoteEndDate()));
                    if (!StringUtils.isEmpty((Object)dIqrInquiryMatePO.getPurchaseIdJson())) {
                        biddingGoodsBO.setPurchaseId(Long.valueOf(Long.parseLong(dIqrInquiryMatePO.getPurchaseIdJson())));
                    }
                    biddingGoodsBO.setPurchaseName(dIqrInquiryMatePO.getPurchaseName());
                    BigDecimal startPriceTemp = null;
                    startPriceTemp = "1".equals(dIqrInquiryMatePO.getQuoteMethod() + "") && "Y".equals(dIqrInquiryMatePO.getTotalPriceFlag()) ? new BigDecimal(dIqrInquiryDetailPO.getBudgetAmount()).divide(amount).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(dIqrInquiryDetailPO.getBudgetPrice()).divide(amount).setScale(2, RoundingMode.HALF_UP);
                    biddingGoodsBO.setStartingPrice(startPriceTemp);
                    nowBiddingList.add(biddingGoodsBO);
                }
            }
            qryBiddingNoticeListRspBO.setNowBiddingList(nowBiddingList);
        } else {
            qryBiddingNoticeListRspBO.setNowNoticeNum(Integer.valueOf(0));
        }
        List<DIqrPurchaseNoticePO> nowNoticeList = this.dIqrPurchaseNoticeMapper.selectNowBiddingNotice(map);
        if (!CollectionUtils.isEmpty(nowNoticeList)) {
            qryBiddingNoticeListRspBO.setHasNoticeNum(Integer.valueOf(nowNoticeList.size()));
        } else {
            qryBiddingNoticeListRspBO.setHasNoticeNum(Integer.valueOf(0));
        }
        List<DIqrPurchaseNoticePO> preNoticeList = this.dIqrPurchaseNoticeMapper.selectPreBiddingNotice(map);
        if (!CollectionUtils.isEmpty(preNoticeList)) {
            ArrayList<BiddingGoodsBO> noBeginBiddingList = new ArrayList<BiddingGoodsBO>();
            for (DIqrPurchaseNoticePO preNotice : preNoticeList) {
                DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(preNotice.getInquiryId());
                List<DIqrInquiryDetailPO> detailList = this.dIqrInquiryDetailMapper.selectByInquiryId(preNotice.getInquiryId());
                if (dIqrInquiryMatePO == null || CollectionUtils.isEmpty(detailList)) continue;
                for (DIqrInquiryDetailPO dIqrInquiryDetailPO : detailList) {
                    BiddingGoodsBO biddingGoodsBO = new BiddingGoodsBO();
                    biddingGoodsBO.setGoodsName(dIqrInquiryDetailPO.getGoodsName());
                    biddingGoodsBO.setInquiryItemId(dIqrInquiryDetailPO.getInquiryItemId());
                    DIqrInquiryDetailPicPO dIqrInquiryDetailPicPO = this.dIqrInquiryDetailPicMapper.selectDetailMainPicByInquiryItemId(dIqrInquiryDetailPO.getInquiryItemId());
                    if (dIqrInquiryDetailPicPO != null) {
                        biddingGoodsBO.setMainPicUrl(dIqrInquiryDetailPicPO.getPicUrl());
                    }
                    biddingGoodsBO.setInquiryId(dIqrInquiryDetailPO.getInquiryId());
                    biddingGoodsBO.setNoticeId(preNotice.getNoticeId());
                    biddingGoodsBO.setLimitQuoteDate(DateUtils.dateToStrLong((Date)dIqrInquiryMatePO.getLimitQuoteDate()));
                    biddingGoodsBO.setQuoteEndDate(DateUtils.dateToStrLong((Date)dIqrInquiryMatePO.getQuoteEndDate()));
                    if (!StringUtils.isEmpty((Object)dIqrInquiryMatePO.getPurchaseIdJson())) {
                        biddingGoodsBO.setPurchaseId(Long.valueOf(Long.parseLong(dIqrInquiryMatePO.getPurchaseIdJson())));
                    }
                    biddingGoodsBO.setPurchaseName(dIqrInquiryMatePO.getPurchaseName());
                    BigDecimal startPriceTemp = null;
                    startPriceTemp = "1".equals(dIqrInquiryMatePO.getQuoteMethod() + "") && "Y".equals(dIqrInquiryMatePO.getTotalPriceFlag()) ? new BigDecimal(dIqrInquiryDetailPO.getBudgetAmount()).divide(amount).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(dIqrInquiryDetailPO.getBudgetPrice()).divide(amount).setScale(2, RoundingMode.HALF_UP);
                    biddingGoodsBO.setStartingPrice(startPriceTemp);
                    noBeginBiddingList.add(biddingGoodsBO);
                }
            }
            qryBiddingNoticeListRspBO.setNoBeginBiddingList(noBeginBiddingList);
        }
        if (!CollectionUtils.isEmpty(overNoticeList = this.dIqrPurchaseNoticeMapper.selectOverBiddingNotice(map))) {
            ArrayList<BiddingGoodsBO> overBiddingList = new ArrayList<BiddingGoodsBO>();
            for (DIqrPurchaseNoticePO overNotice : overNoticeList) {
                DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(overNotice.getInquiryId());
                List<DIqrInquiryDetailPO> detailList = this.dIqrInquiryDetailMapper.selectByInquiryId(overNotice.getInquiryId());
                if (dIqrInquiryMatePO == null || CollectionUtils.isEmpty(detailList)) continue;
                for (DIqrInquiryDetailPO dIqrInquiryDetailPO : detailList) {
                    BiddingGoodsBO biddingGoodsBO = new BiddingGoodsBO();
                    biddingGoodsBO.setGoodsName(dIqrInquiryDetailPO.getGoodsName());
                    biddingGoodsBO.setInquiryItemId(dIqrInquiryDetailPO.getInquiryItemId());
                    DIqrInquiryDetailPicPO dIqrInquiryDetailPicPO = this.dIqrInquiryDetailPicMapper.selectDetailMainPicByInquiryItemId(dIqrInquiryDetailPO.getInquiryItemId());
                    if (dIqrInquiryDetailPicPO != null) {
                        biddingGoodsBO.setMainPicUrl(dIqrInquiryDetailPicPO.getPicUrl());
                    }
                    biddingGoodsBO.setInquiryId(dIqrInquiryDetailPO.getInquiryId());
                    biddingGoodsBO.setNoticeId(overNotice.getNoticeId());
                    biddingGoodsBO.setLimitQuoteDate(DateUtils.dateToStrLong((Date)dIqrInquiryMatePO.getLimitQuoteDate()));
                    biddingGoodsBO.setQuoteEndDate(DateUtils.dateToStrLong((Date)dIqrInquiryMatePO.getQuoteEndDate()));
                    if (!StringUtils.isEmpty((Object)dIqrInquiryMatePO.getPurchaseIdJson())) {
                        biddingGoodsBO.setPurchaseId(Long.valueOf(Long.parseLong(dIqrInquiryMatePO.getPurchaseIdJson())));
                    }
                    biddingGoodsBO.setPurchaseName(dIqrInquiryMatePO.getPurchaseName());
                    BigDecimal startPriceTemp = null;
                    startPriceTemp = "1".equals(dIqrInquiryMatePO.getQuoteMethod() + "") && "Y".equals(dIqrInquiryMatePO.getTotalPriceFlag()) ? new BigDecimal(dIqrInquiryDetailPO.getBudgetAmount()).divide(amount).setScale(2, RoundingMode.HALF_UP) : new BigDecimal(dIqrInquiryDetailPO.getBudgetPrice()).divide(amount).setScale(2, RoundingMode.HALF_UP);
                    biddingGoodsBO.setStartingPrice(startPriceTemp);
                    if (Constants.INQUIRY_DETAIL_DOC_STATUS_22004.equals(dIqrInquiryDetailPO.getDocStatus())) {
                        biddingGoodsBO.setDealStatusName("\u6210\u4ea4");
                        biddingGoodsBO.setDealDate(DateUtils.dateToStr((Date)dIqrInquiryDetailPO.getModifyTime()));
                    } else {
                        biddingGoodsBO.setDealStatusName("\u5df2\u7ed3\u675f");
                    }
                    biddingGoodsBO.setEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate()));
                    overBiddingList.add(biddingGoodsBO);
                }
            }
            qryBiddingNoticeListRspBO.setOverBiddingList(overBiddingList);
        }
        qryBiddingNoticeListRspBO.setRespCode("0000");
        qryBiddingNoticeListRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryBiddingNoticeListRspBO=" + qryBiddingNoticeListRspBO.toString());
        return qryBiddingNoticeListRspBO;
    }
}

