/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillListReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationBillBO;
import com.tydic.enquiry.api.quote.service.QryQuotationBillListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.QryQuotationBillListService"})
public class QryQuotationBillListServiceImpl
implements QryQuotationBillListService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationBillListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryQuotationBillList"})
    public QryQuotationBillListRspBO qryQuotationBillList(@RequestBody QryQuotationBillListReqBO reqBO) {
        QryQuotationBillListRspBO rspBO = new QryQuotationBillListRspBO();
        List<Object> quotationBillBOList = new ArrayList();
        DIqrQuotationPO record = new DIqrQuotationPO();
        if (reqBO.getTableId() == null) {
            return rspBO;
        }
        if (reqBO.getSupplierId() != null) {
            record.setSupplierId(reqBO.getSupplierId());
        }
        if (reqBO.getPlanDepart() != null) {
            record.setPlanDepart(reqBO.getPlanDepart());
        }
        if (reqBO.getPlanUnit() != null) {
            record.setPurchaseId(reqBO.getPlanUnit());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPlanUnitName())) {
            record.setPurchaseName(reqBO.getPlanUnitName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getDocType())) {
            record.setDocType(reqBO.getDocType());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getBusiType())) {
            record.setBusiType(reqBO.getBusiType());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getInquiryName())) {
            record.setInquiryName(reqBO.getInquiryName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getInquiryCode())) {
            record.setInquiryCode(reqBO.getInquiryCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getPlanDepartName())) {
            record.setPlanDepartName(reqBO.getPlanDepartName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getSupplierName())) {
            record.setSupplierName(reqBO.getSupplierName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getRegistTimeStart())) {
            record.setRegistTimeStart(DateUtils.strToDateLong((String)reqBO.getRegistTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getRegistTimeEnd())) {
            record.setRegistTimeEnd(DateUtils.strToDateLong((String)reqBO.getRegistTimeEnd(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getQuotationSubmitTimeStart())) {
            record.setQuotationSubmitTimeStart(DateUtils.strToDateLong((String)reqBO.getQuotationSubmitTimeStart(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBO.getQuotationSubmitTimeEnd())) {
            record.setQuotationSubmitTimeEnd(DateUtils.strToDateLong((String)reqBO.getQuotationSubmitTimeEnd(), (String)"yyyy-MM-dd"));
        }
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        if (reqBO.getTableId() == 1) {
            docStatusList.add(Integer.valueOf("4001"));
            docStatusList.add(Integer.valueOf("4002"));
            record.setInquiryDocStatus(Integer.parseInt("2008"));
        } else {
            docStatusList.add(Integer.valueOf("4004"));
            docStatusList.add(Integer.valueOf("4006"));
        }
        record.setDocStatusList(docStatusList);
        record.setHisStatus("1");
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setOrderBy("REGIST_TIME");
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getChoiceIds())) {
            record.setChoiceIds(reqBO.getChoiceIds());
        }
        List<Object> quotationPoList = new ArrayList();
        Page page = new Page(reqBO.getPageNo() == null ? 1 : reqBO.getPageNo(), reqBO.getPageSize() == null ? 1000 : reqBO.getPageSize());
        quotationPoList = "Y".equals(reqBO.getIsPagination()) ? this.dIqrQuotationMapper.selectQuotationForPage(record, (Page<DIqrQuotationPO>)page) : this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        ArrayList<String> bidDocStatusList = new ArrayList<String>();
        bidDocStatusList.add("2005");
        bidDocStatusList.add("2006");
        bidDocStatusList.add("2007");
        ArrayList<Long> inquiryIdList = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(quotationPoList)) {
            quotationBillBOList = quotationPoList.stream().map(e -> {
                log.info("\u62a5\u4ef7\u4fe1\u606f\uff1a" + JSONArray.toJSONString((Object)e));
                QuotationBillBO quotationBillBO = new QuotationBillBO();
                BeanUtils.copyProperties((Object)e, (Object)quotationBillBO);
                log.info("\u62a5\u4ef7\u4fe1\u606f\uff1a" + JSONArray.toJSONString((Object)e));
                try {
                    Long amount = e.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)e.getAmountSec())) {
                        amount = QuoteUtil.decode(e.getAmountSec(), e.getQuotationId().toString());
                    }
                    quotationBillBO.setAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                    quotationBillBO.setMarginAmount(MoneyUtils.Long2BigDecimal((Long)e.getMarginAmount()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                quotationBillBO.setQuoteLimitRounds(e.getQuoteTimeLimit());
                quotationBillBO.setPlanUnit(e.getPurchaseId());
                quotationBillBO.setPlanUnitName(e.getPurchaseName());
                quotationBillBO.setLimitQuoteDate(DateUtils.dateToStr((Date)e.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                quotationBillBO.setQuoteEndDate(DateUtils.dateToStr((Date)e.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                quotationBillBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)e.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                quotationBillBO.setRegistTime(DateUtils.dateToStr((Date)e.getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                quotationBillBO.setQuoteTimeReq(quotationBillBO.getLimitQuoteDate() + "\u81f3" + quotationBillBO.getQuoteEndDate());
                quotationBillBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", e.getPayStatus() + ""));
                quotationBillBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("QUOTE_DOC_STATUS", e.getDocStatus() + ""));
                quotationBillBO.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", e.getBusiType() + ""));
                quotationBillBO.setDocTypeName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", e.getDocType() + ""));
                inquiryIdList.add(e.getInquiryId());
                return quotationBillBO;
            }).collect(Collectors.toList());
            List<DIqrInquiryMatePO> dIqrInquiryMatePOlist = this.dIqrInquiryMateMapper.selectByInquiryIds(inquiryIdList);
            if (CollectionUtils.isNotEmpty(dIqrInquiryMatePOlist)) {
                quotationBillBOList = quotationBillBOList.stream().map(e -> {
                    for (DIqrInquiryMatePO dIqrInquiryMatePO : dIqrInquiryMatePOlist) {
                        log.info("\u6267\u884c\u5355\u4fe1\u606f\uff1a" + JSONArray.toJSONString((Object)dIqrInquiryMatePO));
                        if (dIqrInquiryMatePO.getInquiryId().longValue() == e.getInquiryId().longValue() && dIqrInquiryMatePO.getDocStatus() != null && bidDocStatusList.contains(dIqrInquiryMatePO.getDocStatus().toString())) {
                            e.setIsConfirmFlag("Y");
                        } else if (dIqrInquiryMatePO.getInquiryId().longValue() == e.getInquiryId().longValue()) {
                            e.setIsConfirmFlag("N");
                        }
                        log.info("\u6267\u884c\u5355\u8bae\u4ef7\u6b21\u6570\u9650\u5236\uff1a" + dIqrInquiryMatePO.getLimitBargainNum());
                        if (dIqrInquiryMatePO.getInquiryId().longValue() == e.getInquiryId().longValue() && dIqrInquiryMatePO.getLimitBargainNum() != null && dIqrInquiryMatePO.getLimitBargainNum() != 0) {
                            log.info("\u6267\u884c\u5355\u8bae\u4ef7\u6b21\u6570\u9650\u5236\uff1a" + dIqrInquiryMatePO.getLimitBargainNum());
                            e.setQuoteLimitRounds(dIqrInquiryMatePO.getLimitBargainNum());
                        }
                        if (dIqrInquiryMatePO.getInquiryId().longValue() != e.getInquiryId().longValue()) continue;
                        e.setMarginFlag(dIqrInquiryMatePO.getMarginFlag());
                        break;
                    }
                    return e;
                }).collect(Collectors.toList());
            }
            log.info("\u62a5\u4ef7\u5217\u8868\u4fe1\u606f\uff1a" + JSONArray.toJSONString(quotationBillBOList));
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(quotationBillBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

