/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.registdoc.bo.InviteSupRegistBO;
import com.tydic.enquiry.api.registdoc.bo.QryInviteSupRegistReqBO;
import com.tydic.enquiry.api.registdoc.bo.QryInviteSupRegistRspBO;
import com.tydic.enquiry.api.registdoc.service.QryInviteSupRegistService;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.registdoc.service.QryInviteSupRegistService"})
public class QryInviteSupRegistServiceImpl
implements QryInviteSupRegistService {
    private static final Logger log = LoggerFactory.getLogger(QryInviteSupRegistServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    @PostMapping(value={"qryInviteSupRegist"})
    public QryInviteSupRegistRspBO qryInviteSupRegist(@RequestBody QryInviteSupRegistReqBO reqBO) {
        QryInviteSupRegistRspBO rspBO = new QryInviteSupRegistRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiType())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (null == reqBO.getSupplierId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("purchaseId", reqBO.getPurchaseId());
        map.put("inquiryCode", reqBO.getInquiryCode());
        map.put("inquiryName", reqBO.getInquiryName());
        map.put("supplierId", reqBO.getSupplierId());
        map.put("busiType", reqBO.getBusiType());
        map.put("imitQuoteDate", DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getImitQuoteDate()));
        map.put("registEndDate", new Date());
        map.put("docStatus", reqBO.getDocStatus());
        List<DIqrRegistDocPO> iqrRegistDocPOList = this.dIqrRegistDocMapper.queryHadRegistInfoForPage(map, (Page<Map<String, Object>>)page);
        if (CollectionUtils.isNotEmpty(iqrRegistDocPOList)) {
            List collect = iqrRegistDocPOList.stream().map(e -> {
                InviteSupRegistBO inviteSupRegistBO = new InviteSupRegistBO();
                BeanUtils.copyProperties((Object)e, (Object)inviteSupRegistBO);
                inviteSupRegistBO.setLimitQuoteDate(DateUtils.dateToStrLong((Date)e.getLimitQuoteDate()));
                inviteSupRegistBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("REQIST_DOC_STATUS", e.getDocStatus() + ""));
                inviteSupRegistBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", e.getPayStatus()));
                return inviteSupRegistBO;
            }).collect(Collectors.toList());
            rspBO.setRows(collect);
        } else {
            rspBO.setRows(new ArrayList());
        }
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

