/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.AdduotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.AdduotationBillRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationAttachmentBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.bo.SubmitQuotationBillRspBO;
import com.tydic.enquiry.api.quote.service.AddQuotationBillService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationAttachMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationAttachPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.AddQuotationBillService"})
public class AddQuotationBillServiceImpl
implements AddQuotationBillService {
    private static final Logger log = LoggerFactory.getLogger(AddQuotationBillServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private SeqIdCreateService seqIdCreateService;
    @Autowired
    private DIqrQuotationAttachMapper dIqrQuotationAttachMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    @PostMapping(value={"addQuotationBill"})
    public AdduotationBillRspBO addQuotationBill(@RequestBody AdduotationBillReqBO adduotationBillReqBO) {
        AdduotationBillRspBO rspBO = new AdduotationBillRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(adduotationBillReqBO.getInquiryId());
        DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
        qryQuotationPO.setInquiryId(adduotationBillReqBO.getInquiryId());
        qryQuotationPO.setHisStatus("1");
        qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryQuotationPO.setSupplierId(adduotationBillReqBO.getSupplierId());
        List<DIqrQuotationPO> quotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
        if (dIqrInquiryMatePO == null || dIqrInquiryMatePO.getDocType() == null) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        Date date0 = new Date();
        if (!dIqrInquiryMatePO.getDocStatus().toString().equals("2006") || date0.compareTo(dIqrInquiryMatePO.getQuoteEndDate()) >= 0 || date0.compareTo(dIqrInquiryMatePO.getLimitQuoteDate()) < 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (quotationPOs == null || quotationPOs.size() <= 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO quotationPO = quotationPOs.get(0);
        if (quotationPO.getPayStatus() == null || "1".equals(quotationPO.getPayStatus())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u7ade\u4ef7\u5355\u672a\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (quotationPOs != null && quotationPOs.size() > 0 && quotationPOs.get(0).getQuoteRounds() != null && dIqrInquiryMatePO.getLimitBargainNum() != null && Integer.valueOf(quotationPOs.get(0).getQuoteRounds()) >= dIqrInquiryMatePO.getLimitBargainNum()) {
            log.error("\u5f53\u524d\u62a5\u4ef7\u5df2\u63d0\u4ea4\u6216\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7\u5df2\u63d0\u4ea4\u6216\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationId(quotationPO.getQuotationId());
        List<DIqrQuotationPkgPO> quotationPkgList = this.dIqrQuotationPkgMapper.selectByQuotationId(quotationPO.getQuotationId());
        DIqrQuotationPO qryInquiryQuotationPO = new DIqrQuotationPO();
        qryInquiryQuotationPO.setInquiryId(adduotationBillReqBO.getInquiryId());
        qryInquiryQuotationPO.setHisStatus("1");
        qryInquiryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryInquiryQuotationPO.setDocStatus(Integer.valueOf("40014"));
        List<DIqrQuotationPO> inquiryQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryInquiryQuotationPO);
        Long mostQuotationId = null;
        List<Object> quotationItemPOs = new ArrayList();
        if (inquiryQuotationPOs != null && inquiryQuotationPOs.size() > 0) {
            Long quoteAmount = inquiryQuotationPOs.get(0).getAmount();
            if (StringUtils.isNotEmpty((CharSequence)inquiryQuotationPOs.get(0).getAmountSec())) {
                quoteAmount = QuoteUtil.decode(inquiryQuotationPOs.get(0).getAmountSec(), inquiryQuotationPOs.get(0).getQuotationId().toString());
            }
            mostQuotationId = inquiryQuotationPOs.get(0).getQuotationId();
            for (DIqrQuotationPO dIqrQuotationPO : inquiryQuotationPOs) {
                Long amount = dIqrQuotationPO.getAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                    amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                }
                if (quoteAmount <= amount) continue;
                mostQuotationId = dIqrQuotationPO.getQuotationId();
            }
            DIqrQuotationItemPO qryQuotationItemPO = new DIqrQuotationItemPO();
            qryQuotationItemPO.setQuotationId(mostQuotationId);
            quotationItemPOs = this.dIqrQuotationItemMapper.selectByQuotationItem(qryQuotationItemPO);
            BigDecimal hundred = new BigDecimal("100");
            BigDecimal proportion = new BigDecimal(dIqrInquiryMatePO.getOfferIncreaseValue()).divide(hundred);
            BigDecimal price = new BigDecimal(dIqrInquiryMatePO.getOfferIncreaseValue());
            block5: for (DIqrQuotationItemPO dIqrQuotationItemPO : quotationItemPOs) {
                Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                BigDecimal quotationItemQrice = new BigDecimal("0");
                BigDecimal quotationItemAmount = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                    quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                try {
                    quotationItemQrice = "2".equals(dIqrInquiryMatePO.getBusiType()) && "1".equals(dIqrInquiryMatePO.getOfferIncreaseType()) ? MoneyUtils.Long2BigDecimal((Long)quotePrice).multiply(proportion.add(new BigDecimal("1"))).setScale(2, 4) : ("2".equals(dIqrInquiryMatePO.getBusiType()) && "2".equals(dIqrInquiryMatePO.getOfferIncreaseType()) ? MoneyUtils.Long2BigDecimal((Long)quotePrice).add(price) : (!"2".equals(dIqrInquiryMatePO.getBusiType()) && "1".equals(dIqrInquiryMatePO.getOfferIncreaseType()) ? MoneyUtils.Long2BigDecimal((Long)quotePrice).multiply(new BigDecimal("1").subtract(proportion)).setScale(2, 4) : MoneyUtils.Long2BigDecimal((Long)quotePrice).subtract(price)));
                    quotationItemAmount = quotationItemQrice.multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    for (DIqrQuotationItemPO quotationItemPO : dIqrQuotationItemPOList) {
                        if (quotationItemPO.getInquiryItemId().longValue() != dIqrQuotationItemPO.getInquiryItemId().longValue()) continue;
                        dIqrQuotationItemPO.setQuoteAmount(0L);
                        dIqrQuotationItemPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationItemQrice), quotationItemPO.getQuotationId().toString()));
                        dIqrQuotationItemPO.setQuotePrice(0L);
                        dIqrQuotationItemPO.setQuotePriceSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationItemAmount), quotationItemPO.getQuotationId().toString()));
                        continue block5;
                    }
                }
                catch (Exception e2) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                    log.error("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e2);
                    throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e2);
                }
            }
        }
        adduotationBillReqBO.setQuotationId(quotationPO.getQuotationId());
        ArrayList<QuotationPackageBO> packageList = new ArrayList<QuotationPackageBO>();
        for (DIqrQuotationPkgPO dIqrQuotationPkgPO : quotationPkgList) {
            QuotationPackageBO quotationPackageBO = new QuotationPackageBO();
            BeanUtils.copyProperties((Object)dIqrQuotationPkgPO, (Object)quotationPackageBO);
            packageList.add(quotationPackageBO);
        }
        adduotationBillReqBO.setPackageList(packageList);
        DIqrQuotationPO updateStatusPO = new DIqrQuotationPO();
        updateStatusPO.setReviewResult(Constants.REVIEW_RESULT_2);
        updateStatusPO.setInquiryId(quotationPO.getInquiryId());
        this.dIqrQuotationMapper.updateStatusByInquiryId(updateStatusPO);
        if (!"40014".equals(quotationPO.getDocStatus().toString())) {
            this.updateQuotationBill(adduotationBillReqBO, dIqrInquiryMatePO.getDocType(), dIqrQuotationItemPOList, dIqrInquiryMatePO.getTotalPriceFlag(), quotationPO);
        } else {
            this.addQuotationBill(adduotationBillReqBO, dIqrInquiryMatePO.getDocType(), dIqrQuotationItemPOList, dIqrInquiryMatePO.getTotalPriceFlag(), quotationPO);
        }
        try {
            DIqrQuotationPO record;
            Calendar nowTime = Calendar.getInstance();
            nowTime.add(12, 5);
            long m = 300000L;
            if (dIqrInquiryMatePO.getDocType() != null && "23".equals(dIqrInquiryMatePO.getDocType()) && nowTime.getTime().after(dIqrInquiryMatePO.getQuoteEndDate()) && dIqrInquiryMatePO.getDelayBiddingFlag() != null && "Y".equals(dIqrInquiryMatePO.getDelayBiddingFlag())) {
                record = new DIqrQuotationPO();
                Date date = new Date(dIqrInquiryMatePO.getQuoteEndDate().getTime() + m);
                record.setQuoteEndDate(date);
                record.setInquiryId(quotationPO.getInquiryId());
                this.dIqrQuotationMapper.updateQuoteEndTimeByInquiryId(record);
                DIqrRegistDocPO registDoc = new DIqrRegistDocPO();
                registDoc.setQuoteEndDate(date);
                registDoc.setInquiryId(quotationPO.getInquiryId());
                this.dIqrRegistDocMapper.updateQuoteEndTimeByInquiryId(registDoc);
            }
            record = new DIqrQuotationPO();
            record.setInquiryId(adduotationBillReqBO.getInquiryId());
            record.setDocStatus(Integer.valueOf("4002"));
            record.setValidStatus(Constants.IS_VALID_Y);
            record.setHisStatus("1");
            List<DIqrQuotationPO> list = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
            List<Object> quotationIds = new ArrayList();
            if (!CollectionUtils.isEmpty(list)) {
                quotationIds = list.stream().map(e -> e.getQuotationId()).collect(Collectors.toList());
            }
            DIqrInquiryMatePO updateInquiryMatePO = new DIqrInquiryMatePO();
            updateInquiryMatePO.setQuotationIdsJson(JSONArray.toJSONString(quotationIds));
            updateInquiryMatePO.setQuotationNum(quotationIds.size());
            updateInquiryMatePO.setInquiryId(adduotationBillReqBO.getInquiryId());
            if (dIqrInquiryMatePO.getDocType() != null && "23".equals(dIqrInquiryMatePO.getDocType()) && nowTime.getTime().after(dIqrInquiryMatePO.getQuoteEndDate()) && dIqrInquiryMatePO.getDelayBiddingFlag() != null && "Y".equals(dIqrInquiryMatePO.getDelayBiddingFlag())) {
                Date quoteEndDate = new Date(dIqrInquiryMatePO.getQuoteEndDate().getTime() + m);
                updateInquiryMatePO.setQuoteEndDate(quoteEndDate);
                updateInquiryMatePO.setDelayLengthTime(dIqrInquiryMatePO.getDelayLengthTime() == null ? 5 : dIqrInquiryMatePO.getDelayLengthTime() + 5);
                updateInquiryMatePO.setDelayCnt(dIqrInquiryMatePO.getDelayCnt() == null ? 1 : dIqrInquiryMatePO.getDelayCnt() + 1);
            }
            this.dIqrInquiryMateMapper.updateByInquiryId(updateInquiryMatePO);
        }
        catch (Exception e3) {
            log.error("\u66f4\u65b0\u8be2\u4ef7\u5355\u62a5\u4ef7\u5bb6\u6570\u5931\u8d25:" + e3);
            throw new BusinessException("9999", "\u66f4\u65b0\u8be2\u4ef7\u5355\u62a5\u4ef7\u5bb6\u6570\u5931\u8d25:" + e3.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u63d0\u4ea4\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO updateQuotationBill(AdduotationBillReqBO adduotationBillReqBO, String docType, List<DIqrQuotationItemPO> dIqrQuotationItemPOs, String totalPriceFlag, DIqrQuotationPO quotationPO) {
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
        HashMap<String, Long> pkgQuoteAmountMap = new HashMap<String, Long>();
        Long quoteAmount = 0L;
        if (!"Y".equals(totalPriceFlag)) {
            try {
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                    BigDecimal itemQuoteAmount = new BigDecimal("0");
                    itemQuoteAmount = MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getQuotePrice()).multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    dIqrQuotationItemPO.setQuoteAmount(MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                    quoteAmount = dIqrQuotationItemPO.getQuoteAmount() + quoteAmount;
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.size() <= 0) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), dIqrQuotationItemPO.getQuoteAmount());
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId()) == null) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), dIqrQuotationItemPO.getQuoteAmount());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId())) continue;
                    Long pkgQuoteAmount = (Long)pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId());
                    pkgQuoteAmount = pkgQuoteAmount + dIqrQuotationItemPO.getQuoteAmount();
                    pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), pkgQuoteAmount);
                }
                updateQuotationPO.setAmount(quoteAmount);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38," + e);
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            updateQuotationPO.setAmount(MoneyUtils.BigDecimal2Long((BigDecimal)adduotationBillReqBO.getAmount()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        updateQuotationPO.setSupplierContactName(adduotationBillReqBO.getSupplierContactName());
        updateQuotationPO.setSupplierContactTele(adduotationBillReqBO.getSupplierContactTele());
        updateQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)adduotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
        updateQuotationPO.setDeliveryIntPromise(adduotationBillReqBO.getDeliveryIntPromise());
        updateQuotationPO.setQuoteExplain(adduotationBillReqBO.getQuoteExplain());
        updateQuotationPO.setQuotationSubmitTime(new Date());
        updateQuotationPO.setDocStatus(Integer.valueOf("40014"));
        updateQuotationPO.setNodeStatus(Integer.valueOf("41013"));
        updateQuotationPO.setQuotationId(adduotationBillReqBO.getQuotationId());
        updateQuotationPO.setQuoteIpAddr(adduotationBillReqBO.getQuoteIpAddr());
        if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
            updateQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
            Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
            updateQuotationPO.setQuoteRounds(quoteRounds.toString());
        } else {
            updateQuotationPO.setQuoteRounds("1");
        }
        updateQuotationPO.setQuotationCreateUserId(adduotationBillReqBO.getUserId());
        updateQuotationPO.setQuotationCreateUserName(adduotationBillReqBO.getUsername());
        updateQuotationPO.setReviewResult(Constants.REVIEW_RESULT_1);
        try {
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(updateQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        if ("23".equals(docType)) {
            try {
                ArrayList<DIqrQuotationPkgPO> quotationPkgList = new ArrayList<DIqrQuotationPkgPO>();
                for (QuotationPackageBO quotationPackageBO : adduotationBillReqBO.getPackageList()) {
                    DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                    dIqrQuotationPkgPO.setInquiryPkgId(quotationPackageBO.getInquiryPkgId());
                    dIqrQuotationPkgPO.setQuotationId(adduotationBillReqBO.getQuotationId());
                    dIqrQuotationPkgPO.setQuoteExplain(quotationPackageBO.getQuoteExplain());
                    if (pkgQuoteAmountMap.size() > 0 && pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()) != null) {
                        dIqrQuotationPkgPO.setAmount((Long)pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()));
                    } else {
                        dIqrQuotationPkgPO.setAmount(MoneyUtils.BigDecimal2Long((BigDecimal)quotationPackageBO.getAmount()));
                    }
                    dIqrQuotationPkgPO.setQuoteIpAddr(adduotationBillReqBO.getQuoteIpAddr());
                    dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("40014"));
                    dIqrQuotationPkgPO.setNodeStatus(Integer.valueOf("41013"));
                    if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
                        updateQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
                    } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
                        Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
                        updateQuotationPO.setQuoteRounds(quoteRounds.toString());
                    } else {
                        updateQuotationPO.setQuoteRounds("1");
                    }
                    quotationPkgList.add(dIqrQuotationPkgPO);
                }
                this.dIqrQuotationPkgMapper.updateByIdList(quotationPkgList, adduotationBillReqBO.getQuotationId());
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5355\u5931\u8d25");
                log.error("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5355\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            this.dIqrQuotationItemMapper.updateByIdList(dIqrQuotationItemPOs, adduotationBillReqBO.getQuotationId());
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25:", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25:", (Throwable)e);
        }
        this.dIqrQuotationAttachMapper.deleteByQuotationId(adduotationBillReqBO.getQuotationId());
        if (adduotationBillReqBO.getQuoteAttachmentInfoList() != null && adduotationBillReqBO.getQuoteAttachmentInfoList().size() > 0) {
            ArrayList<DIqrQuotationAttachPO> dIqrQuotationAttachPOList = new ArrayList<DIqrQuotationAttachPO>();
            for (QuotationAttachmentBO quotationAttachmentBO : adduotationBillReqBO.getQuoteAttachmentInfoList()) {
                DIqrQuotationAttachPO dIqrQuotationAttachPO = new DIqrQuotationAttachPO();
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("99");
                SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                Long quotationAttachmentId = seqEnquiryPubRspBO.getDocId();
                dIqrQuotationAttachPO.setQuotationId(adduotationBillReqBO.getQuotationId());
                dIqrQuotationAttachPO.setAttachmentName(quotationAttachmentBO.getAttachmentName());
                dIqrQuotationAttachPO.setAttachmentType(quotationAttachmentBO.getAttachmentBusiType());
                dIqrQuotationAttachPO.setAttachmentUrl(quotationAttachmentBO.getAttachmentUrl());
                dIqrQuotationAttachPO.setOssPath(quotationAttachmentBO.getOssPath());
                dIqrQuotationAttachPO.setUploadTime(new Date());
                dIqrQuotationAttachPO.setUploadUserId(adduotationBillReqBO.getQuotationCreateUserId());
                dIqrQuotationAttachPO.setUploadUserName(adduotationBillReqBO.getQuotationCreateUserName());
                dIqrQuotationAttachPO.setQuotationAttachmentId(quotationAttachmentId);
            }
            this.dIqrQuotationAttachMapper.insertBatch(dIqrQuotationAttachPOList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u66f4\u65b0\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO addQuotationBill(AdduotationBillReqBO submitQuotationBillReqBO, String docType, List<DIqrQuotationItemPO> dIqrQuotationItemPOs, String totalPriceFlag, DIqrQuotationPO quotationPO) {
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO addQuotationPO = new DIqrQuotationPO();
        BeanUtils.copyProperties((Object)quotationPO, (Object)addQuotationPO);
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("4");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        Long quotationId = seqEnquiryPubRspBO.getDocId();
        HashMap<String, Long> pkgQuoteAmountMap = new HashMap<String, Long>();
        Long quoteAmount = 0L;
        if (!"Y".equals(totalPriceFlag)) {
            try {
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                    BigDecimal itemQuoteAmount = new BigDecimal("0");
                    itemQuoteAmount = MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getQuotePrice()).multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    dIqrQuotationItemPO.setQuoteAmount(MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                    quoteAmount = dIqrQuotationItemPO.getQuoteAmount() + quoteAmount;
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.size() <= 0) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), dIqrQuotationItemPO.getQuoteAmount());
                    } else if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId()) == null) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), dIqrQuotationItemPO.getQuoteAmount());
                    } else if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId())) {
                        Object pkgQuoteAmount = (Long)pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId());
                        pkgQuoteAmount = (Long)pkgQuoteAmount + dIqrQuotationItemPO.getQuoteAmount();
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), (Long)pkgQuoteAmount);
                    }
                    dIqrQuotationItemPO.setQuotationId(quotationId);
                }
                addQuotationPO.setAmount(0L);
                addQuotationPO.setAmountSec(QuoteUtil.encode(quoteAmount, quotationId.toString()));
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            addQuotationPO.setAmount(MoneyUtils.BigDecimal2Long((BigDecimal)submitQuotationBillReqBO.getAmount()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        addQuotationPO.setSupplierContactName(submitQuotationBillReqBO.getSupplierContactName());
        addQuotationPO.setSupplierContactTele(submitQuotationBillReqBO.getSupplierContactTele());
        addQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)submitQuotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
        addQuotationPO.setDeliveryIntPromise(submitQuotationBillReqBO.getDeliveryIntPromise());
        addQuotationPO.setQuoteExplain(submitQuotationBillReqBO.getQuoteExplain());
        addQuotationPO.setQuotationSubmitTime(new Date());
        addQuotationPO.setDocStatus(Integer.valueOf("40014"));
        addQuotationPO.setNodeStatus(Integer.valueOf("41013"));
        addQuotationPO.setQuotationId(quotationId);
        addQuotationPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
        if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
            addQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
            Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
            addQuotationPO.setQuoteRounds(quoteRounds.toString());
        } else {
            addQuotationPO.setQuoteRounds("1");
        }
        addQuotationPO.setQuotationCreateUserId(submitQuotationBillReqBO.getUserId());
        addQuotationPO.setQuotationCreateUserName(submitQuotationBillReqBO.getUsername());
        addQuotationPO.setLastRoundQuotationId(submitQuotationBillReqBO.getQuotationId());
        addQuotationPO.setReviewResult(Constants.REVIEW_RESULT_1);
        if ("23".equals(docType)) {
            try {
                DIqrQuotationPkgPO updateQuotationPkg = new DIqrQuotationPkgPO();
                updateQuotationPkg.setQuotationId(submitQuotationBillReqBO.getQuotationId());
                updateQuotationPkg.setHisStatus("2");
                this.dIqrQuotationPkgMapper.updateByQuotationId(updateQuotationPkg);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5931\u8d25");
                log.error("\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5305\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
            }
            try {
                ArrayList<DIqrQuotationPkgPO> addIqrQuotationPkgList = new ArrayList<DIqrQuotationPkgPO>();
                List<DIqrQuotationPkgPO> oldQuotationPkgList = this.dIqrQuotationPkgMapper.selectByQuotationId(submitQuotationBillReqBO.getQuotationId());
                int count = 0;
                for (DIqrQuotationPkgPO quotationPkgPO : oldQuotationPkgList) {
                    DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
                    dIqrQuotationPkgPO.setInquiryPkgId(quotationPkgPO.getInquiryPkgId());
                    dIqrQuotationPkgPO.setQuotationId(quotationId);
                    dIqrQuotationPkgPO.setQuotationPkgId(quotationId + "-" + ++count);
                    dIqrQuotationPkgPO.setInquiryId(quotationPkgPO.getInquiryId());
                    dIqrQuotationPkgPO.setHisStatus("1");
                    dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
                    dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("40014"));
                    dIqrQuotationPkgPO.setNodeStatus(Integer.valueOf("41013"));
                    dIqrQuotationPkgPO.setQuotePkgDetailNum(quotationPkgPO.getQuotePkgDetailNum());
                    if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
                        dIqrQuotationPkgPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
                    } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
                        Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
                        dIqrQuotationPkgPO.setQuoteRounds(quoteRounds.toString());
                    } else {
                        dIqrQuotationPkgPO.setQuoteRounds("1");
                    }
                    for (QuotationPackageBO quotationPackageBO : submitQuotationBillReqBO.getPackageList()) {
                        if (!quotationPackageBO.getInquiryPkgId().equals(quotationPkgPO.getInquiryPkgId())) continue;
                        dIqrQuotationPkgPO.setQuoteExplain(quotationPackageBO.getQuoteExplain());
                        if (pkgQuoteAmountMap.size() > 0 && pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()) != null) {
                            dIqrQuotationPkgPO.setAmount(0L);
                            dIqrQuotationPkgPO.setAmountSec(QuoteUtil.encode((Long)pkgQuoteAmountMap.get(quotationPackageBO.getInquiryPkgId()), quotationId.toString()));
                        }
                        dIqrQuotationPkgPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
                        if (totalPriceFlag == null || !"Y".equals(totalPriceFlag)) break;
                        dIqrQuotationPkgPO.setAmount(0L);
                        dIqrQuotationPkgPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationPackageBO.getAmount()), quotationId.toString()));
                        break;
                    }
                    addIqrQuotationPkgList.add(dIqrQuotationPkgPO);
                }
                this.dIqrQuotationPkgMapper.insertBatch(addIqrQuotationPkgList);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25");
                log.error("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
                throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                dIqrQuotationItemPO.setQuotationId(quotationId);
            }
            this.dIqrQuotationItemMapper.insertBatch(dIqrQuotationItemPOs);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            if (submitQuotationBillReqBO.getQuoteAttachmentInfoList() != null && submitQuotationBillReqBO.getQuoteAttachmentInfoList().size() > 0) {
                ArrayList<DIqrQuotationAttachPO> dIqrQuotationAttachPOList = new ArrayList<DIqrQuotationAttachPO>();
                for (QuotationAttachmentBO quotationAttachmentBO : submitQuotationBillReqBO.getQuoteAttachmentInfoList()) {
                    DIqrQuotationAttachPO dIqrQuotationAttachPO = new DIqrQuotationAttachPO();
                    SeqEnquiryReqBO attaSeqEnquiryReqBO = new SeqEnquiryReqBO();
                    attaSeqEnquiryReqBO.setSystemId("ZH01");
                    attaSeqEnquiryReqBO.setSeqType("99");
                    SeqEnquiryRspBO attaSeqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(attaSeqEnquiryReqBO);
                    Long quotationAttachmentId = attaSeqEnquiryPubRspBO.getDocId();
                    dIqrQuotationAttachPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
                    dIqrQuotationAttachPO.setAttachmentName(quotationAttachmentBO.getAttachmentName());
                    dIqrQuotationAttachPO.setAttachmentType(quotationAttachmentBO.getAttachmentBusiType());
                    dIqrQuotationAttachPO.setAttachmentUrl(quotationAttachmentBO.getAttachmentUrl());
                    dIqrQuotationAttachPO.setOssPath(quotationAttachmentBO.getOssPath());
                    dIqrQuotationAttachPO.setUploadTime(new Date());
                    dIqrQuotationAttachPO.setUploadUserId(submitQuotationBillReqBO.getQuotationCreateUserId());
                    dIqrQuotationAttachPO.setUploadUserName(submitQuotationBillReqBO.getQuotationCreateUserName());
                    dIqrQuotationAttachPO.setQuotationAttachmentId(quotationAttachmentId);
                    dIqrQuotationAttachPOList.add(dIqrQuotationAttachPO);
                }
                this.dIqrQuotationAttachMapper.insertBatch(dIqrQuotationAttachPOList);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u9644\u4ef6\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u9644\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u9644\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            this.dIqrQuotationMapper.insertSelective(addQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
            updateQuotationPO.setHisStatus("2");
            updateQuotationPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(updateQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u65b0\u589e\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

